/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.util;

import com.utility.TncJdbc;
import com.webhook.util.CDCFilesHandler;
import com.webhook.util.CDCTables;
import com.webhook.util.Command;
import java.util.List;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class DeleteCDC
implements Command {
    private final TncJdbc jdbcTemplate;
    private final List<CDCTables> tablesList;
    private final String dbName;

    public DeleteCDC(TncJdbc jdbcTemplate, List<CDCTables> table) {
        this.jdbcTemplate = jdbcTemplate;
        this.tablesList = table;
        this.dbName = jdbcTemplate.getLogin().getDataBaseName();
    }

    public void execute() {
        this.disableCdcForTable();
        if (this.shouldDeleteFileGroup()) {
            this.disableCdcForDB();
            this.deleteFileAndFileGroup();
        }
    }

    private void disableCdcForTable() {
        this.tablesList.stream().flatMap(cdcTables -> cdcTables.getRelatedTables().stream()).forEach(cdcTable -> {
            String table = cdcTable.getValueWithoutDbo();
            this.jdbcTemplate.execute(" IF EXISTS (SELECT * FROM sys.tables where [name]='" + table + "' AND is_tracked_by_cdc = 1)  EXEC SYS.sp_cdc_disable_table  @SOURCE_SCHEMA= 'DBO',  @SOURCE_NAME= '" + table + "',  @capture_instance = 'DBO_" + table + "' ");
        });
    }

    private boolean shouldDeleteFileGroup() {
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(" SELECT COUNT(*) [cnt] FROM WEBHOOK_SUBSCRIPTIONS");
        rs.next();
        return rs.getInt("cnt") == 0;
    }

    private void disableCdcForDB() {
        this.jdbcTemplate.execute(" IF EXISTS (SELECT COUNT(*) [cnt] FROM sys.databases where [name]='" + this.dbName + "' AND is_cdc_enabled = 1)  EXEC SYS.sp_cdc_disable_db");
        this.jdbcTemplate.executeOnDefaultDb(" ALTER DATABASE " + this.dbName + " SET ALLOW_SNAPSHOT_ISOLATION OFF ");
    }

    private void deleteFileAndFileGroup() {
        this.jdbcTemplate.executeOnDefaultDb(" IF EXISTS (select * from sysfiles where [name] = 'HOLOO_CDC_" + this.dbName + "') ALTER DATABASE " + this.dbName + " REMOVE FILE [HOLOO_CDC_" + this.dbName + "]");
        this.jdbcTemplate.executeOnDefaultDb(" IF EXISTS (select * from sysfilegroups where groupname = 'HOLOO_CT_" + this.dbName + "') ALTER DATABASE " + this.dbName + " REMOVE FILEGROUP [HOLOO_CT_" + this.dbName + "]");
        CDCFilesHandler filesHandler = new CDCFilesHandler();
        filesHandler.delete(this.dbName);
    }
}

