/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.util;

import com.utility.TncJdbc;
import com.webhook.util.CDCTables;
import com.webhook.util.Command;
import java.io.File;
import java.util.List;

public class CreateCDC
implements Command {
    private final TncJdbc jdbcTemplate;
    private final List<CDCTables> tablesList;
    private final String dbName;

    public CreateCDC(TncJdbc jdbcTemplate, List<CDCTables> table) {
        this.jdbcTemplate = jdbcTemplate;
        this.tablesList = table;
        this.dbName = jdbcTemplate.getLogin().getDataBaseName();
    }

    public void execute() {
        this.enableCdcForDB();
        this.createFileGroupAndFile();
        this.enableCdcForTable();
    }

    private void enableCdcForDB() {
        this.jdbcTemplate.executeOnDefaultDb(" IF NOT EXISTS (SELECT * FROM sys.databases where [name]='" + this.dbName + "' AND is_cdc_enabled = 1) EXEC SYS.sp_cdc_enable_db");
        this.jdbcTemplate.executeOnDefaultDb(" ALTER DATABASE " + this.dbName + " SET ALLOW_SNAPSHOT_ISOLATION ON");
    }

    private void createFileGroupAndFile() {
        this.jdbcTemplate.executeOnDefaultDb(" IF NOT EXISTS (select * from sysfilegroups where groupname = N'HOLOO_CT_" + this.dbName + "')  ALTER DATABASE " + this.dbName + " ADD FILEGROUP [HOLOO_CT_" + this.dbName + "] ");
        File file = new File("./", "HOLOO_CDC_" + this.dbName + ".ndf");
        this.jdbcTemplate.executeOnDefaultDb(" IF NOT EXISTS (select * from sysfiles where [name] = N'HOLOO_CDC_" + this.dbName + "')  ALTER DATABASE [" + this.dbName + "] ADD FILE ( NAME = N'HOLOO_CDC_" + this.dbName + "', FILENAME = '" + file.getAbsolutePath() + "',  SIZE = 8192KB , FILEGROWTH = 10%) TO FILEGROUP [HOLOO_CT_" + this.dbName + "] ");
    }

    private void enableCdcForTable() {
        this.tablesList.stream().flatMap(cdcTables -> cdcTables.getRelatedTables().stream()).forEach(table -> this.jdbcTemplate.execute(" IF NOT EXISTS (SELECT * FROM sys.tables where [name]='" + table + "' AND is_tracked_by_cdc = 1)  EXEC SYS.SP_CDC_ENABLE_TABLE  @SOURCE_SCHEMA= 'DBO',  @SOURCE_NAME= '" + table.getValueWithoutDbo().toLowerCase() + "',  @ROLE_NAME= NULL,  @FILEGROUP_NAME= 'HOLOO_CT_" + this.dbName + "',  @SUPPORTS_NET_CHANGES = 0 "));
    }
}

