/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.util;

import com.dto.LoginDto;
import com.utility.DbConnection;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class CDCStateHandler {
    private final DbConnection dbConnection;

    public CDCStateHandler(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public boolean isStopState(LoginDto login) {
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(" SELECT COUNT(*) cnt FROM WEBHOOK_SUBSCRIPTIONS WHERE isNULL(STOP_STATE,0) = 0");
        rs.next();
        return rs.getInt("cnt") == 0;
    }

    public void setStopState() {
        this.dbConnection.getJdbcTemplate(this.dbConnection.setToken()).update(" UPDATE WEBHOOK_SUBSCRIPTIONS SET STOP_STATE = 1");
    }

    public void setStartState(LoginDto login) {
        this.dbConnection.getJdbcTemplate(login).update(" UPDATE WEBHOOK_SUBSCRIPTIONS SET STOP_STATE = 0");
    }

    public void createWebHookTableIfNotExist(LoginDto login) {
        String sql = " IF NOT EXISTS (select [name] from sys.tables where [name] = 'WebHook_Subscriptions')  CREATE TABLE WebHook_Subscriptions(  [API_URL] TEXT NOT NULL,  [WH_TABLE_NAME] TEXT NOT NULL,  [STOP_STATE] INT NULL,  [API_KEY] TEXT NULL)";
        this.dbConnection.getJdbcTemplate(login).execute(sql);
    }
}

