/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.events;

import com.utility.ConvertStr;
import com.utility.DbLogin;
import com.webhook.events.BaseChangeFieldGenerator;
import com.webhook.util.CDCTables;
import com.webhook.util.ColumnNameChanger;
import java.util.Map;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class ProductChangeField
extends BaseChangeFieldGenerator {
    private String aCode;
    private String mCode = null;
    private String sCode = null;

    ProductChangeField(DbLogin dbLogin) {
        super(dbLogin);
    }

    protected void addToChangedFields(Map<String, Object> payload, CDCTables changedTable) {
        this.aCode = String.valueOf(payload.get("a_code"));
        this.changedFields = ColumnNameChanger.getFakedColumnsPayload(payload, (CDCTables)changedTable);
        try {
            this.assignMainGroupCode();
            this.assignSideGroupCode();
            this.addCommonNamesToChangedFieldsMap();
        }
        catch (Exception e) {
            return;
        }
        this.encryptUnitCode();
        this.addGroupsErp();
        this.replaceExist();
    }

    private void encryptUnitCode() {
        Object o = this.changedFields.get("UnitErpCode");
        if (o == null || String.valueOf(o).isEmpty() || String.valueOf(o).equals("0")) {
            return;
        }
        String unitErpCode = String.valueOf(this.changedFields.get("UnitErpCode"));
        this.changedFields.put("UnitErpCode", ConvertStr.encrypt((String)unitErpCode));
    }

    private void addCommonNamesToChangedFieldsMap() {
        SqlRowSet rs = this.getJdbcTemplate().queryForRowSet(" SELECT DISTINCT M_GROUPNAME MGN, S_GROUPNAME SGN, A_NAME  FROM W_SHOWARTICLEFORSEARCH_BIG WHERE A_CODE = ?", new Object[]{this.aCode});
        if (!rs.next()) {
            return;
        }
        this.changedFields.put("Name", rs.getString("A_NAME"));
        this.changedFields.put("SideGroupName", rs.getString("SGN"));
        this.changedFields.put("MainGroupName", rs.getString("MGN"));
    }

    private void addGroupsErp() {
        this.changedFields.put("MainGroupErpCode", ConvertStr.encrypt((String)this.mCode));
        this.changedFields.put("SideGroupErpCode", ConvertStr.encrypt((String)this.sCode));
    }

    private void assignMainGroupCode() throws IndexOutOfBoundsException {
        this.mCode = this.aCode.substring(0, 2);
    }

    private void assignSideGroupCode() throws IndexOutOfBoundsException {
        this.sCode = this.aCode.substring(0, 4);
    }

    private void replaceExist() {
        String aCode = (String)this.changedFields.get(CDCTables.PRODUCT.getTableCodeFieldToShow());
        aCode = ConvertStr.decrypt((String)aCode);
        SqlRowSet rs = this.getJdbcTemplate().queryForRowSet(" SELECT DISTINCT ROUND(W.[EXIST], 3) [fewTak], ROUND(V.[EXIST], 3) [fewSpd] \n FROM W_ShowArticleForSearch_Big W \n LEFT JOIN W_GETEXISTARTICLE V ON V.A_CODE = W.A_CODE \n WHERE W.A_CODE = ?", new Object[]{aCode});
        if (!rs.next()) {
            return;
        }
        this.changedFields.put("fewTak", rs.getDouble("fewTak"));
        this.changedFields.put("fewSpd", rs.getDouble("fewSpd"));
    }
}

