/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.events;

import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.DbLogin;
import com.webhook.util.CDCTables;
import io.debezium.data.Envelope;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class ChangeStructParser {
    private final DbLogin dbLogin = DbLogin.getInstance();
    private final Struct recordChangeValue;
    private Map<String, Object> afterPayload;
    private Map<String, Object> beforePayload;
    private String changedTableName;

    ChangeStructParser(Struct recordChangeValue) {
        this.recordChangeValue = recordChangeValue;
    }

    public LoginDto getLogin() {
        return this.dbLogin.getLogin();
    }

    public DbConnection getDbConnection() {
        return this.dbLogin.getDbConnection();
    }

    Map<String, Object> getAfterPayload() {
        if (this.afterPayload == null) {
            Struct struct = (Struct)this.recordChangeValue.get("after");
            this.afterPayload = this.getMapFromStruct(struct);
        }
        return this.afterPayload;
    }

    Map<String, Object> getBeforePayload() {
        if (this.beforePayload == null) {
            Struct struct = (Struct)this.recordChangeValue.get("before");
            this.beforePayload = this.getMapFromStruct(struct);
        }
        return this.beforePayload;
    }

    private Map<String, Object> getMapFromStruct(Struct struct) {
        return struct.schema().fields().stream().map(Field::name).filter(fieldName -> struct.get(fieldName) != null).map(fieldName -> Pair.of((Object)fieldName.toLowerCase(), (Object)struct.get(fieldName))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public Map<String, Object> getMapFromOperation(Envelope.Operation operation) {
        return operation == Envelope.Operation.DELETE ? this.beforePayload : this.afterPayload;
    }

    private Struct getStructFromOperation(Envelope.Operation operation) {
        String record = operation == Envelope.Operation.DELETE ? "before" : "after";
        return (Struct)this.recordChangeValue.get(record);
    }

    public String getErpCode(Map<String, Object> payload, String codeField) {
        String code = String.valueOf(payload.get(codeField.toLowerCase()));
        return ConvertStr.encrypt((String)code);
    }

    public String getChangedTableName() {
        if (this.changedTableName == null) {
            this.changedTableName = (String)((Struct)this.recordChangeValue.get("source")).get("table");
        }
        return this.changedTableName;
    }

    public CDCTables getChangedTable() {
        return CDCTables.getTable((String)this.getChangedTableName());
    }

    public String[] getUrlAndAPIKey(String table) {
        SqlRowSet rowSet = this.dbLogin.getDbConnection().getJdbcTemplate(this.dbLogin.getLogin()).queryForRowSet(" SELECT [API_URL], [API_KEY] FROM WEBHOOK_SUBSCRIPTIONS WHERE [WH_TABLE_NAME] like '%" + table + "%'");
        rowSet.next();
        String url = rowSet.getString("API_URL");
        String key = rowSet.getString("API_KEY");
        return new String[]{url != null ? url : "", key != null ? key : ""};
    }

    public boolean isFoodPrepared() {
        return this.getChangedTableName().toLowerCase().contains("res_facture") && this.pagerChanged();
    }

    private boolean pagerChanged() {
        try {
            Map after = this.getAfterPayload();
            Map before = this.getBeforePayload();
            int pagerAfter = after.getOrDefault("pagerno", -1);
            int pagerBefore = before.getOrDefault("pagerno", -1);
            return pagerAfter == 1 && pagerBefore == 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

