/*
 * Decompiled with CFR 0.152.
 */
package com.webhook;

import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.webhook.util.CDCFilesHandler;
import com.webhook.util.ColumnIncludeGenerator;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import java.io.File;
import java.net.InetAddress;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:application.properties"})
public class DebeziumConnectorConfig {
    private final DbConnection dbConnection;
    @Value(value="${db.port}")
    private Integer port;

    public DebeziumConnectorConfig(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public Configuration connect(LoginDto login) throws NullPointerException {
        String tablesToListen = this.getTablesToListen(login);
        if (tablesToListen == null) {
            return null;
        }
        LoginDto config = this.dbConnection.getConfig();
        String databaseName = login.getDataBaseName();
        CDCFilesHandler filesHandler = new CDCFilesHandler();
        Map fileMap = filesHandler.makeAndGetCDCFiles(databaseName);
        String dbServerInstance = config.getDataBaseName();
        return ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with("name", databaseName + "_sqlserver_connector").with("connector.class", "io.debezium.connector.sqlserver.SqlServerConnector").with("offset.storage", "org.apache.kafka.connect.storage.FileOffsetBackingStore").with("offset.storage.file.filename", ((File)fileMap.get("OFFSET_FILE")).getAbsolutePath()).with("offset.flush.interval.ms", 11000)).with("database.hostname", InetAddress.getLoopbackAddress().getHostAddress()).with("database.port", this.port == null || this.port == 0 ? 1433 : this.port)).with("database.user", config.getUserName()).with("database.password", config.getUserPass()).with("database.dbname", databaseName).with("database.instance", dbServerInstance.substring(dbServerInstance.lastIndexOf("\\") + 1)).with("database.include.list", databaseName).with("database.applicationIntent", "ReadOnly").with("snapshot.isolation.mode", (EnumeratedValue)SqlServerConnectorConfig.SnapshotIsolationMode.SNAPSHOT)).with("event.processing.failure.handling.mode", (EnumeratedValue)CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN)).with("table.include.list", tablesToListen).with("column.include.list", new ColumnIncludeGenerator(tablesToListen).getCommaSeparatedIncludedColumns()).with("include.schema.changes", "false").with("database.server.id", "14352").with("database.server.name", dbServerInstance.replace("-", "_").replace("\\", "_")).with("database.history", "io.debezium.relational.history.FileDatabaseHistory").with("database.history.file.filename", ((File)fileMap.get("HISTORY_FILE")).getAbsolutePath()).build();
    }

    private String getTablesToListen(LoginDto myLogin) {
        String sql = " SELECT [WH_TABLE_NAME] T_NAME FROM WEBHOOK_SUBSCRIPTIONS WHERE WH_TABLE_NAME NOT LIKE '%PAGER%'";
        SqlRowSet rowSet = this.dbConnection.getJdbcTemplate(myLogin).queryForRowSet(sql);
        return ConvertStr.getCommaSeparatedString((SqlRowSet)rowSet, (String)"T_NAME");
    }

    public boolean noTablesSubscribed(LoginDto loginDto) {
        return this.getTablesToListen(loginDto) == null;
    }
}

