/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.utility.ConvertStr;
import com.utility.TextNormalizer;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class SearchQuery {
    private final String COMPOUND_INDICATOR = " ";
    private final String MULTI_WORD_INDICATOR = ",";

    public boolean isTextSearch(String queryValue) {
        return queryValue.contains(" ") || queryValue.contains("\"");
    }

    public String makeSqlQuery(@NonNull String paramValue, @NonNull String fieldName, @Nullable String tableAlias, @NonNull String tableName) {
        String fullField = this.concatAliasWithField(tableAlias, fieldName);
        paramValue = TextNormalizer.getNormalizedText((String)paramValue);
        StringBuilder sb = new StringBuilder();
        if (!paramValue.contains(",")) {
            return sb.append(" ISNULL(").append(fullField).append(",'') LIKE ").append(this.wrapCompoundParamByPercent(paramValue)).toString();
        }
        return sb.append(" ISNULL(").append(fullField).append(",'') IN (SELECT ").append("A.").append(fieldName).append(" FROM ").append(tableName).append(" AS A INNER JOIN (VALUES ").append(this.wrapMultiParamsByPercent(paramValue)).append(") AS B ([Q_PARAMS]) ON A.").append(fieldName).append(" LIKE B.[Q_PARAMS])").toString();
    }

    public String makeSqlQueryNoTextSearch(@NonNull String paramValue, @NonNull String fieldName, @Nullable String tableAlias) {
        String fullField = this.concatAliasWithField(tableAlias, fieldName);
        paramValue = TextNormalizer.getNormalizedText((String)paramValue.trim());
        StringBuilder sb = new StringBuilder();
        if (!paramValue.contains(",")) {
            return sb.append(" ISNULL(").append(fullField).append(",'') = '").append(paramValue).append("'").toString();
        }
        String[] split = paramValue.split(",");
        if (paramValue.contains(",,")) {
            throw new TncException(TncExceptionMessages.INCORRECT_PARAM);
        }
        for (String item : split) {
            sb.append("'").append(item.trim()).append("',");
        }
        sb = ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)sb, (String)",");
        return fullField + " IN (" + sb + ")";
    }

    private String concatAliasWithField(String tableAlias, String fieldName) {
        String[] fieldNames;
        tableAlias = (!ConvertStr.isNullOrEmpty((String)tableAlias) ? tableAlias + "." : "").trim();
        StringBuilder builder = new StringBuilder();
        for (String field : fieldNames = fieldName.split("\\+")) {
            builder.append(tableAlias).append(field.trim()).append("+");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private String wrapCompoundParamByPercent(String compoundParam) {
        String[] split;
        StringBuilder builder = new StringBuilder("'");
        String compoundParamNew = compoundParam.trim();
        if (compoundParamNew.startsWith("\"") && compoundParamNew.endsWith("\"")) {
            compoundParamNew = compoundParamNew.replace("\"", "");
            return builder.append(compoundParamNew).append("'").toString();
        }
        if (compoundParamNew.startsWith("\"") && !compoundParamNew.endsWith("\"")) {
            compoundParamNew = compoundParamNew.replace("\"", "");
            return builder.append(compoundParamNew).append("%'").toString();
        }
        if (!compoundParamNew.startsWith("\"") && compoundParamNew.endsWith("\"")) {
            compoundParamNew = compoundParamNew.replace("\"", "");
            return builder.append("%").append(compoundParamNew).append("'").toString();
        }
        for (String param : split = compoundParamNew.split(" ")) {
            builder.append("%").append(param).append("%");
        }
        builder.append("'");
        return builder.toString();
    }

    private String wrapMultiParamsByPercent(String multiParams) {
        String[] split;
        StringBuilder builder = new StringBuilder();
        multiParams = multiParams.trim();
        for (String param : split = multiParams.split(",")) {
            if (!param.startsWith("\"") && !param.endsWith("\"")) {
                if (param.contains(" ")) {
                    builder.append("(").append(this.wrapCompoundParamByPercent(param)).append("),");
                    continue;
                }
                builder.append("('%").append(param).append("%'),");
                continue;
            }
            if (param.startsWith("\"") && param.endsWith("\"")) {
                param = param.replace("\"", "");
                builder.append("('").append(param).append("'),");
                continue;
            }
            if (param.startsWith("\"") && !param.endsWith("\"")) {
                param = param.replace("\"", "");
                builder.append("('").append(param).append("%'),");
                continue;
            }
            if (param.startsWith("\"") || !param.endsWith("\"")) continue;
            param = param.replace("\"", "");
            builder.append("('%").append(param).append("'),");
        }
        builder.deleteCharAt(builder.lastIndexOf(","));
        return builder.toString();
    }
}

