/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnectInfo;
import com.utility.TncJdbc;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class DbConnection {
    private final LoginDto myConfig = LoginDto.builder().build();
    private final Map<String, DbConnectInfo> perSerialDataSources = new ConcurrentHashMap();

    public DbConnection() {
        if (!this.getUserConfig(this.myConfig)) {
            return;
        }
        this.getJdbcTemplate(null);
    }

    public TncJdbc getJdbcTemplate(@Nullable LoginDto userLogin) {
        return (TncJdbc)this.recycleDbConnectInfo(userLogin).getJdbcTemplate();
    }

    public TransactionTemplate getTransactionTemplate(@Nullable LoginDto userLogin) {
        return this.recycleDbConnectInfo(userLogin).getTransactionTemplate();
    }

    @NonNull
    private DbConnectInfo recycleDbConnectInfo(@Nullable LoginDto userLogin) {
        DbConnectInfo dc;
        LoginDto login = userLogin == null ? LoginDto.builder().build() : userLogin;
        String nullSafeSerial = login.getJdbcKey();
        if (this.perSerialDataSources.containsKey(nullSafeSerial)) {
            dc = (DbConnectInfo)this.perSerialDataSources.get(nullSafeSerial);
        } else {
            DataSource dataSource = this.createDataSource();
            dc = DbConnectInfo.newInstance((javax.sql.DataSource)dataSource, (LoginDto)login);
            this.perSerialDataSources.put(nullSafeSerial, dc);
        }
        return dc;
    }

    private DataSource createDataSource() {
        DataSource dataSource = new DataSource();
        dataSource.setUrl("jdbc:sqlserver://" + this.myConfig.getDataBaseName());
        dataSource.setUsername(this.myConfig.getUserName());
        dataSource.setPassword(this.myConfig.getUserPass());
        dataSource.setTestOnBorrow(true);
        dataSource.setTestWhileIdle(true);
        dataSource.setValidationQuery("SELECT 1");
        dataSource.setTimeBetweenEvictionRunsMillis(3600000);
        return dataSource;
    }

    public boolean isDataSourceNotSet(@Nullable LoginDto userLogin) {
        return ConvertStr.isNullOrEmpty((String)this.recycleDbConnectInfo(userLogin).getApacheDataSource().getUsername());
    }

    public String getDbNameSql(String dbName) {
        if (ConvertStr.isNullOrEmpty((String)dbName)) {
            try {
                return this.setToken().makeUseDbSql();
            }
            catch (Throwable ignored) {
                return " USE MASTER \n";
            }
        }
        return " USE " + dbName + " \n";
    }

    public LoginDto getConfig() {
        return this.myConfig;
    }

    public LoginDto setToken() {
        return (LoginDto)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    }

    private void closeConnection(JdbcTemplate jdbcTemplate) {
        ((DataSource)Objects.requireNonNull(jdbcTemplate.getDataSource())).close();
    }

    private boolean getUserConfig(LoginDto myLoginDto) {
        StringBuilder inputFileName = new StringBuilder("../Config.udl");
        try {
            String inLine;
            FileReader inputFileReader;
            try {
                inputFileReader = new FileReader(inputFileName.toString());
            }
            catch (IOException ex) {
                inputFileReader = new FileReader("Config.udl");
            }
            BufferedReader inputStream = new BufferedReader(inputFileReader);
            while ((inLine = inputStream.readLine()) != null) {
                inputFileName.append(inLine);
            }
            inputStream.close();
            int index = inputFileName.indexOf("U\u0000s\u0000e\u0000r\u0000 \u0000I\u0000D") + 16;
            String inputStreamUser = inputFileName.substring(index);
            int LUserIndex = inputStreamUser.indexOf(";");
            inputStreamUser = inputStreamUser.substring(0, LUserIndex);
            index = inputFileName.indexOf("P\u0000a\u0000s\u0000s\u0000w\u0000o\u0000r\u0000d") + 18;
            String inputStreamPass = inputFileName.substring(index);
            int LPassIndex = inputStreamPass.indexOf(";");
            inputStreamPass = inputStreamPass.substring(0, LPassIndex);
            index = inputFileName.indexOf("D\u0000a\u0000t\u0000a\u0000 \u0000S\u0000o\u0000u\u0000r\u0000c\u0000e") + 24;
            String inputStreamDS = inputFileName.substring(index);
            inputStreamUser = inputStreamUser.replace("\u0000", "");
            inputStreamPass = inputStreamPass.replace("\u0000", "");
            inputStreamDS = inputStreamDS.replace("\u0000", "");
            myLoginDto.setDataBaseName(inputStreamDS);
            myLoginDto.setUserName(inputStreamUser);
            myLoginDto.setUserPass(inputStreamPass);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private void addDefaultUser(LoginDto myLogin) {
        this.getJdbcTemplate(myLogin).execute("Insert Into UserDb (name,PasWord,SuperVizor,UserCodeInc,SaveSpdSel,DeActive) Select 'TncCloud','1',0,-10,0,1 From UserDb ");
    }

    public boolean createDataBase(LoginDto myLogin) {
        String dbName = "S" + myLogin.getSerial() + "_" + myLogin.getDataBaseName();
        myLogin.setDataBaseName("[" + dbName + "]");
        TncJdbc jdbcTemplate = this.getJdbcTemplate(myLogin);
        this.closeConnection((JdbcTemplate)jdbcTemplate);
        String sqlStr = "Select Count(*) cnt  from Master..sysdatabases where name='" + dbName + "'";
        SqlRowSet rs = jdbcTemplate.queryForRowSet("!!!" + sqlStr);
        jdbcTemplate = this.getJdbcTemplate(myLogin);
        if (!rs.next()) {
            return false;
        }
        if (rs.getInt("cnt") != 0) {
            return false;
        }
        jdbcTemplate.executeOnDefaultDb("CREATE DATABASE " + dbName);
        try {
            String mdfFilePath = "";
            String ldfFilePath = "";
            SqlRowSet rs1 = jdbcTemplate.queryForRowSet("!!!Select physical_name from " + dbName + ".sys.database_files");
            while (rs1.next()) {
                if ("".equals(mdfFilePath)) {
                    mdfFilePath = rs1.getString("physical_name");
                    continue;
                }
                if (!"".equals(ldfFilePath)) continue;
                ldfFilePath = rs1.getString("physical_name");
            }
            assert (mdfFilePath != null);
            String bakFileName = mdfFilePath.substring(0, mdfFilePath.lastIndexOf("\\")) + "/Holoo";
            jdbcTemplate.executeOnDefaultDb("Restore database " + dbName + " from disk= N'" + bakFileName + "' \n  with replace , FILE = 1 , MOVE N'Holoo_Data' To N'" + mdfFilePath + "',\n                            MOVE N'Holoo_Log'  To N'" + ldfFilePath + "' ");
            this.addDefaultUser(myLogin);
            return true;
        }
        catch (Exception ex) {
            jdbcTemplate.executeOnDefaultDb("Drop DATABASE " + dbName);
            return false;
        }
    }

    public void runScript(LoginDto myLogin) {
        int goRunScriptWebService = 23;
        int runScriptWebService = 0;
        TncJdbc jdbcTemplate = this.getJdbcTemplate(myLogin);
        this.setVersion("1.04", (JdbcTemplate)jdbcTemplate);
        String sqlStr = "Select Integer from Msetup2 where Name='RunScriptWebService' ";
        SqlRowSet rowSet = jdbcTemplate.queryForRowSet(sqlStr);
        while (rowSet.next()) {
            runScriptWebService = rowSet.getInt("Integer");
        }
        sqlStr = "Select Count(*) cnt from dbo.sysobjects where id = object_id(N'[dbo].[W_GetExistArticle]') and OBJECTPROPERTY(id, N'IsView') = 1 \n";
        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
        while (rowSet.next()) {
            if (rowSet.getInt("cnt") != 0) continue;
            runScriptWebService = 0;
        }
        if (runScriptWebService < goRunScriptWebService) {
            DataSource ds = new DataSource();
            DataSource recycledDs = this.recycleDbConnectInfo(myLogin).getApacheDataSource();
            ds.setUrl(Objects.requireNonNull(recycledDs).getUrl());
            ds.setUsername(recycledDs.getUsername());
            ds.setPassword(this.myConfig.getUserPass());
            String dbname = myLogin.getDataBaseName();
            if (dbname.indexOf("]") > 0) {
                dbname = dbname.substring(1, dbname.indexOf("]"));
            }
            ds.setDefaultCatalog(dbname);
            JdbcTemplate jdbcTemp = new JdbcTemplate((javax.sql.DataSource)ds);
            this.runScriptTable(jdbcTemp);
            if (!myLogin.getIsMyHoloo().booleanValue()) {
                this.makeTriggerScripts(jdbcTemp);
            } else {
                this.executeSmartHelpScripts(jdbcTemp, myLogin);
            }
            jdbcTemp.execute("if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[GetPoshakTreeValues]') and xtype in (N'FN', N'IF', N'TF'))\n   drop function [dbo].[GetPoshakTreeValues]");
            jdbcTemp.execute("CREATE FUNCTION [dbo].[GetPoshakTreeValues](@ID INT, @outType int)\nRETURNS NVARCHAR(4000) AS\nBEGIN\n   DECLARE @NAME NVARCHAR(255)\n   SET @NAME = ''\n   WHILE (@ID > 0)\n   BEGIN\n       IF (@NAME <> '')\n           SET @NAME = '/' + @NAME\n       IF (@outType = 0) --getPropsParentId\n           SET @NAME = (SELECT CAST([ID] AS nvarchar(50)) FROM PoshakProperties WHERE ID = \n               (SELECT [ParentID] FROM PoshakProperties WHERE ID = (SELECT PId FROM POSHAK WHERE ID = @ID))) + @NAME    \n       ELSE IF (@outType = 1) --getPropsParentName\n           SET @NAME = (SELECT [Name] FROM PoshakProperties WHERE ID = \n               (SELECT [ParentID] FROM PoshakProperties WHERE ID = (SELECT PId FROM POSHAK WHERE ID = @ID))) + @NAME\n       ELSE IF (@outType = 2) --getPropsIdTree\n           SET @NAME = (SELECT CAST([PId] AS NVARCHAR(50)) FROM Poshak WHERE ID = @ID) + @NAME\n       ELSE IF (@outType = 3) --getPropsNameTree\n           SET @NAME = (SELECT [Name] FROM PoshakProperties WHERE ID = (SELECT [PId] FROM Poshak WHERE ID = @ID)) + @NAME\n       SET @ID = (SELECT ParentID FROM Poshak WHERE ID = @ID)\n   END\nRETURN @NAME\nEND");
            jdbcTemp.execute(" if (select count(id) from [dbo].syscolumns where id = (select id from  [dbo].sysobjects where name='customer') and name='IsSeller')=0 \n  ALTER TABLE dbo.CUSTOMER  ADD IsSeller bit NULL ");
            jdbcTemp.execute("if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[GetPropsTreeName]') and xtype in (N'FN', N'IF', N'TF'))\ndrop function [dbo].GetPropsTreeName");
            jdbcTemp.execute("CREATE FUNCTION DBO.GetPropsTreeName(@ID INT) \nRETURNS NVARCHAR(255) AS \nBEGIN \n   DECLARE @NAME NVARCHAR(255)\n   SET @NAME = ''\n   WHILE (@ID > 0)\n   BEGIN\n     IF (@NAME<>'')\n     SET @NAME = '/' + @NAME\n     SET @NAME = (SELECT [NAME] FROM POSHAKPROPERTIES WHERE ID = @ID) + @NAME\n     SET @ID = (SELECT PARENTID FROM POSHAKPROPERTIES WHERE ID = @ID)\n   END\n   RETURN @NAME \nEND\n");
            jdbcTemp.execute("if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[GetPropsTreeId]') and xtype in (N'FN', N'IF', N'TF'))\ndrop function [dbo].GetPropsTreeId\n");
            jdbcTemp.execute("CREATE FUNCTION DBO.GetPropsTreeId(@ID INT)  \nRETURNS NVARCHAR(255)  AS  \nBEGIN \n   DECLARE @NAME NVARCHAR(255)\n   SET @NAME = ''\n   WHILE (@ID>0)\n   BEGIN\n     IF (@NAME<>'')\n     SET @NAME = '/' + @NAME\n     SET @NAME = (SELECT CAST([ID] AS NVARCHAR(50)) FROM POSHAKPROPERTIES WHERE ID=@ID) + @NAME\n     SET @ID  = (SELECT PARENTID FROM POSHAKPROPERTIES WHERE ID=@ID)\n   END\n   RETURN @NAME \nEND\n");
            jdbcTemp.execute(" if not exists ( Select [Id] From sysColumns Where [Name] = 'IsChange'  And [id]=( Select [id] From Sysobjects where [Name] = 'TmpFacture' and [xtype] = 'U' ))\n  Alter Table [TmpFacture] Add IsChange int not null,\n    CONSTRAINT DF_TmpFacture_IsChange DEFAULT 1 FOR IsChange ");
            jdbcTemp.execute("if not exists ( Select [Id] From sysColumns Where [Name] = 'IsDeleted'  And [id]=( Select [id] From Sysobjects where [Name] = 'TmpFacture' and [xtype] = 'U' ))\n  Alter Table [TmpFacture] Add IsDeleted int not null,\n    CONSTRAINT DF_TmpFacture_IsDeleted DEFAULT 0 FOR IsDeleted");
            sqlStr = "if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Sp_ReturnMandehSarfasl]')  and OBJECTPROPERTY(id, N'IsProcedure') = 1)   drop procedure [dbo].[Sp_ReturnMandehSarfasl] ";
            jdbcTemp.execute(sqlStr);
            sqlStr = "Create PROCEDURE [dbo].[Sp_ReturnMandehSarfasl]\n @Sarfasl_Code Nvarchar(11)='',\n@FDate        datetime ='',\n@LDate        datetime =''  \nAS  \ndeclare @SqlFilter nvarchar(500)    \nset @SqlFilter=''\nif (@FDate<>'')\n set @SqlFilter =' AND ( S.Sanad_Date >= '''+convert(nvarchar(10),@FDate,111)+''' )'\nif (@LDate<>'') \n set @SqlFilter=@SqlFilter+' And ( S.Sanad_Date <= '''+\n                                  convert(nvarchar(10),@LDate,111)+''')  '  if (@Sarfasl_Code<>'')\n  set @SqlFilter =@SqlFilter+'   And ( Sl.Col_Code = '''+@Sarfasl_Code+''' or \n                    Sl.Col_Code+Sl.Moien_code = '''+@Sarfasl_Code+''' Or\n                    Sl.Col_Code+Sl.Moien_code+Sl.tafzili_code = '''+@Sarfasl_Code+''') '\nExec('\n     SELECT  sar.Sarfasl_Code Code ,sar.Sarfasl_Name Name , Round(SUM(bed)-SUM(bes),0)  Price\n     FROM SND_LIST Sl INNER JOIN SANAD S ON Sl.Sanad_Code = S.Sanad_Code\n     Inner Join Sarfasl sar On sar.Sarfasl_Code=Sl.Col_Code+Sl.Moien_code+Sl.tafzili_code\n     WHERE  Joze = 0 '+@SqlFilter+'\n     group by Sarfasl_Code,Sarfasl_Name \n     order by Sarfasl_Code\n      ')";
            jdbcTemp.execute(sqlStr);
            sqlStr = "if exists (select * from dbo.sysobjects where id =  object_id(N'[dbo].[Sp_ReturnMandehSarfaslType]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)  drop procedure [dbo].[Sp_ReturnMandehSarfaslType]";
            jdbcTemp.execute(sqlStr);
            sqlStr = "Create Procedure [dbo].[Sp_ReturnMandehSarfaslType]  \n@RepType tinyint,\n@Fdate   datetime = '',\n@LDate   datetime = ''   \nAS \ndeclare @SqlFilter nvarchar(500)    \nset @SqlFilter=''\nif (@FDate<>'')\n set @SqlFilter =' AND ( sa.Sanad_Date >= '''+convert(nvarchar(10),@FDate,111)+''' )'\nif (@LDate<>'') \n set @SqlFilter=@SqlFilter+' AND (sa.Sanad_Date <= '''+\n                                     convert(nvarchar(10),@LDate,111)+''')  '  \nExec ('\n SELECT S.sarfasl_code Code, S.Sarfasl_name As Name, round(SUM(bed)-SUM(bes),0)  Price\n FROM SND_LIST Sl INNER JOIN dbo.SANAD Sa ON Sl.Sanad_Code = Sa.Sanad_Code\n Inner Join sarfasl S on  Sl.Col_code+Sl.Moien_code+Sl.Tafzili_code = S.Sarfasl_Code \n WHERE  Joze = 0 '+ @SqlFilter+ ' And (S.Type = '+@RepType+') \n Group by S.sarfasl_code,S.Sarfasl_name\n Order by S.sarfasl_code')";
            jdbcTemp.execute(sqlStr);
            sqlStr = "if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Sp_ReturnMandehCustomer]') and OBJECTPROPERTY(id, N'IsProcedure') = 1) \n drop procedure [dbo].[Sp_ReturnMandehCustomer]";
            jdbcTemp.execute(sqlStr);
            sqlStr = "Create Procedure [dbo].[Sp_ReturnMandehCustomer]\n   @FetchRecord   int=0,\n   @RepRypeBedBes tinyint=1  \nAs   \n\n  Declare @FetchRec  nvarchar(20)\n  Declare @SqlWhere  nvarchar(500)  \n \n set @FetchRec ='Top '+cast(@FetchRecord as nvarchar(6))\n if (@FetchRecord=0) \n   set @FetchRec =' Top 100 Percent  '\n Set @SqlWhere  =' Mandeh>0 '\n if (@RepRypeBedBes=2) \n   Set @SqlWhere  =' Mandeh<0 '\n Exec('SELECT '+@FetchRec+'\n      case  \n      when Col_code_bed+Moien_code_bed+Tafzili_code_bed<>'''' then \n           Col_code_bed+Moien_code_bed+Tafzili_code_bed\n      else     \n        Col_code_bes+Moien_code_bes+Tafzili_code_bes \n      end  Code,\n      C_name As Name,abs(Mandeh)  Price \n      from  W_Calc_Mandeh_Customer where '+@SqlWhere+'\n      Order by abs(Mandeh) DESC')";
            jdbcTemp.execute(sqlStr);
            sqlStr = "if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Sp_ReturnMandehArticle]')  and OBJECTPROPERTY(id, N'IsProcedure') = 1) \n drop procedure [dbo].[Sp_ReturnMandehArticle]";
            jdbcTemp.execute(sqlStr);
            sqlStr = "Create Procedure [dbo].[Sp_ReturnMandehArticle] \n    @FetchRecord   int=0,\n    @RepRype tinyint=1\nAs  \n\n  Declare @FetchRec  nvarchar(20)  \n  set @FetchRec ='Top '+cast(@FetchRecord as nvarchar(6))\n  if (@FetchRecord=0) \n    set @FetchRec =' Top 100 Percent  '\n   Declare @OrderType nvarchar(10)     \n   set @OrderType =' DESC ';         \n   if (@RepRype=2) \n     set @OrderType=' Asc '\n  Exec('Select '+@FetchRec+'A_Code_c code, A_Name as Name, Round(isnull(Exist,0),3) Few,    isnull(Sel_price,0) Price \n         From Article where model<>''#*Not_Article*#'' \n         Order by Few '+@OrderType)    ";
            jdbcTemp.execute(sqlStr);
            sqlStr = "if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Sp_ReturnSellArticle]')  and OBJECTPROPERTY(id, N'IsProcedure') = 1) \n drop procedure [dbo].[Sp_ReturnSellArticle]";
            jdbcTemp.execute(sqlStr);
            sqlStr = "Create PROCEDURE [dbo].[Sp_ReturnSellArticle] \n    @FetchRecord   int=0, \n    @RepTypeMinMax tinyint, \n    @Reptype       tinyint , \n    @FDate         datetime, \n    @Ldate         datetime \n AS \n Declare @FetchRec nvarchar(100)\n Declare @OrderBy nvarchar(500)  \n set @FetchRec ='Top '+cast(@FetchRecord as nvarchar(6))\n if (@FetchRecord=0) \n   set @FetchRec =' Top 100 Percent '\n  declare @SqlFilter nvarchar(500)  \n  set @SqlFilter=''\n  if (@FDate<>'')\n   set @SqlFilter =' AND ( f.fac_Date >= '''+convert(nvarchar(10),@FDate,111)+''' )'\n  if (@LDate<>'') \n   set @SqlFilter=@SqlFilter+' AND (f.fac_Date <= '''+\n                                       convert(nvarchar(10),@LDate,111)+''')  '  \n set @Orderby=' ORDER BY ';\n if (@RepType=1) \n   set @Orderby = @Orderby+ ' Few '\n if (@RepType=2) \n   set @Orderby = @Orderby+ ' Price '\n if (@ReptypeMinMax=1) \n  set @Orderby=@Orderby+' desc '\nExec ('\n       SELECT DISTINCT '+@FetchRec+'\n       '''' Code ,A.A_Name  Name,Round(SUM(FA.Few_Article),3) Few,        Round(SUM(FA.Few_Article * FA.Price_BS),2)  Price\n       FROM FACTART FA INNER JOIN ARTICLE A ON FA.A_Code = A.A_Code INNER JOIN FACTURE F ON        FA.Fac_Code = F.Fac_Code AND FA.Fac_Type = F.Fac_Type\n       WHERE (FA.Fac_Type = ''F'')\n       '+@SqlFilter+'\n       GROUP BY FA.A_Code, FA.Fac_Type, A.A_Name\n      '+@OrderBy+'\n ')";
            jdbcTemp.execute(sqlStr);
            sqlStr = "if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Sp_ReturnReportSarfasl]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)\ndrop procedure [dbo].[Sp_ReturnReportSarfasl]";
            jdbcTemp.execute(sqlStr);
            sqlStr = " Create PROCEDURE [dbo].[Sp_ReturnReportSarfasl] \n   @FetchRecord  int =0,\n   @Sarfasl_Code Nvarchar(11),\n   @FDate        datetime ,\n   @LDate        datetime \n AS \n declare @FetchRec nvarchar(100)\n set @FetchRec ='Top '+cast(@FetchRecord as nvarchar(6))\n if (@FetchRecord=0) \n   set @FetchRec =' Top 100 Percent '\n declare @SqlFilter nvarchar(500)  \n  set @SqlFilter=''\n  if (@FDate<>'')\n   set @SqlFilter =' AND (Sanad_Date >= '''+convert(nvarchar(10),@FDate,111)+''' )'\n  if (@LDate<>'') \n   set @SqlFilter=@SqlFilter+' AND (Sanad_Date <= '''+\n       convert(nvarchar(10),@LDate,111)+''')  '  \n  exec ('SELECT '+@FetchRec+' Sanad_Code_C,Convert(nvarchar(10),Sanad_Date,111) Sanad_Date, Comment_Line, \n         Round(Bed,2)Bed ,Round(Bes,2) Bes \n  FROM SND_LIST Sl\n       INNER JOIN SANAD S ON Sl.Sanad_Code = S.Sanad_Code\n  WHERE Joze = 0 \n      '+@SqlFilter+'\n      And (Col_Code = '''+@Sarfasl_Code+''' or \n           Col_Code+Moien_code = '''+@Sarfasl_Code+''' Or \n           Col_Code+Moien_code+tafzili_code = '''+@Sarfasl_Code+''') \n            Order by Sanad_Date desc,Sanad_Time ')";
            jdbcTemp.execute(sqlStr);
            sqlStr = "if (Select Count(*) from Msetup2 Where Name='RunScriptWebService' ) = 0 \n Insert Into Msetup2(Name,Integer) Values('RunScriptWebService'," + goRunScriptWebService + ") else Update Msetup2 set Integer = " + goRunScriptWebService + " where Name='RunScriptWebService' ";
            jdbcTemp.execute(sqlStr);
            ds.close();
        }
    }

    private void setVersion(String version, JdbcTemplate jdbcTemplate) {
        jdbcTemplate.update(" IF EXISTS (SELECT * FROM MSETUP2 WHERE NAME = 'WebServiceVersion')  BEGIN  IF (SELECT count(*) FROM MSETUP2 WHERE NAME = 'WebServiceVersion' AND [STRING] <> '" + version + "' ) > 0   UPDATE MSETUP2 SET [STRING] = '" + version + "' WHERE NAME = 'WebServiceVersion'  END  ELSE    INSERT INTO MSETUP2 ([NAME], [STRING]) VALUES ('WebServiceVersion', '" + version + "')");
    }

    private void executeSmartHelpScripts(JdbcTemplate jdbcTemp, LoginDto myLogin) {
        boolean notExistNewFewFields;
        jdbcTemp.execute("if (select count(id) from [dbo].syscolumns where id = (select id from [dbo].sysobjects where name='TmpFactart') and name='DarsadTakhfif')=0 \n  Alter Table TmpFactart ADD DarsadTakhfif Float not Null, \n        CONSTRAINT DF_TmpFactart_DarsadTakhfif default(0) FOR DarsadTakhfif ");
        jdbcTemp.execute("if (select count(id) from [dbo].syscolumns where id = (select id from  [dbo].sysobjects where name='TmpFactart') and name='TakhfifSatriR')=0 \n Alter Table TmpFactart ADD TakhfifSatriR Float not Null, \n CONSTRAINT DF_TmpFactart_TakhfifSatriR default(0) FOR TakhfifSatriR");
        jdbcTemp.execute("IF (SELECT COUNT(ID) FROM [DBO].SYSCOLUMNS WHERE ID =  (SELECT ID FROM [DBO].SYSOBJECTS \n WHERE NAME='TmpFactart') and name='A_index') = 0 \n  ALTER TABLE TmpFactart Add A_index int NOT NULL, \n  Constraint TmpFactart_A_index Default(1) for A_index");
        jdbcTemp.execute("if (select Count(id) from [dbo].syscolumns where id = (select id from [dbo].sysobjects where name = 'Article') and name = 'IsActive') = 0 \n Alter Table Article \n  Add IsActive bit Not Null, \n CONSTRAINT DF_Article_IsActive DEFAULT 1 FOR IsActive \n");
        jdbcTemp.execute(" if  (select count(id) from [dbo].syscolumns where id = (select id from  [dbo].sysobjects where name='customer') and name='IsActive')=0 \n  ALTER TABLE dbo.CUSTOMER  ADD IsActive bit Not NULL,  Constraint customer_IsActive Default(1)for IsActive");
        jdbcTemp.execute("if Not exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[PoshakProperties]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)\n CREATE TABLE [dbo].[PoshakProperties](\n [ID] [int] IDENTITY(1,1) NOT NULL,\n [ParentID] [int] NOT NULL,\n [Name] [nvarchar](300) NOT NULL\n CONSTRAINT [PK_PoshakProperties] PRIMARY KEY CLUSTERED\n([Id] ASC)) ON [PRIMARY]");
        jdbcTemp.execute("if (select count(id) from [dbo].syscolumns where id =(select id from  [dbo].sysobjects where name='ArticlePrice') and name = 'TakhfifRialy')=0\nAlter Table ArticlePrice\nAdd TakhfifRialy Float Not Null,\nDarsadTakhfif Float Not Null,\nConstraint DF_AticlePrice_TakhfifRialy  Default(0) for TakhfifRialy ,\nConstraint DF_AticlePrice_DarsadTakhfif  Default(0) for DarsadTakhfif\nif (select count(id) from [dbo].syscolumns where id =(select id from  [dbo].sysobjects where name='ArticlePrice') and name='Min_Price')=0 \n  Alter Table ArticlePrice  ADD Min_Price Float  Null\nif (select count(id) from [dbo].syscolumns where id =(select id from  [dbo].sysobjects where name='ArticlePrice') and name='Max_Price')=0 \n  Alter Table ArticlePrice  ADD Max_Price Float  Null");
        boolean bl = notExistNewFewFields = (Integer)jdbcTemp.queryForObject("SELECT COUNT(ID) FROM [DBO].SYSCOLUMNS WHERE ID =\n(SELECT ID FROM [DBO].SYSOBJECTS WHERE [NAME] = 'Article') and [NAME] = 'FewSpd'", Integer.class) == 0;
        if (notExistNewFewFields) {
            jdbcTemp.execute(myLogin.makeUseDbSql() + " ALTER TABLE ARTICLE\n ADD FewSpd FLOAT NULL,  FewTak FLOAT NULL, FewKarton FLOAT NULL");
            jdbcTemp.execute(myLogin.makeUseDbSql() + "   UPDATE A SET A.FewSpd = V.Exist, A.FewKarton = W.Exist2, A.FewTak = W.Exist     FROM ARTICLE A INNER JOIN W_ShowArticleForSearch_Big W ON W.A_CODE = A.A_CODE    INNER JOIN W_GetExistArticle V ON V.A_CODE = A.A_CODE ");
        }
    }

    private void runScriptTable(JdbcTemplate jdbcTemp) {
        String sqlStr;
        SqlRowSet rs = this.getJdbcTemplate(null).queryForRowSet("select [Name] from [dbo].sysobjects where  Name like '%DF__ARTICLE__ModifyD__%'");
        while (rs.next()) {
            sqlStr = rs.getString("Name");
            if ("DF_Article_ModifyDate".equals(sqlStr)) continue;
            jdbcTemp.execute("Alter Table Article DROP CONSTRAINT " + sqlStr);
            jdbcTemp.execute("Alter Table Article DROP Column ModifyDate");
        }
        jdbcTemp.execute("if not exists ( Select [Id] From sysColumns Where [Name] = 'IsChange'  And [id]=( Select [id] From Sysobjects where [Name] = 'Article' and [xtype] = 'U' ))\n  Alter Table [Article] Add IsChange int not null,     CONSTRAINT DF_Article_IsChange DEFAULT 1 FOR IsChange");
        sqlStr = "if (select count(id) from [dbo].syscolumns where id =(select id from [dbo].sysobjects where name='Article') and name='ModifyDate')=0 \nAlter Table Article Add ModifyDate datetime not null,\n    CONSTRAINT DF_Article_ModifyDate DEFAULT(GetDate()) FOR ModifyDate";
        jdbcTemp.execute(sqlStr);
        sqlStr = "if not exists (Select [Id] From sysColumns Where [Name] = 'WebId' And [id]=( Select [id] From Sysobjects where [Name] = 'RqTitle'  And [xtype] = 'U' )) Alter table RqTitle Add WebId nvarchar(20)";
        jdbcTemp.execute(sqlStr);
        sqlStr = "if not exists (Select [Id] From sysColumns Where [Name] = 'OrderId' And [id]=( Select [id] From Sysobjects where [Name] = 'Facture'  And [xtype] = 'U' )) ALTER TABLE FACTURE ADD [OrderId] [int] Not Null, CONSTRAINT DF_FACTURE_OrderId default(0) FOR OrderId";
        jdbcTemp.execute(sqlStr);
        sqlStr = "if not exists (Select [Id] From sysColumns Where [Name] = 'WebId' And [id]=( Select [id] From Sysobjects where [Name] = 'Fbailpre'  And [xtype] = 'U' )) Alter table Fbailpre Add WebId nvarchar(50) \n ELSE ALTER TABLE FBailPre ALTER COLUMN WebId nvarchar(50)";
        jdbcTemp.execute(sqlStr);
        sqlStr = "if not exists (Select [Id] From sysColumns Where [Name] = 'Id' And [id]=( Select [id] From Sysobjects where [Name] = 'Fbailpre'  And [xtype] = 'U' )) Alter table Fbailpre Add Id int identity(1,1)";
        jdbcTemp.execute(sqlStr);
        sqlStr = "if not exists (Select [Id] From sysColumns Where [Name] = 'FbailPreId' And [id]=( Select [id] From Sysobjects where [Name] = 'Facture'  And [xtype] = 'U' )) Alter Table FACTURE Add FbailPreId Int Not Null, CONSTRAINT DF_FACTURE_FbailPreId default(0) FOR FbailPreId";
        jdbcTemp.execute(sqlStr);
        sqlStr = "if not exists (Select [Id] From sysColumns Where [Name] = 'WebId' And [id]=( Select [id] From Sysobjects where [Name] = 'Facture'  And [xtype] = 'U' )) Alter table Facture Add WebId nvarchar(50) \n ELSE ALTER TABLE FACTURE ALTER COLUMN WebId nvarchar(50) ";
        jdbcTemp.execute(sqlStr);
        sqlStr = "if not exists (Select [Id] From sysColumns Where [Name] = 'WebId' And [id]=( Select [id] From Sysobjects where [Name] = 'Sanad'  And [xtype] = 'U' )) Alter Table Sanad Add WebId nvarchar(50) \n ELSE ALTER TABLE SANAD ALTER COLUMN WebId nvarchar(50)";
        jdbcTemp.execute(sqlStr);
        jdbcTemp.execute(" IF (SELECT COUNT(ID) FROM [DBO].SYSCOLUMNS WHERE ID =  (SELECT ID FROM [DBO].SYSOBJECTS WHERE NAME='Poshak') AND NAME = 'PId') = 0  BEGIN Alter Table Poshak Add PId Int END ");
        jdbcTemp.execute("IF (SELECT COUNT(ID) FROM [DBO].SYSCOLUMNS WHERE ID =  (SELECT ID FROM [DBO].SYSOBJECTS WHERE NAME='ItemArticle') AND NAME='PoshakId_C') = 0  BEGIN Alter Table ItemArticle\n  Add PoshakId_C Nvarchar(255) Not Null,   Constraint DF_ItemArticle_PoshakId_C Default('') for PoshakId_C END ");
        rs = this.getJdbcTemplate(null).queryForRowSet("select [Name] from [dbo].sysobjects where  Name like '%DF__CUSTOMER__Modify__%'");
        while (rs.next()) {
            sqlStr = rs.getString("Name");
            if ("DF_Customer_ModifyDate".equals(sqlStr)) continue;
            jdbcTemp.execute("Alter Table Customer DROP CONSTRAINT " + sqlStr);
            jdbcTemp.execute("Alter Table Customer DROP Column ModifyDate");
        }
        jdbcTemp.execute("if not exists (Select [Id] From sysColumns Where [Name] = 'IsChange' And [id]=(Select [id] From Sysobjects where [Name] = 'Customer' and [xtype] = 'U' )) \n Alter Table [Customer] Add IsChange int not null, \n  CONSTRAINT DF_Customer_IsChange DEFAULT 1 FOR IsChange");
        sqlStr = "if  (select count(id) from [dbo].syscolumns where id =(select id from [dbo].sysobjects where name='Customer') and name='ModifyDate')=0 \n Alter Table Customer Add ModifyDate datetime not null, \n    CONSTRAINT DF_Customer_ModifyDate DEFAULT(GetDate()) FOR ModifyDate";
        jdbcTemp.execute(sqlStr);
        sqlStr = "if not exists (Select [Id] From sysColumns Where [Name] = 'WebId' And [id]=( Select [id] From Sysobjects where [Name] = 'Customer' And [xtype] = 'U' ))begin Alter table Customer Add WebId nvarchar(20) exec sp_refreshview 'W_Calc_Mandeh_Customer'end ";
        jdbcTemp.execute(sqlStr);
        sqlStr = "if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[W_GetExistArticle]') and OBJECTPROPERTY(id, N'IsView') = 1) \n drop view  [dbo].[W_GetExistArticle]";
        jdbcTemp.execute(sqlStr);
        sqlStr = " Create VIEW W_GetExistArticle As \n Select S.A_Code, S.A_Code_C, Exist - ISNULL(FbailArt.FbailFew, 0) \n  + ISNULL(RqArt.RqFew, 0) Exist from W_ShowArticleForSearch_Big S \n LEFT OUTER JOIN \n (SELECT A_Code, SUM(Few_Article) FbailFew \n  FROM  ABAILPRE A \n  INNER JOIN FBAILPRE F ON F.Fac_Code = A.Fac_Code AND F.Fac_Type = A.Fac_Type \n  where F.Fac_Type = 'P' And ISNULL([Delete], 0) = 0 \n  GROUP BY A.A_Code) FbailArt ON S.A_Code = FbailArt.A_Code \n LEFT OUTER JOIN \n (SELECT R_ArCode A_Code, SUM(CASE WHEN F.RQType = 'K' THEN R_Few * ISNULL(Unit_Few, 1) \n         else -(R_Few * Isnull(Unit_Few, 1)) end) RqFew \n  FROM RQDETAIL A \n  INNER JOIN RQTITLE F ON F.RqIndex = A.RqIndex \n  LEFT JOIN UNIT U ON U.Unit_Code = A.Unit_Code \n  WHERE ISNULL(ShowOrHide, 0) = 1 \n  GROUP BY A.R_ArCode) RqArt ON S.A_Code = RqArt.A_Code ";
        jdbcTemp.execute(sqlStr);
        sqlStr = "if not exists (Select [Id] From sysColumns Where [Name] = 'FNaghd' And [id]=( Select [id] From Sysobjects where [Name] = 'TmpFacture' And [xtype] = 'U' ))begin  Alter table TmpFacture Add FNaghd float not null,    Constraint DF_TmpFacture_FNaghd Default(0) For FNaghd,  FNaghdSarfasl NVarchar(11) null,  FCard float not null,  Constraint DF_TmpFacture_FCard Default(0) For FCard,  FCardSarfasl Nvarchar(11) null,  FNesiyeh float not null,   Constraint DF_TmpFacture_FNesiyeh Default(0) For FNesiyeh,  SumLevy float not null,   Constraint DF_TmpFacture_SumLevy Default(0) For SumLevy,  SumScot float not null,   Constraint DF_TmpFacture_SumScot Default(0) For SumScot, SumPrice float not null,  Constraint DF_TmpFacture_SumPrice Default(0) For SumPrice, SumFew float not null,  Constraint DF_TmpFacture_SumFew Default(0) For SumFew, WebId int  not null,  Constraint DF_TmpFacture_WebId Default(0) For WebId, C_Code_C Nvarchar(50) null end";
        jdbcTemp.execute(sqlStr);
        sqlStr = "if not exists (Select [Id] From sysColumns Where [Name] = 'Levy' And [id]=( Select [id] From Sysobjects where [Name] = 'TmpFactart' And [xtype] = 'U' )) begin  Alter table TmpFactart Add Levy float not null,     Constraint DF_TmpFactart_Levy Default(0) For Levy,  Scot float not null,    Constraint DF_TmpFactart_Scot Default(0) For Scot end";
        jdbcTemp.execute(sqlStr);
        sqlStr = " IF NOT EXISTS (SELECT [ID] FROM SYSCOLUMNS WHERE [NAME] = 'WEBBLOB' AND [ID] = (SELECT [ID] FROM  SYSOBJECTS WHERE [NAME] = 'PROCESS' AND [XTYPE] = 'U')) BEGIN  ALTER TABLE PROCESS ADD WEBBLOB IMAGE NULL  END";
        jdbcTemp.execute(sqlStr);
    }

    private void makeTriggerScripts(JdbcTemplate jdbcTemp) {
        jdbcTemp.execute("IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[trUpdateArt]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)  DROP trigger [dbo].[trUpdateArt]");
        jdbcTemp.execute("CREATE TRIGGER [dbo].[trUpdateArt] ON [dbo].[ARTICLE]\nFOR UPDATE, DELETE\nAs\nBEGIN\n   IF (SELECT COUNT(*) FROM INSERTED) > 0\n   BEGIN\n       DECLARE @OldIsChange int,@IsChange int\n       Select @OldIsChange = IsChange From deleted\n       Select @IsChange = IsChange From inserted\n       IF (Update(IsChange) And @OldIsChange = 0 And @IsChange = 1) or\n           (not Update(IsChange) And @OldIsChange = 0)\n           BEGIN\n           IF NOT UPDATE(IsChange)\n               UPDATE Article SET IsChange = 1, ModifyDate=GETDATE()\n                   WHERE A_Code IN (SELECT A_Code FROM inserted)\n           IF EXISTS " + this.getIfTmpDeleteExistString() + " \n               INSERT INTO TmpDeleteTable (TableKey,TableType,[state])\n                   SELECT A_Code,3,1 FROM Deleted\n                   WHERE CAST(A_Code as Nvarchar(7)) NOT IN                    (SELECT TableKey FROM TmpDeleteTable WHERE TableType = 3)\n       END\n       ELSE\n           IF NOT UPDATE(IsChange)\n               UPDATE Article SET ModifyDate = GETDATE()\n                   WHERE A_Code IN (SELECT A_Code FROM inserted)\n   END\n   ELSE IF EXISTS " + this.getIfTmpDeleteExistString() + " \n   BEGIN\n       IF (SELECT COUNT(A_Code)\n           FROM Deleted\n           WHERE CAST(A_Code AS NVARCHAR(7)) NOT IN (SELECT TableKey FROM TmpDeleteTable WHERE TableType = 3)) > 0\n               INSERT INTO TmpDeleteTable (TableKey,TableType,[state])\n               SELECT A_Code,3,0 From Deleted\n               WHERE CAST(A_Code as Nvarchar(7)) NOT IN (Select TableKey From TmpDeleteTable Where TableType = 3)\n   END\nEND");
        jdbcTemp.execute("if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trUpdateCus]') and OBJECTPROPERTY(id, N'IsTrigger') = 1) \n drop trigger [dbo].[trUpdateCus] \n");
        jdbcTemp.execute("create TRIGGER trUpdateCus \nON [Customer] \nFOR UPDATE, DELETE \nAS \nBEGIN \n   IF (SELECT COUNT(*) FROM Inserted) > 0 \n   BEGIN \n       declare @OldIsChange int, @IsChange int \n       Select  @OldIsChange = IsChange From deleted \n       Select  @IsChange = IsChange From inserted \n       if (Update(IsChange) And (@OldIsChange=0)And(@IsChange=1))or \n           ((not Update(IsChange))And (@OldIsChange = 0)) \n       begin \n           if not Update(IsChange) \n               update Customer set IsChange = 1, \n               ModifyDate=GETDATE() \n               where C_Code in (select C_Code from inserted) \n           IF EXISTS " + this.getIfTmpDeleteExistString() + " \n               Insert Into TmpDeleteTable (TableKey, TableType, [state]) \n               Select C_Code,4,1 From Deleted \n               where Cast(C_Code as Nvarchar(5)) not in                    (Select TableKey From TmpDeleteTable Where TableType = 4) \n       end \n       ELSE IF NOT UPDATE(IsChange)            update Customer set ModifyDate = GETDATE() \n           where C_Code in (select C_Code from inserted) \n  end \n  ELSE IF EXISTS " + this.getIfTmpDeleteExistString() + " \n  BEGIN    IF (SELECT COUNT(C_Code) \n    FROM Deleted \n    WHERE CAST(C_Code AS NVARCHAR(5)) NOT IN \n       (SELECT TableKey FROM TmpDeleteTable WHERE TableType = 4 )) > 0 \n     Insert Into TmpDeleteTable (TableKey,TableType,[state]) \n     Select C_Code,4,0 From Deleted \n     where Cast(C_Code as Nvarchar(5)) \n       not in (Select TableKey From TmpDeleteTable Where TableType = 4) \n  END \n END ");
    }

    private String getIfTmpDeleteExistString() {
        return " (SELECT * FROM DBO.SYSOBJECTS WHERE ID = OBJECT_ID(N'[dbo].[TmpDeleteTable]')  AND OBJECTPROPERTY(id, N'IsTable') = 1) ";
    }
}

