/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.dto.LoginDto;
import com.utility.TncJdbc;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

class DbConnectInfo {
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;

    private DbConnectInfo(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.transactionTemplate = transactionTemplate;
    }

    public static DbConnectInfo newInstance(javax.sql.DataSource dataSource, LoginDto loginDto) {
        TncJdbc tj = new TncJdbc(loginDto, dataSource);
        TransactionTemplate tt = new TransactionTemplate((PlatformTransactionManager)new JdbcTransactionManager(dataSource));
        return new DbConnectInfo((JdbcTemplate)tj, tt);
    }

    public DataSource getApacheDataSource() {
        return (DataSource)this.jdbcTemplate.getDataSource();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }
}

