/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.dto.LoginDto;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.utility.CodeChecker;
import com.utility.CodeCheckerResult;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TextNormalizer;
import com.utility.TncLog;
import com.webhook.dto.ChangeNotificationModel;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class CallApi {
    private static final TncLog log = new TncLog();

    private static HttpURLConnection setConnection(LoginDto myLogin, String furl) {
        try {
            HttpURLConnection conn = CallApi.getCommonConnection((String)furl);
            if (myLogin.getIsMyHoloo().booleanValue()) {
                conn.setRequestProperty("apikey", "25B430EC63D14BD285EF00174FC29BC3C4785D840E0541A8A69D0086C1074BCB");
                conn.setRequestProperty("serial", myLogin.getSerial());
            }
            return conn;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static HttpURLConnection getCommonConnection(String mUrl) throws IOException {
        URL url = new URL(mUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setConnectTimeout(600000);
        conn.setReadTimeout(600000);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        return conn;
    }

    private static void sendApi(HttpURLConnection conn, String input, String dbName) {
        if (CallApi.shouldNotCallApi()) {
            return;
        }
        try {
            DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)wr, StandardCharsets.UTF_8));
            writer.write(input);
            writer.close();
            wr.close();
            int responseCode = conn.getResponseCode();
            conn.disconnect();
            log.info("dbName: " + dbName + "responseCode = " + responseCode + ", method = " + (input.contains("Table") ? "GetNotify" : "LastChange"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void callApiLastChange(LoginDto myLogin) {
        if (myLogin.getIsTorfehNegar().booleanValue()) {
            return;
        }
        HttpURLConnection conn = CallApi.setConnection((LoginDto)myLogin, (String)"http://10.10.10.218:5100/api/AgentNotify/LastChange");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String Date2 = formatter.format(new Date());
        String DbName = myLogin.getDataBaseName();
        DbName = DbName.substring(DbName.indexOf("[") + 1, DbName.lastIndexOf("]"));
        String input = "{\"Dbname\":\"" + DbName + "\",  \"DateTime\":\"" + Date2 + "\",  \"Message\":\"\u0627\u062a\u0635\u0627\u0644 \u0628\u0647 \u0633\u0631\u0648\u0631\"}";
        CallApi.sendApi((HttpURLConnection)conn, (String)input, (String)myLogin.getDataBaseName());
    }

    public static boolean shouldNotCallApi() {
        File f = new File("./", "doNotCallApi.dat");
        return f.exists();
    }

    public static void callApiGetNotify(LoginDto myLogin, String tableName, int msgType, String commaSeparatedCodes, String commaSeparatedCRUDStates) {
        if (myLogin.getIsTorfehNegar().booleanValue()) {
            return;
        }
        HttpURLConnection conn = CallApi.setConnection((LoginDto)myLogin, (String)"http://10.10.10.218:5100/api/AgentNotify/GetNotify");
        String dbName = myLogin.getDataBaseName();
        dbName = dbName.substring(dbName.indexOf("[") + 1, dbName.lastIndexOf("]"));
        String input = "{\"Dbname\":\"" + dbName + "\",  \"Table\":\"" + tableName + "\",  \"MsgType\":" + msgType + ",  \"MsgValue\":\"" + commaSeparatedCodes + "\",  \"Message\":\"" + commaSeparatedCRUDStates + "\"}";
        if (tableName.equalsIgnoreCase("Article") || tableName.equalsIgnoreCase("PoshakProperties") || tableName.equalsIgnoreCase("Poshak")) {
            log.info("dbName: " + myLogin.getDataBaseName() + " *** JSON: " + input);
        }
        CallApi.sendApi((HttpURLConnection)conn, (String)input, (String)myLogin.getDataBaseName());
    }

    public static synchronized List<Map<String, Object>> callApiGetNotify(LoginDto myLogin, String tableName, int msgType, String commaSeparatedCodes, String commaSeparatedCRUDStates, String methodName, DbConnection dbConnection) {
        if (myLogin.getIsTorfehNegar().booleanValue()) {
            return new ArrayList<Map<String, Object>>();
        }
        CodeChecker codeChecker = new CodeChecker(myLogin, dbConnection, tableName);
        CodeCheckerResult result = codeChecker.findUnavailableCodes(commaSeparatedCodes, methodName, commaSeparatedCRUDStates);
        if (ConvertStr.isNullOrEmpty((String)result.getCodesToSend()) || ConvertStr.isNullOrEmpty((String)result.getCrudToSendForEach())) {
            return result.getCodesToResend();
        }
        HttpURLConnection conn = CallApi.setConnection((LoginDto)myLogin, (String)"http://10.10.10.218:5100/api/AgentNotify/GetNotify");
        String dbName = myLogin.getDataBaseName();
        dbName = dbName.substring(dbName.indexOf("[") + 1, dbName.lastIndexOf("]"));
        String input = "{\"Dbname\":\"" + dbName + "\",  \"Table\":\"" + tableName + "\",  \"MsgType\":" + msgType + ",  \"MsgValue\":\"" + result.getCodesToSend() + "\",  \"Message\":\"" + result.getCrudToSendForEach() + "\"}";
        if (tableName.equalsIgnoreCase("Article") || tableName.equalsIgnoreCase("M_Group") || tableName.equalsIgnoreCase("S_Group") || tableName.equalsIgnoreCase("PoshakProperties") || tableName.equalsIgnoreCase("Poshak") || tableName.equalsIgnoreCase("Sarfasl")) {
            log.info("table: " + tableName + "method: " + methodName + " dbName: " + myLogin.getDataBaseName() + " *** JSON: " + input);
        }
        CallApi.sendApi((HttpURLConnection)conn, (String)input, (String)myLogin.getDataBaseName());
        return result.getCodesToResend();
    }

    public static void sendChangeNotification(List<ChangeNotificationModel> model) {
        if (model == null || model.isEmpty()) {
            return;
        }
        HttpURLConnection conn = CallApi.setWebHookConnection((String)model.get(0).getUrl(), (String)model.get(0).getApiKey());
        String input = CallApi.getWebHookJson(model);
        CallApi.saveWebHookJson((String)input);
        CallApi.sendApi((HttpURLConnection)conn, (String)TextNormalizer.getNormalizedText((String)input), (String)model.get(0).getDbname());
    }

    private static HttpURLConnection setWebHookConnection(String url, String apiKey) {
        try {
            HttpURLConnection conn = CallApi.getCommonConnection((String)url);
            if (apiKey != null) {
                conn.setRequestProperty("apikey", apiKey);
            }
            return conn;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getWebHookJson(List<ChangeNotificationModel> model) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(model);
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    private static void saveWebHookJson(String json) {
        File file = new File("./", "sentToAPI.txt");
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ConvertStr.writeToFile((File)file, (String)json);
    }
}

