/*
 * Decompiled with CFR 0.152.
 */
package com.service.product;

import com.dao.PoshakDao;
import com.dto.ArticlePriceDto;
import com.dto.LoginDto;
import com.dto.Poshak;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.SearchQuery;
import com.utility.TncException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service
public class PoshakService {
    private final DbConnection db;
    private final PoshakDao dao;

    @Autowired
    public PoshakService(DbConnection db, PoshakDao dao) {
        this.db = db;
        this.dao = dao;
    }

    public List<Map<String, Object>> getPoshakPropsList(HttpServletRequest request) {
        LoginDto login = this.db.setToken();
        return this.dao.getPoshakProps(login, this.getFilterPoshakProps(request));
    }

    public Map<String, List<Map<String, Object>>> getPoshakListForProduct(String sqlWhere, @Nullable String commaSeparatedACodes) {
        LoginDto login = this.db.setToken();
        sqlWhere = this.getSqlWhereForAll(sqlWhere, commaSeparatedACodes);
        List rowSetPoshak = this.dao.getPoshak(login, sqlWhere);
        List rowSellPrices = this.dao.getPoshakSellPrices(login, sqlWhere);
        HashMap<String, List<Map<String, Object>>> mapPoshakList = new HashMap<String, List<Map<String, Object>>>();
        for (Map poshak : rowSetPoshak) {
            String aCode = (String)poshak.get("A_code");
            this.getSellPrices(poshak, rowSellPrices);
            if (!login.getIsMyHoloo().booleanValue()) {
                poshak.put("A_code", ConvertStr.encrypt((String)aCode));
            }
            if (mapPoshakList.containsKey(aCode)) {
                ((List)mapPoshakList.get(aCode)).add(poshak);
                continue;
            }
            mapPoshakList.put(aCode, ConvertStr.singletonArrayList((Object)poshak));
        }
        return mapPoshakList;
    }

    private String getSqlWhereForAll(String sqlWhere, String commaSeperatedACodes) {
        if (commaSeperatedACodes == null) {
            return sqlWhere;
        }
        if (ConvertStr.isNullOrEmpty((String)sqlWhere)) {
            return " WHERE A.A_CODE IN (" + commaSeperatedACodes + ")";
        }
        return sqlWhere + " AND A.A_CODE IN (" + commaSeperatedACodes + ")";
    }

    public List<Map<String, Object>> getPoshakList(String sqlWhere, String aCode) {
        LoginDto login = this.db.setToken();
        sqlWhere = this.getSqlWhere(sqlWhere, aCode);
        List rowSetPoshak = this.dao.getPoshak(login, sqlWhere);
        List rowSellPrices = this.dao.getPoshakSellPrices(login, sqlWhere);
        ArrayList<Map<String, Object>> mapPoshakList = new ArrayList<Map<String, Object>>();
        for (Map poshak : rowSetPoshak) {
            if (!ConvertStr.isNullOrEmpty((String)aCode) && !aCode.equals(poshak.get("A_Code"))) continue;
            this.getSellPrices(poshak, rowSellPrices);
            if (!login.getIsMyHoloo().booleanValue()) {
                poshak.put("A_code", ConvertStr.encrypt((String)((String)poshak.get("A_code"))));
            }
            mapPoshakList.add(poshak);
        }
        return mapPoshakList;
    }

    private String getSqlWhere(String sqlWhere, String aCode) {
        if (aCode == null) {
            return sqlWhere;
        }
        if (ConvertStr.isNullOrEmpty((String)sqlWhere)) {
            return " WHERE A.A_CODE=" + aCode;
        }
        return sqlWhere + " AND A.A_CODE=" + aCode;
    }

    public List<Map<String, Object>> getPoshakList(HttpServletRequest request) {
        return this.getPoshakList(this.getFilter(request), null);
    }

    private void getSellPrices(Map<String, Object> mapPoshak, List<Map<String, Object>> rowSellPrices) {
        for (Map<String, Object> map : rowSellPrices) {
            if (!mapPoshak.get("A_Code").equals(map.get("A_Code")) || !mapPoshak.get("Id").equals(map.get("ID"))) continue;
            LinkedHashMap<String, Object> sellPriceInnerAmounts = new LinkedHashMap<String, Object>();
            sellPriceInnerAmounts.put("Price", map.get("Price"));
            mapPoshak.put(this.getSellPriceTagNumber((Integer)map.get("SelId")), sellPriceInnerAmounts);
        }
    }

    private String getSellPriceTagNumber(Integer k) {
        if (k == null) {
            return "SellPrice";
        }
        return "SellPrice" + (k == 1 ? "" : k);
    }

    public synchronized List<Map<String, Object>> postPoshakSmartHelp(List<Poshak> poshakList) throws TncException {
        LoginDto loginDto = this.db.setToken();
        try {
            this.dao.bulkInsert(loginDto, poshakList);
        }
        catch (TncException e) {
            return Collections.singletonList(e.getErrorMap());
        }
        HashMap<String, Boolean> responseMap = new HashMap<String, Boolean>();
        responseMap.put("Success", true);
        return Collections.singletonList(responseMap);
    }

    public synchronized List<Map<String, Object>> postPoshakPropertiesSmartHelp(List<Poshak> poshakList) throws TncException {
        LoginDto loginDto = this.db.setToken();
        try {
            this.dao.bulkInsertPoshakProperties(loginDto, poshakList);
        }
        catch (TncException e) {
            return Collections.singletonList(e.getErrorMap());
        }
        HashMap<String, Boolean> responseMap = new HashMap<String, Boolean>();
        responseMap.put("Success", true);
        return Collections.singletonList(responseMap);
    }

    public synchronized ResponseEntity<?> insertArticlePriceSH(ArticlePriceDto[] dtoArray) {
        LoginDto loginDto = this.db.setToken();
        try {
            this.dao.bulkInsertArticlePrice(loginDto, dtoArray);
        }
        catch (TncException e) {
            return ConvertStr.getMapResponseEntity((String)"ArticlePrice", Collections.singletonList(e.getErrorMap()), Collections.emptyList());
        }
        HashMap<String, Boolean> responseMap = new HashMap<String, Boolean>();
        responseMap.put("Success", true);
        return ConvertStr.getMapResponseEntity((String)"ArticlePrice", Collections.emptyList(), Collections.singletonList(responseMap));
    }

    private String getFilter(HttpServletRequest request) {
        String sqlWhere = "";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        SearchQuery searchQuery = new SearchQuery();
        if (info.containsKey("id")) {
            sqlWhere = sqlWhere + searchQuery.makeSqlQueryNoTextSearch((String)info.get("id"), "[poshakId]", "i");
        }
        if (info.containsKey("a_code")) {
            sqlWhere = this.addAndIfNecessary(sqlWhere);
            sqlWhere = sqlWhere + searchQuery.makeSqlQueryNoTextSearch((String)info.get("a_code"), "[a_code]", "i");
        }
        if (info.containsKey("parentid")) {
            sqlWhere = this.addAndIfNecessary(sqlWhere);
            sqlWhere = sqlWhere + searchQuery.makeSqlQueryNoTextSearch((String)info.get("parentid"), "[parentId]", "i");
        }
        if (info.containsKey("producterpcode")) {
            sqlWhere = this.addAndIfNecessary(sqlWhere);
            sqlWhere = sqlWhere + searchQuery.makeSqlQueryNoTextSearch(ConvertStr.decrypt((String)((String)info.get("producterpcode"))), "[a_code]", "i");
        }
        if (!"".equals(sqlWhere)) {
            sqlWhere = " Where " + sqlWhere;
        }
        return sqlWhere;
    }

    private String addAndIfNecessary(String sqlWhere) {
        return !sqlWhere.isEmpty() ? sqlWhere + " And " : "";
    }

    private String getFilterPoshakProps(HttpServletRequest request) {
        String sqlWhere = "";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        SearchQuery searchQuery = new SearchQuery();
        if (info.containsKey("id")) {
            sqlWhere = sqlWhere + searchQuery.makeSqlQueryNoTextSearch((String)info.get("id"), "[ID]", "");
        }
        if (info.containsKey("parentid")) {
            sqlWhere = this.addAndIfNecessary(sqlWhere);
            sqlWhere = sqlWhere + searchQuery.makeSqlQueryNoTextSearch((String)info.get("parentid"), "[parentId]", "");
        }
        if (info.containsKey("name")) {
            sqlWhere = this.addAndIfNecessary(sqlWhere);
            sqlWhere = sqlWhere + searchQuery.makeSqlQuery((String)info.get("name"), "[NAME]", "", "PoshakProperties");
        }
        if (!"".equals(sqlWhere)) {
            sqlWhere = " Where " + sqlWhere;
        }
        return sqlWhere;
    }
}

