/*
 * Decompiled with CFR 0.152.
 */
package com.service.product;

import com.dao.ItemArticleDao;
import com.dto.ItemArticleDto;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ItemArticleService {
    private final ItemArticleDao itemArticleDao;
    private final DbConnection dbConnection;

    @Autowired
    public ItemArticleService(ItemArticleDao itemArticleDao, DbConnection dbConnection) {
        this.itemArticleDao = itemArticleDao;
        this.dbConnection = dbConnection;
    }

    public synchronized ResponseEntity<Map<String, Object>> postItemArticleSH(List<ItemArticleDto> body) {
        LoginDto loginDto = this.dbConnection.setToken();
        if (!loginDto.getIsMyHoloo().booleanValue()) {
            return null;
        }
        return this.postSmartHelpItemArticle(loginDto, body);
    }

    private ResponseEntity<Map<String, Object>> postSmartHelpItemArticle(LoginDto loginDto, List<ItemArticleDto> body) {
        try {
            this.itemArticleDao.bulkInsert(loginDto, body);
            return ConvertStr.getMapResponseEntity((String)"ItemArticle", null, (List)this.makeSuccessMap());
        }
        catch (TncException e) {
            return ConvertStr.getMapResponseEntity((String)"ItemArticle", Collections.singletonList(e.getErrorMap()), null);
        }
    }

    private ResponseEntity<Map<String, Object>> postSelfHostItemArticle(LoginDto loginDto, List<ItemArticleDto> body) {
        return (ResponseEntity)this.dbConnection.getTransactionTemplate(loginDto).execute(status -> {
            try {
                for (ItemArticleDto itemArticleDto : body) {
                    int idC = this.getIdC(itemArticleDto.getA_code(), loginDto);
                    itemArticleDto.setPoshakidc(idC);
                    this.itemArticleDao.insert(itemArticleDto, loginDto);
                }
                return ConvertStr.getMapResponseEntity((String)"ItemArticle", null, (List)this.makeSuccessMap());
            }
            catch (Exception ignore) {
                TncException e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
                return ConvertStr.getMapResponseEntity((String)"ItemArticle", Collections.singletonList(e.getErrorMap()), null);
            }
        });
    }

    private List<Map<String, Object>> makeSuccessMap() {
        HashMap<String, Boolean> success = new HashMap<String, Boolean>();
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>();
        success.put("Success", true);
        successList.add(success);
        return successList;
    }

    private int getIdC(String aCode, LoginDto loginDto) {
        int idC = this.itemArticleDao.getExistingPoshakIdC(aCode, loginDto);
        return ++idC;
    }
}

