/*
 * Decompiled with CFR 0.152.
 */
package com.service;

import com.dao.HolooSettingsDao;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.SoftwareInfo;
import com.utility.TncJdbc;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class SettingLoader {
    private final LoginDto login;
    private HolooSettingsDao settingDao;

    public SettingLoader(DbConnection dbConnection, LoginDto login) {
        this.settingDao = new HolooSettingsDao(dbConnection);
        this.login = login;
    }

    public <T> T getUserDBField(String fieldName) {
        SqlRowSet rs = this.settingDao.getJdbcTemplate(this.login).queryForRowSet("SELECT " + fieldName + " FROM UserDB WHERE UserCodeInc = ?", new Object[]{this.login.getUserCodeInc()});
        if (!rs.next()) {
            return null;
        }
        if (rs.getObject(fieldName) == null) {
            return null;
        }
        return (T)rs.getObject(fieldName);
    }

    public <T> T getUserDBField(String fieldName, T defValue) {
        Object t = this.getUserDBField(fieldName);
        return (T)(t != null ? t : defValue);
    }

    public int getDollarUnit() {
        return this.settingDao.getMSetup2Integer(this.login, "Dollar_Unit");
    }

    public boolean getSecondUnit() {
        return this.settingDao.getMSetup2Boolean(this.login, "SecondVahed");
    }

    public boolean negativeInvoiceEnabled() {
        return this.settingDao.getMSetupBoolean(this.login, "Negative_Fact");
    }

    public boolean negativeOfSathEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "Negative_OfSath");
    }

    public boolean negativeOfPishEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "NegativePish");
    }

    public boolean negativeOfReqEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "NegativeInReq");
    }

    public boolean calcSoodInForooshEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "CalcSoodInForoosh");
    }

    public boolean calcSoodInForooshEndBuyPriceEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "CalcSoodInForooshEndBuyPrice");
    }

    public boolean hazinehInFactFEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "HazinehInFactF");
    }

    public boolean hazinehInFactKEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "HazinehInFactK");
    }

    public boolean sarshekanHazinehEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "SarshekanHazineh");
    }

    public boolean mustHaveStore() {
        return !this.settingDao.getMSetup2Boolean(this.login, "Res_SelNotExistedArt");
    }

    private boolean isAnyDiscount() {
        return this.settingDao.getMSetup2Boolean(this.login, "AnyTakhfif");
    }

    public boolean isDiscountEnabled() {
        return this.isUseRialDiscountPercent() || this.isUsePerRowDiscountPrice();
    }

    public boolean isUseRialDiscountPercent() {
        return this.isAnyDiscount() && this.getDiscountMode() == 2 && this.useRialDiscountPercent();
    }

    public boolean useRialDiscountPercent() {
        return this.settingDao.getMSetup2Boolean(this.login, "DarsadTakhfifR");
    }

    public boolean isProductDiscountPerMGroup() {
        return this.settingDao.getMSetup2Boolean(this.login, "MGroupDarsadTakhfif");
    }

    public boolean isProductDiscountPerSGroup() {
        return this.settingDao.getMSetup2Boolean(this.login, "SGroupDarsadTakhfif");
    }

    private boolean isTakhfifRAskAllPriceCalcTDarsad() {
        return this.settingDao.getMSetup2Boolean(this.login, "TakhfifRAskAllPriceCalcTDarsad");
    }

    public boolean isUsePerRowDiscountPercent() {
        return this.isAnyDiscount() && this.getDiscountMode() == 2 && this.isTakhfifRAskAllPriceCalcTDarsad() && this.getUseTakhfifPriceOrDarasd() == 0;
    }

    public boolean isUsePerRowDiscountPrice() {
        return this.isAnyDiscount() && this.getDiscountMode() == 2 && this.isTakhfifRAskAllPriceCalcTDarsad() && this.getUseTakhfifPriceOrDarasd() == 1;
    }

    private int getUseTakhfifPriceOrDarasd() {
        return this.settingDao.getMSetup2Integer(this.login, "PriceOrDarasd");
    }

    private int getDiscountMode() {
        return this.settingDao.getMSetup2Integer(this.login, "ModeTakhfif");
    }

    public boolean isCalcExistInFactByPFact() {
        return this.settingDao.getMSetup2Boolean(this.login, "CalcExistInFactByPFact");
    }

    public int getKindVAT() {
        int kindVat = this.isPercentInvoice() && this.isPercentInvoiceSale() ? (this.isCalcVatJ() ? 0 : 1) : 2;
        return kindVat;
    }

    private boolean isPercentInvoice() {
        return this.settingDao.getMSetup2Boolean(this.login, "DarsadFacture");
    }

    private boolean isPercentInvoiceSale() {
        return this.settingDao.getMSetup2Boolean(this.login, "DarsadFactF");
    }

    public boolean isCalcVatJ() {
        return (this.isVatInvoiceScotSell() || this.isVATInvoiceScotBuy() || this.isVatInvoiceLevySell() || this.isVATInvoiceLevyBuy()) && this.settingDao.getMSetup2Boolean(this.login, "CalcVat_J");
    }

    public boolean isCalcVatK() {
        return this.settingDao.getMSetup2Boolean(this.login, "CalcVat_K");
    }

    private Boolean andBooleans(SqlRowSet rowSet) {
        boolean res = true;
        while (rowSet.next()) {
            res = rowSet.getBoolean("Boolean") && res;
        }
        return res;
    }

    public boolean isVatInvoiceScotSell() {
        return (Boolean)this.settingDao.doMultiple(arg_0 -> this.andBooleans(arg_0), "[Boolean]", "0", this.login, new String[]{"DarsadFacture", "DarsadFactF", "Darsad_Shahrdary"});
    }

    public boolean isVatInvoiceLevySell() {
        return (Boolean)this.settingDao.doMultiple(arg_0 -> this.andBooleans(arg_0), "[Boolean]", "0", this.login, new String[]{"DarsadFacture", "DarsadFactF", "Darsad_Amozesh"});
    }

    public boolean isVATInvoiceScotBuy() {
        return (Boolean)this.settingDao.doMultiple(arg_0 -> this.andBooleans(arg_0), "[Boolean]", "0", this.login, new String[]{"DarsadFacture", "DarsadFactK", "Darsad_Shahrdary"});
    }

    public boolean isVATInvoiceLevyBuy() {
        return (Boolean)this.settingDao.doMultiple(arg_0 -> this.andBooleans(arg_0), "[Boolean]", "0", this.login, new String[]{"DarsadFacture", "DarsadFactK", "Darsad_Amozesh"});
    }

    public double getLevyPercent() {
        return ConvertStr.parseNullSafeDouble((String)this.settingDao.getMSetup2String(this.login, "Darsad_Maliyat", "0"));
    }

    public double getScotPercent() {
        return ConvertStr.parseNullSafeDouble((String)this.settingDao.getMSetup2String(this.login, "Darsad_Avarez", "0"));
    }

    public double getServicePercent() {
        return this.settingDao.getMSetup2Float(this.login, "Res_DarsadService");
    }

    public String getDefaultCustomer() {
        return this.settingDao.getMSetup2String(this.login, "DefPartyCode", null);
    }

    public boolean sendProductsDisabled() {
        return (Boolean)this.getUserDBField("WSendArticle", (Object)false) == false;
    }

    public boolean sendResTablesDisabled() {
        return (Boolean)this.getUserDBField("WSendDesk", (Object)false) == false;
    }

    public boolean sendPicturesDisabled() {
        return (Boolean)this.getUserDBField("WSendArticlePicture", (Object)false) == false;
    }

    public boolean isTaxEnabledOnProducts() {
        return this.settingDao.getMSetup2Boolean(this.login, "ArticleHasTax");
    }

    public int getPrintConfigType() {
        if (this.isCustomPrintDisabled()) {
            return -1;
        }
        return this.settingDao.getMSetup2Integer(this.login, "ResPrintConfigType");
    }

    private boolean isCustomPrintDisabled() {
        return !this.settingDao.getMSetup2Boolean(this.login, "ResHasCutomPrint");
    }

    public boolean isSendActiveResMenuProducts() {
        return this.settingDao.getMSetup2Integer(this.login, "SendArticleType", -1) == 0;
    }

    public boolean userHasLimitedAccessToProducts() {
        return this.settingDao.userHasLimitedAccessToProducts(this.login);
    }

    public boolean showInvoicePayment() {
        return this.login.getSuperVizor() != false || this.settingDao.getMSetup2Boolean(this.login, "Res_OKOtherFactor");
    }

    public boolean showThisUserResInvoicesOnly() {
        return this.login.getSuperVizor() == false && this.settingDao.getMSetup2Boolean(this.login, "Res_FilterUserReservFacts");
    }

    private boolean getMS2Boolean(String name) {
        return this.settingDao.getMSetup2Boolean(this.login, name);
    }

    public boolean isNegativeInvoiceAllowed() {
        return this.settingDao.getMSetupBoolean(this.login, "Negative_Fact");
    }

    public boolean doNotSendCustomerData() {
        return (Boolean)this.getUserDBField("WSendParty", (Object)false) == false;
    }

    public double getMS2Double(String name) {
        return this.settingDao.getMSetup2Float(this.login, name);
    }

    public boolean isUseUnit() {
        return this.settingDao.getMSetup2Boolean(this.login, "M_Unit");
    }

    public boolean isCalcByUnit() {
        return this.settingDao.getMSetup2Boolean(this.login, "SecondVahed") && this.isUseUnit();
    }

    public boolean unitSellPriceEnabled() {
        return this.isUseUnit() && !this.userCannotAccessPriceTypes() && this.settingDao.getMSetup2Boolean(this.login, "UnitSellPrice");
    }

    public boolean searchArtGroupEnabled() {
        return this.getMS2Boolean("SearchMgSgArt");
    }

    public boolean searchArtSubGroupEnabled() {
        return this.getMS2Boolean("SearchBySideGroup");
    }

    public boolean isPartyGroupEnabled() {
        return (Boolean)this.getUserDBField("DBPnlUserPartyGroup", (Object)false) != false && this.getMS2Boolean("FreeCodeForCustomer") && (!this.getMS2Boolean("BedCustomerMoienTaf") || !this.getMS2Boolean("BesCustomerMoienTaf"));
    }

    public boolean isCreditAlarmEnabled() {
        return this.getMS2Boolean("AlarmEtebar");
    }

    public boolean isRepeatArtEnabled() {
        return this.getMS2Boolean("AdamTekrarKala");
    }

    public boolean isKitShoes() {
        return (Integer)Objects.requireNonNull(this.settingDao.getJdbcTemplate(this.login).queryForObject("SELECT COUNT(*) CNT FROM ArtExst2", Integer.class)) > 0;
    }

    public long getPartyMaxCode() {
        SqlRowSet rs = this.settingDao.getJdbcTemplate(this.login).queryForRowSet("Select Max(cast(C_Code AS bigint)) maxCode from  CUSTOMER");
        rs.next();
        return rs.getLong("maxCode");
    }

    public boolean isModatTasviehEnabled() {
        return this.getMS2Boolean("SlctModdatTasvieh");
    }

    public boolean isSendCustomerRemainDisabled() {
        return (Boolean)this.getUserDBField("WSendReminParty", (Object)false) == false;
    }

    public boolean isSendPartyOpenChecksRemainDisabled() {
        return (Boolean)this.getUserDBField("WSendReminChequeNotReceive", (Object)false) == false;
    }

    public boolean isEmkanVosoolCheckKharjiEnabled() {
        return this.getMS2Boolean("EmkanVosoolCheckKharji");
    }

    public boolean isCalcExistInReqEnabled() {
        return this.getMS2Boolean("CalcExistInReq");
    }

    public boolean isUseHazHamlInFactEnabled() {
        return this.getMS2Boolean("UseHazHamlInFact");
    }

    public double getRoundNumber() {
        return this.getMS2Double("RoundNumber");
    }

    public boolean picsSavedInDB() {
        return this.getMS2Boolean("CheckBoxSavepicinDb");
    }

    public boolean userHasLimitedAccessToCustomers() {
        return (Boolean)this.getUserDBField("DBPnlUserPartyRight", (Object)false);
    }

    public boolean userHasAccessToInvoiceBeforeTimeRecord() {
        return this.isGetGps() && (Boolean)this.getUserDBField("AccessDroidGPSFact", (Object)false) != false;
    }

    public boolean isGetGps() {
        return this.isGPSEnabled() && new SoftwareInfo(this.getJdbc()).lockAllowsGPS();
    }

    private boolean isGPSEnabled() {
        return (Boolean)this.getUserDBField("AccessDroidGPS", (Object)false);
    }

    public String getMidManId() {
        return (String)this.getUserDBField("MiddleManId", (Object)"");
    }

    public boolean getReceiveMoienByUser() {
        return this.getMS2Boolean("WReciveMoeinByUser");
    }

    private boolean userCannotAccessPriceTypes() {
        return (Boolean)this.getUserDBField("DBPnlOrderPriceType", (Object)false) == false;
    }

    public Boolean[] getAllowedPriceTypesForUser() {
        String allowedPriceTypes;
        Object[] allPriceTypes = new Boolean[10];
        if (this.userCannotAccessPriceTypes()) {
            Arrays.fill(allPriceTypes, (Object)false);
            return allPriceTypes;
        }
        SqlRowSet rs = this.getJdbc().queryForRowSet("SELECT IsNull(UserListArt5Price, '') allowedPriceTypes FROM UserDB \n WHERE IsUserLimitArt5Price = 1 AND UserCodeInc = ?", new Object[]{this.login.getUserCodeInc()});
        if (!rs.next() || ConvertStr.isNullOrEmpty((String)(allowedPriceTypes = rs.getString("allowedPriceTypes")))) {
            Arrays.fill(allPriceTypes, (Object)true);
            return allPriceTypes;
        }
        Arrays.fill(allPriceTypes, (Object)false);
        for (String typeIndex : allowedPriceTypes.split(",")) {
            allPriceTypes[Integer.parseInt((String)typeIndex)] = true;
        }
        return allPriceTypes;
    }

    public boolean getUserArtAmountAccess() {
        return (Boolean)this.getUserDBField("DBPnlUserArtAmountRight", (Object)false);
    }

    public boolean isDueDateEnabled() {
        return this.getMS2Boolean("SlctModdatTasvieh");
    }

    public boolean isThreeUnitEnabled() {
        return this.getMS2Boolean("FlagKarton_Basteh");
    }

    public boolean isCalcNewBoxPack() {
        return this.getMS2Boolean("CalcNewKartonBasteh");
    }

    public boolean isArticleExist2Enabled() {
        return this.getMS2Boolean("ArticleExist2");
    }

    public boolean isArticleExistInvoiceEnabled() {
        return this.getMS2Boolean("ArtExistFact");
    }

    public <T> void getMapMultiple(Function<SqlRowSet, T> doOnEachRow, Consumer<Map<String, T>> consumeResultMap, String valueColName, String valueColDefaultValue, String ... names) {
        consumeResultMap.accept(this.settingDao.getMapMultiple(doOnEachRow, valueColName, valueColDefaultValue, this.login, names));
    }

    public TncJdbc getJdbc() {
        return this.settingDao.getJdbcTemplate(this.login);
    }

    public LoginDto getLogin() {
        return this.login;
    }

    public HolooSettingsDao getSettingDao() {
        return this.settingDao;
    }

    public void setSettingDao(HolooSettingsDao settingDao) {
        this.settingDao = settingDao;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SettingLoader)) {
            return false;
        }
        SettingLoader other = (SettingLoader)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LoginDto this$login = this.getLogin();
        LoginDto other$login = other.getLogin();
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        HolooSettingsDao this$settingDao = this.getSettingDao();
        HolooSettingsDao other$settingDao = other.getSettingDao();
        return !(this$settingDao == null ? other$settingDao != null : !this$settingDao.equals(other$settingDao));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SettingLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoginDto $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        HolooSettingsDao $settingDao = this.getSettingDao();
        result = result * 59 + ($settingDao == null ? 43 : $settingDao.hashCode());
        return result;
    }

    public String toString() {
        return "SettingLoader(login=" + this.getLogin() + ", settingDao=" + this.getSettingDao() + ")";
    }
}

