/*
 * Decompiled with CFR 0.152.
 */
package com.security;

import com.dto.LoginDto;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class JwtAuthorizationFilter
extends BasicAuthenticationFilter {
    public JwtAuthorizationFilter(AuthenticationManager authenticationManager) {
        super(authenticationManager);
    }

    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String header = req.getHeader("Authorization");
        if (header == null || !header.startsWith("Bearer ")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        UsernamePasswordAuthenticationToken authentication = this.getAuthentication(req);
        if (authentication != null) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        } else {
            res.setStatus(200);
            res.setContentType("application/json");
            res.getWriter().println("{\"Login\":{\"State\":\"false\", \"Error\":\"Invalid Token\", \"ErrorCode\":2}}");
        }
    }

    private UsernamePasswordAuthenticationToken getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        try {
            if (token == null) {
                return null;
            }
            Claims body = (Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody();
            Object userId = body.get((Object)"username");
            if (userId != null) {
                LoginDto myLoginClass = LoginDto.builder().UserName((String)userId).DataBaseName((String)body.getOrDefault((Object)"databaseName", (Object)"")).UserCodeInc(((Integer)body.getOrDefault((Object)"userCodeInc", (Object)0)).intValue()).Serial((String)body.getOrDefault((Object)"serial", (Object)"")).IsTorfehNegar(Boolean.valueOf((Boolean)body.getOrDefault((Object)"isTnc", (Object)false))).isAndroid(((Boolean)body.getOrDefault((Object)"isAndroid", (Object)false)).booleanValue()).subsystemid(((Integer)body.getOrDefault((Object)"subSystemId", (Object)0)).intValue()).isPosLog(((Boolean)body.getOrDefault((Object)"isPosLog", (Object)false)).booleanValue()).IsMyHoloo(Boolean.valueOf((Boolean)body.getOrDefault((Object)"isMyHoloo", (Object)false))).SuperVizor(Boolean.valueOf((Boolean)body.getOrDefault((Object)"supervisor", (Object)false))).complimentaryActive(((Boolean)body.getOrDefault((Object)"complimentary", (Object)false)).booleanValue()).build();
                return new UsernamePasswordAuthenticationToken((Object)myLoginClass, null, new ArrayList());
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }
}

