/*
 * Decompiled with CFR 0.152.
 */
package com.resource;

import com.Application;
import com.dao.MainGroupDao;
import com.dao.ProductDao;
import com.dao.SideGroupDao;
import com.dao.UnitDao;
import com.dto.ArticlePriceDto;
import com.dto.Poshak;
import com.google.gson.Gson;
import com.service.product.PoshakService;
import com.utility.ConvertStr;
import com.utility.JsonParser;
import com.utility.TextNormalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
public class Product {
    private final Application config;
    private final MainGroupDao mainGroupDao;
    private final SideGroupDao sideGroupDao;
    private final UnitDao unitDao;
    private final PoshakService poshakService;
    private final ProductDao productDao;

    public Product(Application Config, MainGroupDao mainGroupDao, SideGroupDao sideGroupDao, UnitDao unitDao, PoshakService poshakService, ProductDao productDao) {
        this.config = Config;
        this.mainGroupDao = mainGroupDao;
        this.sideGroupDao = sideGroupDao;
        this.unitDao = unitDao;
        this.poshakService = poshakService;
        this.productDao = productDao;
    }

    @GetMapping(value={"/MainGroup"})
    public ResponseEntity<?> getMainGroup(HttpServletRequest request) {
        if (!this.config.usePack1) {
            return null;
        }
        return this.mainGroupDao.getMainGroupList(request);
    }

    @GetMapping(value={"/SideGroup"})
    public ResponseEntity<?> getSideGroup(HttpServletRequest request) {
        if (!this.config.usePack1) {
            return null;
        }
        return this.sideGroupDao.getSideGroupList(request);
    }

    @GetMapping(value={"/Unit"})
    public ResponseEntity<?> getUnit(HttpServletRequest request) {
        if (!this.config.usePack1) {
            return null;
        }
        return this.unitDao.getUnitList(request);
    }

    @GetMapping(value={"/Poshak"})
    public ResponseEntity<?> getPoshak(HttpServletRequest request) {
        if (!this.config.usePack1) {
            return null;
        }
        return ConvertStr.getMapResponseEntity((String)"poshak", (List)this.poshakService.getPoshakList(request), (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    @GetMapping(value={"/PoshakProps"})
    public ResponseEntity<?> getPoshakProps(HttpServletRequest request) {
        if (!this.config.usePack1) {
            return null;
        }
        return ConvertStr.getMapResponseEntity((String)"PoshakProps", (List)this.poshakService.getPoshakPropsList(request), (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    @ApiIgnore
    @PostMapping(value={"/PoshakZ"})
    public ResponseEntity<?> postPoshakZ(@RequestBody byte[] zippedBody) {
        if (!this.config.usePack2) {
            return null;
        }
        String body = ConvertStr.deCompressionGZip((byte[])zippedBody);
        body = body.substring(14, body.length() - 1);
        Gson gson = new Gson();
        Poshak[] items = (Poshak[])gson.fromJson(body, Poshak[].class);
        return ConvertStr.getMapResponseEntity((String)"Poshak", new ArrayList(), (List)this.poshakService.postPoshakSmartHelp(Arrays.asList(items)));
    }

    @ApiIgnore
    @PostMapping(value={"/PoshakPropsZ"})
    public ResponseEntity<?> postPoshakPropsZ(@RequestBody byte[] zippedBody) {
        if (!this.config.usePack2) {
            return null;
        }
        String body = ConvertStr.deCompressionGZip((byte[])zippedBody);
        body = body.substring(14, body.length() - 1);
        Gson gson = new Gson();
        Poshak[] items = (Poshak[])gson.fromJson(body, Poshak[].class);
        return ConvertStr.getMapResponseEntity((String)"PoshakProperties", new ArrayList(), (List)this.poshakService.postPoshakPropertiesSmartHelp(Arrays.asList(items)));
    }

    @ApiIgnore
    @PostMapping(value={"/ArticlePriceZ"})
    public ResponseEntity<?> postArticlePrice(@RequestBody byte[] zippedBody) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.poshakService.insertArticlePriceSH((ArticlePriceDto[])new JsonParser(ArticlePriceDto[].class).parseJson(ConvertStr.deCompressionGZip((byte[])zippedBody)));
    }

    @GetMapping(value={"/Product"})
    public ResponseEntity<?> getProduct(HttpServletRequest request) {
        if (!this.config.usePack1) {
            return null;
        }
        return this.productDao.getProductList(request, -1, -1);
    }

    @GetMapping(value={"/Product/{page}/{itemsPerPage}"})
    public ResponseEntity<?> getProduct(HttpServletRequest request, @PathVariable(value="page") int page, @PathVariable(value="itemsPerPage") int itemsPerPage) {
        if (!this.config.usePack1) {
            return null;
        }
        return this.productDao.getProductList(request, itemsPerPage, page);
    }

    @GetMapping(value={"/Product/count"})
    public ResponseEntity<?> getProductCount(HttpServletRequest request) {
        if (!this.config.usePack1) {
            return null;
        }
        return this.productDao.getProductCount(request);
    }

    @PostMapping(value={"/MainGroup"}, consumes={"application/json"})
    public ResponseEntity<?> postMainGroup(@RequestBody String body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.mainGroupDao.postMainGroupList(body, 0, true);
    }

    @PutMapping(value={"/MainGroup"}, consumes={"application/json"})
    public ResponseEntity<?> putMainGroup(@RequestBody String body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.mainGroupDao.postMainGroupList(body, 1, true);
    }

    @PostMapping(value={"/MainGroupZ"}, consumes={"application/json"})
    public ResponseEntity<?> postMainGroup(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.mainGroupDao.postMainGroupList(ConvertStr.deCompressionGZip((byte[])body), 0, false);
    }

    @PostMapping(value={"/SideGroup"}, consumes={"application/json"})
    public ResponseEntity<?> postSideGroup(@RequestBody String body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.sideGroupDao.postSideGroupList(body, 0, true);
    }

    @PutMapping(value={"/SideGroup"}, consumes={"application/json"})
    public ResponseEntity<?> putSideGroup(@RequestBody String body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.sideGroupDao.postSideGroupList(body, 1, true);
    }

    @PostMapping(value={"/SideGroupZ"}, consumes={"application/json"})
    public ResponseEntity<?> postSideGroup(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.sideGroupDao.postSideGroupList(ConvertStr.deCompressionGZip((byte[])body), 0, false);
    }

    @PostMapping(value={"/Product"}, consumes={"application/json"})
    public ResponseEntity<?> postProduct(@RequestBody String body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.productDao.postProductList(body, 0, true);
    }

    @PutMapping(value={"/Product"}, consumes={"application/json"})
    public ResponseEntity<?> putProduct(@RequestBody String body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.productDao.postProductList(body, 1, true);
    }

    @PostMapping(value={"/ProductZ"}, consumes={"application/json"})
    public ResponseEntity<?> postProduct(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.productDao.postProductList(ConvertStr.deCompressionGZip((byte[])body), 0, false);
    }
}

