/*
 * Decompiled with CFR 0.152.
 */
package com.resource;

import com.Application;
import com.dao.InvoiceDao;
import com.dto.InvoiceDto;
import com.utility.ConvertStr;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/Invoice"})
public class Invoice {
    private final Application config;
    private final InvoiceDao invoiceDao;

    public Invoice(Application Config, InvoiceDao invoiceDao) {
        this.config = Config;
        this.invoiceDao = invoiceDao;
    }

    @GetMapping(value={"/PreInvoice"}, produces={"application/json"})
    public ResponseEntity<?> getPreInvoiceInfo(HttpServletRequest request) {
        if (!this.config.usePack2) {
            return null;
        }
        request.setAttribute("type", (Object)new String[]{"5"});
        return this.invoiceDao.getInvoiceList(request);
    }

    @GetMapping(value={"/PreInvoiceConvert"}, produces={"application/json"})
    public ResponseEntity<?> getConvertInvoice(HttpServletRequest request) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.invoiceDao.getInvoiceInfo(request, 1);
    }

    @GetMapping(value={"/Order"}, produces={"application/json"})
    public ResponseEntity<?> getOrderInfo(HttpServletRequest request) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.invoiceDao.getInvoiceInfo(request, 0);
    }

    @GetMapping(value={"/Invoice"}, produces={"application/json"})
    public ResponseEntity<?> getInvoiceList(HttpServletRequest request) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.invoiceDao.getInvoiceList(request);
    }

    @GetMapping(value={"/TmpInvoice"}, produces={"application/json"})
    public ResponseEntity<?> getTmpInvoiceList(HttpServletRequest request) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.invoiceDao.getTmpInvoiceList(request);
    }

    @PostMapping(value={"/PreInvoice"}, consumes={"application/json"})
    public ResponseEntity<?> postPreInvoiceList(@RequestBody String body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.invoiceDao.postInvoiceList(body, 1, true);
    }

    @PostMapping(value={"/PreInvoiceZ"}, consumes={"application/json"})
    public ResponseEntity<?> postPreInvoiceList(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.invoiceDao.postSmartHelpPreInvoice(ConvertStr.deCompressionGZip((byte[])body));
    }

    @PostMapping(value={"/Order"}, consumes={"application/json"})
    public ResponseEntity<?> postOrderList(@RequestBody String body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.invoiceDao.postInvoiceList(body, 0, true);
    }

    @PostMapping(value={"/OrderZ"}, consumes={"application/json"})
    public ResponseEntity<?> postOrderList(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.invoiceDao.postSmartHelpOrder(ConvertStr.deCompressionGZip((byte[])body));
    }

    @PostMapping(value={"/Invoice"}, consumes={"application/json"})
    public ResponseEntity<?> postInvoiceList(@RequestBody String body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.invoiceDao.postInvoiceList(body, 2, true);
    }

    @PostMapping(value={"/InvoiceZ"}, consumes={"application/json"})
    public ResponseEntity<?> postInvoiceList(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.invoiceDao.postInvoiceList(ConvertStr.deCompressionGZip((byte[])body), 2, false);
    }

    @ApiIgnore
    @PutMapping(value={"/Invoice"})
    public ResponseEntity<?> editInvoiceList(@RequestBody InvoiceDto body) {
        return this.invoiceDao.editInvoice(body.getInvoiceInfo());
    }
}

