/*
 * Decompiled with CFR 0.152.
 */
package com.resource;

import com.Application;
import com.dao.CustomerDao;
import com.dao.InvoiceDao;
import com.dao.ProductDao;
import com.utility.ConvertStr;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/General"})
public class General {
    private final Application config;
    private final CustomerDao customer;
    private final InvoiceDao invoiceDao;
    private final ProductDao productDao;

    public General(Application Config, CustomerDao customer, InvoiceDao invoiceDao, ProductDao productDao) {
        this.config = Config;
        this.customer = customer;
        this.invoiceDao = invoiceDao;
        this.productDao = productDao;
    }

    @PostMapping(consumes={"application/json"})
    public ResponseEntity<?> postInvoiceList(@RequestBody String body) throws JSONException {
        if (!this.config.usePack2) {
            return null;
        }
        JSONObject obj = new JSONObject(body);
        obj = ConvertStr.rebuildJsonObject((JSONObject)obj);
        JSONArray arr = obj.getJSONArray("generalinfo");
        String dto = "";
        String apiName = "";
        if (arr.getJSONObject(0).has("dto") && (dto = arr.getJSONObject(0).getString("dto")).charAt(0) == '[') {
            dto = dto.substring(1, dto.length() - 1);
        }
        if (arr.getJSONObject(0).has("apiname")) {
            apiName = arr.getJSONObject(0).getString("apiname");
        }
        switch (apiName) {
            case "InvoicePost": {
                return this.invoiceDao.postInvoiceList(dto, 2, true);
            }
            case "ReceiveFromCustomer": 
            case "ProductPost": {
                return this.productDao.postProductList(dto, 0, true);
            }
            case "CustomerPost": {
                return this.customer.postCustomerList(CustomerDao.CustomerPostOptions.builder().body(dto).build());
            }
        }
        return null;
    }
}

