/*
 * Decompiled with CFR 0.152.
 */
package com.dto;

import com.utility.ConvertStr;
import java.text.ParseException;
import lombok.NonNull;

public class PosTransactionDto {
    private int id;
    private int posType;
    private String posSerial;
    private double posPrice;
    private String bankName;
    private String resultPosInt64;
    private String posIpAddress;
    @NonNull
    private String transDate;
    private String posAcceptorId;
    private String posTerminalId;
    private String serialCode;
    private String companyName;

    public String getTransDateTime() {
        try {
            return ConvertStr.normalizeDbDateTime((String)this.transDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getUncStr() {
        return this.resultPosInt64 + this.posSerial + this.serialCode;
    }

    public int getId() {
        return this.id;
    }

    public int getPosType() {
        return this.posType;
    }

    public String getPosSerial() {
        return this.posSerial;
    }

    public double getPosPrice() {
        return this.posPrice;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getResultPosInt64() {
        return this.resultPosInt64;
    }

    public String getPosIpAddress() {
        return this.posIpAddress;
    }

    @NonNull
    public String getTransDate() {
        return this.transDate;
    }

    public String getPosAcceptorId() {
        return this.posAcceptorId;
    }

    public String getPosTerminalId() {
        return this.posTerminalId;
    }

    public String getSerialCode() {
        return this.serialCode;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setPosType(int posType) {
        this.posType = posType;
    }

    public void setPosSerial(String posSerial) {
        this.posSerial = posSerial;
    }

    public void setPosPrice(double posPrice) {
        this.posPrice = posPrice;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public void setResultPosInt64(String resultPosInt64) {
        this.resultPosInt64 = resultPosInt64;
    }

    public void setPosIpAddress(String posIpAddress) {
        this.posIpAddress = posIpAddress;
    }

    public void setTransDate(@NonNull String transDate) {
        if (transDate == null) {
            throw new NullPointerException("transDate is marked non-null but is null");
        }
        this.transDate = transDate;
    }

    public void setPosAcceptorId(String posAcceptorId) {
        this.posAcceptorId = posAcceptorId;
    }

    public void setPosTerminalId(String posTerminalId) {
        this.posTerminalId = posTerminalId;
    }

    public void setSerialCode(String serialCode) {
        this.serialCode = serialCode;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PosTransactionDto)) {
            return false;
        }
        PosTransactionDto other = (PosTransactionDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getPosType() != other.getPosType()) {
            return false;
        }
        if (Double.compare(this.getPosPrice(), other.getPosPrice()) != 0) {
            return false;
        }
        String this$posSerial = this.getPosSerial();
        String other$posSerial = other.getPosSerial();
        if (this$posSerial == null ? other$posSerial != null : !this$posSerial.equals(other$posSerial)) {
            return false;
        }
        String this$bankName = this.getBankName();
        String other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
            return false;
        }
        String this$resultPosInt64 = this.getResultPosInt64();
        String other$resultPosInt64 = other.getResultPosInt64();
        if (this$resultPosInt64 == null ? other$resultPosInt64 != null : !this$resultPosInt64.equals(other$resultPosInt64)) {
            return false;
        }
        String this$posIpAddress = this.getPosIpAddress();
        String other$posIpAddress = other.getPosIpAddress();
        if (this$posIpAddress == null ? other$posIpAddress != null : !this$posIpAddress.equals(other$posIpAddress)) {
            return false;
        }
        String this$transDate = this.getTransDate();
        String other$transDate = other.getTransDate();
        if (this$transDate == null ? other$transDate != null : !this$transDate.equals(other$transDate)) {
            return false;
        }
        String this$posAcceptorId = this.getPosAcceptorId();
        String other$posAcceptorId = other.getPosAcceptorId();
        if (this$posAcceptorId == null ? other$posAcceptorId != null : !this$posAcceptorId.equals(other$posAcceptorId)) {
            return false;
        }
        String this$posTerminalId = this.getPosTerminalId();
        String other$posTerminalId = other.getPosTerminalId();
        if (this$posTerminalId == null ? other$posTerminalId != null : !this$posTerminalId.equals(other$posTerminalId)) {
            return false;
        }
        String this$serialCode = this.getSerialCode();
        String other$serialCode = other.getSerialCode();
        if (this$serialCode == null ? other$serialCode != null : !this$serialCode.equals(other$serialCode)) {
            return false;
        }
        String this$companyName = this.getCompanyName();
        String other$companyName = other.getCompanyName();
        return !(this$companyName == null ? other$companyName != null : !this$companyName.equals(other$companyName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PosTransactionDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getPosType();
        long $posPrice = Double.doubleToLongBits(this.getPosPrice());
        result = result * 59 + (int)($posPrice >>> 32 ^ $posPrice);
        String $posSerial = this.getPosSerial();
        result = result * 59 + ($posSerial == null ? 43 : $posSerial.hashCode());
        String $bankName = this.getBankName();
        result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
        String $resultPosInt64 = this.getResultPosInt64();
        result = result * 59 + ($resultPosInt64 == null ? 43 : $resultPosInt64.hashCode());
        String $posIpAddress = this.getPosIpAddress();
        result = result * 59 + ($posIpAddress == null ? 43 : $posIpAddress.hashCode());
        String $transDate = this.getTransDate();
        result = result * 59 + ($transDate == null ? 43 : $transDate.hashCode());
        String $posAcceptorId = this.getPosAcceptorId();
        result = result * 59 + ($posAcceptorId == null ? 43 : $posAcceptorId.hashCode());
        String $posTerminalId = this.getPosTerminalId();
        result = result * 59 + ($posTerminalId == null ? 43 : $posTerminalId.hashCode());
        String $serialCode = this.getSerialCode();
        result = result * 59 + ($serialCode == null ? 43 : $serialCode.hashCode());
        String $companyName = this.getCompanyName();
        result = result * 59 + ($companyName == null ? 43 : $companyName.hashCode());
        return result;
    }

    public String toString() {
        return "PosTransactionDto(id=" + this.getId() + ", posType=" + this.getPosType() + ", posSerial=" + this.getPosSerial() + ", posPrice=" + this.getPosPrice() + ", bankName=" + this.getBankName() + ", resultPosInt64=" + this.getResultPosInt64() + ", posIpAddress=" + this.getPosIpAddress() + ", transDate=" + this.getTransDate() + ", posAcceptorId=" + this.getPosAcceptorId() + ", posTerminalId=" + this.getPosTerminalId() + ", serialCode=" + this.getSerialCode() + ", companyName=" + this.getCompanyName() + ")";
    }

    public PosTransactionDto(int id, int posType, String posSerial, double posPrice, String bankName, String resultPosInt64, String posIpAddress, @NonNull String transDate, String posAcceptorId, String posTerminalId, String serialCode, String companyName) {
        if (transDate == null) {
            throw new NullPointerException("transDate is marked non-null but is null");
        }
        this.id = id;
        this.posType = posType;
        this.posSerial = posSerial;
        this.posPrice = posPrice;
        this.bankName = bankName;
        this.resultPosInt64 = resultPosInt64;
        this.posIpAddress = posIpAddress;
        this.transDate = transDate;
        this.posAcceptorId = posAcceptorId;
        this.posTerminalId = posTerminalId;
        this.serialCode = serialCode;
        this.companyName = companyName;
    }

    public PosTransactionDto() {
    }
}

