/*
 * Decompiled with CFR 0.152.
 */
package com.dao.util;

import com.dao.util.BulkInsertHelper;
import com.dto.OrderDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import java.util.List;
import java.util.stream.Collectors;

public class OrderBulkInsert
extends BulkInsertHelper<OrderDto.OrderInfo> {
    public OrderBulkInsert(DbConnection dbConnection) {
        super(dbConnection);
    }

    protected boolean getIdentityInsertOn() {
        return true;
    }

    protected String getIdFieldName() {
        return "RqIndex";
    }

    protected List<String> getAllIds(List<OrderDto.OrderInfo> dtoList) {
        return dtoList.stream().map(dto -> String.valueOf(dto.getRqindex())).collect(Collectors.toList());
    }

    protected String appendInsertValues(OrderDto.OrderInfo dto) {
        return dto.getRqindex() + ",'" + dto.getRqindex2() + "','" + dto.getRqtype() + "', '" + dto.getR_cuscode() + "', '" + dto.getT_date() + "', '" + dto.getT_time() + "', '" + dto.getR_date() + "', " + dto.getSumprice() + ", " + dto.getUsername() + ", '" + ConvertStr.getBoolToInt((Boolean)dto.getShoworhide()) + "', '" + ConvertStr.nullSafeString((String)dto.getVaseteh_code()) + "', '" + ConvertStr.nullSafeString((String)dto.getComment()) + "', " + dto.getBeianeh() + ", " + ConvertStr.nullSafeDouble((Double)dto.getFnaghd()) + ", " + ConvertStr.nullSafeDouble((Double)dto.getFcheck()) + ", " + ConvertStr.nullSafeDouble((Double)dto.getFcard()) + ", " + dto.getSanad_code() + ", " + ConvertStr.nullSafeDouble((Double)dto.getFtakhfif());
    }

    protected String getTableName() {
        return "RQTITLE";
    }

    protected String[] getColumnsToInsertInto() {
        return new String[]{"RqIndex", "RqIndex2", "RqType", "R_CusCode", "T_DATE", "T_TIME", "R_DATE", "SumPrice", "USERNAME", "ShowOrHide", "VASETEH_CODE", "COMMENT", "BEIANEH", "FNaghd", "FCheck", "FCard", "SANAD_CODE", "FTakhfif"};
    }
}

