/*
 * Decompiled with CFR 0.152.
 */
package com.dao.restaurant;

import com.dao.HolooSettingsDao;
import com.dao.SarfaslDao;
import com.dao.restaurant.ResTableDao;
import com.dto.InvoiceDetailDto;
import com.dto.LoginDto;
import com.dto.restaurant.ResInvoiceDto;
import com.google.gson.Gson;
import com.service.SettingLoader;
import com.service.invoice.CheckPayError;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.JsonDeserializer;
import com.utility.TextNormalizer;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.websocket.model.WaiterMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ResTableDao {
    private final DbConnection dbConnection;
    private int KindVat = 2;

    public ResTableDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public ResponseEntity getTableList(HttpServletRequest request) {
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        String sqlStr = "SELECT Desk_Name tablename, Desk_Comment tablecomment, Desk_Open tablebusy, [ID] id \n  FROM Res_Desk ResTable \n";
        String sqlWhere = this.getFilter(request);
        sqlWhere = sqlWhere.isEmpty() ? "" : " WHERE " + sqlWhere;
        sqlStr = sqlStr + sqlWhere + "  ORDER BY [ID] ASC";
        List rowSet = jdbcTemplate.queryForList(sqlStr);
        return ConvertStr.getMapResponseEntity((String)"ResTables", (List)rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    public synchronized ResponseEntity<Map<String, Object>> postResInvoice(String body) {
        ResInvoiceDto[] resInvoices;
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        ArrayList success = new ArrayList();
        ArrayList failure = new ArrayList();
        ArrayList myProduct = new ArrayList();
        try {
            resInvoices = this.requireResInvoiceDto(body);
        }
        catch (TncException ex) {
            return ConvertStr.getMapResponseEntity((String)"Invoice", Collections.singletonList(ex.getErrorMap()), Collections.emptyList());
        }
        if (ConvertStr.queryBoolean((JdbcTemplate)jdbcTemplate, (String)(" Select IsNull(Res_SaveSpdSel,0) from UserDB Where UserCodeInc = " + myLogin.getUserCodeInc()), (Object[])new Object[0])) {
            throw new TncException(TncExceptionMessages.RECEPTIONIST_ACCEPT_NEEDED);
        }
        if (ConvertStr.queryBoolean((JdbcTemplate)jdbcTemplate, (String)(" Select IsNull(Res_SaveSpdSel,0) from UserDB Where UserCodeInc = " + myLogin.getUserCodeInc()), (Object[])new Object[0])) {
            throw new TncException(TncExceptionMessages.RECEPTIONIST_ACCEPT_NEEDED);
        }
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, myLogin);
        for (ResInvoiceDto resInvoice : resInvoices) {
            resInvoice.setFactype("R");
            resInvoice.setFtype_kf("F");
            resInvoice.setType(1);
            String defaultCustomer = settingLoader.getDefaultCustomer();
            if (defaultCustomer != null) {
                resInvoice.setCustomercode(defaultCustomer);
            }
            resInvoice.setServicepercent(settingLoader.getServicePercent());
            Boolean isSuccess = (Boolean)this.dbConnection.getTransactionTemplate(myLogin).execute(status -> {
                try {
                    this.checkForErrorsInResInvoice((JdbcTemplate)jdbcTemplate, resInvoice);
                    String sqlStr = "SELECT DESK_NAME FROM RES_DESK WHERE [ID]=" + resInvoice.getTableid();
                    SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rs.next()) {
                        resInvoice.setTablename(rs.getString("DESK_NAME"));
                    }
                    if (!myLogin.getIsMyHoloo().booleanValue()) {
                        sqlStr = "SELECT ISNULL(MAX(F_CODE_C), 0) + 1 F_CODE_C FROM RES_FACTURE ";
                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                        resInvoice.setCode(0L);
                        while (rs.next()) {
                            resInvoice.setCode((long)rs.getInt("F_CODE_C"));
                        }
                        sqlStr = "INSERT INTO RES_FACTURE (F_TYPE, F_CODE_C, F_DATE, F_TIME, DESK_NAME, C_CODE, F_COMMENT, USERCODE, F_POS, POS_CODE, FAC_TYPE, DARSADSERVICE, MONEY_CODE, MONEY_PRICE,BON_PRICE, BON_NO, C_CODE_PEIK, OUTER_ORD, EXPORTERSID) VALUES(" + resInvoice.getType() + "," + resInvoice.getCode() + ",'" + resInvoice.getDate() + "','" + resInvoice.getTime() + "','" + resInvoice.getTablename() + "','" + resInvoice.getCustomercode() + "','" + resInvoice.getComment() + "','" + myLogin.getUserCodeInc() + "'," + resInvoice.getPos() + ",'" + resInvoice.getPossarfasl() + "','" + resInvoice.getFactype() + "'," + resInvoice.getServicepercent() + ",1,1," + resInvoice.getBonprice() + ",'" + resInvoice.getBonno() + "', '00000', '0', 6)";
                        jdbcTemplate.execute(sqlStr);
                        rs = jdbcTemplate.queryForRowSet(" SELECT SCOPE_IDENTITY() InvoiceID ");
                        resInvoice.setId(Long.valueOf(0L));
                        while (rs.next()) {
                            resInvoice.setId(Long.valueOf(rs.getLong("InvoiceID")));
                        }
                        if (resInvoice.getId() <= 0L) {
                            throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                        }
                    }
                    for (int i = 0; i < resInvoice.getDetailinfo().size(); ++i) {
                        InvoiceDetailDto dtl = (InvoiceDetailDto)resInvoice.getDetailinfo().get(i);
                        dtl.setInputid(dtl.getId());
                        this.setProductId(myLogin, dtl);
                        this.checkForErrorsInResDtl(dtl, myLogin, myProduct, settingLoader);
                        this.handleDtlCommonParts(dtl, (JdbcTemplate)jdbcTemplate);
                        sqlStr = "INSERT INTO RES_FAC_LIST(F_CODE, FL_INDEX, A_CODE, FL_FEW, FL_PRICE, FL_COMMENT, LEVY, SCOT, DARSAD_TAKHFIF, TAKHFIFSATRIR, DARSAD_TYPE, ART_OUTERORD, SUMTAKHFIFSATRI_P) VALUES(" + resInvoice.getId() + "," + dtl.getId() + ",'" + dtl.getProductid() + "'," + dtl.getFew() + "," + dtl.getPrice() + ",'" + dtl.getComment() + "'," + dtl.getLevy() + "," + dtl.getScot() + "," + ConvertStr.getNonNull((Double)dtl.getDiscountpercent()) + "," + ConvertStr.getNonNull((Double)dtl.getDiscountprice()) + ", 0, 0, 0)";
                        jdbcTemplate.execute(sqlStr);
                    }
                    resInvoice.setActionmode(Integer.valueOf(1));
                    sqlStr = "INSERT INTO RMTEMPFACTURE(FACTID, DESKTITLE, FACTSTYLE, FCACTIONMODE, PRINTCONFIGTYPE, OLDDESKTITLE) VALUES (" + resInvoice.getId() + ",'" + resInvoice.getTablename() + "', 1, " + resInvoice.getActionmode() + ", -1, ' ')";
                    jdbcTemplate.execute(sqlStr);
                    this.handleCommonFactureParts(resInvoice, (JdbcTemplate)jdbcTemplate, myLogin);
                    sqlStr = "UPDATE RES_FACTURE SET SUM_LEVY = ?, SUM_SCOT= ?, F_SUMPRICE = ?, ISLEVYANDSCOT = ? WHERE F_CODE = ?";
                    jdbcTemplate.update(sqlStr, new Object[]{resInvoice.getLevy(), resInvoice.getScot(), resInvoice.getSumprice(), resInvoice.getLevy() + resInvoice.getScot() > 0.0 ? 1 : 0, resInvoice.getId()});
                    success.add(this.makeSuccessMap(myLogin, resInvoice));
                }
                catch (Throwable t) {
                    status.setRollbackOnly();
                    TncException e = this.buildError(myProduct, myLogin, resInvoice, t);
                    failure.add(e.getErrorMap());
                    return false;
                }
                return true;
            });
            if (!ConvertStr.nullSafeBool((Boolean)isSuccess)) break;
        }
        return ConvertStr.getMapResponseEntity((String)"ResInvoice", failure, success);
    }

    private Map<String, Object> makeSuccessMap(LoginDto login, ResInvoiceDto resInvoice) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        if (resInvoice.getId() != null) {
            model.put("Id", resInvoice.getId());
        }
        model.put("ErpCode", ConvertStr.encrypt((String)String.valueOf(resInvoice.getId())));
        model.put("Code", String.valueOf(resInvoice.getCode()));
        if (login.getIsMyHoloo().booleanValue()) {
            model.put("Dbname", login.getDataBaseName().substring(login.getDataBaseName().indexOf("[") + 1, login.getDataBaseName().lastIndexOf("]")));
        }
        return model;
    }

    private TncException toTncException(Throwable t) {
        TncException e = t instanceof TncException ? (TncException)t : new TncException(TncExceptionMessages.DEFAULT_ERROR);
        return e;
    }

    private ResInvoiceDto[] parseResInvoice(String body) throws JSONException {
        JSONObject obj = new JSONObject(body);
        obj = ConvertStr.rebuildJsonObject((JSONObject)obj);
        JSONArray jsonArray = obj.getJSONArray("resinvoiceinfo");
        body = jsonArray.toString();
        Gson gson = new Gson();
        return (ResInvoiceDto[])gson.fromJson(body, ResInvoiceDto[].class);
    }

    private void handleCommonFactureParts(ResInvoiceDto resInvoice, JdbcTemplate jdbcTemplate, LoginDto myLogin) throws AssertionError {
        HolooSettingsDao settingDao = new HolooSettingsDao(this.dbConnection);
        if (settingDao.getMSetup2Boolean(myLogin, "DarsadFacture") && settingDao.getMSetup2Boolean(myLogin, "DarsadFactF")) {
            this.KindVat = settingDao.getMSetup2Boolean(myLogin, "CalcVat_J") ? 0 : 1;
        }
        String sqlStr = "SELECT ROUND(SUM(FL_FEW*FL_PRICE),0) SUM_PRICE FROM RES_FAC_LIST WHERE F_CODE='" + resInvoice.getId() + "'";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            resInvoice.setSumprice(rs.getDouble("SUM_PRICE"));
        }
        resInvoice.setServicecost((double)Math.round(resInvoice.getSumprice() * resInvoice.getServicepercent() / 100.0));
        if (this.KindVat == 0) {
            sqlStr = "SELECT ROUND(SUM(FL_FEW * FL_PRICE * LEVY) / 100 ,0) SUM_LEVY, ROUND(SUM(FL_FEW * FL_PRICE * SCOT) / 100 ,0) SUM_SCOT FROM RES_FAC_LIST WHERE F_CODE='" + resInvoice.getId() + "'";
            Map sumScotLevyMap = jdbcTemplate.queryForMap(sqlStr);
            resInvoice.setLevy(((Double)sumScotLevyMap.get("SUM_LEVY")).doubleValue());
            resInvoice.setScot(((Double)sumScotLevyMap.get("SUM_SCOT")).doubleValue());
        } else if (this.KindVat == 1) {
            resInvoice.setLevy((double)Math.round((resInvoice.getSumprice() - resInvoice.getDiscount()) * resInvoice.getLevy() / 100.0));
            resInvoice.setScot((double)Math.round((resInvoice.getSumprice() - resInvoice.getDiscount()) * resInvoice.getScot() / 100.0));
        }
        sqlStr = "UPDATE RES_DESK SET DESK_OPEN=1 WHERE [ID]=" + resInvoice.getTableid();
        jdbcTemplate.execute(sqlStr);
    }

    private void handleDtlCommonParts(InvoiceDetailDto dtl, JdbcTemplate jdbcTemplate) {
        dtl.setProductcode("");
        dtl.setProductname("");
        dtl.setBuyprice(Double.valueOf(0.0));
        if (dtl.getLevy() == null) {
            dtl.setLevy(Double.valueOf(0.0));
        }
        if (dtl.getScot() == null) {
            dtl.setScot(Double.valueOf(0.0));
        }
        String sqlStr = "SELECT A_CODE_C,A_NAME,ISNULL(BUY_PRICE,0) BUY_PRICE,ISNULL(LEVY,0) LEVY, ISNULL(SCOT,0) SCOT,ISNULL(INCLUDE_TAX,0) INCLUDE_TAX FROM ARTICLE WHERE A_CODE='" + dtl.getProductid() + "'";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            if (rs.getString("A_CODE_C") != null) {
                dtl.setProductcode(rs.getString("A_CODE_C"));
            }
            if (rs.getString("A_NAME") != null) {
                dtl.setProductname(rs.getString("A_NAME"));
            }
            dtl.setBuyprice(Double.valueOf(rs.getDouble("BUY_PRICE")));
            if (!rs.getBoolean("INCLUDE_TAX") || dtl.getLevy() != 0.0 || dtl.getScot() != 0.0) continue;
            dtl.setLevy(Double.valueOf(rs.getDouble("LEVY")));
            dtl.setScot(Double.valueOf(rs.getDouble("SCOT")));
        }
        sqlStr = "Update Article Set Exist = Exist - " + dtl.getFew() + " ,Exist_Mandeh = Exist_Mandeh - " + dtl.getFew() + " Where A_Code = '" + dtl.getProductid() + "'";
        jdbcTemplate.execute(sqlStr);
    }

    private void checkForErrorsInResDtl(InvoiceDetailDto dtl, LoginDto myLogin, List<Map<String, Object>> myProduct, SettingLoader settingLoader) throws TncException {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        if (dtl.getProductid() == null) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        String sqlStr = "Select Count(*) cnt From Article where A_Code='" + dtl.getProductid() + "'";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        if (rs.next() && rs.getInt("cnt") == 0) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        if (dtl.getFew() == null || dtl.getFew() <= 0.0 || dtl.getKarton() != null && dtl.getKarton() < 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
        }
        if (dtl.getPrice() != null && dtl.getPrice() <= 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_PRICE);
        }
        if (dtl.getLevy() != null && dtl.getLevy() < 0.0 || dtl.getScot() != null && dtl.getScot() < 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_LEVY_SCOT);
        }
        if (!settingLoader.isUsePerRowDiscountPercent() || dtl.getDiscountpercent() == null) {
            dtl.setDiscountpercent(Double.valueOf(0.0));
        }
        if (settingLoader.isUsePerRowDiscountPercent() && dtl.getDiscountpercent() < 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_DISCOUNT_AMOUNT);
        }
        if (!settingLoader.isUseRialDiscountPercent() && !settingLoader.isUsePerRowDiscountPrice() || dtl.getDiscountprice() == null) {
            dtl.setDiscountprice(Double.valueOf(0.0));
        }
        if (settingLoader.isUseRialDiscountPercent() || settingLoader.isUsePerRowDiscountPrice() && dtl.getDiscountprice() < 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_DISCOUNT_AMOUNT);
        }
        if (dtl.getId() == null || dtl.getId().isEmpty()) {
            throw new TncException(TncExceptionMessages.INVALID_ID);
        }
        try {
            Integer.parseInt(dtl.getId());
        }
        catch (NumberFormatException e) {
            throw new TncException(TncExceptionMessages.INVALID_ID);
        }
        double existingAmount = 0.0;
        if (settingLoader.mustHaveStore()) {
            sqlStr = settingLoader.isCalcExistInFactByPFact() ? "Select Exist from W_GetExistArticle where A_Code ='" + dtl.getProductid() + "'" : "Select Exist from W_ShowArticleForSearch_Big where A_Code ='" + dtl.getProductid() + "'";
            rs = jdbcTemplate.queryForRowSet(sqlStr);
            while (rs.next()) {
                existingAmount = rs.getDouble("Exist");
            }
            if (dtl.getFew() > existingAmount) {
                LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
                model.put("ErpCode", dtl.getProducterpcode());
                model.put("Few", existingAmount);
                myProduct.add(model);
                throw new TncException(TncExceptionMessages.BELOW_PRODUCTS_HAVE_NO_STORE);
            }
        }
    }

    private void checkForErrorsInResInvoice(JdbcTemplate jdbcTemplate, ResInvoiceDto resInvoice) throws TncException {
        if (resInvoice.getTableid() <= 0) {
            throw new TncException(TncExceptionMessages.INVALID_TABLE_NUMBER);
        }
        SqlRowSet rs = jdbcTemplate.queryForRowSet("select COUNT(*) cnt from RES_DESK where [ID]=" + resInvoice.getTableid());
        if (rs.next() && rs.getInt("CNT") == 0) {
            throw new TncException(TncExceptionMessages.INVALID_TABLE_NUMBER);
        }
        rs = jdbcTemplate.queryForRowSet(" SELECT COUNT(*) cnt FROM RES_DESK WHERE ISNULL(DESK_OPEN, '0') ='0' AND [ID]=" + resInvoice.getTableid());
        if (rs.next() && rs.getInt("cnt") == 0) {
            throw new TncException(TncExceptionMessages.SELECTED_TABLE_OCCUPIED);
        }
        if (resInvoice.getType() < 1 || resInvoice.getType() > 2) {
            throw new TncException(TncExceptionMessages.INVALID_INVOICE_TYPE);
        }
        if (resInvoice.getDate() == null || resInvoice.getDate().length() != 10) {
            throw new TncException(TncExceptionMessages.INVALID_DATE);
        }
        if (resInvoice.getTime() == null || resInvoice.getTime().length() < 5) {
            throw new TncException(TncExceptionMessages.INVALID_TIME);
        }
    }

    private boolean isPaymentWithNoPay(ResInvoiceDto resInvoice) {
        return resInvoice.getType() == 2 && resInvoice.getCash() == 0.0 && resInvoice.getPos() == 0.0 && resInvoice.getNesiyeh() == 0.0;
    }

    private boolean isFinalPayAndHasActionMode(ResInvoiceDto resInvoice) {
        return resInvoice.getActionmode() != 0 && resInvoice.getType() == 2;
    }

    private void checkPayments(ResInvoiceDto resInvoice, LoginDto login) throws TncException {
        if (this.isPaymentWithNoPay(resInvoice)) {
            throw new TncException(TncExceptionMessages.FINAL_SETTLEMENT_NEEDS_PAID_AMOUNT);
        }
        if (this.isFinalPayAndHasActionMode(resInvoice)) {
            throw new TncException(TncExceptionMessages.INVALID_ACTION_MODE_FOR_FINAL_SETTLEMENT);
        }
        CheckPayError check = new CheckPayError(this.dbConnection, new SarfaslDao(this.dbConnection));
        CheckPayError.PayErrorType idxErrorPay = check.checkErrorPay(resInvoice.getCash(), "", CheckPayError.SarfaslType.NONE, login);
        if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CASH_AMOUNT);
        }
        idxErrorPay = check.checkErrorPay(resInvoice.getPos(), resInvoice.getPossarfasl(), CheckPayError.SarfaslType.CARD, login);
        if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.SARFASL_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CARD_HEADING);
        }
        if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CARD_AMOUNT);
        }
        idxErrorPay = check.checkErrorPay(resInvoice.getNesiyeh(), "", CheckPayError.SarfaslType.NONE, login);
        if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.SARFASL_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CREDIT_AMOUNT);
        }
        idxErrorPay = check.checkErrorPay(resInvoice.getDiscount(), "", CheckPayError.SarfaslType.NONE, login);
        if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.SARFASL_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_DISCOUNT_AMOUNT);
        }
    }

    public ResponseEntity<Map<String, Object>> postEditInvoice(String body) {
        ResInvoiceDto[] resInvoices;
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        ArrayList myProduct = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        try {
            JSONObject obj = new JSONObject(body);
            obj = ConvertStr.rebuildJsonObject((JSONObject)obj);
            JSONArray jsonArray = obj.getJSONArray("resinvoiceinfo");
            body = jsonArray.toString();
            Gson gson = new Gson();
            resInvoices = (ResInvoiceDto[])gson.fromJson(body, ResInvoiceDto[].class);
        }
        catch (Exception ex) {
            TncException e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            failure.add(e.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Invoice", failure, success);
        }
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, myLogin);
        for (ResInvoiceDto resInvoice : resInvoices) {
            Boolean isSuccess = (Boolean)this.dbConnection.getTransactionTemplate(myLogin).execute(status -> {
                try {
                    InvoiceDetailDto dtl;
                    this.checkInvoiceEditErrors((JdbcTemplate)jdbcTemplate, resInvoice, myLogin);
                    String sqlStr = "SELECT F_CODE_C, F_CODE FROM RES_FACTURE WHERE F_CODE =" + resInvoice.getId();
                    SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rs.next()) {
                        resInvoice.setCode((long)rs.getInt("F_CODE_C"));
                    }
                    ArrayList<String> oldArticleCodes = new ArrayList<String>();
                    sqlStr = "SELECT A_CODE ArticleCode, FL_FEW FEW FROM RES_FAC_LIST WHERE F_CODE=" + resInvoice.getId();
                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rs.next()) {
                        double oldFew = rs.getDouble("FEW");
                        String oldArtCode = rs.getString("ArticleCode");
                        oldArticleCodes.add(oldArtCode);
                        sqlStr = "Update Article Set Exist = Exist + " + oldFew + " ,Exist_Mandeh = Exist_Mandeh + " + oldFew + " Where A_Code = '" + oldArtCode + "'";
                        jdbcTemplate.execute(sqlStr);
                    }
                    ArrayList<InvoiceDetailDto> modifiedDtl = new ArrayList<InvoiceDetailDto>();
                    for (InvoiceDetailDto dtl2 : resInvoice.getDetailinfo()) {
                        sqlStr = "SELECT FL_FEW FROM RES_FAC_LIST WHERE F_CODE=" + resInvoice.getId() + " AND A_CODE=" + ConvertStr.decrypt((String)dtl2.getProducterpcode());
                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                        while (rs.next()) {
                            dtl2.setOldamount(rs.getDouble("FL_FEW"));
                        }
                        modifiedDtl.add(dtl2);
                    }
                    resInvoice.setDetailinfo(modifiedDtl);
                    String whereStr = "(SELECT TOP 1 [ID] FROM RMTEMPFACTURE WHERE FACTID=" + resInvoice.getId() + " AND FACTSTYLE=1)";
                    String deleteTmpDtlStr = " DELETE FROM RMTEMPFACTUREDETAIL WHERE RMTEMPFACTUREID=" + whereStr;
                    String deleteTmpStr = " DELETE FROM RMTEMPFACTURE WHERE FACTID=" + resInvoice.getId() + " AND FACTSTYLE=1";
                    sqlStr = deleteTmpDtlStr + " \n " + deleteTmpStr;
                    jdbcTemplate.execute(sqlStr);
                    sqlStr = "SELECT DESK_NAME FROM RES_FACTURE WHERE F_CODE = " + resInvoice.getId();
                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rs.next()) {
                        resInvoice.setTablename(rs.getString("DESK_NAME"));
                    }
                    boolean shouldMakeTempFact = false;
                    boolean someArticlesAreDeleted = resInvoice.getDetailinfo().size() < oldArticleCodes.size();
                    Iterator iterator = resInvoice.getDetailinfo().iterator();
                    while (iterator.hasNext() && !(shouldMakeTempFact = (dtl = (InvoiceDetailDto)iterator.next()).getFew().doubleValue() != dtl.getOldamount() || dtl.isEdited() || someArticlesAreDeleted)) {
                    }
                    if (shouldMakeTempFact) {
                        sqlStr = "INSERT INTO RMTEMPFACTURE(FACTID, DESKTITLE, FACTSTYLE, FCACTIONMODE, PRINTCONFIGTYPE, OLDDESKTITLE) VALUES (" + resInvoice.getId() + ",'" + resInvoice.getTablename() + "',1," + resInvoice.getActionmode() + " ,-1,' ')";
                        jdbcTemplate.execute(sqlStr);
                    }
                    long tmpId = -1L;
                    StringBuilder addedFlIncIndexes = new StringBuilder();
                    sqlStr = "SELECT [ID] RMFACTID FROM RMTEMPFACTURE WHERE FACTID=" + resInvoice.getId() + " AND FACTSTYLE=1";
                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rs.next()) {
                        tmpId = rs.getLong("RMFACTID");
                    }
                    for (int i = 0; i < resInvoice.getDetailinfo().size(); ++i) {
                        InvoiceDetailDto dtl3 = (InvoiceDetailDto)resInvoice.getDetailinfo().get(i);
                        this.setProductId(myLogin, dtl3);
                        this.checkForErrorsInResDtl(dtl3, myLogin, myProduct, settingLoader);
                        this.handleDtlCommonParts(dtl3, (JdbcTemplate)jdbcTemplate);
                        sqlStr = "SELECT COUNT(FL_INDEX) CNT FROM RES_FAC_LIST WHERE F_CODE=" + resInvoice.getId() + " and FL_Index =" + dtl3.getId();
                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                        boolean insert = true;
                        while (rs.next()) {
                            insert = rs.getInt("CNT") <= 0;
                        }
                        String flIndex = dtl3.getId();
                        if (insert) {
                            sqlStr = "INSERT INTO RES_FAC_LIST(F_CODE, FL_INDEX, A_CODE, FL_FEW, FL_PRICE, FL_COMMENT, LEVY, SCOT, DARSAD_TAKHFIF, TAKHFIFSATRIR, DARSAD_TYPE, ART_OUTERORD, SUMTAKHFIFSATRI_P) VALUES(" + resInvoice.getId() + "," + flIndex + ",'" + dtl3.getProductid() + "'," + dtl3.getFew() + "," + dtl3.getPrice() + ",'" + dtl3.getComment() + "'," + dtl3.getLevy() + "," + dtl3.getScot() + "," + ConvertStr.getNonNull((Double)dtl3.getDiscountpercent()) + "," + ConvertStr.getNonNull((Double)dtl3.getDiscountprice()) + ", 0, 0, 0)";
                            jdbcTemplate.execute(sqlStr);
                        } else if (dtl3.isEdited()) {
                            sqlStr = "UPDATE RES_FAC_LIST SET FL_INDEX='" + flIndex + "', A_CODE='" + dtl3.getProductid() + "', FL_FEW=" + dtl3.getFew() + ", FL_PRICE=" + dtl3.getPrice() + ", FL_COMMENT='" + dtl3.getComment() + "', LEVY=" + dtl3.getLevy() + ", SCOT=" + dtl3.getScot() + ", DARSAD_TAKHFIF=" + ConvertStr.getNonNull((Double)dtl3.getDiscountpercent()) + ", TAKHFIFSATRIR=" + ConvertStr.getNonNull((Double)dtl3.getDiscountprice()) + " WHERE F_CODE=" + resInvoice.getId() + " AND FL_INDEX=" + flIndex;
                            jdbcTemplate.execute(sqlStr);
                        }
                        sqlStr = "SELECT FL_INC_INDEX FROM RES_FAC_LIST WHERE A_CODE=" + dtl3.getProductid() + " AND F_CODE=" + resInvoice.getId();
                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                        int row = 0;
                        while (rs.next()) {
                            row = rs.getInt("FL_INC_INDEX");
                        }
                        addedFlIncIndexes.append(row).append(",");
                        if (!shouldMakeTempFact || !dtl3.isEdited() || tmpId == -1L) continue;
                        sqlStr = "INSERT INTO RMTEMPFACTUREDETAIL(RMTEMPFACTUREID, OLDAMOUNT, FCDETAILID, ROWSTATUS, A_CODE, FL_PRICE, FACTID, FACTSTYLE) VALUES(" + tmpId + "," + (dtl3.getOldamount() == 0.0 ? dtl3.getFew().doubleValue() : dtl3.getOldamount()) + "," + row + ",'" + this.calculateRowStatus(dtl3.getFew().doubleValue(), dtl3.getOldamount(), oldArticleCodes, dtl3.getProductid()) + "','" + dtl3.getProductid() + "'," + dtl3.getPrice() + "," + resInvoice.getId() + ",1)";
                        jdbcTemplate.execute(sqlStr);
                    }
                    if (shouldMakeTempFact && tmpId != -1L && someArticlesAreDeleted) {
                        addedFlIncIndexes = ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)addedFlIncIndexes, (String)",");
                        sqlStr = "INSERT INTO RMTEMPFACTUREDETAIL(RMTEMPFACTUREID, OLDAMOUNT, FCDETAILID, ROWSTATUS, A_CODE, FL_PRICE, FACTID, FACTSTYLE)  SELECT " + tmpId + ", FL_Few, Fl_Inc_Index, 0, A_Code, FL_Price, " + resInvoice.getId() + ", 1 FROM Res_Fac_List  WHERE F_Code ='" + resInvoice.getId() + "' AND Fl_Inc_Index NOT IN(" + addedFlIncIndexes + ") ";
                        jdbcTemplate.execute(sqlStr);
                        sqlStr = "DELETE FROM RES_FAC_LIST WHERE F_CODE =" + resInvoice.getId() + " AND FL_INC_INDEX NOT IN(" + addedFlIncIndexes + ")";
                        jdbcTemplate.execute(sqlStr);
                    }
                    this.handleCommonFactureParts(resInvoice, (JdbcTemplate)jdbcTemplate, myLogin);
                    if (resInvoice.getSumprice() + resInvoice.getLevy() + resInvoice.getScot() + resInvoice.getServicecost() != resInvoice.getCash() + resInvoice.getBonprice() + resInvoice.getPos() + resInvoice.getDiscount() + resInvoice.getNesiyeh()) {
                        throw new TncException(TncExceptionMessages.UNEVEN_PAY_AND_TO_PAY_PRICES);
                    }
                    rs = jdbcTemplate.queryForRowSet(" SELECT SUM(ISNULL(TakhfifSatriR , 0)) PerRowDiscountR, SUM((FL_FEW * FL_PRICE * ISNULL(DARSAD_TAKHFIF , 0)) / 100) DiscountPercent FROM RES_FAC_LIST WHERE F_CODE='" + resInvoice.getId() + "'");
                    double TakhfifSatriR = 0.0;
                    while (rs.next()) {
                        if (rs.getDouble("PerRowDiscountR") > 0.0) {
                            TakhfifSatriR = rs.getDouble("PerRowDiscountR");
                            continue;
                        }
                        TakhfifSatriR = rs.getDouble("DiscountPercent");
                    }
                    if (resInvoice.getDiscount() < TakhfifSatriR) {
                        throw new TncException(TncExceptionMessages.UNEVEN_TOTAL_DISCOUNT_AND_DTL_SUM_DISCOUNT);
                    }
                    if (resInvoice.getComment() == null) {
                        resInvoice.setComment("");
                    }
                    if (resInvoice.getPossarfasl() == null) {
                        resInvoice.setPossarfasl("");
                    }
                    sqlStr = " UPDATE RES_FACTURE SET SUM_LEVY=" + resInvoice.getLevy() + ", SUM_SCOT=" + resInvoice.getScot() + ", F_NAGHD= " + resInvoice.getCash() + ", F_NESIEH= " + resInvoice.getNesiyeh() + ", F_POS= " + resInvoice.getPos() + ", POS_CODE= " + resInvoice.getPossarfasl() + ", F_TYPE= " + resInvoice.getType() + ", F_TAKHFIF=" + resInvoice.getDiscount() + ", F_SERVICE=" + resInvoice.getServicecost() + ", F_SUMPRICE=" + resInvoice.getSumprice() + ", F_COMMENT='" + resInvoice.getComment() + "', KIND_VAT= '" + this.KindVat + "', DARSADSERVICE=" + resInvoice.getServicepercent() + ", ISLEVYANDSCOT=" + (resInvoice.getLevy() + resInvoice.getScot() > 0.0 ? 1 : 0) + " WHERE F_CODE='" + resInvoice.getId() + "'";
                    jdbcTemplate.execute(sqlStr);
                    success.add(this.makeSuccessMap(myLogin, resInvoice));
                }
                catch (Throwable t) {
                    status.setRollbackOnly();
                    TncException e = this.buildError(myProduct, myLogin, resInvoice, t);
                    failure.add(e.getErrorMap());
                    return false;
                }
                return true;
            });
            if (!ConvertStr.nullSafeBool((Boolean)isSuccess)) break;
        }
        return ConvertStr.getMapResponseEntity((String)"ResInvoiceEdit", failure, success);
    }

    private void setProductId(LoginDto myLogin, InvoiceDetailDto dtl) {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        if (dtl.getCustomrelation() != null) {
            String sqlStr = "SELECT A_CODE FROM ARTICLE WHERE " + dtl.getCustomrelation() + "=" + dtl.getProducterpcode();
            SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
            while (rs.next()) {
                dtl.setProductid(rs.getString("A_CODE"));
            }
        } else if (!myLogin.getIsMyHoloo().booleanValue() && dtl.getProducterpcode() != null || myLogin.getIsMyHoloo().booleanValue() && dtl.getProductid() == null) {
            dtl.setProductid(ConvertStr.decrypt((String)dtl.getProducterpcode()));
        }
    }

    private TncException buildError(List<Map<String, Object>> myProduct, LoginDto myLogin, ResInvoiceDto resInvoice, Throwable mainException) {
        TncException e = this.toTncException(mainException);
        if (resInvoice.getId() > 0L) {
            e.putMoreInfo("Id", (Object)resInvoice.getId());
        }
        e.putMoreInfo("ProductDetail", myProduct);
        if (myLogin.getIsMyHoloo().booleanValue()) {
            e.putMoreInfo("Dbname", (Object)myLogin.getDataBaseName().substring(myLogin.getDataBaseName().indexOf("[") + 1, myLogin.getDataBaseName().lastIndexOf("]")));
        }
        return e;
    }

    private int calculateRowStatus(double newFew, double oldFew, List<String> oldArticleCodes, String newArticleCode) {
        if (!this.isNewAdded(oldArticleCodes, newArticleCode)) {
            if (newFew != oldFew) {
                return 1;
            }
        } else {
            return 2;
        }
        return 1;
    }

    private boolean isNewAdded(List<String> oldArticleCodes, String newArticleCode) {
        return !oldArticleCodes.contains(newArticleCode);
    }

    private void checkInvoiceEditErrors(JdbcTemplate jdbcTemplate, ResInvoiceDto dto, LoginDto login) throws TncException {
        if (dto.getId() == null) {
            throw new TncException(TncExceptionMessages.INVALID_INVOICE_NUMBER);
        }
        String sqlStr = " SELECT COUNT(*) CNT FROM RES_FACTURE WHERE F_CODE = " + dto.getId();
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        if (rs.next() && rs.getInt("CNT") == 0) {
            throw new TncException(TncExceptionMessages.INVALID_INVOICE_NUMBER);
        }
        sqlStr = " SELECT F_TYPE FROM RES_FACTURE WHERE F_CODE =" + dto.getId();
        rs = jdbcTemplate.queryForRowSet(sqlStr);
        if (rs.next() && rs.getShort("F_TYPE") != 1) {
            throw new TncException(TncExceptionMessages.INVOICE_NUMBER_ALREADY_SETTLED);
        }
        Integer actionMode = dto.getActionmode();
        if (actionMode == null || actionMode < 0 || actionMode > 8) {
            throw new TncException(TncExceptionMessages.INCORRECT_ACTION_MODE);
        }
        this.checkPayments(dto, login);
    }

    private String getFilter(HttpServletRequest request) {
        String sqlWhere = "";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        if (info.containsKey("tablename")) {
            sqlWhere = ConvertStr.addToSqlWhere((String)sqlWhere, (String)("Desk_Name='" + (String)info.get("tablename"))) + "'";
        }
        if (info.containsKey("tablebusy")) {
            sqlWhere = ConvertStr.addToSqlWhere((String)sqlWhere, (String)("Isnull(Desk_Open, 0)=" + ConvertStr.getBoolToInt((Boolean)Boolean.valueOf((String)info.get("tablebusy")))));
        }
        if (info.containsKey("tablecomment")) {
            sqlWhere = ConvertStr.addToSqlWhere((String)sqlWhere, (String)("ISNULL(Desk_Comment, '')='" + (String)info.get("tablecomment"))) + "'";
        }
        return sqlWhere;
    }

    public ResponseEntity sendRequests(String body) {
        ResInvoiceDto[] resInvoices;
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        try {
            resInvoices = this.requireResInvoiceDto(body);
        }
        catch (TncException ex) {
            failure.add(ex.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Invoice", failure, success);
        }
        return (ResponseEntity)this.dbConnection.getTransactionTemplate(myLogin).execute(status -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
            for (ResInvoiceDto resInvoice : resInvoices) {
                Object savePoint = status.createSavepoint();
                try {
                    String oldTableTitleForDB;
                    if (ConvertStr.nullSafeLong((Long)resInvoice.getId()) <= 0L) {
                        throw new TncException(TncExceptionMessages.INVALID_INVOICE_NUMBER);
                    }
                    String sqlStr = "SELECT COUNT(F_CODE) CNT FROM RES_FACTURE WHERE F_CODE= ? AND F_TYPE = 1";
                    SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getId()});
                    int count = -1;
                    if (rs.next()) {
                        count = rs.getInt("CNT");
                    }
                    if (count <= 0) {
                        throw new TncException(TncExceptionMessages.INVOICE_NUMBER_ALREADY_SETTLED);
                    }
                    ActionMode actionMode = ActionMode.find((int)ConvertStr.nullSafeInt((Integer)resInvoice.getActionmode()));
                    if (actionMode.equals((Object)ActionMode.NONE)) {
                        throw new TncException(TncExceptionMessages.INCORRECT_ACTION_MODE);
                    }
                    if (actionMode.equals((Object)ActionMode.CHANGE_TABLE) && resInvoice.getTableid() <= 0) {
                        throw new TncException(TncExceptionMessages.INVALID_TABLE_NUMBER);
                    }
                    sqlStr = "SELECT DESK_NAME FROM RES_FACTURE WHERE F_CODE=" + resInvoice.getId();
                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                    String oldTableName = "";
                    if (rs.next()) {
                        oldTableName = rs.getString("DESK_NAME");
                    }
                    String newTableName = "";
                    if (actionMode.equals((Object)ActionMode.CHANGE_TABLE)) {
                        sqlStr = "SELECT DESK_NAME FROM RES_DESK WHERE [ID] = ?";
                        rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getTableid()});
                        if (rs.next()) {
                            newTableName = rs.getString("DESK_NAME");
                        }
                        sqlStr = "UPDATE RES_FACTURE SET DESK_NAME= ? WHERE F_CODE = ? AND F_TYPE = 1";
                        jdbcTemplate.update(sqlStr, new Object[]{newTableName, resInvoice.getId()});
                        sqlStr = "UPDATE RES_DESK SET DESK_OPEN=0 WHERE NAME = ?";
                        jdbcTemplate.update(sqlStr, new Object[]{oldTableName});
                        sqlStr = " UPDATE RES_DESK SET DESK_OPEN=1 WHERE NAME = ?";
                        jdbcTemplate.update(sqlStr, new Object[]{newTableName});
                    }
                    sqlStr = "SELECT COUNT(FACTID) CNT FROM RMTEMPFACTURE WITH(NOLOCK) WHERE FACTID = ? AND FACTSTYLE = 1";
                    rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getId()});
                    boolean insert = true;
                    while (rs.next()) {
                        insert = rs.getInt("CNT") <= 0;
                    }
                    assert (newTableName != null);
                    String string = oldTableTitleForDB = newTableName.isEmpty() ? "" : oldTableName;
                    if (insert) {
                        sqlStr = "INSERT INTO RMTEMPFACTURE (FACTID, DeskTitle, FactStyle, FCActionMode, PrintConfigType, OldDeskTitle) VALUES(?, ?, 1, ?, -1, ?)";
                        jdbcTemplate.update(sqlStr, new Object[]{resInvoice.getId(), oldTableName, actionMode, oldTableTitleForDB});
                    } else {
                        sqlStr = "UPDATE RMTEMPFACTURE SET DeskTitle = ?, FactStyle = 1, FCActionMode = ?, PrintConfigType = -1 , OldDeskTitle = ? WHERE FactID = ?";
                        jdbcTemplate.update(sqlStr, new Object[]{oldTableName, actionMode, oldTableTitleForDB, resInvoice.getId()});
                    }
                    Map model = this.makeSuccessMap(myLogin, resInvoice);
                    model.put("Message", "Success");
                    success.add(model);
                }
                catch (Throwable t) {
                    status.rollbackToSavepoint(savePoint);
                    TncException e = this.toTncException(t);
                    if (resInvoice.getId() > 0L) {
                        e.putMoreInfo("Id", (Object)resInvoice.getId());
                    }
                    e.putMoreInfo("DetailedMessage", (Object)e.getMessage());
                    failure.add(e.getErrorMap());
                }
            }
            return ConvertStr.getMapResponseEntity((String)"ResInvoice", (List)failure, (List)success);
        });
    }

    public ResInvoiceDto[] requireResInvoiceDto(String body) throws TncException {
        try {
            return this.parseResInvoice(body);
        }
        catch (Exception ex) {
            TncException e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            e.putMoreInfo("ErrorMessage", (Object)ex.getMessage());
            throw e;
        }
    }

    public void callWaiter(String body) throws Exception {
        WaiterMessage[] messages;
        for (WaiterMessage waiterMessage : messages = (WaiterMessage[])new JsonDeserializer(WaiterMessage[].class).makeDtoArray(body, "callWaiter")) {
        }
    }
}

