/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dto.LoginDto;
import com.dto.SellerDetailDto;
import com.utility.DbConnection;
import java.util.Map;
import java.util.Objects;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository
public class SellerDetailDao {
    private final DbConnection dbConnection;

    public SellerDetailDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public LoginDto login() {
        return this.dbConnection.setToken();
    }

    public Map<String, Object> getCustomerSellerState(String cCode, LoginDto login) {
        return this.dbConnection.getJdbcTemplate(login).queryForMap(" SELECT ISNULL(IsSeller, 0) IsSeller FROM CUSTOMER WHERE C_CODE = ?", new Object[]{cCode});
    }

    public boolean productNotExist(String a_code, LoginDto login) {
        Integer count = (Integer)this.dbConnection.getJdbcTemplate(login).queryForObject(" SELECT COUNT(*) cnt FROM ARTICLE  WHERE A_CODE = ?", Integer.class, new Object[]{a_code});
        return count == null || count == 0;
    }

    public void insert(SellerDetailDto dto, LoginDto login) {
        this.dbConnection.getTransactionTemplate(login).executeWithoutResult(transactionStatus -> {
            try {
                this.dbConnection.getJdbcTemplate(login).update(" INSERT INTO SellerDetail (C_CODE, A_CODE, COMMISSION) VALUES (?, ?, ?)", new Object[]{dto.getCustomerCode(), dto.getProductCode(), dto.getCommission()});
            }
            catch (Exception e) {
                transactionStatus.setRollbackOnly();
                throw new RuntimeException(e);
            }
        });
    }

    public SellerDetailDto getSellerDtl(String cCode, String aCode, LoginDto login) {
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(" SELECT [ID], C_CODE, A_CODE, COMMISSION  FROM SellerDetail WHERE C_CODE = ? AND A_CODE = ?", new Object[]{cCode, aCode});
        if (!rs.next()) {
            return null;
        }
        return new SellerDetailDto(Objects.requireNonNull(rs.getBigDecimal("ID")).longValue(), null, null, Double.valueOf(rs.getDouble("COMMISSION")), rs.getString("C_CODE"), rs.getString("A_CODE"));
    }
}

