/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dao.util.ArticlePriceBulkInsert;
import com.dao.util.PoshakBulkInsert;
import com.dao.util.PoshakPropertiesBulkInsert;
import com.dto.ArticlePriceDto;
import com.dto.LoginDto;
import com.dto.Poshak;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncJdbc;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PoshakDao {
    private DbConnection dbConnection;

    @Autowired
    public PoshakDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public List<Map<String, Object>> getPoshak(LoginDto login, String sqlWhere) {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        String joins = " From ItemArticle i \n inner join Article A on a.A_Code=I.A_Code \n inner join Poshak p on p.ID = I.PoshakID \n inner join M_GROUP M on M.M_groupcode = Substring(A.A_Code, 1, 2) \n inner join S_group S on S.M_groupcode=M.M_groupcode and \n S.M_groupcode+S.S_groupcode = Substring(A.A_Code, 1, 4) \n";
        String sqlStr = " declare @fews table(a_code nvarchar(10), poshak_id int, my_few float) \n insert into @fews (a_code, poshak_id, my_few) \n Select i.A_Code, i.PoshakID,  i.Few + (Select isNull(SUM(few), 0) from itemFact f \n where f.A_code = a.A_code and f.poshakidf = i.PoshakID \n  and Fac_Type in ('Q')) Few \n" + joins + sqlWhere + " \n Select I.POSHAKID ID, p.ParentID, p.A_Name [Name], I.A_Code, \n dbo.[GetPoshakTreeValues](i.PoshakID, 0) [RootParentIdTree], \n dbo.[GetPoshakTreeValues](i.PoshakID, 1) [RootParentNameTree], \n dbo.[GetPoshakTreeValues](i.PoshakID, 2) [IdTree], \n dbo.[GetPoshakTreeValues](i.PoshakID, 3) [NameTree], \n f.my_few Few, \n f.my_few - (Select isNull(SUM(few), 0) from itemFact f \n  where f.A_code = a.A_code and f.poshakidf = i.PoshakID \n   and Fac_Type in ('Q', 'T')) FewTak, \n f.my_few - (Select isNull(SUM(few), 0) from itemFact f \n  where f.A_code = a.A_code and f.poshakidf = i.PoshakID \n   and Fac_Type in ('J', 'P', 'Q', 'T', 'F', 'Y', 'K', 'X', 'N')) FewSpd, \n i.I_Min [Min], i.I_Max [Max],i.PoshakId_C \n" + joins + " inner join @fews f on f.a_code = i.A_Code and f.poshak_id = i.PoshakID \n" + sqlWhere;
        return jdbcTemplate.queryForList(sqlStr);
    }

    public List<Map<String, Object>> getPoshakSellPrices(LoginDto login, String sqlWhere) {
        String sqlStr = "SELECT I.POSHAKID ID, I.A_CODE, AP.SELID, AP.SEL_PRICE PRICE \n FROM ITEMARTICLE I \n INNER JOIN ARTICLE A ON A.A_CODE = I.A_CODE \n INNER JOIN ARTICLEPRICE AP ON AP.POSHAKID = I.POSHAKID and AP.A_CODE = I.A_CODE \n INNER JOIN M_GROUP M ON M.M_GROUPCODE=SUBSTRING(A.A_CODE, 1, 2) \n INNER JOIN S_GROUP S ON S.M_GROUPCODE=M.M_GROUPCODE AND \nS.M_GROUPCODE + S.S_GROUPCODE = SUBSTRING(A.A_CODE, 1, 4)" + sqlWhere + " order by ID ";
        return this.dbConnection.getJdbcTemplate(login).queryForList(sqlStr);
    }

    public void bulkInsert(LoginDto loginDto, List<Poshak> poshakList) throws TncException {
        new PoshakBulkInsert(this.dbConnection).bulkInsert(loginDto, poshakList);
    }

    public void bulkInsertPoshakProperties(LoginDto loginDto, List<Poshak> poshakList) throws TncException {
        new PoshakPropertiesBulkInsert(this.dbConnection).bulkInsert(loginDto, poshakList);
    }

    public void bulkInsertArticlePrice(LoginDto loginDto, ArticlePriceDto[] dtoList) {
        new ArticlePriceBulkInsert(this.dbConnection).bulkInsert(loginDto, Arrays.asList(dtoList));
    }

    public List<Map<String, Object>> getPoshakProps(LoginDto login, String sqlWhere) {
        String sql = "SELECT [Id], [ParentId], [Name], DBO.GetPropsTreeName(ID) TreeName, DBO.GetPropsTreeId(ID) TreeCode\nFROM [PoshakProperties] " + sqlWhere + " ORDER BY ID";
        return this.dbConnection.getJdbcTemplate(login).queryForList(sql);
    }
}

