/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dao.util.ItemArticleBulkInsert;
import com.dto.ItemArticleDto;
import com.dto.LoginDto;
import com.dto.Poshak;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class ItemArticleDao {
    private final DbConnection dbConnection;

    @Autowired
    public ItemArticleDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    int getAttribCountByProductAndPoshakId(String productId, int poshakId, LoginDto login) {
        String sqlStr = " SELECT COUNT(*) CNT FROM ITEMARTICLE WHERE A_CODE='" + productId + "' AND POSHAKID = " + poshakId;
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        rs.next();
        return rs.getInt("CNT");
    }

    double getAttribFewByProductAndPoshakId(String productId, int poshakId, LoginDto login) {
        String sqlStr = " SELECT FEW FROM ITEMARTICLE WHERE A_CODE='" + productId + "' AND POSHAKID = " + poshakId;
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        rs.next();
        return rs.getDouble("FEW");
    }

    public void insert(ItemArticleDto itemArticleDto, LoginDto login) {
        String sqlStr = " INSERT INTO ITEMARTICLE (A_CODE, POSHAKID, FEW, SELECTED, I_MIN, I_MAX, POSHAKID_C)  VALUES(?, ?, ?, ?, ?, ?, ?)";
        this.dbConnection.getJdbcTemplate(login).update(sqlStr, new Object[]{itemArticleDto.getA_code(), itemArticleDto.getPoshakid(), itemArticleDto.getFew(), 0, itemArticleDto.getMin(), itemArticleDto.getMax(), itemArticleDto.getPoshakidc()});
    }

    public void bulkInsert(LoginDto loginDto, List<ItemArticleDto> itemArticleList) throws TncException {
        new ItemArticleBulkInsert(this.dbConnection).bulkInsert(loginDto, itemArticleList);
    }

    void updateItemArticleFew(LoginDto login, Poshak poshak, String productId, String operatorChar) {
        String sqlStr = " UPDATE ITEMARTICLE SET FEW = FEW " + operatorChar + poshak.getFew() + " WHERE A_CODE = '" + productId + "' AND POSHAKID = " + poshak.getId();
        this.dbConnection.getJdbcTemplate(login).execute(sqlStr);
    }

    void insertItemFact(LoginDto login, String facCode, String facType, String productId, Poshak poshak, int index) {
        String sqlStr = " INSERT INTO ITEMFACT(FAC_CODE,FAC_TYPE,A_CODE,A_INDEX,POSHAKIDF,FEW) SELECT DBO.PRODUCCODE(" + facCode + "),'" + facType + "','" + productId + "'," + index + "," + poshak.getId() + "," + poshak.getFew();
        this.dbConnection.getJdbcTemplate(login).execute(sqlStr);
    }

    StringBuilder getAttributeNameTree(Poshak poshak, StringBuilder sb, LoginDto login) {
        String sqlStr = "SELECT DBO.GETTREELEVELNAME(" + poshak.getId() + ") NAME ";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        while (rs.next()) {
            if (!sb.toString().isEmpty()) {
                sb.append("-");
            }
            sb.append(rs.getString("NAME")).append("*").append(ConvertStr.removeDecimalPartFromDouble((double)poshak.getFew()));
        }
        return sb;
    }

    public int getExistingPoshakIdC(String aCode, LoginDto login) {
        String sqlStr = "SELECT TOP 1 PoshakID_C FROM ItemArticle WHERE A_CODE = ? ORDER BY PoshakID_C DESC ";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr, new Object[]{aCode});
        if (rs.next()) {
            return rs.getInt("PoshakID_C");
        }
        return 0;
    }
}

