/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dao.HolooSettingsDao;
import com.dao.InvoiceDao;
import com.dao.InvoiceExpenseDao;
import com.dao.ItemArticleDao;
import com.dao.SarfaslDao;
import com.dao.SerialDao;
import com.dao.process.InvoiceProcessDao;
import com.dao.process.ProcessDao;
import com.dao.util.OrderBulkInsert;
import com.dao.util.PreInvoiceBulkInsert;
import com.dto.InvoiceDetailDto;
import com.dto.InvoiceDto;
import com.dto.InvoiceExpenseDto;
import com.dto.LoginDto;
import com.dto.OrderDtlDto;
import com.dto.OrderDto;
import com.dto.PaymentDetailDto;
import com.dto.Poshak;
import com.dto.industrial.ArticleSarfasl;
import com.google.gson.Gson;
import com.service.SettingLoader;
import com.service.invoice.CheckPayError;
import com.service.invoice.ExpenseCalculator;
import com.service.invoice.IncomeCalculator;
import com.service.invoice.ProxyInvoiceService;
import com.service.invoice.commission.CommissionCalculator;
import com.service.invoice.industrial.IndustrialInvoiceService;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.DbLogin;
import com.utility.JsonDeserializer;
import com.utility.Paging;
import com.utility.TextNormalizer;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.utility.TncLog;
import com.utility.TransactionCheck;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.intellij.lang.annotations.Language;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class InvoiceDao {
    private final List<PaymentDetailDto> sndList = new ArrayList();
    private final DbConnection dbConnection;
    private final HolooSettingsDao settingDao;
    private final InvoiceExpenseDao expenseDao;
    private final SarfaslDao sarfaslDao;
    private final TncLog log;
    private ItemArticleDao itemArticleDao;
    private ExpenseCalculator expenseCalculator;
    private IncomeCalculator incomeCalculator;
    private int Min_CodeSanad = 0;
    private int Max_CodeSanad = 0;

    public InvoiceDao(DbConnection dbConnection, HolooSettingsDao settingDao, InvoiceExpenseDao expenseDao, SarfaslDao sarfaslDao, TncLog log) {
        this.dbConnection = dbConnection;
        this.settingDao = settingDao;
        this.expenseDao = expenseDao;
        this.sarfaslDao = sarfaslDao;
        this.log = log;
    }

    @Autowired
    public void setExpenseCalculator(ExpenseCalculator expenseCalculator) {
        this.expenseCalculator = expenseCalculator;
    }

    @Autowired
    public void setIncomeCalculator(IncomeCalculator incomeCalculator) {
        this.incomeCalculator = incomeCalculator;
    }

    @Autowired
    public void setItemArticleDao(ItemArticleDao itemArticleDao) {
        this.itemArticleDao = itemArticleDao;
    }

    public ResponseEntity<?> getInvoiceList(HttpServletRequest request) {
        Object rowSet;
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        String sqlStr = " select f.fac_code, f.Fac_Code_C Code, f.Fac_Type Type, s.Sanad_Code_c SanadCode, \n f.FAC_COMMENT comment, C.C_Name CustomerName, C.C_Code CustomerErpCode, C.C_CODE_C customerCodeC, \n convert(nvarchar(10), f.Fac_Date, 111) [Date], convert(nvarchar(8), f.Fac_Time, 108) [Time], \n f.FNaghd SumNaghd, f.Card SumCard, f.FNesieh SumNesiyeh, f.Takhfif SumDiscount, \n f.FCheck SumCheck, f.Sum_Levy SumLevy, f.Sum_Scot SumScot, f.Sum_Price SumPrice, \n f.Fac_Code ErpCode \n from Facture f \n Inner join Customer c On c.C_Code = f.C_Code \n Inner join Sanad s On s.sanad_code = f.sanad_Code ";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        int itemsPerPage = ConvertStr.parseNullSafeInt((String)info.getOrDefault("itemsperpage", "0"));
        int page = ConvertStr.parseNullSafeInt((String)info.getOrDefault("page", "0"));
        Paging paging = new Paging(itemsPerPage, page, "FACTURE");
        String sqlWhere = this.getFilter(info);
        String keyField = "f.SANAD_CODE";
        String tableName = "FACTURE";
        if (info.containsKey("type")) {
            if (((String)info.get("type")).equals("5")) {
                sqlStr = "Select Count(*) cnt From sysColumns Where [Name] = 'Id' And [id]=( Select [id] From Sysobjects where [Name] = 'Fbailpre'  And [xtype] = 'U' )";
                rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                String FErpCode = "f.Fac_Code";
                tableName = "FBailPre";
                keyField = "f.FAC_CODE";
                while (rowSet.next()) {
                    if (rowSet.getInt("cnt") <= 0) continue;
                    FErpCode = ",f.id ErpCode";
                }
                sqlStr = "select f.Fac_Code, f.Fac_Code_C Code, f.Fac_Type Type, 0 SanadCode, C.C_Name CustomerName, C.C_Code CustomerErpCode, convert(nvarchar(10), f.Fac_Date, 111) Date, convert(nvarchar(8), f.Fac_Time, 108) Time,   0 SumNaghd, 0 SumCard, 0 SumNesiyeh, Isnull(f.Takhfif,0) SumDiscount, 0 SumCheck, f.Sum_Levy SumLevy,f.Sum_Scot SumScot,f.Sum_Price SumPrice" + FErpCode + " , f.Fac_Comment Comment  from  Fbailpre f  Inner join Customer c On c.C_Code = f.C_Code ";
            } else if (((String)info.get("type")).equals("6")) {
                keyField = "RqIndex";
                tableName = "RqTitle";
                sqlStr = "select f.RqIndex Fac_Code, f.RqIndex2 Code, F.RqType Type, 0 SanadCode,  C.C_Name CustomerName, C.C_Code CustomerErpCode, convert(nvarchar(10), f.T_Date, 111) Date, convert(nvarchar(8), f.T_Time, 108) Time, 0 SumNaghd, 0 SumCard, 0 SumNesiyeh, 0 SumDiscount, 0 SumCheck, 0 SumLevy, 0 SumScot, F.SumPrice SumPrice, f.RqIndex ErpCode  from rqtitle f  Inner join Customer c On c.C_Code = f.R_CusCode";
            }
        }
        sqlStr = paging.makeSql(Paging.PageSqlData.builder().selectSqlStr(sqlStr).whereStr(sqlWhere).alias("f").keyField(keyField).tableName(tableName).build());
        rowSet = jdbcTemplate.queryForList(sqlStr);
        sqlStr = this.GetInvoiceDetailQuery(info, this.commaBindCodeAndTypeWithQuotes((List)rowSet, info.getOrDefault("type", "").equals("6")));
        List rowSetDetail = jdbcTemplate.queryForList(sqlStr);
        for (int i = 0; i < rowSet.size(); ++i) {
            Map map = (Map)rowSet.get(i);
            String typeLetter = map.get("Type").toString();
            String titleId = ConvertStr.getNullIfEmpty((String)map.remove("ErpCode").toString());
            if (!myLogin.getIsMyHoloo().booleanValue() && !myLogin.getIsTorfehNegar().booleanValue()) {
                map.put("ErpCode", ConvertStr.encrypt((String)titleId));
            } else {
                map.put("InvoiceId", titleId);
            }
            String customerId = ConvertStr.getNullIfEmpty((String)map.remove("CustomerErpCode").toString());
            if (myLogin.getIsMyHoloo().booleanValue()) {
                map.put("CustomerId", customerId);
            } else {
                map.put("CustomerErpCode", ConvertStr.encrypt((String)customerId));
            }
            map.put("Type", ConvertStr.setTypeOfFacture((String)map.get("Type").toString()));
            map.put("TypeName", ConvertStr.setTypeNameOfFacture((int)((Integer)map.get("Type"))));
            ArrayList<Map> mapDetailList = new ArrayList<Map>();
            for (Map mapDetail : rowSetDetail) {
                Object facCode = mapDetail.get("fac_code");
                if (!map.get("fac_code").equals(facCode)) continue;
                List serials = jdbcTemplate.queryForList(" SELECT A_SERIAL FROM FAC_SER WHERE FAC_CODE = ? AND FAC_TYPE = ? AND A_CODE = ?", String.class, new Object[]{facCode, typeLetter, mapDetail.get("ProductErpCode")});
                if (!ConvertStr.isNullOrEmpty((Collection)serials)) {
                    mapDetail.put("serials", serials);
                }
                String productID = ConvertStr.getNullIfEmpty((String)mapDetail.remove("ProductErpCode").toString());
                if (myLogin.getIsMyHoloo().booleanValue()) {
                    mapDetail.put("ProductId", productID);
                } else {
                    mapDetail.put("ProductErpCode", ConvertStr.encrypt((String)productID));
                }
                mapDetail.remove("fac_code");
                mapDetailList.add(mapDetail);
            }
            map.put("Detail", mapDetailList);
            map.remove("fac_code");
            rowSet.set(i, map);
        }
        return ConvertStr.getMapResponseEntity((String)"invoice", (List)rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    private String commaBindCodeAndTypeWithQuotes(List<Map<String, Object>> rowSet, boolean isOrder) {
        List codesAndTypes = rowSet.stream().map(invoiceMap -> invoiceMap.get("Fac_Code").toString() + (isOrder ? "" : invoiceMap.getOrDefault("Type", "").toString())).collect(Collectors.toList());
        return ConvertStr.commaBindStringsWithQuotes(codesAndTypes);
    }

    @Language(value="SQL")
    private String GetInvoiceDetailQuery(Map<String, String> info, String commaBoundCodeAndTypes) {
        String sqlStr = "SELECT fa.fac_code, fa.A_Index Row, a.A_Code_C ProductCode, a.A_Name ProductName, \n a.A_Code ProductErpCode, fa.Few_Article Few, fa.few_article2 Karton, fa.Price_BS Price, \n fa.FacArtic_Comment comment, (fa.Few_Article * fa.Price_BS) SumPrice, \n fa.Levy Levy, fa.Scot Scot, fa.DarsadTakhfif PersentDiscount, fa.TakhfifSatriR Discount \n FROM Factart fa \n INNER JOIN Article a ON a.a_code = fa.a_code \n";
        String FOrderby = " ORDER BY fa.Fac_Code,fa.A_Index \n";
        String where = " WHERE fa.Fac_Code + fa.Fac_Type IN (" + commaBoundCodeAndTypes + ")";
        if (info.containsKey("type")) {
            if (info.get("type").equals("5")) {
                sqlStr = " SELECT fa.Fac_Code, fa.A_Index Row, a.A_Code_C ProductCode, \n a.A_Name ProductName, a.A_Code ProductErpCode, fa.Few_Article / unit_few Few, \n fa.few_article2 Karton,fa.Price_BS Price, \n  ((fa.Few_Article / unit_few)*fa.Price_BS) SumPrice, fa.Levy Levy, fa.Scot Scot, \n Isnull(fa.DarsadTakhfif, 0) PersentDiscount, isnull(fa.TakhfifSatriR, 0) Discount, \n fa.FacArtic_Comment Comment  FROM abailpre fa \n  INNER JOIN Article a on a.a_code = fa.a_code \n";
            } else if (info.get("type").equals("6")) {
                sqlStr = "SELECT fa.RqIndex Fac_Code, fa.RqIncIndex Row, a.A_Code_C ProductCode, \n a.A_Name ProductName, a.A_Code ProductErpCode, \n fa.R_Few Few,fa.R_Few2 Karton,fa.R_Cost Price, \n (fa.R_Few * fa.R_Cost) SumPrice, 0 Levy, 0 Scot , 0 PersentDiscount, 0 Discount \n FROM RqDetail fa \n INNER JOIN Article a ON a.a_code = fa.R_ArCode \n";
                FOrderby = " ORDER BY fa.RqIndex,fa.RqIncIndex \n";
                where = " WHERE fa.RqIndex IN (" + commaBoundCodeAndTypes + ")";
            }
        }
        sqlStr = sqlStr + where + FOrderby;
        return sqlStr;
    }

    public ResponseEntity<?> getInvoiceInfo(HttpServletRequest request, int RegisterType2) {
        int i;
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        String FFiledName = "FbailPreId";
        if (RegisterType2 == 0) {
            FFiledName = "OrderId";
        }
        String sqlStr = " Select f.Fac_Code_C Code,s.Sanad_Code_c SanadCode," + FFiledName + " ErpCode  from Facture f  Inner join Sanad s On s.sanad_code=f.sanad_Code ";
        StringBuilder sqlWhere = new StringBuilder();
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        String JsonInput = "";
        if (info.containsKey("invoiceinfo")) {
            JsonInput = info.toString();
        }
        if (!ConvertStr.isNullOrEmpty((String)JsonInput)) {
            try {
                JSONObject obj = new JSONObject(JsonInput);
                obj = ConvertStr.rebuildJsonObject((JSONObject)obj);
                JSONArray arr = obj.getJSONArray("invoiceinfo");
                for (i = 0; i < arr.length(); ++i) {
                    if (!sqlWhere.toString().isEmpty()) {
                        sqlWhere.append(",");
                    }
                    if (!arr.getJSONObject(i).has("erpcode")) continue;
                    sqlWhere.append(ConvertStr.decrypt((String)arr.getJSONObject(i).getString("erpcode")));
                }
                sqlWhere = new StringBuilder(" Where " + FFiledName + " in (" + sqlWhere + ")");
            }
            catch (JSONException obj) {
                // empty catch block
            }
        }
        if (sqlWhere.toString().isEmpty()) {
            sqlWhere = new StringBuilder(" Where isnull(" + FFiledName + ",0)>0 ");
        }
        sqlStr = sqlStr + sqlWhere + "  order by " + FFiledName;
        List rowSet = jdbcTemplate.queryForList(sqlStr);
        for (i = 0; i < rowSet.size(); ++i) {
            Map map = (Map)rowSet.get(i);
            map.put("ErpCode", ConvertStr.encrypt((String)ConvertStr.getNullIfEmpty((String)map.get("ErpCode").toString())));
            rowSet.set(i, map);
        }
        return ConvertStr.getMapResponseEntity((String)"invoiceinfo", (List)rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    public ResponseEntity<?> getTmpInvoiceList(HttpServletRequest request) {
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        String sqlStr = " select Id, FType, C_Code, C_CodeVaseteh, convert(nvarchar(19), FDateTime, 120) FDateTime, \n FNaghd, FNaghdSarfasl, FCard, \n FCardSarfasl, Takhfif, FNesiyeh, Comment, Kind, WebId, C_Code_C, SumLevy, SumScot \n From TmpFacture f \n";
        String sqlWhere = this.filterTmpInvoice(request);
        String fOrderBy = "  order by FDateTime";
        sqlStr = sqlStr + sqlWhere + fOrderBy;
        List rowSet = jdbcTemplate.queryForList(sqlStr);
        sqlStr = "Select IDFacture,A_Code,A_few,A_Few2,A_Price,Unit_code,A_Comment,Levy,Scot, DarsadTakhfif, TakhfifSatriR, A_Index From TmpFactart ";
        List rowSetDetail = jdbcTemplate.queryForList(sqlStr);
        sqlStr = " SELECT FAC_CODE, Fac_Type, A_Code, A_Index, PoshakIDF, Few, Price FROM ITEMFACT";
        List itemFactList = jdbcTemplate.queryForList(sqlStr);
        for (int i = 0; i < rowSet.size(); ++i) {
            Map map = (Map)rowSet.get(i);
            ArrayList<Map> mapDetailList = new ArrayList<Map>();
            for (Map mapDetail : rowSetDetail) {
                if (!map.get("ID").equals(mapDetail.get("IDFacture"))) continue;
                List mapPoshakList = this.getPoshakList(itemFactList, mapDetail);
                mapDetail.put("Poshak", mapPoshakList);
                mapDetailList.add(mapDetail);
            }
            map.put("Detail", mapDetailList);
            rowSet.set(i, map);
        }
        return ConvertStr.getMapResponseEntity((String)"invoice", (List)rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    private List<Map<String, Object>> getPoshakList(List<Map<String, Object>> itemFactList, Map<String, Object> detailMap) {
        ArrayList<Map<String, Object>> mapPoshakList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> mapItemFact : itemFactList) {
            int itemFactId = Integer.parseInt((String)mapItemFact.getOrDefault("FAC_CODE", "0"));
            int tmpFactId = (Integer)detailMap.get("IDFacture");
            String itemFactACode = (String)mapItemFact.getOrDefault("A_Code", "0");
            String tmpFactArtACode = (String)detailMap.get("A_Code");
            if (tmpFactId != itemFactId || !itemFactACode.equals(tmpFactArtACode)) continue;
            mapItemFact.remove("FAC_CODE");
            mapItemFact.remove("A_Code");
            mapPoshakList.add(mapItemFact);
        }
        return mapPoshakList;
    }

    private void ReturnMinMax_CodeSanad_For_OneDay(JdbcTemplate jdbcTemplate, String OneDay) {
        boolean lastDate = false;
        String sqlStr = " SELECT     MAX(Sanad_Code_C) AS Code   FROM      dbo.SANAD  WHERE     (Sanad_Date < '" + OneDay + "') ";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            this.Min_CodeSanad = rs.getInt("Code") + 1;
        }
        sqlStr = " SELECT     MIN(Sanad_Code_C) AS Code   FROM      dbo.SANAD  WHERE     (Sanad_Date > '" + OneDay + "') ";
        rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            this.Max_CodeSanad = rs.getInt("Code");
        }
        if (this.Max_CodeSanad == 0) {
            sqlStr = " SELECT  MAX(Sanad_Code_C) AS Code  FROM    dbo.SANAD  WHERE   (Sanad_Date <= '" + OneDay + "') ";
            rs = jdbcTemplate.queryForRowSet(sqlStr);
            while (rs.next()) {
                this.Max_CodeSanad = rs.getInt("Code") + 1;
            }
            lastDate = true;
        }
        if (!lastDate) {
            if (this.Min_CodeSanad < this.Max_CodeSanad) {
                --this.Max_CodeSanad;
            } else if (this.Min_CodeSanad == this.Max_CodeSanad) {
                --this.Min_CodeSanad;
                this.Max_CodeSanad = this.Min_CodeSanad;
            }
            if (this.Max_CodeSanad < this.Min_CodeSanad) {
                this.Max_CodeSanad = this.Min_CodeSanad;
            }
            if (this.Max_CodeSanad < 2) {
                this.Max_CodeSanad = 2;
                this.Min_CodeSanad = 2;
            }
        }
    }

    private int returnSanadCode2(JdbcTemplate jdbcTemplate, int sanadCode, String sanadDate) {
        int sanadCode2 = 0;
        sanadDate = sanadDate.replace("-", "/");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        Date tmpSanadDate = null;
        try {
            tmpSanadDate = formatter.parse(sanadDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        String sqlStr = " SELECT      Sanad_Code_C, Sanad_Code_C2, Sanad_Date  FROM         dbo.SANAD  WHERE     (Sanad_Code_C = " + sanadCode + ") ORDER BY Sanad_Code_C2";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            if (rs.isFirst()) {
                sanadCode2 = rs.getInt("Sanad_Code_C2") + 1;
            }
            assert (tmpSanadDate != null);
            if (!Objects.requireNonNull(rs.getDate("Sanad_Date")).before(tmpSanadDate) && !Objects.equals(rs.getDate("Sanad_Date"), tmpSanadDate)) continue;
            sanadCode2 = rs.getInt("Sanad_Code_C2") + 1;
        }
        return sanadCode2;
    }

    private void incSanadCode(JdbcTemplate jdbcTemplate, int firstCode, int firstCode2) {
        if (firstCode2 > 0) {
            String sqlStr = " SELECT     COUNT(Sanad_Code_C) AS Code  FROM         dbo.SANAD  WHERE     (Sanad_Code_C = " + firstCode + ") ";
            SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
            while (rs.next()) {
                if (rs.getInt("Code") <= 0) continue;
                sqlStr = " UPDATE    Sanad  SET       Sanad_Code_C2 = Sanad_Code_C2 + 1  WHERE     Sanad_Code_C = '" + firstCode + "' AND Sanad_Code_C2 >= '" + firstCode2 + "'";
                jdbcTemplate.execute(sqlStr);
            }
        }
    }

    private void sanadAdd(PaymentDetailDto.Builder paymentBuilder) {
        this.sndList.add(paymentBuilder.build());
    }

    private StringBuilder getInsertFactureStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("Insert into Facture(Fac_code,Fac_type,Fac_code_c,C_Code,Fac_Date,Fac_Time,Sanad_Code,Sum_price,Sum_few,").append("FNaghd,FCheck,FNesieh,TasviehDate,Takhfif,UserCode,HlpFieldL,").append("DateUser,TimeUser,Card,Kind_Vat,Sum_Levy,Sum_Scot,IsLevyAndScot,Fac_Comment)");
        return sb;
    }

    private void appendSelectFactureStatement(StringBuilder sb, InvoiceDto.InvoiceInfo p) {
        sb.append(" ( ").append("'").append(p.getId()).append("',").append("'").append(p.getType()).append("',").append("'").append(p.getCode()).append("',").append("'").append(p.getCustomerid()).append("',").append("'").append(p.getDate()).append("',").append("'").append(p.getTime()).append("',").append(p.getSanadcode()).append(",").append(p.getSumprice()).append(",").append(p.getSumfew()).append(",").append(p.getCash()).append(",").append(p.getSumcheck()).append(",").append(p.getNesiyeh()).append(",").append("'").append(ConvertStr.nullSafeString((String)p.getTasviehdate())).append("',").append(p.getDiscount()).append(",").append(p.getUsercode()).append(",").append(ConvertStr.getBoolToInt((Boolean)p.getHlpfieldl())).append(",").append("'").append(ConvertStr.nullSafeString((String)p.getDateuser())).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getTimeuser())).append("',").append(p.getBank()).append(",").append(p.getKindvat()).append(",").append(p.getLevy()).append(",").append(p.getScot()).append(",").append(ConvertStr.getBoolToInt((Boolean)p.getIslevyandscot())).append(",").append("'").append(ConvertStr.nullSafeString((String)p.getComment())).append("'").append(" ) ");
    }

    private StringBuilder getInsertFactartStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("Insert into Factart(Fac_Code,Fac_Type,A_Code,A_Index,Few_Article,few_article2,Price_Bs,Buy_Price,ACode_C,").append("vahedcode,VahedFew,FacArtic_Comment,FewKarton,Levy,Scot,DarsadTakhfif,DarsadPorsant,TakhfifSatriR,ArtExist)");
        return sb;
    }

    private void appendSelectFactartStatement(StringBuilder sb, InvoiceDetailDto p) {
        sb.append(" ( ").append("'").append(p.getId()).append("',").append("'").append(p.getType()).append("',").append("'").append(p.getProductid()).append("',").append(p.getAindex()).append(",").append(p.getFew()).append(",").append(p.getFew2()).append(",").append(p.getPrice()).append(",").append(p.getBuyprice()).append(",").append("'").append(p.getProductcode()).append("',").append(p.getUnitid()).append(",").append(p.getUnitfew()).append(",").append("'").append(ConvertStr.nullSafeString((String)p.getComment())).append("',").append(p.getKarton()).append(",").append(p.getLevy()).append(",").append(p.getScot()).append(",").append(p.getPersentdiscount()).append(",").append(p.getDiscount()).append(",").append(p.getPersentporsant()).append(",").append(p.getArtexist()).append(" ) ");
    }

    public synchronized ResponseEntity<Map<String, Object>> postInvoiceList(String Msg, int FRegisterType, boolean rebuildJson) {
        LoginDto myLogin = this.dbConnection.setToken();
        try {
            TransactionCheck t = TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDataBaseName());
            t.waitTranEndForTables(new String[]{"FACTURE", "FACTART", "TMPFACTURE", "RQTITLE", "RQDETAIL", "FBAILPRE", "ABAILPRE", "ARTICLE"});
            return (ResponseEntity)this.dbConnection.getTransactionTemplate(myLogin).execute(status -> this.postInvoice(Msg, FRegisterType, rebuildJson, myLogin));
        }
        catch (TncException e) {
            return ConvertStr.getMapResponseEntity((String)"Invoice", (List)e.makeFailureList(), (List)e.getSuccessList());
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized ResponseEntity<Map<String, Object>> postInvoice(String msg, int FRegisterType, boolean rebuildJson, LoginDto myLogin) {
        block246: {
            block247: {
                failure = new ArrayList<Map>();
                success = new ArrayList<LinkedHashMap<K, V>>();
                exceptions = new ArrayList<TncException>();
                jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
                try {
                    holder = new InvoiceSetupValueHolder(new SettingLoader(this.dbConnection, myLogin));
                    holder.fetch();
                    try {
                        if (rebuildJson) {
                            invoiceInfo = (InvoiceDto.InvoiceInfo[])new JsonDeserializer(InvoiceDto.InvoiceInfo[].class).makeDtoArray(msg, "invoiceinfo");
                            this.log.info(myLogin.getDataBaseName() + " INPUT JSON = " + msg);
                        } else {
                            msg = msg.substring(15, msg.length() - 1);
                            gson = new Gson();
                            invoiceInfo = (InvoiceDto.InvoiceInfo[])gson.fromJson(msg, InvoiceDto.InvoiceInfo[].class);
                        }
                    }
                    catch (Exception ex) {
                        e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
                        if (myLogin.getIsTorfehNegar().booleanValue()) {
                            e.putMoreInfo("ErrorMessage", (Object)ex.getMessage());
                        }
                        failure.add(e.getErrorMap());
                        return ConvertStr.getMapResponseEntity((String)"Invoice", failure, success);
                    }
                    if (myLogin.getIsMyHoloo().booleanValue() && invoiceInfo.length > 0 && !ConvertStr.isNullOrEmpty((String)invoiceInfo[0].getFac_code())) {
                        return this.postInvoiceListOnly(myLogin, invoiceInfo);
                    }
                    myProduct = new ArrayList<LinkedHashMap<K, V>>();
                    sanadCode = 0;
                    block20: for (InvoiceDto.InvoiceInfo invoice : invoiceInfo) {
                        errorProductCode = null;
                        try {
                            this.sndList.clear();
                            invoice.setInputid(invoice.getId());
                            if (ConvertStr.isNullOrEmpty((Collection)invoice.getDetailinfo())) {
                                throw new TncException(TncExceptionMessages.NO_INVOICE_DETAIL_PROVIDED);
                            }
                            if (ConvertStr.isNullOrEmpty((String)invoice.getType())) {
                                throw new TncException(TncExceptionMessages.INVALID_INVOICE_TYPE);
                            }
                            if (myLogin.getIsMyHoloo().booleanValue() && invoice.getKind() == null) {
                                throw new TncException(TncExceptionMessages.INVALID_INVOICE_TYPE);
                            }
                            type = Integer.parseInt(invoice.getType());
                            invoiceType = InvoiceType.getInvoiceType((int)type, (int)FRegisterType);
                            invoice.setType(invoiceType.getSymbol());
                            invoice.setInvoiceType(invoiceType);
                            saleCostsActive = holder.enabledHazineInvoiceF != false && invoiceType.equals((Object)InvoiceType.SALE) != false;
                            buyCostsActive = holder.enableKharidHazineh != false && invoiceType.equals((Object)InvoiceType.BUY) != false;
                            avarezShahrdary = "";
                            avarezAmozesh = "";
                            switch (1.$SwitchMap$com$dao$InvoiceDao$InvoiceType[invoiceType.ordinal()]) {
                                case 1: {
                                    avarezShahrdary = this.settingDao.getMSetup2String(myLogin, "SarAvarezK", "1070001");
                                    avarezAmozesh = this.settingDao.getMSetup2String(myLogin, "SarMaliatK", "1070002");
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    avarezShahrdary = this.settingDao.getMSetup2String(myLogin, "Vat_Sarfasl_Avarez", "");
                                    avarezAmozesh = this.settingDao.getMSetup2String(myLogin, "Vat_Sarfasl_Maliat", "");
                                    break;
                                }
                                case 4: {
                                    avarezShahrdary = this.settingDao.getMSetup2String(myLogin, "SarAvarezRetK", "1070001");
                                    avarezAmozesh = this.settingDao.getMSetup2String(myLogin, "SarMaliatRetK", "1070002");
                                    break;
                                }
                                case 5: {
                                    avarezShahrdary = this.settingDao.getMSetup2String(myLogin, "SarAvarezRetF", "");
                                    avarezAmozesh = this.settingDao.getMSetup2String(myLogin, "SarMaliatRetF", "");
                                    break;
                                }
                            }
                            vasetehPrice = 0.0;
                            if (ConvertStr.isNullOrEmpty((String)invoice.getInputid())) {
                                throw new TncException(TncExceptionMessages.INVALID_ID);
                            }
                            if (!ConvertStr.isNullOrEmpty((String)invoice.getCustomrelation())) {
                                sqlStr = "Select C_Code From Customer where " + invoice.getCustomrelation() + "='" + invoice.getCustomererpcode() + "'";
                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                while (rs.next()) {
                                    invoice.setCustomerid(rs.getString("C_Code"));
                                }
                            } else if (!ConvertStr.isNullOrEmpty((String)invoice.getCustid())) {
                                invoice.setCustomerid(invoice.getCustid());
                            } else if (!ConvertStr.isNullOrEmpty((String)invoice.getCustomererpcode())) {
                                invoice.setCustomerid(ConvertStr.decrypt((String)invoice.getCustomererpcode()));
                            }
                            if (ConvertStr.isNullOrEmpty((String)invoice.getCustomerid())) {
                                throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
                            }
                            if (!ConvertStr.isNullOrEmpty((String)invoice.getCustomerid()) && ConvertStr.isNullOrEmpty((String)invoice.getCustid())) {
                                sqlStr = "Select Count(*)cnt From Customer where C_Code='" + invoice.getCustomerid() + "'";
                                v0 = invoiceIsBuyType = invoiceType.equals((Object)InvoiceType.BUY) != false || invoiceType.equals((Object)InvoiceType.RETURN_FROM_BUY) != false;
                                if (this.isInvoiceOrPreInvoice(FRegisterType)) {
                                    sqlStr = invoiceIsBuyType != false ? sqlStr + " And IsNull(Forosh,0) = 1  " : sqlStr + " And IsNull(Kharid,0) = 1  ";
                                }
                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                while (rs.next()) {
                                    if (rs.getInt("cnt") != 0) continue;
                                    error = TncExceptionMessages.INVALID_CUSTOMER_CODE;
                                    if (this.isInvoiceOrPreInvoice(FRegisterType) == false) throw new TncException(error);
                                    if (invoiceIsBuyType) {
                                        error = TncExceptionMessages.CUSTOMER_NOT_SELLER;
                                        throw new TncException(error);
                                    }
                                    error = TncExceptionMessages.CUSTOMER_NOT_BUYER;
                                    throw new TncException(error);
                                }
                                sqlStr = "Select C_Name From Customer where C_Code='" + invoice.getCustomerid() + "'";
                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                while (rs.next()) {
                                    invoice.setCustomername(rs.getString("C_Name"));
                                }
                            }
                            if (ConvertStr.dateIsInvalid((String)invoice.getDate())) {
                                throw new TncException(TncExceptionMessages.INVALID_DATE);
                            }
                            if (ConvertStr.isNullOrEmpty((String)invoice.getTime()) != false) throw new TncException(TncExceptionMessages.INVALID_TIME);
                            if (invoice.getTime().length() < 5) {
                                throw new TncException(TncExceptionMessages.INVALID_TIME);
                            }
                            if (ConvertStr.isNullOrEmpty((String)invoice.getComment())) {
                                invoice.setComment("");
                            }
                            if (ConvertStr.isNullOrEmpty((String)invoice.getMidmanerpcode())) {
                                invoice.setMidmanerpcode("");
                            }
                            if (!ConvertStr.isNullOrEmpty((String)invoice.getMidmanerpcode())) {
                                invoice.setMidmanerpcode(ConvertStr.decrypt((String)invoice.getMidmanerpcode()));
                                sqlStr = "SELECT COUNT(*) cnt FROM CUSTOMER  WHERE IsNull(vaseteh, 0) = 1 AND C_Code = '" + invoice.getMidmanerpcode() + "'";
                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                while (rs.next()) {
                                    if (rs.getInt("cnt") != 0) continue;
                                    throw new TncException(TncExceptionMessages.INVALID_MEDIATOR_ERP_CODE);
                                }
                            }
                            checkPayError = new CheckPayError(this.dbConnection, this.sarfaslDao);
                            if (this.isInvoice(FRegisterType)) {
                                idxErrorPay = checkPayError.checkErrorPay(invoice.getCash(), invoice.getCashsarfasl(), CheckPayError.SarfaslType.CASH, myLogin);
                                if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.SARFASL_ERROR)) {
                                    throw new TncException(TncExceptionMessages.INVALID_CASH_HEADING);
                                }
                                if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
                                    throw new TncException(TncExceptionMessages.INVALID_CASH_AMOUNT);
                                }
                                idxErrorPay = checkPayError.checkErrorPay(invoice.getBank(), invoice.getBanksarfasl(), CheckPayError.SarfaslType.CARD, myLogin);
                                if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.SARFASL_ERROR)) {
                                    throw new TncException(TncExceptionMessages.INVALID_CARD_HEADING.setArgs(new Object[]{myLogin.getDataBaseName() + " - " + invoice.getBanksarfasl()}));
                                }
                                if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
                                    throw new TncException(TncExceptionMessages.INVALID_CARD_AMOUNT);
                                }
                                idxErrorPay = checkPayError.checkErrorPay(invoice.getNesiyeh(), "", CheckPayError.SarfaslType.NONE, myLogin);
                                if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
                                    throw new TncException(TncExceptionMessages.INVALID_CREDIT_AMOUNT);
                                }
                                idxErrorPay = checkPayError.checkErrorPay(invoice.getDiscount(), "", CheckPayError.SarfaslType.NONE, myLogin);
                                if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
                                    throw new TncException(TncExceptionMessages.INVALID_DISCOUNT_AMOUNT);
                                }
                            }
                            this.checkDuplicateWebId(myLogin, invoice.getInputid(), FRegisterType);
                            if (this.isOrder(FRegisterType)) {
                                sqlStr = "Select IsNull(Max(RqIndex2),0) + 1 RqIndex2 From RQTITLE";
                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                invoice.setCode(0);
                                while (rs.next()) {
                                    invoice.setCode(rs.getInt("RqIndex2"));
                                }
                                totalDiscount = 0.0;
                                if (invoice.getDiscount() != 0.0) break block246;
                                var31_41 = invoice.getDetailinfo().iterator();
                                break block247;
                            }
                            if (this.isPreInvoice(FRegisterType)) {
                                sqlStr = this.settingDao.getMSetup2Boolean(myLogin, "MaxFac_Code_C") != false ? "SELECT ISNULL(MAX(FAC_CODE_C),0)+1 FAC_CODE_C FROM FBAILPRE WHERE FAC_TYPE='P'" : "SELECT ISNULL((SELECT TOP 1 FAC_CODE_C FROM FBAILPRE WHERE FAC_TYPE='P' ORDER BY FAC_CODE DESC, FAC_TYPE) , 0) + 1 FAC_CODE_C";
                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                invoice.setCode(0);
                                while (rs.next()) {
                                    invoice.setCode(rs.getInt("FAC_CODE_C"));
                                }
                                sqlStr = "Select dbo.produccode(Isnull(Max(Fac_Code),0)+1) Fac_Code From FbailPre Where Fac_Type='P'";
                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                invoice.setId("0");
                                while (rs.next()) {
                                    invoice.setId(ConvertStr.getNullIfEmpty((String)rs.getString("Fac_Code")));
                                }
                                if (!ConvertStr.isNullOrEmpty((String)invoice.getMidmanerpcode())) {
                                    sqlStr = "Select Isnull(vaseteh_porsant,0) vasetehPrice From Customer Where C_Code='" + invoice.getMidmanerpcode() + "'";
                                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                                    while (rs.next()) {
                                        vasetehPrice = rs.getDouble("vasetehPrice");
                                    }
                                }
                                sqlStr = "Insert into FbailPre(Sanad_Code,Fac_code,Fac_type,Fac_code_c,C_Code,Fac_Date,Fac_Time, Sum_price,vasetehCode,vasetehPrice,Takhfif,Fac_Comment,UserCode,WebId) Values('0','" + invoice.getId() + "','P'," + invoice.getCode() + ",'" + invoice.getCustomerid() + "','" + invoice.getDate() + "','" + invoice.getTime() + "',0,'" + invoice.getMidmanerpcode() + "'," + vasetehPrice + "," + invoice.getDiscount() + ",'" + invoice.getComment() + "'," + myLogin.getUserCodeInc() + ",'" + invoice.getInputid() + "')";
                                jdbcTemplate.execute(sqlStr);
                            } else if (this.isInvoice(FRegisterType)) {
                                if (!myLogin.getIsMyHoloo().booleanValue()) {
                                    if (invoice.getCode() <= 0) {
                                        invoice.setCode(this.generateInvoiceCustomCode(myLogin, (JdbcTemplate)jdbcTemplate, invoiceType));
                                    } else {
                                        this.checkDuplicateInvoiceCustomCode(invoice.getCode(), (JdbcTemplate)jdbcTemplate);
                                    }
                                    if (myLogin.getIsTorfehNegar().booleanValue()) {
                                        invoice.setId(this.getTorfehNegarInvCode(jdbcTemplate, invoiceType));
                                    } else {
                                        sqlStr = "Select dbo.produccode(Isnull(Max(Fac_Code), 0) + 1) Fac_Code From Facture Where Fac_Type='" + invoiceType.getSymbol() + "'";
                                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                                        invoice.setId("0");
                                        while (rs.next()) {
                                            invoice.setId(ConvertStr.getNullIfEmpty((String)rs.getString("Fac_Code")));
                                        }
                                    }
                                    if (!ConvertStr.isNullOrEmpty((String)invoice.getMidmanerpcode())) {
                                        sqlStr = "Select Isnull(vaseteh_porsant,0) vasetehPrice From Customer Where C_Code='" + invoice.getMidmanerpcode() + "'";
                                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                                        while (rs.next()) {
                                            vasetehPrice = rs.getDouble("vasetehPrice");
                                        }
                                    }
                                    if ((affectedRow = jdbcTemplate.update(sqlStr = "Insert into Facture(Fac_code,Fac_type,Fac_code_c,C_Code,Fac_Date,Fac_Time,Sum_price,FNaghd,FCheck,FNesieh,TasviehDate,Takhfif,UserCode,HlpFieldL,DCEghtesad,DMaliat,HazFactK,DateUser,TimeUser,[Card],Kind_Vat,Fac_Comment,WebId,IsCms, RetFacCode) Values('" + invoice.getId() + "','" + invoiceType.getSymbol() + "'," + invoice.getCode() + ",'" + invoice.getCustomerid() + "','" + invoice.getDate() + "','" + invoice.getTime() + "',0," + invoice.getCash() + ",0," + invoice.getNesiyeh() + ",'" + invoice.getDate() + "'," + invoice.getDiscount() + "," + myLogin.getUserCodeInc() + ",1,0,0,0,'" + invoice.getDate() + "','" + invoice.getTime() + "'," + invoice.getBank() + "," + holder.kindVAT + ",'" + invoice.getComment() + "','" + invoice.getInputid() + "'," + ConvertStr.getBoolToInt((Boolean)myLogin.getIsTorfehNegar()) + "," + ConvertStr.getNullableStrSqlField((String)invoice.getRetfaccode()) + ")")) == 0) {
                                        throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                                    }
                                } else {
                                    sqlStr = "Insert into TmpFacture(FType, C_Code, C_CodeVaseteh, FDateTime, FNaghd, FNaghdSarfasl, FCard, FCardSarfasl, Takhfif, FNesiyeh, Comment, Kind, WebId, C_Code_C) Values('" + invoiceType.getSymbol() + "',";
                                    sqlStr = ConvertStr.isNullOrEmpty((String)invoice.getCustid()) != false ? sqlStr + "'" + invoice.getCustomerid() + "'," : sqlStr + "'',";
                                    sqlStr = sqlStr + "'" + invoice.getMidmanerpcode() + "','" + invoice.getDate() + " " + invoice.getTime() + "'," + invoice.getCash() + "," + ConvertStr.getNullableStrSqlField((String)invoice.getCashsarfasl()) + "," + invoice.getBank() + "," + ConvertStr.getNullableStrSqlField((String)invoice.getBanksarfasl()) + "," + invoice.getDiscount() + "," + invoice.getNesiyeh() + ",'" + invoice.getComment() + "'," + invoice.getKind() + ",'" + invoice.getInputid() + "','" + invoice.getCustid() + "')";
                                    affectedRow = jdbcTemplate.update(sqlStr);
                                    invoice.setId(null);
                                    rs = jdbcTemplate.queryForRowSet(" Select SCOPE_IDENTITY() id ");
                                    while (rs.next()) {
                                        invoice.setId(rs.getString("id"));
                                    }
                                    if (invoice.getId() == null || invoice.getId().equals("0")) {
                                        this.log.info(myLogin.getDataBaseName() + "$$$ TmpFacture Id is null = " + invoice.getId());
                                        rs = jdbcTemplate.queryForRowSet(" SELECT MAX(Id) id FROM TMPFACTURE");
                                        if (rs.next()) {
                                            invoice.setId(rs.getString("id"));
                                        }
                                    }
                                    if (ConvertStr.isNullOrEmpty((String)invoice.getId()) || affectedRow == 0) {
                                        this.log.info(myLogin.getDataBaseName() + "$$$ TmpFacture error: id = " + invoice.getId() + " - affectedRows = " + affectedRow);
                                        throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                                    }
                                }
                            }
                            while (true) {
                                if (!myLogin.getIsMyHoloo().booleanValue()) {
                                    this.insertCustomerAddress((JdbcTemplate)jdbcTemplate, invoice);
                                }
                                proxyServiceSupplier = (Supplier<ProxyInvoiceService>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$postInvoice$2(com.dto.LoginDto ), ()Lcom/service/invoice/ProxyInvoiceService;)((InvoiceDao)this, (LoginDto)myLogin);
                                for (j = 0; j < invoice.getDetailinfo().size(); ++j) {
                                    dtl = (InvoiceDetailDto)invoice.getDetailinfo().get(j);
                                    dtl.setInputid(dtl.getId());
                                    if (dtl.getLevy() == null) {
                                        dtl.setLevy(Double.valueOf(0.0));
                                    }
                                    if (dtl.getScot() == null) {
                                        dtl.setScot(Double.valueOf(0.0));
                                    }
                                    if (!ConvertStr.isNullOrEmpty((String)dtl.getCustomrelation())) {
                                        sqlStr = "Select A_Code From Article where " + dtl.getCustomrelation() + "=" + dtl.getProducterpcode();
                                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                                        while (rs.next()) {
                                            dtl.setProductid(rs.getString("A_Code"));
                                        }
                                    } else if (!myLogin.getIsMyHoloo().booleanValue() && !ConvertStr.isNullOrEmpty((String)dtl.getProducterpcode()) || myLogin.getIsMyHoloo().booleanValue() && ConvertStr.isNullOrEmpty((String)dtl.getProductid())) {
                                        dtl.setProductid(ConvertStr.decrypt((String)dtl.getProducterpcode()));
                                    }
                                    if (ConvertStr.isNullOrEmpty((String)dtl.getProductid())) {
                                        errorProductCode = dtl.getProductid();
                                        throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
                                    }
                                    if (ConvertStr.isNullOrEmpty((String)dtl.getComment())) {
                                        dtl.setComment("");
                                    }
                                    sqlStr = "Select Count(*) cnt From Article where A_Code = ?";
                                    dtl = rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{dtl.getProductid()}, new int[]{12});
                                    // MONITORENTER : rs
                                    if (rs.next() && rs.getInt("cnt") == 0) {
                                        errorProductCode = dtl.getProductid();
                                        throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
                                    }
                                    // MONITOREXIT : dtl
                                    if (dtl.getFew() == null) throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
                                    if (dtl.getFew() <= 0.0) {
                                        throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
                                    }
                                    if (dtl.getKarton() != null && dtl.getKarton() < 0.0) {
                                        throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
                                    }
                                    if (dtl.getPrice() != null && !myLogin.isComplimentaryActive() && dtl.getPrice() <= 0.0) {
                                        throw new TncException(TncExceptionMessages.INVALID_PRODUCT_PRICE);
                                    }
                                    if (dtl.getLevy() != null && dtl.getLevy() < 0.0) {
                                        throw new TncException(TncExceptionMessages.INVALID_LEVY_SCOT);
                                    }
                                    if (dtl.getScot() != null && dtl.getScot() < 0.0) {
                                        throw new TncException(TncExceptionMessages.INVALID_LEVY_SCOT);
                                    }
                                    if (!holder.usedDarsadTakhfifSatri || dtl.getDiscountpercent() == null) {
                                        dtl.setDiscountpercent(Double.valueOf(0.0));
                                    }
                                    if (holder.usedDarsadTakhfifSatri && dtl.getDiscountpercent() < 0.0) {
                                        throw new TncException(TncExceptionMessages.INVALID_DISCOUNT_AMOUNT);
                                    }
                                    if (!holder.usedDarsadTakhfifRialy && !holder.usedPriceTakhfifSatri || dtl.getDiscountprice() == null) {
                                        dtl.setDiscountprice(Double.valueOf(0.0));
                                    }
                                    if ((holder.usedDarsadTakhfifRialy || holder.usedPriceTakhfifSatri) && dtl.getDiscountprice() < 0.0) {
                                        throw new TncException(TncExceptionMessages.INVALID_DISCOUNT_AMOUNT);
                                    }
                                    Unit_Few = 1.0;
                                    if (!holder.useUnit) {
                                        dtl.setUnitid("0");
                                    }
                                    if (!ConvertStr.isNullOrEmpty((String)dtl.getUnitid()) && !dtl.getUnitid().equals("0")) {
                                        dtl.setUnitid(ConvertStr.decrypt((String)dtl.getUnitid()));
                                        sqlStr = "Select Isnull(unit_few,0) unit_few From Unit Where cast(Unit_Code as nvarchar(5))='" + dtl.getUnitid() + "'";
                                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                                        Unit_Few = 0.0;
                                        while (rs.next()) {
                                            Unit_Few = rs.getDouble("unit_few");
                                        }
                                        if (Unit_Few == 0.0) {
                                            throw new TncException(TncExceptionMessages.INVALID_UNIT_ERP_CODE);
                                        }
                                    }
                                    if (ConvertStr.isNullOrEmpty((String)dtl.getUnitid())) {
                                        dtl.setUnitid("0");
                                    }
                                    existProduct = 0.0;
                                    getExist = 0.0;
                                    if (!myLogin.getIsMyHoloo().booleanValue()) {
                                        sqlStr = "Select Exist from Article where A_Code ='" + dtl.getProductid() + "'";
                                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                                        while (rs.next()) {
                                            existProduct = rs.getDouble("Exist");
                                        }
                                        if (this.isInvoice(FRegisterType) != false && this.negativeInvoiceNotAllowed(holder.negativeFact, invoice) != false || this.isPreInvoice(FRegisterType) != false && this.negativePishNotAllowed(holder.negativePish, invoice) != false || this.isOrder(FRegisterType) && this.negativeInvoiceNotAllowed(holder.negativeOrder, invoice)) {
                                            sqlStr = holder.calcExistInFactByPFact != false ? "Select Exist from W_GetExistArticle where A_Code ='" + dtl.getProductid() + "'" : "Select Exist from W_ShowArticleForSearch_Big where A_Code ='" + dtl.getProductid() + "'";
                                            rs = jdbcTemplate.queryForRowSet(sqlStr);
                                            while (rs.next()) {
                                                getExist = rs.getDouble("Exist");
                                            }
                                            if (Unit_Few * dtl.getFew() > getExist) {
                                                model = new LinkedHashMap<String, Object>();
                                                model.put("ErpCode", dtl.getProducterpcode());
                                                model.put("Few", getExist);
                                                myProduct.add(model);
                                                throw new TncException(TncExceptionMessages.BELOW_PRODUCTS_HAVE_NO_STORE);
                                            }
                                        }
                                    }
                                    this.checkExistPoshak(holder.negativeOfSath, invoice, myProduct, dtl, myLogin);
                                    if (invoiceType.equals((Object)InvoiceType.PROXY)) {
                                        proxyInvoiceService = proxyServiceSupplier.get();
                                        dtl.setSellercommission(proxyInvoiceService.getCommission(dtl));
                                        dtl.setSellererpcode(ConvertStr.decrypt((String)dtl.getSellererpcode()));
                                        sarfaslCode = proxyInvoiceService.getSellerSarfasl(dtl.getSellererpcode());
                                        dtl.setSellersarfasl(sarfaslCode);
                                    } else {
                                        dtl.setSellercommission(0.0);
                                        dtl.setSellererpcode(null);
                                    }
                                    dtl.setProductcode("");
                                    dtl.setProductname("");
                                    dtl.setBuyprice(Double.valueOf(0.0));
                                    if (!myLogin.getIsMyHoloo().booleanValue()) {
                                        sqlStr = "Select A_Code_C,A_Name,Isnull(Buy_Price,0) Buy_Price,Isnull(levy,0) levy,  Isnull(scot,0) scot,Isnull(Include_Tax,0) Include_Tax From Article  Where A_Code='" + dtl.getProductid() + "'";
                                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                                        while (rs.next()) {
                                            if (!ConvertStr.isNullOrEmpty((String)rs.getString("A_Code_C"))) {
                                                dtl.setProductcode(ConvertStr.getNullIfEmpty((String)rs.getString("A_Code_C")));
                                            }
                                            if (!ConvertStr.isNullOrEmpty((String)rs.getString("A_Name"))) {
                                                dtl.setProductname(ConvertStr.getNullIfEmpty((String)rs.getString("A_Name")));
                                            }
                                            dtl.setBuyprice(Double.valueOf(rs.getDouble("Buy_Price")));
                                        }
                                    }
                                    dtl.setAindex(Integer.valueOf(j + 1));
                                    if (this.isOrder(FRegisterType)) {
                                        sqlStr = "Insert into RQDETAIL(RqIndex,RqType,R_ArCode,R_ArCode_C,R_ArName,R_Few,R_FewAval, R_Cost,unit_code,R_Commen,r_few2,r_fewaval2, DarsadTakhfif, TakhfifSatriR) Values('" + invoice.getId() + "','" + invoiceType.getSymbol() + "','" + dtl.getProductid() + "','" + dtl.getProductcode() + "','" + dtl.getProductname() + "'," + dtl.getFew() + "," + dtl.getFew() + "," + dtl.getPrice() + "," + dtl.getUnitid() + ",'" + dtl.getComment() + "'," + dtl.getKarton() + "," + dtl.getKarton() + "," + dtl.getDiscountpercent() + "," + dtl.getDiscountprice() + ")";
                                        jdbcTemplate.execute(sqlStr);
                                    } else if (this.isPreInvoice(FRegisterType)) {
                                        sqlStr = "select ISnull(karton,0)karton From Article Where A_Code='" + dtl.getProductid() + "'";
                                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                                        amountInBox = 0.0;
                                        while (rs.next()) {
                                            amountInBox = rs.getDouble("karton");
                                        }
                                        dtl.setFew(Double.valueOf(dtl.getFew() * Unit_Few));
                                        sqlStr = "Insert into AbailPre(Fac_Code, Fac_Type, A_Code, A_Index, First_Article, Few_Article, Price_Bs, Buy_Price, ACode_C, vahedcode, unit_few, FacArtic_Comment, Karton, first_article2, few_article2, Levy, Scot, TakhfifSatriR, DarsadTakhfif) Values('" + invoice.getId() + "','P','" + dtl.getProductid() + "'," + dtl.getAindex() + "," + dtl.getFew() + "," + dtl.getFew() + "," + dtl.getPrice() + "," + dtl.getBuyprice() + ",'" + dtl.getProductcode() + "','" + dtl.getUnitid() + "'," + Unit_Few + ",'" + dtl.getComment() + "'," + amountInBox + "," + dtl.getKarton() + "," + dtl.getKarton() + "," + dtl.getLevy() + "," + dtl.getScot() + "," + dtl.getDiscountprice() + "," + dtl.getDiscountpercent() + ")";
                                        jdbcTemplate.execute(sqlStr);
                                    } else if (this.isInvoice(FRegisterType)) {
                                        if (!myLogin.getIsMyHoloo().booleanValue()) {
                                            sqlStr = "select ISnull(karton,0)karton From Article Where A_Code='" + dtl.getProductid() + "'";
                                            rs = jdbcTemplate.queryForRowSet(sqlStr);
                                            amountInBox = 0.0;
                                            while (rs.next()) {
                                                amountInBox = rs.getDouble("karton");
                                            }
                                            dtl.setFew(Double.valueOf(dtl.getFew() * Unit_Few));
                                            if (invoiceType.equals((Object)InvoiceType.BUY)) {
                                                A_BuyPriceForMiyangin = dtl.getPrice();
                                                if (holder.mCalcSoodInForoosh) {
                                                    A_BuyPriceForMiyangin -= invoice.getDiscount();
                                                }
                                                UpdateSql = existProduct >= 0.0 && existProduct + dtl.getFew() > 0.0 ? " Buy_Price =" + (existProduct * dtl.getBuyprice() + dtl.getFew() * A_BuyPriceForMiyangin) / (existProduct + dtl.getFew()) : " Buy_Price =" + dtl.getFew() * A_BuyPriceForMiyangin / dtl.getFew();
                                                sqlStr = " Select Top 1 Fac_Date, Fac_Time, Price_Bs From FactArt FA  Inner Join Facture F On F.Fac_Code = FA.Fac_Code And F.Fac_Type = FA.Fac_Type  And F.Fac_type = '" + invoiceType.getSymbol() + "' And A_Code = '" + dtl.getProductid() + "' Order by F.Fac_Date desc, F.Fac_Time desc ";
                                                NowDate = new Date();
                                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                EndBuyPrice = 0.0;
                                                if (!rs.next()) {
                                                    EndBuyPrice = A_BuyPriceForMiyangin;
                                                }
                                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                while (rs.next()) {
                                                    if (!NowDate.after(rs.getDate("Fac_date")) && !NowDate.equals(rs.getDate("Fac_date"))) continue;
                                                    EndBuyPrice = A_BuyPriceForMiyangin;
                                                }
                                                if (EndBuyPrice > 0.0) {
                                                    UpdateSql = holder.mCalcSoodInForoosh != false && holder.calcSoodInForooshEndBuyPrice == false ? UpdateSql + " ,EndBuy_Price = " + (EndBuyPrice + invoice.getDiscount()) : UpdateSql + " ,EndBuy_Price = " + EndBuyPrice;
                                                }
                                                sqlStr = "Update Article Set " + UpdateSql + " Where A_Code = '" + dtl.getProductid() + "'";
                                                jdbcTemplate.execute(sqlStr);
                                            }
                                            clc = invoiceType.getOperator();
                                            sqlStr = "Update Article Set Exist = Exist " + clc + dtl.getFew() + " ,Exist_Mandeh = Exist_Mandeh " + clc + dtl.getFew() + " Where A_Code = '" + dtl.getProductid() + "'";
                                            jdbcTemplate.execute(sqlStr);
                                            sqlStr = "Insert into Factart(Fac_Code, Fac_Type, A_Code, A_Index, Few_Article, Price_Bs, Buy_Price, ACode_C, vahedcode, VahedFew, FacArtic_Comment, FewKarton, few_article2, Levy, Scot, ArtExist, TakhfifSatriR, DarsadTakhfif" + (InvoiceType.PROXY.equals((Object)invoiceType) != false ? ", Seller_C_Code, Commission)" : ")") + " Values('" + invoice.getId() + "','" + invoiceType.getSymbol() + "','" + dtl.getProductid() + "'," + dtl.getAindex() + "," + dtl.getFew() + "," + dtl.getPrice() + "," + dtl.getBuyprice() + ",'" + dtl.getProductcode() + "','" + dtl.getUnitid() + "'," + Unit_Few + ",'" + dtl.getSerialComment() + "'," + amountInBox + "," + dtl.getKarton() + "," + dtl.getLevy() + "," + dtl.getScot() + "," + existProduct + "," + dtl.getDiscountprice() + "," + dtl.getDiscountpercent() + (InvoiceType.PROXY.equals((Object)invoiceType) != false ? "," + ConvertStr.getNullableStrSqlField((String)dtl.getSellererpcode()) + ", " + dtl.getSellercommission() + ")" : ")");
                                        } else {
                                            sqlStr = "Insert into TmpFactart(IDFacture, A_Code, A_few, A_Few2, A_Price, Unit_code, A_Comment,Levy,Scot, DarsadTakhfif, TakhfifSatriR, A_INDEX) Values(" + ConvertStr.getNullableStrSqlField((String)invoice.getId()) + ",'" + dtl.getProductid() + "'," + dtl.getFew() + "," + dtl.getKarton() + "," + dtl.getPrice() + ",0,'" + dtl.getComment() + "'," + dtl.getLevy() + "," + dtl.getScot() + "," + dtl.getDiscountpercent() + "," + dtl.getDiscountprice() + "," + dtl.getAindex() + ")";
                                        }
                                        affectedRow = jdbcTemplate.update(sqlStr);
                                        if (affectedRow == 0) {
                                            this.log.info(myLogin.getDataBaseName() + "$$$ TmpFactart error: id = " + invoice.getId() + " - affectedRows = " + affectedRow);
                                            throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                                        }
                                    }
                                    if (!myLogin.getIsMyHoloo().booleanValue()) {
                                        this.addPoshak(myLogin, FRegisterType, invoice, j + 1, dtl);
                                        continue;
                                    }
                                    this.addPoshakMyHoloo(myLogin, FRegisterType, invoice, j + 1, dtl);
                                }
                                if (!ConvertStr.isNullOrEmpty((Collection)invoice.getHazineinfo()) && this.isInvoice(FRegisterType)) {
                                    if (saleCostsActive || buyCostsActive) {
                                        invoice.setHazineinfo(this.expenseCalculator.getModifiedList(invoice, myLogin, checkPayError));
                                    } else {
                                        if (invoiceType.equals((Object)InvoiceType.BUY) && holder.enabledSarshekanHazineh) {
                                            throw new TncException(TncExceptionMessages.CANNOT_ADD_COST_TO_BUY_INVOICE_WITH_ELIMINATOR);
                                        }
                                        if (invoiceType.equals((Object)InvoiceType.BUY) != false) throw new TncException(TncExceptionMessages.ADDING_COST_FEATURE_IS_OFF);
                                        if (invoiceType.equals((Object)InvoiceType.SALE) != false) throw new TncException(TncExceptionMessages.ADDING_COST_FEATURE_IS_OFF);
                                        throw new TncException(TncExceptionMessages.COST_ONLY_AVAILABLE_IN_SALE_BUY_INVOICES);
                                    }
                                }
                                if (!ConvertStr.isNullOrEmpty((Collection)invoice.getIncomeinfo()) && this.isInvoice(FRegisterType)) {
                                    if (!saleCostsActive) {
                                        if (buyCostsActive == false) throw new TncException(TncExceptionMessages.CANNOT_ADD_INCOME_TO_INVOICE);
                                    }
                                    invoice.setIncomeinfo(this.incomeCalculator.getModifiedList(invoice, myLogin, checkPayError));
                                }
                                if (this.isOrder(FRegisterType)) {
                                    sqlStr = holder.useCountInUnitInPrice != false ? " Update Rqtitle Set Sumprice=(Select Round(Sum(R_few*R_cost*Isnull(Unit_few,1)),0)   From Rqdetail rq left join unit u on Isnull(rq.unit_code,0)=u.unit_code   where Rqindex='" + invoice.getId() + "')  Where RqIndex='" + invoice.getId() + "'" : "Update RQTITLE  Set SumPrice=(Select Round(Sum(R_Few*R_Cost),0) From RQDETAIL where RqIndex='" + invoice.getId() + "') Where RqIndex='" + invoice.getId() + "'";
                                    jdbcTemplate.execute(sqlStr);
                                } else if (this.isPreInvoice(FRegisterType)) {
                                    sqlStr = "Update FBailPre  Set Sum_Price=(Select Round(Sum(Few_Article*Price_Bs),0) From AbailPre Where Fac_Type='P' And Fac_Code='" + invoice.getId() + "') Where Fac_Type='P' And Fac_Code='" + invoice.getId() + "'";
                                    jdbcTemplate.execute(sqlStr);
                                    if (vasetehPrice > 0.0) {
                                        sqlStr = "Update FBailPre Set vasetehPrice=Round((Sum_Price * vasetehPrice)/100,0) \n Where Fac_Type='P' And Fac_Code='" + invoice.getId() + "'";
                                        jdbcTemplate.execute(sqlStr);
                                    }
                                } else if (this.isInvoice(FRegisterType)) {
                                    sqlStr = myLogin.getIsMyHoloo() == false ? "Update Facture  Set Sum_Price=(Select Round(Sum(ISNULL(Few_Article, 0) * ISNULL(Price_Bs, 0)), 0) From Factart  Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "') , Sum_Few=(Select Round(Sum(ISNULL(Few_Article, 0)),0) From Factart Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "') Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'" : "Update TmpFacture  Set SumPrice=(Select Round(Sum(A_Few*A_Price), 0) From TmpFactart Where IDFacture=" + invoice.getId() + ") , SumFew=(Select Round(Sum(A_Few),0) From TmpFactart Where IDFacture=" + invoice.getId() + ") Where ID=" + invoice.getId();
                                    affectedRows = jdbcTemplate.update(sqlStr);
                                    if (affectedRows == 0) {
                                        for (i = 0; i < 3; ++i) {
                                            affectedRows = jdbcTemplate.update(sqlStr);
                                            if (affectedRows <= 0) continue;
                                        }
                                        this.log.info(myLogin.getDataBaseName() + " - $$$ Update TmpFacture Tries: " + i + " - id = " + invoice.getId());
                                    }
                                    if (affectedRows == 0) {
                                        this.log.info(myLogin.getDataBaseName() + "$$$ Update TmpFacture error: id = " + invoice.getId() + " - affectedRows = " + affectedRows);
                                        throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                                    }
                                    if (holder.kindVAT == 0) {
                                        sqlStr = myLogin.getIsMyHoloo() == false ? "Update Facture  Set Sum_Levy=(Select Round(Sum(Few_Article * Price_Bs * Levy) / 100, 0)  From Factart Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'),  Sum_Scot=(Select Round(Sum(Few_Article * Price_Bs * Scot) / 100, 0)            From Factart Where Fac_Type='" + invoiceType.getSymbol() + "'           And Fac_Code='" + invoice.getId() + "') Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'" : "Update TmpFacture  Set SumLevy=(Select Round(Sum(A_Few * A_Price * Levy) / 100, 0)  From TmpFactart Where IDFacture=" + invoice.getId() + "),  SumScot=(Select Round(Sum(A_Few * A_Price * Scot) / 100, 0)           From TmpFactart Where IDFacture=" + invoice.getId() + ") Where ID = " + invoice.getId();
                                        jdbcTemplate.execute(sqlStr);
                                    }
                                    if (holder.kindVAT == 1) {
                                        sqlStr = myLogin.getIsMyHoloo() == false ? "Update Facture  Set Sum_Levy=( Round((Sum_Price-Takhfif) * " + invoice.getLevy() + " / 100, 0)) ,   Sum_Scot=( Round((Sum_Price-Takhfif) * " + invoice.getScot() + " / 100, 0)) Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'" : "Update TmpFacture  Set SumLevy=(Round((SumPrice-Takhfif) * " + invoice.getLevy() + " / 100, 0)) ,   SumScot=(Round((SumPrice-Takhfif) * " + invoice.getScot() + " / 100, 0)) Where ID=" + invoice.getId();
                                        jdbcTemplate.execute(sqlStr);
                                    }
                                    if (!myLogin.getIsMyHoloo().booleanValue()) {
                                        sqlStr = "Update Facture  Set DAmozesh = Sum_Levy , DShahrdary = Sum_Scot   , IsLevyAndScot = (Case When Sum_Levy+Sum_Scot > 0 then 1 else 0 end)  Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'";
                                        jdbcTemplate.execute(sqlStr);
                                    }
                                    SumFact = 0.0;
                                    rs = myLogin.getIsMyHoloo() == false ? jdbcTemplate.queryForRowSet(" Select Sum_Price+Sum_Levy+Sum_Scot SumFact From Facture Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'") : jdbcTemplate.queryForRowSet(" Select SumPrice+SumLevy+SumScot SumFact From TmpFacture Where [ID]=" + invoice.getId());
                                    while (rs.next()) {
                                        SumFact = rs.getDouble("SumFact");
                                    }
                                    sumOfAllCosts = 0.0;
                                    sumOfSameCustomerHazineh = 0.0;
                                    sumOfAllIncomes = 0.0;
                                    sumOfSameCustomerIncome = 0.0;
                                    if (invoice.getHazineinfo() != null && (saleCostsActive || buyCostsActive)) {
                                        sumOfAllCosts = this.expenseCalculator.getSumOfAllPrices(invoice);
                                        sumOfSameCustomerHazineh = this.expenseCalculator.getSumOfInvoiceCustomerPrices(invoice);
                                    }
                                    if (invoice.getIncomeinfo() != null && (saleCostsActive || buyCostsActive)) {
                                        sumOfAllIncomes = this.incomeCalculator.getSumOfAllPrices(invoice);
                                        sumOfSameCustomerIncome = this.incomeCalculator.getSumOfInvoiceCustomerPrices(invoice);
                                    }
                                    sumOfPayments = invoice.getCash() + invoice.getBank() + invoice.getNesiyeh() + invoice.getDiscount();
                                    if (invoiceType.equals((Object)InvoiceType.SALE)) {
                                        SumFact -= sumOfSameCustomerHazineh;
                                        SumFact += sumOfSameCustomerIncome;
                                    } else if (invoiceType.equals((Object)InvoiceType.BUY)) {
                                        SumFact += sumOfSameCustomerHazineh;
                                        SumFact -= sumOfSameCustomerIncome;
                                    }
                                    if (!myLogin.getIsTorfehNegar().booleanValue()) {
                                        if (sumOfPayments != SumFact) {
                                            this.log.info(myLogin.getDataBaseName() + " Sums-Exception webId = " + invoice.getInputid() + " - id = " + invoice.getId() + " - sumOfPayments = " + sumOfPayments + " - sumFact = " + SumFact);
                                            throw new TncException(TncExceptionMessages.UNEVEN_PAY_AND_TO_PAY_PRICES);
                                        }
                                    } else {
                                        difference = SumFact - sumOfPayments;
                                        if (sumOfPayments != SumFact) {
                                            if (Math.abs(difference) > 2.0) throw new TncException(TncExceptionMessages.UNEVEN_PAY_AND_TO_PAY_PRICES);
                                        }
                                        if ((invoice.getCash() > 0.0 || invoice.getNesiyeh() == 0.0 && invoice.getBank() == 0.0) && sumOfPayments != SumFact) {
                                            throw new TncException(TncExceptionMessages.UNEVEN_PAY_AND_TO_PAY_PRICES);
                                        }
                                        if (Math.abs(difference) <= 2.0 && sumOfPayments != SumFact) {
                                            if (invoice.getNesiyeh() <= 0.0 && invoice.getBank() > 0.0) {
                                                invoice.setBank(invoice.getBank() + difference);
                                                jdbcTemplate.update(" UPDATE FACTURE SET CARD = ? WHERE  FAC_CODE = ? AND FAC_TYPE = ?", new Object[]{invoice.getBank(), invoice.getId(), invoiceType.getSymbol()});
                                            } else if (invoice.getBank() <= 0.0 && invoice.getNesiyeh() > 0.0) {
                                                invoice.setNesiyeh(invoice.getNesiyeh() + difference);
                                                jdbcTemplate.update(" UPDATE FACTURE SET FNESIEH = ? WHERE  FAC_CODE = ? AND FAC_TYPE = ?", new Object[]{invoice.getNesiyeh(), invoice.getId(), invoiceType.getSymbol()});
                                            }
                                        }
                                    }
                                    invoice.setSumprice(SumFact);
                                    rs = myLogin.getIsMyHoloo() == false ? jdbcTemplate.queryForRowSet(" Select Sum(Isnull(TakhfifSatriR,0)) TakhfifSatriR,Sum((Few_Article * Price_Bs * Isnull(DarsadTakhfif,0))/100) DarsadTakhfif From Factart Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'") : jdbcTemplate.queryForRowSet(" Select Sum(Isnull(TakhfifSatriR,0)) TakhfifSatriR,Sum((A_FEW * A_PRICE * Isnull(DarsadTakhfif,0))/100) DarsadTakhfif From TMPFACTART Where IDFACTURE='" + invoice.getId() + "'");
                                    discountSatriR = 0.0;
                                    while (rs.next()) {
                                        if (rs.getDouble("TakhfifSatriR") > 0.0) {
                                            discountSatriR = rs.getDouble("TakhfifSatriR");
                                            continue;
                                        }
                                        discountSatriR = rs.getDouble("DarsadTakhfif");
                                    }
                                    if (invoice.getDiscount() < discountSatriR) {
                                        throw new TncException(TncExceptionMessages.UNEVEN_TOTAL_DISCOUNT_AND_DTL_SUM_DISCOUNT);
                                    }
                                    if (!myLogin.getIsMyHoloo().booleanValue()) {
                                        this.ReturnMinMax_CodeSanad_For_OneDay((JdbcTemplate)jdbcTemplate, invoice.getDate());
                                        Code_C = this.Max_CodeSanad;
                                        Code_C2 = this.returnSanadCode2((JdbcTemplate)jdbcTemplate, Code_C, invoice.getDate());
                                        this.incSanadCode((JdbcTemplate)jdbcTemplate, Code_C, Code_C2);
                                        Sanad_Type = 14;
                                        if (invoiceType.isOfSaleNature()) {
                                            Sanad_Type = 13;
                                        }
                                        Action = 0;
                                        if (invoice.getCash() > 0.0) {
                                            Action = 1;
                                        }
                                        sqlStr = " INSERT INTO SANAD(Sanad_Code_C, Sanad_Code_C2, Comment, Sanad_Date, Sanad_Time, End_Save, SaveFromFacture, SaveFromAuto, User1, NaghdCheck, DateUser, TimeUser, UserCodeInc, Actions, Number_U, Sanad_Type,EndeditDate)  VALUES(" + Code_C + "," + Code_C2 + ",'','" + invoice.getDate() + "','" + invoice.getTime() + "', 0,1,0,0,0,convert(Nvarchar(10),getdate(),111),convert(Nvarchar(5),getdate(),108),'" + myLogin.getUserCodeInc() + "','" + Action + "',0,'" + Sanad_Type + "',getdate())";
                                        affectedRow = jdbcTemplate.update(sqlStr);
                                        identity = jdbcTemplate.queryForMap(" Select SCOPE_IDENTITY() SanadCode ");
                                        if (identity != null) {
                                            sCode = (BigDecimal)identity.get("SanadCode");
                                            sanadCode = sCode == null ? 0 : sCode.intValue();
                                        }
                                        if (sanadCode <= 0) throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                                        if (affectedRow == 0) {
                                            throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                                        }
                                        if (InvoiceType.PROXY.equals((Object)invoiceType)) {
                                            sanadComment = "\u0628\u0627\u06cc\u062a \u0641\u0631\u0648\u0634 \u06a9\u0627\u0644\u0627\u060c \u0637\u06cc \u0641\u0627\u06a9\u062a\u0648\u0631 \u0646\u06cc\u0627\u0628\u062a\u06cc \u0634\u0645\u0627\u0631\u0647 " + sanadCode;
                                            jdbcTemplate.update(" UPDATE SANAD SET [COMMENT] = ?  WHERE SANAD_CODE = ?", new Object[]{sanadComment, sanadCode});
                                        }
                                        invoice.setSanadcode(sanadCode);
                                        sqlStr = " INSERT INTO SND_indx(Sanad_Code, Fac_Code, Fac_Type, Check_Code)  VALUES(" + sanadCode + ",'" + invoice.getId() + "','" + invoiceType.getSymbol() + "',0)";
                                        jdbcTemplate.execute(sqlStr);
                                        customerSarfasl = "";
                                        rs = jdbcTemplate.queryForRowSet("Select c_code,   Case    when Isnull(Col_code_bed,'') <> '' And Isnull(Col_code_bes,'')='' then        Isnull(Col_code_bed,'')+Isnull(Moien_code_bed,'')+Isnull(Tafzili_Code_Bed,'')    when Isnull(Col_code_bed,'') = '' And Isnull(Col_code_bes,'')<>'' then       Isnull(Col_code_bes,'')+Isnull(Moien_code_bes,'')+Isnull(Tafzili_Code_Bes,'')     when '" + invoiceType.getSymbol() + "' in ('K','X') then        Isnull(Col_code_bes,'')+Isnull(Moien_code_bes,'')+Isnull(Tafzili_Code_Bes,'')    when '" + invoiceType.getSymbol() + "' in ('F','Y') then       Isnull(Col_code_bed,'')+Isnull(Moien_code_bed,'')+Isnull(Tafzili_Code_Bed,'')       end CustomerSarfasl  from customer where C_Code='" + invoice.getCustomerid() + "'");
                                        while (rs.next()) {
                                            customerSarfasl = rs.getString("CustomerSarfasl");
                                        }
                                        jdbcTemplate.execute(" Update Facture Set Sanad_Code=" + sanadCode + " Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'");
                                        this.expenseDao.updateSanadCode(sanadCode, invoice.getId() + invoiceType.getSymbol(), myLogin);
                                        rs = jdbcTemplate.queryForRowSet(" Select Sum_Price, Sum_Levy, Sum_Scot From Facture  Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'");
                                        sumPrice = 0.0;
                                        sumLevy = 0.0;
                                        sumScot = 0.0;
                                        while (rs.next()) {
                                            sumPrice = rs.getDouble("Sum_Price");
                                            sumLevy = rs.getDouble("Sum_Levy");
                                            sumScot = rs.getDouble("Sum_Scot");
                                        }
                                        invoiceTypeName = invoiceType.getFarsiName();
                                        lastCostSarfaslCode = "";
                                        if (this.isCostAvailable(invoice)) {
                                            additionalCosts = invoice.getHazineinfo();
                                            lastCostSarfaslCode = ((InvoiceExpenseDto)additionalCosts.get(additionalCosts.size() - 1)).getSarfaslcode();
                                        }
                                        if (this.isIncomeAvailable(invoice)) {
                                            additionalIncomes = invoice.getIncomeinfo();
                                            lastCostSarfaslCode = ((InvoiceExpenseDto)additionalIncomes.get(additionalIncomes.size() - 1)).getSarfaslcode();
                                            sumOfAllCosts += sumOfAllIncomes;
                                        }
                                        jdbcTemplate.execute(" UPDATE FACTURE SET HAZFACTK =" + sumOfAllCosts + ", HAZSARFASL ='" + lastCostSarfaslCode + "' Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'");
                                        industrialService = new IndustrialInvoiceService(DbLogin.getInstance((DbConnection)this.dbConnection, (LoginDto)myLogin));
                                        industrialService.generate_article_sarfasl_of_invoice_articles(invoice.getDetailinfo());
                                        commissionCalculator = new CommissionCalculator(DbLogin.getNewInstance((DbConnection)this.dbConnection, (LoginDto)myLogin), invoice);
                                        commissionCalculator.calculateCommission();
                                        commissionCalculator.insertFConnect();
                                        switch (1.$SwitchMap$com$dao$InvoiceDao$InvoiceType[invoiceType.ordinal()]) {
                                            case 1: {
                                                if (!industrialService.isIndustrial()) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode("801").moiencode("0001").bed(Double.valueOf(sumPrice)).commentline(" \u0634\u0645\u0627\u0631\u0647 " + invoice.getCode() + " " + invoice.getCustomername()));
                                                } else {
                                                    for (ArticleSarfasl articleSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                                                        this.sanadAdd(PaymentDetailDto.builder().colcode(articleSarfasl.getMainCol()).moiencode(articleSarfasl.getMainMoein()).tafzilicode(articleSarfasl.getMainTafsili()).bed(articleSarfasl.getArticleTotalPrice()).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()).numberline(articleSarfasl.getNumberLine()));
                                                    }
                                                }
                                                if (sumScot > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(avarezShahrdary.substring(0, 3)).moiencode(avarezShahrdary.substring(3, 7)).tafzilicode(avarezShahrdary.substring(7)).bed(Double.valueOf(sumScot)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                                                }
                                                if (sumLevy > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(avarezAmozesh.substring(0, 3)).moiencode(avarezAmozesh.substring(3, 7)).tafzilicode(avarezAmozesh.substring(7)).bed(Double.valueOf(sumLevy)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                                                }
                                                this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bes(Double.valueOf(sumPrice + sumLevy + sumScot)).typeline("F").commentline("\u0641\u0627\u0643\u062a\u0648\u0631 " + invoiceTypeName + " " + invoice.getCode()));
                                                for (PaymentDetailDto.Builder paymentDto : this.expenseCalculator.getSanadDetails(invoice, invoiceTypeName)) {
                                                    this.sanadAdd(paymentDto);
                                                }
                                                for (PaymentDetailDto.Builder paymentDto : this.incomeCalculator.getSanadDetails(invoice, invoiceTypeName)) {
                                                    this.sanadAdd(paymentDto);
                                                }
                                                Comment = "\u062c\u0645\u0639 \u067e\u0631\u062f\u0627\u062e\u062a\u0647\u0627 \u0628\u0627\u0628\u062a " + invoiceTypeName;
                                                if (invoice.getDiscount() > 0.0) {
                                                    Comment = invoice.getDiscount() > 0.0 && invoice.getCash() + invoice.getBank() == 0.0 ? "\u062a\u062e\u0641\u064a\u0641 \u0628\u0627\u0628\u062a " + invoiceTypeName : "\u062c\u0645\u0639 \u067e\u0631\u062f\u0627\u062e\u062a\u0647\u0627 \u0628\u0647 \u0627\u0646\u0636\u0645\u0627\u0645 \u062a\u062e\u0641\u064a\u0641 \u0628\u0627\u0628\u062a " + invoiceTypeName;
                                                }
                                                if (invoice.getCash() + invoice.getBank() + invoice.getDiscount() > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bed(Double.valueOf(invoice.getCash() + invoice.getBank() + invoice.getDiscount())).typeline("S").commentline(Comment + " " + invoice.getCode()));
                                                }
                                                if (invoice.getCash() > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getCashsarfasl().substring(0, 3)).moiencode(invoice.getCashsarfasl().substring(3, 7)).tafzilicode(invoice.getCashsarfasl().substring(7)).bes(Double.valueOf(invoice.getCash())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                                                }
                                                if (invoice.getBank() > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getBanksarfasl().substring(0, 3)).moiencode(invoice.getBanksarfasl().substring(3, 7)).tafzilicode(invoice.getBanksarfasl().substring(7)).bes(Double.valueOf(invoice.getBank())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                                                }
                                                if (!(invoice.getDiscount() > 0.0)) break;
                                                this.sanadAdd(PaymentDetailDto.builder().colcode("803").moiencode("0001").bes(Double.valueOf(invoice.getDiscount())).typeline("Z").commentline("\u0628\u0627\u0628\u062a \u0641\u0627\u0643\u062a\u0648\u0631 " + invoice.getCode() + " " + invoice.getCustomername()));
                                                break;
                                            }
                                            case 2: 
                                            case 3: {
                                                this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bed(Double.valueOf(sumPrice + sumLevy + sumScot)).typeline("F").commentline("\u0641\u0627\u0643\u062a\u0648\u0631 " + invoiceTypeName + " " + invoice.getCode()));
                                                if (invoiceType.equals((Object)InvoiceType.PROXY)) {
                                                    sellersDebtMap = new HashMap<String, Double>();
                                                    for (InvoiceDetailDto dtl : invoice.getDetailinfo()) {
                                                        existingDebt = sellersDebtMap.getOrDefault(dtl.getSellersarfasl(), 0.0);
                                                        price = dtl.getPrice() * dtl.getFew();
                                                        sellersDebtMap.put(dtl.getSellersarfasl(), existingDebt += price + price * ConvertStr.nullSafeDouble((Double)dtl.getLevy()) / 100.0 + price * ConvertStr.nullSafeDouble((Double)dtl.getScot()) / 100.0);
                                                    }
                                                    sum = 0.0;
                                                    lastKey = "";
                                                    for (String sellerSarfasl : sellersDebtMap.keySet()) {
                                                        currentValue = (Double)sellersDebtMap.get(sellerSarfasl);
                                                        sum += currentValue;
                                                        sellersDebtMap.put(sellerSarfasl, Double.valueOf(Math.round(currentValue)));
                                                        lastKey = sellerSarfasl;
                                                    }
                                                    if (sum < (double)Math.round(sum)) {
                                                        sellersDebtMap.put(lastKey, (Double)sellersDebtMap.get(lastKey) + 1.0);
                                                    }
                                                    for (String sellerSarfaslCode : sellersDebtMap.keySet()) {
                                                        name = proxyServiceSupplier.get().getSellerSarfaslName(sellerSarfaslCode);
                                                        colCode = sellerSarfaslCode.substring(0, 3);
                                                        moienCode = sellerSarfaslCode.substring(3, 7);
                                                        tafsiliCode = sellerSarfaslCode.substring(7);
                                                        this.sanadAdd(PaymentDetailDto.builder().colcode(colCode).moiencode(moienCode).tafzilicode(tafsiliCode).bes((Double)sellersDebtMap.get(sellerSarfaslCode)).commentline(" \u0634\u0645\u0627\u0631\u0647 " + invoice.getCode() + " " + name));
                                                    }
                                                } else {
                                                    if (!industrialService.isIndustrial()) {
                                                        this.sanadAdd(PaymentDetailDto.builder().colcode("901").moiencode("0001").bes(Double.valueOf(sumPrice)).commentline(" \u0634\u0645\u0627\u0631\u0647 " + invoice.getCode() + " " + invoice.getCustomername()));
                                                    } else {
                                                        sb = new StringBuilder();
                                                        for (Object aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                                                            sb.delete(0, sb.length());
                                                            this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getOffPriceCol()).moiencode(aSarfasl.getOffPriceMoein()).tafzilicode(aSarfasl.getOffPriceTafsili()).bed(aSarfasl.getArticleTotalBuyPrice()).commentline(sb.append("\u0642\u06cc\u0645\u062a \u062a\u0645\u0627\u0645 \u0634\u062f\u0647_").append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647").append(invoice.getCode()).toString()));
                                                        }
                                                    }
                                                    if (sumScot > 0.0) {
                                                        this.sanadAdd(PaymentDetailDto.builder().colcode(avarezShahrdary.substring(0, 3)).moiencode(avarezShahrdary.substring(3, 7)).tafzilicode(avarezShahrdary.substring(7)).bes(Double.valueOf(sumScot)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                                                    }
                                                    if (sumLevy > 0.0) {
                                                        this.sanadAdd(PaymentDetailDto.builder().colcode(avarezAmozesh.substring(0, 3)).moiencode(avarezAmozesh.substring(3, 7)).tafzilicode(avarezAmozesh.substring(7)).bes(Double.valueOf(sumLevy)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                                                    }
                                                }
                                                for (PaymentDetailDto.Builder paymentDto : this.expenseCalculator.getSanadDetails(invoice, invoiceTypeName)) {
                                                    this.sanadAdd(paymentDto);
                                                }
                                                for (PaymentDetailDto.Builder paymentDto : this.incomeCalculator.getSanadDetails(invoice, invoiceTypeName)) {
                                                    this.sanadAdd(paymentDto);
                                                }
                                                if (invoice.getCash() > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getCashsarfasl().substring(0, 3)).moiencode(invoice.getCashsarfasl().substring(3, 7)).tafzilicode(invoice.getCashsarfasl().substring(7)).bed(Double.valueOf(invoice.getCash())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                                                }
                                                if (invoice.getBank() > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getBanksarfasl().substring(0, 3)).moiencode(invoice.getBanksarfasl().substring(3, 7)).tafzilicode(invoice.getBanksarfasl().substring(7)).bed(Double.valueOf(invoice.getBank())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                                                }
                                                if (invoice.getDiscount() > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode("903").moiencode("0001").bed(Double.valueOf(invoice.getDiscount())).typeline("Z").commentline("\u0628\u0627\u0628\u062a \u0641\u0627\u0643\u062a\u0648\u0631 " + invoice.getCode() + " " + invoice.getCustomername()));
                                                }
                                                if (industrialService.isIndustrial()) {
                                                    sb = new StringBuilder();
                                                    for (Object aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                                                        sb.delete(0, sb.length());
                                                        this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getSellCol()).moiencode(aSarfasl.getSellMoein()).tafzilicode(aSarfasl.getSellTafsili()).bes(aSarfasl.getArticleTotalPrice()).commentline(sb.append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647").append(invoice.getCode()).toString()));
                                                    }
                                                    for (Object aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                                                        sb.delete(0, sb.length());
                                                        this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getMainCol()).moiencode(aSarfasl.getMainMoein()).tafzilicode(aSarfasl.getMainTafsili()).bes(aSarfasl.getArticleTotalBuyPrice()).commentline(sb.append("\u0627\u0646\u0628\u0627\u0631 \u0645\u062d\u0635\u0648\u0644_").append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647").append(invoice.getCode()).toString()).numberline(aSarfasl.getNumberLine()));
                                                    }
                                                }
                                                Comment = "\u062c\u0645\u0639 \u062f\u0631\u064a\u0627\u0641\u062a\u064a \u0628\u0627\u0628\u062a " + invoiceTypeName;
                                                if (invoice.getDiscount() > 0.0) {
                                                    Comment = invoice.getCash() + invoice.getBank() == 0.0 ? "\u062a\u062e\u0641\u064a\u0641 \u0628\u0627\u0628\u062a " + invoiceTypeName : "\u062c\u0645\u0639 \u062f\u0631\u064a\u0627\u0641\u062a\u064a \u0628\u0647 \u0627\u0646\u0636\u0645\u0627\u0645 \u062a\u062e\u0641\u064a\u0641 \u0628\u0627\u0628\u062a " + invoiceTypeName;
                                                }
                                                if (!(invoice.getCash() + invoice.getBank() + invoice.getDiscount() > 0.0)) break;
                                                this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bes(Double.valueOf(invoice.getCash() + invoice.getBank() + invoice.getDiscount())).typeline("S").commentline(Comment + " " + invoice.getCode()));
                                                break;
                                            }
                                            case 4: {
                                                this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bed(Double.valueOf(sumPrice + sumLevy + sumScot)).typeline("F").commentline("\u0641\u0627\u0643\u062a\u0648\u0631 " + invoiceTypeName + " " + invoice.getCode()));
                                                if (!industrialService.isIndustrial()) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode("802").moiencode("0001").bes(Double.valueOf(sumPrice)).commentline(" \u0634\u0645\u0627\u0631\u0647 " + invoice.getCode() + " " + invoice.getCustomername()));
                                                }
                                                if (sumScot > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(avarezShahrdary.substring(0, 3)).moiencode(avarezShahrdary.substring(3, 7)).tafzilicode(avarezShahrdary.substring(7)).bes(Double.valueOf(sumScot)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                                                }
                                                if (sumLevy > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(avarezAmozesh.substring(0, 3)).moiencode(avarezAmozesh.substring(3, 7)).tafzilicode(avarezAmozesh.substring(7)).bes(Double.valueOf(sumLevy)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                                                }
                                                if (invoice.getCash() > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getCashsarfasl().substring(0, 3)).moiencode(invoice.getCashsarfasl().substring(3, 7)).tafzilicode(invoice.getCashsarfasl().substring(7)).bed(Double.valueOf(invoice.getCash())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                                                }
                                                if (invoice.getBank() > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getBanksarfasl().substring(0, 3)).moiencode(invoice.getBanksarfasl().substring(3, 7)).tafzilicode(invoice.getBanksarfasl().substring(7)).bed(Double.valueOf(invoice.getBank())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                                                }
                                                if (invoice.getDiscount() > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode("803").moiencode("0001").bed(Double.valueOf(invoice.getDiscount())).typeline("Z").commentline("\u0628\u0627\u0628\u062a \u0641\u0627\u0643\u062a\u0648\u0631 " + invoice.getCode() + " " + invoice.getCustomername()));
                                                }
                                                if (industrialService.isIndustrial()) {
                                                    sb = new StringBuilder();
                                                    for (Object aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                                                        sb.delete(0, sb.length());
                                                        this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getMainCol()).moiencode(aSarfasl.getMainMoein()).tafzilicode(aSarfasl.getMainTafsili()).bes(aSarfasl.getArticleTotalPrice()).commentline(sb.append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647 ").append(invoice.getCode()).toString()).numberline(aSarfasl.getNumberLine()));
                                                    }
                                                }
                                                Comment = "\u062c\u0645\u0639 \u062f\u0631\u064a\u0627\u0641\u062a\u064a \u0628\u0627\u0628\u062a " + invoiceTypeName;
                                                if (invoice.getDiscount() > 0.0) {
                                                    Comment = invoice.getDiscount() > 0.0 && invoice.getCash() + invoice.getBank() == 0.0 ? "\u062a\u062e\u0641\u064a\u0641 \u0628\u0627\u0628\u062a " + invoiceTypeName : "\u062c\u0645\u0639 \u062f\u0631\u064a\u0627\u0641\u062a\u064a \u0628\u0647 \u0627\u0646\u0636\u0645\u0627\u0645 \u062a\u062e\u0641\u064a\u0641 \u0628\u0627\u0628\u062a " + invoiceTypeName;
                                                }
                                                if (!(invoice.getCash() + invoice.getBank() + invoice.getDiscount() > 0.0)) break;
                                                this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bes(Double.valueOf(invoice.getCash() + invoice.getBank() + invoice.getDiscount())).typeline("S").commentline(Comment + " " + invoice.getCode()));
                                                break;
                                            }
                                            case 5: {
                                                if (!industrialService.isIndustrial()) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode("902").moiencode("0001").bed(Double.valueOf(sumPrice)).commentline(" \u0634\u0645\u0627\u0631\u0647 " + invoice.getCode() + " " + invoice.getCustomername()));
                                                } else {
                                                    sb = new StringBuilder();
                                                    for (Object aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                                                        sb.delete(0, sb.length());
                                                        this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getRetSellCol()).moiencode(aSarfasl.getRetSellMoein()).tafzilicode(aSarfasl.getRetSellTafsili()).bed(aSarfasl.getArticleTotalPrice()).commentline(sb.append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647").append(invoice.getCode()).toString()));
                                                    }
                                                    for (Object aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                                                        sb.delete(0, sb.length());
                                                        this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getMainCol()).moiencode(aSarfasl.getMainMoein()).tafzilicode(aSarfasl.getMainTafsili()).bed(aSarfasl.getArticleTotalBuyPrice()).commentline(sb.append("\u0627\u0646\u0628\u0627\u0631 \u0645\u062d\u0635\u0648\u0644_").append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647").append(invoice.getCode()).toString()).numberline(aSarfasl.getNumberLine()));
                                                    }
                                                }
                                                if (sumScot > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(avarezShahrdary.substring(0, 3)).moiencode(avarezShahrdary.substring(3, 7)).tafzilicode(avarezShahrdary.substring(7)).bed(Double.valueOf(sumScot)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                                                }
                                                if (sumLevy > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(avarezAmozesh.substring(0, 3)).moiencode(avarezAmozesh.substring(3, 7)).tafzilicode(avarezAmozesh.substring(7)).bed(Double.valueOf(sumLevy)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                                                }
                                                Comment = "\u062c\u0645\u0639 \u067e\u0631\u062f\u0627\u062e\u062a\u0647\u0627 \u0628\u0627\u0628\u062a " + invoiceTypeName;
                                                if (invoice.getDiscount() > 0.0) {
                                                    Comment = invoice.getCash() + invoice.getBank() == 0.0 ? "\u062a\u062e\u0641\u064a\u0641 \u0628\u0627\u0628\u062a " + invoiceTypeName : "\u062c\u0645\u0639 \u067e\u0631\u062f\u0627\u062e\u062a\u0647\u0627 \u0628\u0647 \u0627\u0646\u0636\u0645\u0627\u0645 \u062a\u062e\u0641\u064a\u0641 \u0628\u0627\u0628\u062a " + invoiceTypeName;
                                                }
                                                if (invoice.getCash() + invoice.getBank() + invoice.getDiscount() > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bed(Double.valueOf(invoice.getCash() + invoice.getBank() + invoice.getDiscount())).typeline("S").commentline(Comment + " " + invoice.getCode()));
                                                }
                                                sb = new StringBuilder();
                                                aSarfasl = industrialService.getInvoiceArticlesSarfaslList().iterator();
                                                while (aSarfasl.hasNext()) {
                                                    aSarfasl = (ArticleSarfasl)aSarfasl.next();
                                                    sb.delete(0, sb.length());
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getOffPriceCol()).moiencode(aSarfasl.getOffPriceMoein()).tafzilicode(aSarfasl.getOffPriceTafsili()).bes(aSarfasl.getArticleTotalBuyPrice()).commentline(sb.append("\u0642\u06cc\u0645\u062a \u062a\u0645\u0627\u0645 \u0634\u062f\u0647_").append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647").append(invoice.getCode()).toString()));
                                                }
                                                this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bes(Double.valueOf(sumPrice + sumLevy + sumScot)).typeline("F").commentline("\u0641\u0627\u0643\u062a\u0648\u0631 " + invoiceTypeName + " " + invoice.getCode()));
                                                if (invoice.getCash() > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getCashsarfasl().substring(0, 3)).moiencode(invoice.getCashsarfasl().substring(3, 7)).tafzilicode(invoice.getCashsarfasl().substring(7)).bes(Double.valueOf(invoice.getCash())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                                                }
                                                if (invoice.getBank() > 0.0) {
                                                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getBanksarfasl().substring(0, 3)).moiencode(invoice.getBanksarfasl().substring(3, 7)).tafzilicode(invoice.getBanksarfasl().substring(7)).bes(Double.valueOf(invoice.getBank())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                                                }
                                                if (!(invoice.getDiscount() > 0.0)) break;
                                                discountY = this.settingDao.getMSetup2String(myLogin, "BarghashtForush", "9030001");
                                                this.sanadAdd(PaymentDetailDto.builder().colcode(discountY.substring(0, 3)).moiencode(discountY.substring(3, 7)).tafzilicode(discountY.substring(7)).bes(Double.valueOf(invoice.getDiscount())).typeline("Z").commentline("\u0628\u0627\u0628\u062a \u0641\u0627\u0643\u062a\u0648\u0631 " + invoice.getCode() + " " + invoice.getCustomername()));
                                                break;
                                            }
                                        }
                                        this.sndList.addAll(commissionCalculator.getCommissionSndListData());
                                        commissionCalculator.updateFactArt();
                                        for (h = 0; h <= this.sndList.size() - 1; ++h) {
                                            sqlStr = " Insert Into Snd_List(Sanad_Code, Col_Code, Moien_Code, Tafzili_Code, Bed, Bes, Joze, Show_Daftar,Type_Line, Comment_Line, Actions, Number_Line)  Values(" + sanadCode + ",'" + ((PaymentDetailDto)this.sndList.get(h)).getColcode() + "','" + ((PaymentDetailDto)this.sndList.get(h)).getMoiencode() + "','" + ((PaymentDetailDto)this.sndList.get(h)).getTafzilicode() + "'," + ((PaymentDetailDto)this.sndList.get(h)).getBed() + "," + ((PaymentDetailDto)this.sndList.get(h)).getBes() + "," + ConvertStr.getBoolToInt((Boolean)((PaymentDetailDto)this.sndList.get(h)).getJoze()) + "," + ConvertStr.getBoolToInt((Boolean)((PaymentDetailDto)this.sndList.get(h)).getShowdaftar()) + ",'" + ((PaymentDetailDto)this.sndList.get(h)).getTypeline() + "', N'" + ((PaymentDetailDto)this.sndList.get(h)).getCommentline() + "'," + ((PaymentDetailDto)this.sndList.get(h)).getActions() + "," + ((PaymentDetailDto)this.sndList.get(h)).getNumberline() + ")";
                                            jdbcTemplate.execute(sqlStr);
                                        }
                                    }
                                }
                                if (this.isOrderOrInvoice(FRegisterType) && !myLogin.getIsMyHoloo().booleanValue()) {
                                    this.serialOperations(invoice, myLogin);
                                }
                                if (!myLogin.getIsMyHoloo().booleanValue()) {
                                    invoice.setRegisterType(FRegisterType);
                                    invoice.setSanadcode(sanadCode);
                                    new InvoiceProcessDao(this.dbConnection, myLogin, msg).insert((Object)invoice, ProcessDao.ProcessKind.ADD);
                                }
                                if (this.isInvoice(FRegisterType) && sanadCode <= 0 && !myLogin.getIsMyHoloo().booleanValue()) {
                                    throw new Exception("\u062f\u0631 \u062f\u0631\u062c \u0633\u0646\u062f \u0645\u0634\u06a9\u0644\u06cc \u067e\u06cc\u0634 \u0622\u0645\u062f\u0647 \u0648 \u0641\u0627\u06a9\u062a\u0648\u0631 \u062b\u0628\u062a \u0646\u0634\u062f. \u0644\u0637\u0641\u0627 \u0645\u062c\u062f\u062f \u062a\u0644\u0627\u0634 \u0646\u0645\u0627\u06cc\u06cc\u062f");
                                }
                                model = new LinkedHashMap<String, String>();
                                if (!ConvertStr.isNullOrEmpty((String)invoice.getInputid())) {
                                    model.put("Id", invoice.getInputid());
                                }
                                model.put("ErpCode", ConvertStr.encrypt((String)invoice.getId()));
                                model.put("Code", String.valueOf(invoice.getCode()));
                                if (this.isInvoice(FRegisterType)) {
                                    model.put("SanadCode", String.valueOf(sanadCode));
                                }
                                if (myLogin.getIsMyHoloo().booleanValue()) {
                                    model.put("Dbname", myLogin.getDataBaseName().substring(myLogin.getDataBaseName().indexOf("[") + 1, myLogin.getDataBaseName().lastIndexOf("]")));
                                }
                                success.add(model);
                                if (!myLogin.getIsMyHoloo().booleanValue()) continue block20;
                                this.log.info(myLogin.getDataBaseName() + " *** InvInsSuccess: " + model.toString());
                                continue block20;
                                break;
                            }
                        }
                        catch (TncException tncEx) {
                            if (!ConvertStr.isNullOrEmpty((String)invoice.getInputid())) {
                                tncEx.putMoreInfo("Id", (Object)invoice.getInputid());
                            }
                            if (!myProduct.isEmpty()) {
                                if (myProduct.size() == 1) {
                                    tncEx.putMoreInfo("ProductDetail", myProduct.get(0));
                                } else {
                                    tncEx.putMoreInfo("ProductDetail", myProduct);
                                }
                            }
                            if (myLogin.getIsMyHoloo().booleanValue()) {
                                tncEx.putMoreInfo("Dbname", (Object)jdbcTemplate.getLogin().getDataBaseName().substring(myLogin.getDataBaseName().indexOf("[") + 1, myLogin.getDataBaseName().lastIndexOf("]")));
                                this.log.info(myLogin.getDataBaseName() + " *** InvInsTncErr: " + tncEx.getErrorMap());
                            }
                            failure.add(tncEx.getErrorMap());
                            errorLog = "dbname: " + myLogin.getDataBaseName() + " Exception *** message: " + tncEx.getMessage();
                            if (errorProductCode != null) {
                                errorLog = errorLog + " Error A_CODE: " + errorProductCode;
                            }
                            this.log.info(errorLog);
                            exceptions.add(tncEx);
                        }
                    }
                }
                catch (Throwable ex) {
                    e = new TncException(TncExceptionMessages.DEFAULT_ERROR);
                    if (myLogin.getIsTorfehNegar().booleanValue()) {
                        e.putMoreInfo("ErrorMessage", (Object)ex.getMessage());
                    }
                    if (myLogin.getIsMyHoloo().booleanValue()) {
                        e.putMoreInfo("Dbname", (Object)myLogin.getDataBaseName().substring(myLogin.getDataBaseName().indexOf("[") + 1, myLogin.getDataBaseName().lastIndexOf("]")));
                        this.log.info(myLogin.getDataBaseName() + " *** InvInsErr: " + e.getErrorMap());
                    }
                    failure.add(e.getErrorMap());
                    this.log.info("dbname: " + myLogin.getDataBaseName() + "Exception *** message: " + e.getMessage() + " exception message : " + (myLogin.getIsTorfehNegar() == false ? ex.getMessage() : "\n" + ex.getCause() + Arrays.toString(ex.getStackTrace())));
                    exceptions.add(e);
                }
                if (exceptions.isEmpty() != false) return ConvertStr.getMapResponseEntity((String)"Invoice", failure, success);
                throw new TncException(exceptions).addSuccessList(success);
            }
            while (var31_41.hasNext()) {
                dtl = (InvoiceDetailDto)var31_41.next();
                if (dtl.getDiscountprice() == null && dtl.getDiscountpercent() != null) {
                    totalDiscount += dtl.getPrice() * dtl.getFew() * (dtl.getDiscountpercent() / 100.0);
                    continue;
                }
                if (dtl.getDiscountprice() == null || dtl.getDiscountpercent() != null) continue;
                totalDiscount += dtl.getDiscountprice().doubleValue();
            }
        }
        sqlStr = "Insert into RQTITLE(RqIndex2,RqType,R_CusCode,R_Date,T_Date,T_Time,SumPrice, UserName,ShowOrHide,vaseteh_code,Comment,WebId, FTakhfif) Values('" + invoice.getCode() + "','" + invoiceType.getSymbol() + "','" + invoice.getCustomerid() + "','" + invoice.getDate() + "','" + invoice.getDate() + "','" + invoice.getTime() + "',0,1,1,'" + invoice.getMidmanerpcode() + "','" + invoice.getComment() + "','" + invoice.getInputid() + "'," + (totalDiscount == 0.0 ? null : Double.valueOf(totalDiscount)) + ")";
        jdbcTemplate.execute(sqlStr);
        sqlStr = "Select Max(RqIndex)RqIndex  From RQTITLE";
        rs = jdbcTemplate.queryForRowSet(sqlStr);
        invoice.setId("0");
        while (true) {
            if (!rs.next()) ** continue;
            invoice.setId(ConvertStr.getNullIfEmpty((String)rs.getString("RqIndex")));
        }
    }

    private String getTorfehNegarInvCode(TncJdbc jdbcTemplate, InvoiceType invoiceType) {
        SqlRowSet rs = jdbcTemplate.queryForRowSet("exec dbo.CMS_GetMaxFactCode '" + invoiceType.getSymbol() + "'");
        rs.next();
        return rs.getString("Fact_Code");
    }

    private void checkDuplicateInvoiceCustomCode(int invCustCode, JdbcTemplate jdbcTemplate) throws TncException {
        Integer count = (Integer)jdbcTemplate.queryForObject(" SELECT COUNT(*) cnt FROM FACTURE WHERE FAC_CODE_C = ?", Integer.class, new Object[]{invCustCode});
        if (ConvertStr.nullSafeInt((Integer)count) > 0) {
            throw new TncException(TncExceptionMessages.DUPLICATE_INVOICE_CODE.setArgs(new Object[]{invCustCode}));
        }
    }

    private int generateInvoiceCustomCode(LoginDto myLogin, JdbcTemplate jdbcTemplate, InvoiceType invoiceType) {
        if (myLogin.getIsTorfehNegar().booleanValue()) {
            return this.getTorfehNegarInvCodeC(jdbcTemplate, invoiceType);
        }
        String sqlStr = this.settingDao.getMSetup2Boolean(myLogin, "MaxFac_Code_C") ? "SELECT ISNULL(MAX(FAC_CODE_C),0)+1 FAC_CODE_C FROM FACTURE WHERE FAC_TYPE= ?" : "SELECT ISNULL((SELECT TOP 1 FAC_CODE_C FROM FACTURE WHERE FAC_TYPE= ?  ORDER BY FAC_CODE DESC, FAC_TYPE) , 0) + 1 FAC_CODE_C";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{invoiceType.getSymbol()});
        if (rs.next()) {
            return rs.getInt("FAC_CODE_C");
        }
        return 0;
    }

    private int getTorfehNegarInvCodeC(JdbcTemplate jdbcTemplate, InvoiceType invoiceType) {
        SqlRowSet rs = jdbcTemplate.queryForRowSet("exec dbo.CMS_GetMaxFactCode '" + invoiceType.getSymbol() + "'");
        rs.next();
        return rs.getInt("Fact_Code_C");
    }

    private void checkDuplicateWebId(LoginDto login, String inputId, int fRegisterType) throws TncException {
        String table = this.isInvoice(fRegisterType) && login.getIsMyHoloo() == false ? "FACTURE" : (this.isInvoice(fRegisterType) && login.getIsMyHoloo() != false ? "TmpFacture" : (this.isOrder(fRegisterType) ? "RqTitle" : (this.isPreInvoice(fRegisterType) ? "FBailPre" : null)));
        if (table == null) {
            return;
        }
        String sql = "SELECT COUNT(*) FROM " + table + " WHERE WebId = '" + inputId + "'";
        Integer webIdCount = (Integer)this.dbConnection.getJdbcTemplate(login).queryForObject(sql, Integer.class);
        if (webIdCount != null && webIdCount > 0) {
            throw new TncException(TncExceptionMessages.DUPLICATE_WEB_ID);
        }
    }

    private void insertCustomerAddress(JdbcTemplate jdbcTemplate, InvoiceDto.InvoiceInfo invoice) {
        if (!ConvertStr.isNullOrEmpty((String)invoice.getCustomeraddress()) && invoice.getCustomeraddressid() < 1) {
            throw new TncException(TncExceptionMessages.USE_CUSTOMER_ADDRESS_ID_INSTEAD);
        }
        String sql = invoice.getCustomeraddressid() == 1 || invoice.getCustomeraddressid() == 0 ? "SELECT C_ADDRESS cAddress FROM CUSTOMER WHERE C_CODE = '" + invoice.getCustomerid() + "'" : "SELECT C_ADDRESS" + (invoice.getCustomeraddressid() - 1) + " cAddress FROM CUST_TELL \n WHERE CCode = '" + invoice.getCustomerid() + "'";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sql);
        if ((!rs.next() || ConvertStr.isNullOrEmpty((String)rs.getString("cAddress"))) && invoice.getCustomeraddressid() != 0) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_ADDRESS_ID);
        }
        invoice.setCustomeraddress(ConvertStr.nullSafeString((String)rs.getString("cAddress")));
        jdbcTemplate.update(" INSERT INTO FactOther (FAC_CODE, FAC_TYPE, C_NAME, C_ADDRESS, ADDRESS_ID, \n TELL_ID, MOBILE_ID, C_CODE) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{invoice.getId(), invoice.getType(), invoice.getCustomername(), invoice.getCustomeraddress(), invoice.getCustomeraddressid() == 0 ? 1 : invoice.getCustomeraddressid(), 0, 0, invoice.getCustomerid()});
    }

    private void addPoshak(LoginDto login, int fRegisterType, InvoiceDto.InvoiceInfo invoiceInfo, int index, InvoiceDetailDto dtl) {
        if (dtl.getPoshakinfo() == null) {
            return;
        }
        String pType = invoiceInfo.getType();
        if (!login.getIsMyHoloo().booleanValue()) {
            if (this.isOrder(fRegisterType)) {
                pType = "J";
            } else if (this.isPreInvoice(fRegisterType)) {
                pType = "P";
            }
        } else if (this.isInvoice(fRegisterType)) {
            pType = "T";
        }
        StringBuilder pComment = new StringBuilder();
        for (int k = 0; k < dtl.getPoshakinfo().size(); ++k) {
            Poshak myPoshakClass = (Poshak)dtl.getPoshakinfo().get(k);
            if (this.isInvoice(fRegisterType) && !login.getIsMyHoloo().booleanValue()) {
                this.itemArticleDao.updateItemArticleFew(login, myPoshakClass, dtl.getProductid(), invoiceInfo.getInvoiceType().getOperator());
            }
            this.itemArticleDao.insertItemFact(login, invoiceInfo.getId(), pType, dtl.getProductid(), myPoshakClass, index);
            if (!ConvertStr.isNullOrEmpty((String)dtl.getComment())) continue;
            pComment = this.itemArticleDao.getAttributeNameTree(myPoshakClass, pComment, login);
        }
        if (!ConvertStr.isNullOrEmpty((String)dtl.getComment()) || pComment.toString().isEmpty()) {
            return;
        }
        String sqlStr = this.isOrder(fRegisterType) ? " Update RqDetail Set R_Commen = '" + pComment + "' Where RqIndex=" + invoiceInfo.getId() + " And RqType='" + invoiceInfo.getType() + "' And R_ArCode='" + dtl.getProductid() + "'" : (this.isPreInvoice(fRegisterType) ? " Update Abailpre Set FacArtic_Comment = '" + pComment + "' Where Fac_Code='" + invoiceInfo.getId() + "' And Fac_Type='" + pType + "' And A_Code='" + dtl.getProductid() + "' And A_Index=" + (index + 1) : " Update Factart Set FacArtic_Comment = '" + pComment + "' Where Fac_Code='" + invoiceInfo.getId() + "' And Fac_Type='" + pType + "' And A_Code='" + dtl.getProductid() + "' And A_Index=" + (index + 1));
        this.dbConnection.getJdbcTemplate(login).execute(sqlStr);
    }

    private void addPoshakMyHoloo(LoginDto myLogin, int fRegisterType, InvoiceDto.InvoiceInfo invoiceInfo, int index, InvoiceDetailDto dtl) {
        String pType;
        if (dtl.getPoshakinfo() == null) {
            return;
        }
        if (fRegisterType != 2) {
            return;
        }
        switch (invoiceInfo.getType()) {
            case "F": {
                pType = "6";
                break;
            }
            case "K": {
                pType = "5";
                break;
            }
            case "Y": {
                pType = "8";
                break;
            }
            default: {
                return;
            }
        }
        StringBuilder pComment = new StringBuilder();
        for (int k = 0; k < dtl.getPoshakinfo().size(); ++k) {
            Poshak myPoshakClass = (Poshak)dtl.getPoshakinfo().get(k);
            this.itemArticleDao.insertItemFact(myLogin, invoiceInfo.getId(), pType, dtl.getProductid(), myPoshakClass, index);
            if (!ConvertStr.isNullOrEmpty((String)dtl.getComment())) continue;
            pComment = this.itemArticleDao.getAttributeNameTree(myPoshakClass, pComment, myLogin);
        }
        if (!ConvertStr.isNullOrEmpty((String)dtl.getComment()) || pComment.toString().isEmpty()) {
            return;
        }
        String sqlStr = " UPDATE TMPFACTART SET A_COMMENT = '" + pComment + "' WHERE IDFACTURE='" + invoiceInfo.getId() + "' AND A_CODE='" + dtl.getProductid() + "'";
        this.dbConnection.getJdbcTemplate(myLogin).execute(sqlStr);
    }

    private void checkExistPoshak(boolean negativeOfSath, InvoiceDto.InvoiceInfo invoiceInfo, List<Map<String, Object>> myProduct, InvoiceDetailDto myDtlClass, LoginDto myLogin) throws TncException {
        if (myDtlClass.getPoshakinfo() == null) {
            return;
        }
        for (int k = 0; k < myDtlClass.getPoshakinfo().size(); ++k) {
            Poshak myPoshakClass = (Poshak)myDtlClass.getPoshakinfo().get(k);
            if (myPoshakClass.getFew() == null || myPoshakClass.getFew() <= 0.0) {
                LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
                model.put("ErpCode", myDtlClass.getProducterpcode());
                model.put("Id", myPoshakClass.getId());
                myProduct.add(model);
                throw new TncException(TncExceptionMessages.INVALID_ATTRIBUTE_AMOUNT);
            }
            if (this.itemArticleDao.getAttribCountByProductAndPoshakId(myDtlClass.getProductid(), myPoshakClass.getId().intValue(), myLogin) == 0) {
                LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
                model.put("ErpCode", myDtlClass.getProducterpcode());
                model.put("Id", myPoshakClass.getId());
                myProduct.add(model);
                throw new TncException(TncExceptionMessages.INVALID_ATTRIBUTE_CODES);
            }
            if (!this.negativeSathNotAllowed(negativeOfSath, invoiceInfo)) continue;
            double poshakAmount = this.itemArticleDao.getAttribFewByProductAndPoshakId(myDtlClass.getProductid(), myPoshakClass.getId().intValue(), myLogin);
            if (!(myPoshakClass.getFew() > poshakAmount)) continue;
            LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
            model.put("ErpCode", myDtlClass.getProducterpcode());
            model.put("Id", myPoshakClass.getId());
            model.put("Few", poshakAmount);
            myProduct.add(model);
            throw new TncException(TncExceptionMessages.ATTRIBUTES_NO_STORE);
        }
    }

    private boolean negativeInvoiceNotAllowed(boolean negativeFact, InvoiceDto.InvoiceInfo invoiceInfo) {
        if (invoiceInfo.getType().equals("F") || invoiceInfo.getType().equals("X")) {
            return !negativeFact;
        }
        return false;
    }

    private boolean negativeSathNotAllowed(boolean negativeFact, InvoiceDto.InvoiceInfo invoiceInfo) {
        if (invoiceInfo.getType().equals("F") || invoiceInfo.getType().equals("X") || invoiceInfo.getType().equals("P")) {
            return !negativeFact;
        }
        return false;
    }

    private boolean negativePishNotAllowed(boolean negativePish, InvoiceDto.InvoiceInfo invoiceInfo) {
        if (invoiceInfo.getType().equals("P")) {
            return !negativePish;
        }
        return false;
    }

    private boolean isInvoice(int fRegisterType) {
        return fRegisterType == 2;
    }

    private boolean isPreInvoice(int fRegisterType) {
        return fRegisterType == 1;
    }

    private boolean isOrder(int fRegisterType) {
        return fRegisterType == 0;
    }

    private boolean isInvoiceOrPreInvoice(int fRegisterType) {
        return this.isPreInvoice(fRegisterType) || this.isInvoice(fRegisterType);
    }

    private boolean isOrderOrInvoice(int fRegisterType) {
        return this.isInvoice(fRegisterType) || this.isOrder(fRegisterType);
    }

    private boolean isCostAvailable(InvoiceDto.InvoiceInfo invoice) {
        return !ConvertStr.isNullOrEmpty((Collection)invoice.getHazineinfo()) && (invoice.getType().equals("F") || invoice.getType().equals("K"));
    }

    private boolean isIncomeAvailable(InvoiceDto.InvoiceInfo invoice) {
        return !ConvertStr.isNullOrEmpty((Collection)invoice.getIncomeinfo()) && (invoice.getType().equals("F") || invoice.getType().equals("K"));
    }

    private void serialOperations(InvoiceDto.InvoiceInfo invoice, LoginDto myLogin) throws TncException {
        for (InvoiceDetailDto dtl : invoice.getDetailinfo()) {
            dtl.setType(invoice.getType());
            SerialDao serialDao = new SerialDao(this.dbConnection, dtl, myLogin);
            serialDao.assertMustHaveSerial();
            serialDao.assertAnbSerExistence();
            if (ConvertStr.isNullOrEmpty((Collection)dtl.getSerials())) continue;
            serialDao.buyOrSellGivenSerials(invoice.getId());
        }
    }

    private ResponseEntity<Map<String, Object>> postInvoiceListOnly(LoginDto myLogin, InvoiceDto.InvoiceInfo[] invoiceInfo) {
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        try {
            this.insertOrDeleteInvoice(myLogin, invoiceInfo);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.makeErrorWithCause((Throwable)ex));
            return ConvertStr.getMapResponseEntity((String)"Invoice", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"Invoice", failure, success);
    }

    void insertOrDeleteInvoice(LoginDto myLogin, InvoiceDto.InvoiceInfo[] invoiceInfo) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDataBaseName()).transactionDeadLockWrapper(() -> this.insertInvoice(myLogin, invoiceInfo), new String[]{"FACTURE", "FACTART"});
        }
        catch (Exception ex) {
            this.deleteRepeatInvoice(myLogin, invoiceInfo);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteInvoice(myLogin, invoiceInfo);
            }
            throw ex;
        }
    }

    private void insertInvoice(LoginDto myLogin, InvoiceDto.InvoiceInfo[] invoiceArray) {
        int m = 0;
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        StringBuilder sb = new StringBuilder();
        for (InvoiceDto.InvoiceInfo info : invoiceArray) {
            ++m;
            if (sb.length() > 0) {
                sb.append(" , ");
            }
            this.appendSelectFactureStatement(sb, info);
            if (m <= 50) continue;
            sb = this.getInsertFactureStatement().append("values ").append((CharSequence)sb);
            jdbcTemplate.execute("\n" + sb + "\n");
            m = 0;
            sb.delete(0, sb.length());
        }
        if (m > 0) {
            sb = this.getInsertFactureStatement().append("values ").append((CharSequence)sb);
            jdbcTemplate.execute("\n" + sb + "\n");
        }
        m = 0;
        sb.delete(0, sb.length());
        for (InvoiceDto.InvoiceInfo info : invoiceArray) {
            for (int j = 0; j < info.getDetailinfo().size(); ++j) {
                InvoiceDetailDto dtl = (InvoiceDetailDto)info.getDetailinfo().get(j);
                ++m;
                if (sb.length() > 0) {
                    sb.append(" , ");
                }
                if (ConvertStr.isNullOrEmpty((String)dtl.getType())) {
                    dtl.setType(info.getType());
                }
                if (dtl.getAindex() == null) {
                    dtl.setAindex(Integer.valueOf(j + 1));
                }
                this.appendSelectFactartStatement(sb, dtl);
                if (m <= 50) continue;
                sb = this.getInsertFactartStatement().append("values ").append((CharSequence)sb);
                jdbcTemplate.execute(sb.toString());
                m = 0;
                sb.delete(0, sb.length());
            }
        }
        if (m > 0) {
            sb = this.getInsertFactartStatement().append("values ").append((CharSequence)sb);
            jdbcTemplate.execute(sb.toString());
        }
    }

    private void deleteRepeatInvoice(LoginDto myLogin, InvoiceDto.InvoiceInfo[] invoiceArray) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDataBaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
            int i = 0;
            while (i < invoiceArray.length) {
                StringBuilder Fac_Code = new StringBuilder("'" + invoiceArray[i].getFac_code() + invoiceArray[i].getType() + "'");
                ++i;
                for (int j = 0; j < 50 && i < invoiceArray.length; ++j, ++i) {
                    Fac_Code.append(",'").append(invoiceArray[i].getFac_code()).append(invoiceArray[i].getType()).append("'");
                }
                jdbcTemplate.execute(" Delete Facture Where Fac_Code + Fac_Type in (" + Fac_Code + ")");
                jdbcTemplate.execute(" Delete Factart Where Fac_Code + Fac_Type in (" + Fac_Code + ")");
            }
        }, new String[]{"FACTURE", "FACTART"});
    }

    private String filterTmpInvoice(HttpServletRequest request) {
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        String[] infos = new String[]{"ischange", "isdeleted"};
        StringBuilder sqlWhere = new StringBuilder();
        for (String i : infos) {
            if (!info.containsKey(i)) continue;
            if (sqlWhere.length() != 0) {
                sqlWhere.append(" AND ");
            }
            sqlWhere.append("f.").append(i).append(" = '").append((String)info.get(i)).append("'");
        }
        if (sqlWhere.length() > 0) {
            sqlWhere.insert(0, " Where ");
        }
        return sqlWhere.toString();
    }

    private String getFilter(Map<String, String> info) {
        String sqlWhere = "";
        int Type2 = 0;
        if (info.containsKey("type")) {
            Type2 = Integer.parseInt(info.get("type"));
            sqlWhere = Type2 == 6 ? sqlWhere + " f.RqType ='" + ConvertStr.getTypeOfFacture((String)info.get("type")) + "'" : sqlWhere + " f.Fac_Type ='" + ConvertStr.getTypeOfFacture((String)info.get("type")) + "'";
        }
        if (info.containsKey("customererpcode")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 ? sqlWhere + " f.R_CUSCODE = '" + ConvertStr.decrypt((String)info.get("customererpcode")) + "'" : sqlWhere + " f.C_CODE = '" + ConvertStr.decrypt((String)info.get("customererpcode")) + "'";
        }
        if (info.containsKey("erpcode") && Type2 != 6) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " f.FAC_CODE = '" + ConvertStr.decrypt((String)info.get("erpcode")) + "'";
        }
        if (info.containsKey("code")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 ? sqlWhere + " f.RqIndex2 = '" + info.get("code") + "'" : sqlWhere + " f.Fac_code_c = '" + info.get("code") + "'";
        }
        if (info.containsKey("code.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 ? sqlWhere + " f.RqIndex2 >= '" + info.get("code.from") + "'" : sqlWhere + " f.Fac_code_c >= '" + info.get("code.from") + "'";
        }
        if (info.containsKey("code.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 ? sqlWhere + " f.RqIndex2 <= '" + info.get("code.to") + "'" : sqlWhere + " f.Fac_code_c <= '" + info.get("code.to") + "'";
        }
        if (Type2 != 6 && info.containsKey("sanadcode")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " S.Sanad_Code_C = '" + info.get("sanadcode") + "'";
        }
        if (Type2 != 6 && info.containsKey("sanadcode.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " S.Sanad_Code_C >= '" + info.get("sanadcode.from") + "'";
        }
        if (Type2 != 6 && info.containsKey("sanadcode.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " S.Sanad_Code_C <= '" + info.get("sanadcode.to") + "'";
        }
        if (info.containsKey("date")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 ? sqlWhere + " f.T_date = '" + info.get("date") + "'" : sqlWhere + " f.Fac_date = '" + info.get("date") + "'";
        }
        if (info.containsKey("date.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 ? sqlWhere + " f.T_date >= '" + info.get("date.from") + "'" : sqlWhere + " f.Fac_date >= '" + info.get("date.from") + "'";
        }
        if (info.containsKey("date.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 ? sqlWhere + " f.T_date <= '" + info.get("date.to") + "'" : sqlWhere + " f.Fac_date <= '" + info.get("date.to") + "'";
        }
        if (!sqlWhere.isEmpty()) {
            sqlWhere = " Where " + sqlWhere;
        }
        return sqlWhere;
    }

    public synchronized ResponseEntity<?> postSmartHelpOrder(String body) {
        List<Object> orderInfo;
        LoginDto myLogin = this.dbConnection.setToken();
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        try {
            body = body.substring(15, body.length() - 1);
            Gson gson = new Gson();
            orderInfo = Arrays.asList((Object[])gson.fromJson(body, OrderDto.OrderInfo[].class));
        }
        catch (Exception ex) {
            TncException e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            if (myLogin.getIsTorfehNegar().booleanValue()) {
                e.putMoreInfo("ErrorMessage", (Object)ex.getMessage());
            }
            failure.add(e.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Order", failure, success);
        }
        try {
            this.insertOrDeleteOrder(myLogin, orderInfo);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.makeErrorWithCause((Throwable)ex));
            return ConvertStr.getMapResponseEntity((String)"Order", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"Order", failure, success);
    }

    private void insertOrDeleteOrder(LoginDto myLogin, List<OrderDto.OrderInfo> orderInfos) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDataBaseName()).transactionDeadLockWrapper(() -> this.batchInsertOrder(myLogin, orderInfos), new String[]{"RqTitle", "RqDetail"});
        }
        catch (Exception ex) {
            this.deleteRepeatedOrder(myLogin, orderInfos);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteOrder(myLogin, orderInfos);
            }
            throw ex;
        }
    }

    private void batchInsertOrder(LoginDto myLogin, List<OrderDto.OrderInfo> orderInfos) {
        OrderBulkInsert orderInsert = new OrderBulkInsert(this.dbConnection);
        orderInsert.bulkInsert(myLogin, orderInfos);
        OrderBulkInsert.OrderDetailBulkInsert orderDtlInsert = new OrderBulkInsert.OrderDetailBulkInsert(this.dbConnection);
        ArrayList allDtls = new ArrayList();
        for (OrderDto.OrderInfo info : orderInfos) {
            allDtls.addAll(this.makeOrderDtlList(info));
        }
        orderDtlInsert.bulkInsert(myLogin, allDtls);
    }

    private List<OrderDtlDto> makeOrderDtlList(OrderDto.OrderInfo order) {
        return order.getDetailinfo().stream().peek(orderDtlDto -> {
            orderDtlDto.setRqindex(order.getRqindex());
            orderDtlDto.setRqtype(order.getRqtype());
            orderDtlDto.setIsupdate(order.getIsupdate());
        }).collect(Collectors.toList());
    }

    private void deleteRepeatedOrder(LoginDto login, List<OrderDto.OrderInfo> orderInfos) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDataBaseName()).transactionDeadLockWrapper(() -> {
            StringBuilder rqCodes = new StringBuilder();
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
            int i = 0;
            while (i < orderInfos.size()) {
                OrderDto.OrderInfo info = (OrderDto.OrderInfo)orderInfos.get(i);
                rqCodes.delete(0, rqCodes.length());
                rqCodes.append("'").append(info.getRqindex()).append("'");
                ++i;
                for (int j = 0; j < 50 && i < orderInfos.size(); ++j, ++i) {
                    OrderDto.OrderInfo info2 = (OrderDto.OrderInfo)orderInfos.get(i);
                    rqCodes.append(",'").append(info2.getRqindex()).append("'");
                }
                jdbcTemplate.execute(" Delete RQTITLE Where RqIndex in (" + rqCodes + ")");
                jdbcTemplate.execute(" Delete RQDETAIL Where RqIndex in (" + rqCodes + ")");
            }
        }, new String[]{"RqTitle", "RqDetail"});
    }

    public synchronized ResponseEntity<?> postSmartHelpPreInvoice(String body) {
        List<Object> invoiceInfo;
        LoginDto myLogin = this.dbConnection.setToken();
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        try {
            body = body.substring(15, body.length() - 1);
            Gson gson = new Gson();
            invoiceInfo = Arrays.asList((Object[])gson.fromJson(body, InvoiceDto.InvoiceInfo[].class));
        }
        catch (Exception ex) {
            TncException e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            if (myLogin.getIsTorfehNegar().booleanValue()) {
                e.putMoreInfo("ErrorMessage", (Object)ex.getMessage());
            }
            failure.add(e.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"PreInvoice", failure, success);
        }
        try {
            this.insertOrDeletePreInvoice(myLogin, invoiceInfo);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.makeErrorWithCause((Throwable)ex));
            return ConvertStr.getMapResponseEntity((String)"PreInvoice", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"PreInvoice", failure, success);
    }

    private void insertOrDeletePreInvoice(LoginDto myLogin, List<InvoiceDto.InvoiceInfo> invoiceInfo) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDataBaseName()).transactionDeadLockWrapper(() -> this.batchInsertPreInvoice(myLogin, invoiceInfo), new String[]{"FBailPre", "ABailPre"});
        }
        catch (Exception ex) {
            this.deleteRepeatedPreInvoice(myLogin, invoiceInfo);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeletePreInvoice(myLogin, invoiceInfo);
            }
            throw ex;
        }
    }

    private void batchInsertPreInvoice(LoginDto myLogin, List<InvoiceDto.InvoiceInfo> invoiceInfo) {
        PreInvoiceBulkInsert preInvInsert = new PreInvoiceBulkInsert(this.dbConnection);
        preInvInsert.bulkInsert(myLogin, invoiceInfo);
        PreInvoiceBulkInsert.PreInvDtlBatchInsert preDtlInsert = new PreInvoiceBulkInsert.PreInvDtlBatchInsert(this.dbConnection);
        ArrayList allDtls = new ArrayList();
        for (InvoiceDto.InvoiceInfo info : invoiceInfo) {
            allDtls.addAll(this.makePreDtlList(info));
        }
        preDtlInsert.bulkInsert(myLogin, allDtls);
    }

    private List<InvoiceDetailDto> makePreDtlList(InvoiceDto.InvoiceInfo invoice) {
        return invoice.getDetailinfo().stream().peek(orderDtlDto -> {
            orderDtlDto.setId(invoice.getId());
            orderDtlDto.setType(invoice.getType());
            orderDtlDto.setIsupdate(invoice.getIsupdate());
        }).collect(Collectors.toList());
    }

    private void deleteRepeatedPreInvoice(LoginDto login, List<InvoiceDto.InvoiceInfo> invoiceInfo) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDataBaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
            int i = 0;
            while (i < invoiceInfo.size()) {
                InvoiceDto.InvoiceInfo info = (InvoiceDto.InvoiceInfo)invoiceInfo.get(i);
                StringBuilder Fac_Code = new StringBuilder("'" + info.getFac_code() + info.getType() + "'");
                ++i;
                for (int j = 0; j < 50 && i < invoiceInfo.size(); ++j, ++i) {
                    InvoiceDto.InvoiceInfo info2 = (InvoiceDto.InvoiceInfo)invoiceInfo.get(i);
                    Fac_Code.append(",'").append(info2.getFac_code()).append(info2.getType()).append("'");
                }
                jdbcTemplate.execute(" Delete FBailPre Where Fac_Code+Fac_Type in (" + Fac_Code + ")");
                jdbcTemplate.execute(" Delete ABailPre Where Fac_Code+Fac_Type in (" + Fac_Code + ")");
            }
        }, new String[]{"FBailPre", "ABailPre"});
    }

    public ResponseEntity<?> editInvoice(List<InvoiceDto.InvoiceInfo> body) throws TncException {
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        if (!login.getIsTorfehNegar().booleanValue()) {
            return ResponseEntity.badRequest().build();
        }
        StringBuilder sb = new StringBuilder();
        for (InvoiceDto.InvoiceInfo invoice : body) {
            List facCodes = jdbcTemplate.queryForList(" SELECT FAC_CODE FROM FACTURE WHERE  FAC_CODE_C = ? AND FAC_TYPE = ?", new Object[]{invoice.getCode(), invoice.getType()});
            if (facCodes.size() != 1) {
                throw new TncException(TncExceptionMessages.DEFAULT_ERROR);
            }
            this.updateInvoiceCustomer(invoice, (JdbcTemplate)jdbcTemplate);
            this.updateDtl((JdbcTemplate)jdbcTemplate, sb, invoice, facCodes);
        }
        return ResponseEntity.ok().build();
    }

    private void updateInvoiceCustomer(InvoiceDto.InvoiceInfo invoice, JdbcTemplate jdbcTemplate) {
        if (ConvertStr.isNullOrEmpty((String)invoice.getCustomerid())) {
            return;
        }
        SqlRowSet rs = jdbcTemplate.queryForRowSet(" SELECT COMMON, SARFASL_NAME FROM SARFASL WHERE SARFASL_CODE = ?", new Object[]{invoice.getCustomerid()});
        if (rs.next()) {
            invoice.setCustid(rs.getString("COMMON"));
            invoice.setCustomername(rs.getString("SARFASL_NAME"));
        }
        String oldCustomerName = "";
        rs = jdbcTemplate.queryForRowSet(" SELECT C_NAME FROM CUSTOMER WHERE C_CODE = (SELECT C_CODE FROM FACTURE WHERE FAC_CODE_C = ? AND FAC_TYPE = ?)", new Object[]{invoice.getCode(), invoice.getType()});
        if (rs.next()) {
            oldCustomerName = rs.getString("C_NAME");
        }
        if (ConvertStr.isNullOrEmpty((String)oldCustomerName)) {
            throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
        }
        jdbcTemplate.update(" UPDATE FACTURE SET C_CODE = ? WHERE FAC_CODE_C = ? AND FAC_TYPE = ?", new Object[]{invoice.getCustid(), invoice.getCode(), invoice.getType()});
        rs = jdbcTemplate.queryForRowSet(" SELECT SANAD_CODE FROM FACTURE WHERE FAC_CODE_C = ? AND FAC_TYPE = ? AND C_CODE = ?", new Object[]{invoice.getCode(), invoice.getType(), invoice.getCustid()});
        if (rs.next()) {
            invoice.setSanadcode(rs.getInt("SANAD_CODE"));
        }
        String colCode = invoice.getCustomerid().substring(0, 3);
        String moeenCode = invoice.getCustomerid().substring(3, 7);
        String tafsiliCode = invoice.getCustomerid().substring(7);
        jdbcTemplate.update(" UPDATE SND_LIST SET COL_CODE = ?, MOIEN_CODE = ?, TAFZILI_CODE = ? WHERE SANAD_CODE = ? AND COL_CODE = '103'", new Object[]{colCode, moeenCode, tafsiliCode, invoice.getSanadcode()});
        jdbcTemplate.update(" UPDATE SND_LIST SET COMMENT_LINE = REPLACE(COMMENT_LINE, ?, ?) WHERE SANAD_CODE = ?", new Object[]{oldCustomerName, invoice.getCustomername(), invoice.getSanadcode()});
    }

    private void updateDtl(JdbcTemplate jdbcTemplate, StringBuilder sb, InvoiceDto.InvoiceInfo invoice, List<Map<String, Object>> facCodes) {
        if (invoice.getDetailinfo() == null) {
            return;
        }
        for (InvoiceDetailDto dtl : invoice.getDetailinfo()) {
            if (dtl.getFew() == null && dtl.getPrice() == null) continue;
            sb.delete(0, sb.length());
            sb.append(" UPDATE FACTART SET ");
            if (dtl.getFew() != null) {
                sb.append(" FEW_ARTICLE= ").append(dtl.getFew()).append(",");
            }
            if (dtl.getPrice() != null) {
                sb.append(" PRICE_BS= ").append(dtl.getPrice());
            }
            sb.append(" WHERE A_CODE ='").append(dtl.getProductid()).append("' AND FAC_CODE = '").append(facCodes.get(0).get("FAC_CODE")).append("'").append(" AND FAC_TYPE = '").append(invoice.getType()).append("'");
            jdbcTemplate.update(sb.toString());
        }
    }

    private /* synthetic */ ProxyInvoiceService lambda$postInvoice$2(LoginDto myLogin) {
        return new ProxyInvoiceService(DbLogin.getInstance((DbConnection)this.dbConnection, (LoginDto)myLogin));
    }
}

