/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.data;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseResponse;
import com.android.settings.data.SettingsDto;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.TncJdbc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class SettingsRepository
extends AndroidRepository<SettingsDto> {
    public SettingsRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    public BaseResponse<Map<String, Object>> customQuery(HttpServletRequest request, Paging paging, LoginDto login) {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        String sql = "SELECT [name], IsNull(CAST([BOOLEAN] AS NVARCHAR(1)), '')+ IsNull(CAST([INTEGER] AS NVARCHAR(50)), '') + IsNull(CAST([DOUBLE] AS NVARCHAR(50)), '') \n+ CAST(IsNull([STRING], '') AS NVARCHAR(4000)) AS [value] FROM MSETUP2 WHERE [NAME] IN ('Darsad_Maliyat','Darsad_Avarez','searchInvoice','editMyInvoice',\n'allowAddParty','editMyParty','allowInvoicePay','allowRejectInvoiceView','allowShowPartyChequeInfo',\n'allowPartyPayment','allowPartyRemain','allowPartyChequeReamin','allowPartyChequeReturn',\n'allowInvoicePayType','allowPeruseInvoiceView','IsUseMap','IsPartySignature',\n'searchSettlement','IsCheckArticleCount','allowRecieveArticle','searchRecieveArticle',\n'allowRecieveCalcInfo','allowPartyMoein','NotAllowShowTakhfifVisitor','allowSendParty',\n'IsKitChangeTakhfif','IsKitPriceType','IsUseUnit','IsCalcByUnit','IsUnitSellPrice',\n'IsPartyPrice','IsSearchArtGroup','IsSearchArtSubGroup','PriceChangeByUserSell',\n'PriceChangeByUserBuy','PriceChangeByUserRetSell','FreeCodeForCustomer','M_BedCustomerMoienTaf',\n'M_BesCustomerMoienTaf','IsPartyGroup','IsAlarmEtebar','allowNegativeFact','IsGiftKit',\n'IsRepeatArt','IsRepeatArtAdd','CalcExistInReq','ArticleHasTax','isKitShoes',\n'allowShowArticleStock','IsGetGps','IsadminGps','SaveFactListSiah','IsModdatTasvieh',\n'MiddleManCode','ResHasCutomPrint','ResPrintConfigType','atrTitle1','atrTitle2',\n'atrTitle3','atrTitle4','atrTitle5','atrTitle6','atrTitle7','atrTitle8','atrTitle9',\n'atrTitle10','aPartyMaxCode','Serial', 'Res_RoundTakhfifLow', 'Res_RoundTakhfif')";
        List result = jdbcTemplate.queryForList(sql);
        Map userRelatedSettings = jdbcTemplate.queryForMap(" SELECT isNull(RMDroidChangPrice, 'false') Ischangprice\n FROM UserDb WHERE UserCodeInc = ?", new Object[]{login.getUserCodeInc()});
        result.add(this.makeSettingMap("Ischangprice", (Object)ConvertStr.boolStrToInt((String)userRelatedSettings.remove("Ischangprice").toString())));
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        result.add(this.makeSettingMap("DBPnlOrderPriceTakhfif", (Object)settingLoader.isUsePerRowDiscountPrice()));
        result.add(this.makeSettingMap("DBPnlOrderDarsadTakhfif", (Object)settingLoader.isUsePerRowDiscountPercent()));
        result.add(this.makeSettingMap("IsCalcVat", (Object)settingLoader.isCalcVatK()));
        result.add(this.makeSettingMap("IsCalcVat_J", (Object)settingLoader.isCalcVatJ()));
        result.add(this.makeSettingMap("IsVatFactureAvarez_F", (Object)settingLoader.isVatInvoiceScotSell()));
        result.add(this.makeSettingMap("IsVatFactureMaliyat_F", (Object)settingLoader.isVatInvoiceLevySell()));
        result.add(this.makeSettingMap("IsVatFactureAvarez_K", (Object)settingLoader.isVATInvoiceScotBuy()));
        result.add(this.makeSettingMap("IsVatFactureMaliyat_K", (Object)settingLoader.isVATInvoiceLevyBuy()));
        result.add(this.makeSettingMap("showInvoicePayment", (Object)settingLoader.showInvoicePayment()));
        return new BaseResponse.Builder().data(result).build();
    }

    private Map<String, Object> makeSettingMap(String aName, Object aValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", aName);
        map.put("value", aValue);
        return map;
    }
}

