/*
 * Decompiled with CFR 0.152.
 */
package com.android.res_invoice.data.repo;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseError;
import com.android.core.domain.model.BaseResponse;
import com.android.core.utils.params.AndroidFilter;
import com.android.core.utils.params.QueryParamTypes;
import com.android.res_invoice.domain.model.AResInvoiceDtlDto;
import com.android.res_invoice.domain.model.AResInvoiceDto;
import com.dao.SarfaslDao;
import com.dao.restaurant.ResTableDao;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.service.invoice.CheckPayError;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.utility.TncLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class ResInvoiceRepository
extends AndroidRepository<AResInvoiceDto> {
    public ResInvoiceRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    public BaseResponse<Map<String, Object>> customQuery(HttpServletRequest request, Paging paging, LoginDto login) {
        String whereStr = new AndroidFilter(request, QueryParamTypes.RES_INVOICE).getFilter();
        if (!whereStr.isEmpty()) {
            whereStr = " AND " + whereStr;
        }
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        boolean isActiveMenu = settingLoader.isSendActiveResMenuProducts();
        String sql = " SELECT rf.F_Code AS id, rf.C_Code AS partyCode, Desk_Name AS tableName, rf.F_Code_C AS code, \n CONVERT(NVARCHAR(50), rf.F_Date, 120) AS invoiceDate, 1 AS stockInfluence, \n rf.F_Comment AS description, IsNull(rf.F_SumPrice, 0) AS finalPrice, rf.F_Code AS serverId, \n" + settingLoader.getPrintConfigType() + " printConfigType, rf.Alias_Name as aliasName, \n ALIAS_MOBILE aliasMobile, u.Name AS [owner], rf.F_Takhfif serverDiscountPrice, \n F_NAGHD cashAmount, F_NESIEH creditAmount, F_Pos posAmount \n FROM Res_Facture rf \n INNER JOIN USERDB u ON rf.UserCode = u.UserCodeInc \n WHERE rf.Fac_Type = 'R' AND rf.F_Type = 1 \n AND rf.FType_KF = 'F' AND IsNull(u.Res_SaveSpdSel, 0) = 0 \n" + whereStr + " ORDER BY rf.F_Code";
        List invoices = jdbcTemplate.queryForList(sql);
        String productGroupCode = isActiveMenu ? "Ra.A_Type" : "(S.M_groupcode+S.S_groupcode)";
        String joinGroupOrMenu = isActiveMenu ? " INNER JOIN (SELECT DISTINCT A_Code, Max(A_Type) AS A_Type \n FROM Res_MenuArt GROUP BY A_Code) Ra ON Ra.A_Code = rfl.A_Code \n" : " INNER JOIN M_Group M ON SubString(rfl.A_Code, 1, 2) = M.M_GroupCode \n INNER JOIN S_Group S ON M.M_GroupCode = S.M_GroupCode AND \n SubString(rfl.A_Code, 3, 2) = S.S_GroupCode";
        sql = "SELECT rfl.A_Code AS productId, " + productGroupCode + " AS productGroupCode, rfl.F_Code AS invoiceId, \n Isnull(rfl.FL_Few,0) AS amount, IsNull(rfl.FL_Price, 0) AS price, \n rfl.Fl_Inc_Index AS serverId, rfl.FL_Comment as description, rfl.Art_OuterOrd as takeOut, \n rfl.Darsad_takhfif discountPercent, rfl.takhfifSatriR discountPrice \n FROM Res_Fac_List rfl \n INNER JOIN Res_Facture rf ON rf.F_Code = rfl.F_Code \n INNER JOIN USERDB u ON rf.UserCode = u.UserCodeInc \n" + joinGroupOrMenu + " WHERE (rf.FType_KF = 'F') AND (IsNull(u.Res_SaveSpdSel, 0) = 0) \n AND (rf.Fac_Type = 'R') AND (rf.F_Type = 1) \n" + whereStr + " \n order by rfl.F_Code, rfl.FL_Index ";
        List details = jdbcTemplate.queryForList(sql);
        invoices.forEach(invoice -> {
            List list = details.stream().filter(map -> map.get("invoiceId").equals(invoice.get("id"))).collect(Collectors.toList());
            invoice.put("detailInfo", list);
        });
        return new BaseResponse.Builder().data(invoices).build();
    }

    protected BaseResponse<Map<String, Object>> insert(@NotNull AResInvoiceDto resInvoice, LoginDto login, TransactionStatus status) throws TncException {
        BaseResponse.Builder response = new BaseResponse.Builder();
        ArrayList myProduct = new ArrayList();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        resInvoice.setType(1);
        if (resInvoice.isRetail()) {
            resInvoice.setCustomerCode(ConvertStr.decrypt((String)resInvoice.getCustomerCode()));
            if (ConvertStr.isNullOrEmpty((String)resInvoice.getCustomerCode()) || this.customerNotExists(resInvoice.getCustomerCode(), jdbcTemplate)) {
                throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
            }
        } else {
            String defaultCustomer = settingLoader.getDefaultCustomer();
            if (defaultCustomer != null) {
                resInvoice.setCustomerCode(defaultCustomer);
            }
        }
        resInvoice.setServiceCommission(settingLoader.getServicePercent());
        try {
            this.checkForErrorsInResInvoice(jdbcTemplate, resInvoice);
            resInvoice.setCode(this.nextFCodeC(jdbcTemplate, resInvoice.getFacType()));
            String[] dateTime = resInvoice.getInvoiceDate().split(" ");
            if (!ConvertStr.isNullOrEmpty((String)dateTime[1]) && dateTime[1].length() > 5) {
                dateTime[1] = dateTime[1].substring(0, 5);
            }
            String sqlStr = "INSERT INTO RES_FACTURE (F_TYPE, F_CODE_C, F_DATE, F_TIME, DESK_NAME, C_CODE, Alias_Name, F_COMMENT, USERCODE, F_NAGHD, F_POS, POS_CODE, FAC_TYPE, DARSADSERVICE, MONEY_CODE, MONEY_PRICE,ALIAS_MOBILE, BON_PRICE, BON_NO, C_CODE_PEIK, OUTER_ORD, ExporterSId, TasviehDate, F_TAKHFIF,HlpFieldL) VALUES(" + resInvoice.getType() + "," + resInvoice.getCode() + ",'" + dateTime[0] + "','" + dateTime[1] + "','" + resInvoice.getTableName() + "','" + resInvoice.getCustomerCode() + "'," + ConvertStr.getNullableStrSqlField((String)resInvoice.getAliasName()) + "," + ConvertStr.getNullableStrSqlField((String)resInvoice.getDescription()) + ",'" + login.getUserCodeInc() + "'," + resInvoice.getCashAmount() + "," + resInvoice.getPosAmount() + "," + ConvertStr.getNullableStrSqlField((String)resInvoice.getPosHeading()) + ",'" + resInvoice.getFacType() + "'," + resInvoice.getServiceCommission() + ", 1, 1, " + ConvertStr.getNullableStrSqlField((String)resInvoice.getAliasMobile()) + "," + resInvoice.getCouponPrice() + "," + ConvertStr.getNullableStrSqlField((String)resInvoice.getCouponNumber()) + ", '00000', 0, " + resInvoice.getId() + ", " + resInvoice.getSettleDate() + ", " + resInvoice.getServerDiscountPrice() + ", 1)";
            jdbcTemplate.execute(sqlStr);
            SqlRowSet rs = jdbcTemplate.queryForRowSet(" SELECT SCOPE_IDENTITY() InvoiceID ");
            resInvoice.setId(Long.valueOf(0L));
            while (rs.next()) {
                resInvoice.setId(Long.valueOf(rs.getLong("InvoiceID")));
            }
            if (resInvoice.getId() <= 0L) {
                throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            }
            for (int i = 0; i < resInvoice.getDetailInfo().size(); ++i) {
                AResInvoiceDtlDto dtl = (AResInvoiceDtlDto)resInvoice.getDetailInfo().get(i);
                this.checkForErrorsInResDtl(dtl, jdbcTemplate, myProduct, settingLoader);
                this.handleDtlCommonParts(dtl, (JdbcTemplate)jdbcTemplate, settingLoader);
                this.addToDiscount(resInvoice, dtl);
                sqlStr = "INSERT INTO RES_FAC_LIST(F_CODE, FL_INDEX, A_CODE, FL_FEW, FL_PRICE, FL_COMMENT, LEVY, SCOT, DARSAD_TAKHFIF, TAKHFIFSATRIR, DARSAD_TYPE, ART_OUTERORD, SUMTAKHFIFSATRI_P, MinA_Name, Buy_Price) VALUES(" + resInvoice.getId() + "," + (i + 1) + ",'" + dtl.getProductId() + "'," + dtl.getAmount() + "," + dtl.getPrice() + ",'" + dtl.getDescription() + "'," + dtl.getLevy() + "," + dtl.getScot() + "," + ConvertStr.getNonNull((Double)dtl.getDiscountPercent()) + "," + ConvertStr.getNonNull((Double)dtl.getDiscountPrice()) + ", " + ConvertStr.getBoolToInt((Boolean)(!settingLoader.useRialDiscountPercent() ? 1 : 0)) + ", " + ConvertStr.getBoolToInt((Boolean)dtl.getTakeOut()) + ", 0, '" + dtl.getProductName() + "', " + dtl.getBuyPrice() + ")";
                jdbcTemplate.execute(sqlStr);
            }
            if (!resInvoice.isRetail()) {
                sqlStr = "INSERT INTO RMTEMPFACTURE(FACTID, DESKTITLE, FACTSTYLE, FCACTIONMODE, PRINTCONFIGTYPE, OLDDESKTITLE) VALUES (" + resInvoice.getId() + ", '" + resInvoice.getTableName() + "', 1 , 1, " + resInvoice.getPrintConfigType() + ", '')";
                jdbcTemplate.execute(sqlStr);
            }
            int kindVAT = this.handleCommonFactureParts(resInvoice, settingLoader);
            sqlStr = "UPDATE RES_FACTURE SET SUM_LEVY = ?, SUM_SCOT= ?, F_SUMPRICE = ?, ISLEVYANDSCOT = ?, kind_Vat = ?, F_TAKHFIF = ?  WHERE F_CODE = ? AND FType_KF = 'F' and Fac_Type = ?";
            jdbcTemplate.update(sqlStr, new Object[]{resInvoice.getLevy(), resInvoice.getScot(), resInvoice.getSumPrice(), resInvoice.getLevy() + resInvoice.getScot() > 0.0 ? 1 : 0, kindVAT, resInvoice.getServerDiscountPrice(), resInvoice.getId(), resInvoice.getFacType()});
            return response.data((Object)this.makeSuccessMap(resInvoice)).build();
        }
        catch (Throwable t) {
            status.setRollbackOnly();
            return response.withError(this.buildError(resInvoice, t)).build();
        }
    }

    private void addToDiscount(@NotNull AResInvoiceDto resInvoice, AResInvoiceDtlDto dtl) {
        if (resInvoice.isRetail()) {
            resInvoice.setServerDiscountPrice(resInvoice.getServerDiscountPrice() + this.calculateDiscount(dtl));
        }
    }

    private double calculateDiscount(@NotNull AResInvoiceDtlDto dtl) {
        double sum = dtl.getPrice() * dtl.getAmount();
        return !ConvertStr.isNullOrZero((Double)dtl.getDiscountPercent()) ? sum * dtl.getDiscountPercent() / 100.0 : dtl.getDiscountPrice();
    }

    private boolean customerNotExists(String customerCode, @NotNull TncJdbc jdbcTemplate) {
        SqlRowSet rs = jdbcTemplate.queryForRowSet("SELECT COUNT(*) cnt FROM CUSTOMER WHERE C_CODE = ?", new Object[]{customerCode});
        return !rs.next() || rs.getInt("cnt") == 0;
    }

    private void deleteRmTempForInvoice(@NotNull AResInvoiceDto resInvoice, @NotNull TncJdbc jdbcTemplate) {
        jdbcTemplate.execute("DELETE FROM RmTempFacture  WHERE FactId = " + resInvoice.getId());
        jdbcTemplate.execute("DELETE RMTempFactureDetail WHERE FactId = " + resInvoice.getId());
    }

    @NotNull
    private Map<String, Object> makeSuccessMap(@NotNull AResInvoiceDto resInvoice, ResTableDao.ActionMode actionMode) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        if (resInvoice.getId() != null) {
            model.put("id", resInvoice.getId());
        }
        if (resInvoice.getCode() != 0L) {
            model.put("code", resInvoice.getCode());
        }
        if (actionMode != null) {
            model.put("message", actionMode.getMessage());
        }
        return model;
    }

    @NotNull
    private Map<String, Object> makeSuccessMap(@NotNull AResInvoiceDto resInvoice) {
        return this.makeSuccessMap(resInvoice, null);
    }

    @NotNull
    private TncException toTncException(Throwable t) {
        TncException e = t instanceof TncException ? (TncException)t : new TncException(TncExceptionMessages.DEFAULT_ERROR);
        return e;
    }

    private int handleCommonFactureParts(@NotNull AResInvoiceDto resInvoice, @NotNull SettingLoader settingLoader) {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(settingLoader.getLogin());
        int kindVat = settingLoader.getKindVAT();
        String sqlStr = "SELECT ROUND(SUM(FL_FEW * FL_PRICE), 0) SUM_PRICE FROM RES_FAC_LIST WHERE F_CODE= ?";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getId()});
        while (rs.next()) {
            resInvoice.setSumPrice(rs.getDouble("SUM_PRICE"));
        }
        resInvoice.setServiceCost((double)Math.round(resInvoice.getSumPrice() * resInvoice.getServiceCommission() / 100.0));
        if (kindVat == 0) {
            sqlStr = " DECLARE @discount FLOAT \n SET @discount = (SELECT F_TAKHFIF FROM Res_Facture WHERE F_Code = " + resInvoice.getId() + ") \n SELECT ROUND(SUM(((FL_FEW * FL_PRICE) - @discount)  * LEVY) / 100, 0) SUM_LEVY, \n ROUND(SUM(((FL_FEW * FL_PRICE) - @discount) * SCOT) / 100, 0) SUM_SCOT \n FROM RES_FAC_LIST \n WHERE F_CODE='" + resInvoice.getId() + "'";
            Map sumScotLevyMap = jdbcTemplate.queryForMap(sqlStr);
            resInvoice.setLevy(((Double)sumScotLevyMap.get("SUM_LEVY")).doubleValue());
            resInvoice.setScot(((Double)sumScotLevyMap.get("SUM_SCOT")).doubleValue());
        } else if (kindVat == 1) {
            resInvoice.setLevy((double)Math.round((resInvoice.getSumPrice() - resInvoice.getServerDiscountPrice()) * settingLoader.getLevyPercent() / 100.0));
            resInvoice.setScot((double)Math.round((resInvoice.getSumPrice() - resInvoice.getServerDiscountPrice()) * settingLoader.getScotPercent() / 100.0));
        }
        if (!resInvoice.isRetail()) {
            sqlStr = "UPDATE RES_DESK SET DESK_OPEN = 1 WHERE [ID] = " + resInvoice.getTableId();
            jdbcTemplate.execute(sqlStr);
            double sumWithTax = resInvoice.getSumPrice() + resInvoice.getLevy() + resInvoice.getScot();
            double finalRawPrice = sumWithTax - resInvoice.getServerDiscountPrice();
            double roundedRemains = finalRawPrice - resInvoice.getFinalPrice();
            resInvoice.setServerDiscountPrice(resInvoice.getServerDiscountPrice() + roundedRemains);
        }
        if (!resInvoice.hasNoPaymentData() && this.unevenPayment(resInvoice)) {
            throw new TncException(TncExceptionMessages.UNEVEN_PAY_AND_TO_PAY_PRICES);
        }
        return kindVat;
    }

    private boolean unevenPayment(@NotNull AResInvoiceDto resInvoice) {
        return resInvoice.getSumPrice() + resInvoice.getScot() + resInvoice.getLevy() - resInvoice.getServerDiscountPrice() != resInvoice.getPosAmount() + resInvoice.getCashAmount() + resInvoice.getCreditAmount() + resInvoice.getCouponPrice();
    }

    private void handleDtlCommonParts(@NotNull AResInvoiceDtlDto dtl, JdbcTemplate jdbcTemplate, SettingLoader settingLoader) {
        boolean isCalcVatJ;
        dtl.setProductCode("");
        dtl.setProductName("");
        dtl.setBuyPrice(Double.valueOf(0.0));
        if (dtl.getLevy() == null) {
            dtl.setLevy(Double.valueOf(0.0));
        }
        if (dtl.getScot() == null) {
            dtl.setScot(Double.valueOf(0.0));
        }
        String levy = (isCalcVatJ = settingLoader.isCalcVatJ()) ? " ISNULL(LEVY, 0) " : String.valueOf(settingLoader.getLevyPercent());
        String scot = isCalcVatJ ? " ISNULL(SCOT, 0) " : String.valueOf(settingLoader.getScotPercent());
        String sqlStr = "SELECT A_CODE_C, A_NAME, ISNULL(BUY_PRICE, 0) BUY_PRICE, " + levy + " LEVY, \n IsNull(DarsadTakhfif, 0) DiscountPercent, IsNull(PriceTakhfif, 0) DiscountPrice, \n" + scot + " SCOT, ISNULL(INCLUDE_TAX, 0) INCLUDE_TAX FROM ARTICLE\n WHERE A_CODE='" + dtl.getProductId() + "'";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            boolean includeTax;
            if (rs.getString("A_CODE_C") != null) {
                dtl.setProductCode(rs.getString("A_CODE_C"));
            }
            if (rs.getString("A_NAME") != null) {
                dtl.setProductName(rs.getString("A_NAME"));
            }
            dtl.setBuyPrice(Double.valueOf(rs.getDouble("BUY_PRICE")));
            boolean bl = includeTax = !isCalcVatJ || rs.getBoolean("INCLUDE_TAX");
            if (includeTax && dtl.getLevy() == 0.0 && dtl.getScot() == 0.0) {
                dtl.setLevy(Double.valueOf(rs.getDouble("LEVY")));
                dtl.setScot(Double.valueOf(rs.getDouble("SCOT")));
            }
            if (ConvertStr.isNullOrZero((Double)dtl.getDiscountPercent())) {
                dtl.setDiscountPercent(Double.valueOf(rs.getDouble("DiscountPercent")));
            }
            if (!ConvertStr.isNullOrZero((Double)dtl.getDiscountPrice())) continue;
            dtl.setDiscountPrice(Double.valueOf(rs.getDouble("DiscountPrice")));
        }
        sqlStr = "Update Article Set Exist = Exist - " + dtl.getAmount() + ", Exist_Mandeh = Exist_Mandeh - " + dtl.getAmount() + " Where A_Code = '" + dtl.getProductId() + "'";
        jdbcTemplate.execute(sqlStr);
    }

    private void checkForErrorsInResDtl(@NotNull AResInvoiceDtlDto dtl, TncJdbc jdbcTemplate, List<Map<String, Object>> myProduct, SettingLoader settingLoader) throws TncException {
        if (dtl.getProductId() == null) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        String sqlStr = "Select Count(*) cnt From Article where A_Code='" + dtl.getProductId() + "'";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        if (rs.next() && rs.getInt("cnt") == 0) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        if (dtl.getAmount() == null || dtl.getAmount() <= 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
        }
        if (dtl.getPrice() == null) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_PRICE);
        }
        if (dtl.getLevy() != null && dtl.getLevy() < 0.0 || dtl.getScot() != null && dtl.getScot() < 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_LEVY_SCOT);
        }
        if (!settingLoader.isUsePerRowDiscountPercent() || dtl.getDiscountPercent() == null) {
            dtl.setDiscountPercent(Double.valueOf(0.0));
        }
        if (!settingLoader.isDiscountEnabled() || dtl.getDiscountPrice() == null) {
            dtl.setDiscountPrice(Double.valueOf(0.0));
        }
        double existingAmount = 0.0;
        if (!settingLoader.getLogin().isAndroid() && settingLoader.mustHaveStore()) {
            sqlStr = "Select Exist from W_ShowArticleForSearch_Big where A_Code = ?";
            rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{dtl.getProductId()});
            while (rs.next()) {
                existingAmount = rs.getDouble("Exist");
            }
            if (dtl.getAmount() > existingAmount) {
                LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
                model.put("productId", dtl.getProductId());
                model.put("amount", existingAmount);
                myProduct.add(model);
                throw new TncException(TncExceptionMessages.BELOW_PRODUCTS_HAVE_NO_STORE);
            }
        }
    }

    private void checkForErrorsInResInvoice(TncJdbc jdbcTemplate, @NotNull AResInvoiceDto resInvoice) throws TncException {
        if (!resInvoice.isRetail()) {
            if (resInvoice.getTableId() <= 0) {
                throw new TncException(TncExceptionMessages.INVALID_TABLE_NUMBER);
            }
            SqlRowSet rs = jdbcTemplate.queryForRowSet("SELECT COUNT(*) cnt FROM RES_DESK WHERE [ID]=" + resInvoice.getTableId());
            if (rs.next() && rs.getInt("CNT") == 0) {
                throw new TncException(TncExceptionMessages.INVALID_TABLE_NUMBER);
            }
            rs = jdbcTemplate.queryForRowSet("SELECT DESK_NAME FROM RES_DESK WHERE [ID]=" + resInvoice.getTableId());
            if (rs.next()) {
                resInvoice.setTableName(rs.getString("DESK_NAME"));
            }
            if ((rs = jdbcTemplate.queryForRowSet(" SELECT COUNT(*) cnt FROM RES_FACTURE WHERE F_TYPE = '1'\n AND FType_KF = 'F' and Fac_Type = ? AND IsNull(DESK_NAME, '') = ?", new Object[]{resInvoice.getFacType(), resInvoice.getTableName()})).next() && rs.getInt("cnt") > 0) {
                throw new TncException(TncExceptionMessages.SELECTED_TABLE_OCCUPIED);
            }
        }
        if (resInvoice.getType() < 1 || resInvoice.getType() > 2) {
            throw new TncException(TncExceptionMessages.INVALID_INVOICE_TYPE);
        }
        if (resInvoice.getInvoiceDate() == null || ConvertStr.parseDate((String)resInvoice.getInvoiceDate()) == null) {
            throw new TncException(TncExceptionMessages.INVALID_DATE);
        }
        this.checkPayments(resInvoice, jdbcTemplate.getLogin());
    }

    private void checkPayments(@NotNull AResInvoiceDto resInvoice, LoginDto login) throws TncException {
        if (resInvoice.hasNoPaymentData()) {
            return;
        }
        new CheckPayError(this.dbConnection, new SarfaslDao(this.dbConnection)).checkAll(CheckPayError.PaymentData.builder().cash(resInvoice.getCashAmount()).cashHeading(resInvoice.getCashHeading()).checkCashHeading(resInvoice.isRetail()).pos(resInvoice.getPosAmount()).posHeading(resInvoice.getPosHeading()).credit(resInvoice.getCreditAmount()).discount(resInvoice.getDiscount()).coupon(resInvoice.getCouponPrice()).couponNumber(resInvoice.getCouponNumber()).build(), login);
    }

    private BaseError buildError(@NotNull AResInvoiceDto resInvoice, Throwable mainException) {
        TncException e = this.toTncException(mainException);
        if (resInvoice.getCode() > 0L) {
            e.putMoreInfo("id", (Object)resInvoice.getCode());
        }
        if (!resInvoice.isRetail()) {
            e.putMoreInfo("errorDetail", (Object)("MESSAGE = " + mainException.getMessage() + " CAUSE = " + mainException.getCause()));
        }
        return e.makeAndroidError();
    }

    public BaseResponse<Map<String, Object>> editResInvoice(AResInvoiceDto resInvoice, LoginDto myLogin) {
        return (BaseResponse)this.dbConnection.getTransactionTemplate(myLogin).execute(status -> this.internalEditResInvoice(resInvoice, myLogin, status));
    }

    private BaseResponse<Map<String, Object>> internalEditResInvoice(AResInvoiceDto resInvoice, LoginDto myLogin, TransactionStatus status) {
        BaseResponse.Builder response = new BaseResponse.Builder();
        ArrayList myProduct = new ArrayList();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, myLogin);
        Object savePoint = null;
        try {
            AResInvoiceDtlDto dtl;
            savePoint = status.createSavepoint();
            resInvoice.setId(resInvoice.getServerId());
            this.checkInvoiceEditErrors(jdbcTemplate, resInvoice);
            String sqlStr = "SELECT F_CODE_C, DESK_NAME FROM RES_FACTURE WHERE FType_KF = 'F' and Fac_Type = ? AND F_CODE = ?";
            SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getFacType(), resInvoice.getId()});
            while (rs.next()) {
                resInvoice.setCode((long)rs.getInt("F_CODE_C"));
                resInvoice.setTableName(rs.getString("DESK_NAME"));
            }
            ConcurrentHashMap oldDtls = this.fetchOldDtls(resInvoice, jdbcTemplate);
            for (AResInvoiceDtlDto dtl2 : resInvoice.getDetailInfo()) {
                long clientSentId = dtl2.getId() == null ? -1L : dtl2.getId();
                dtl2.setEdited(this.isDtlEdited(dtl2, (Map)oldDtls));
                dtl2.setOldAmount(this.getOldAmount((AResInvoiceDtlDto)oldDtls.get(clientSentId)));
                dtl2.setNewlyInserted(dtl2.getId() == null);
            }
            boolean someArticlesAreDeleted = oldDtls.size() > resInvoice.getDetailInfo().size();
            sqlStr = "DELETE FROM RES_FAC_LIST WHERE F_CODE = " + resInvoice.getId();
            jdbcTemplate.execute(sqlStr);
            String whereStr = "(SELECT TOP 1 [ID] FROM RMTempFacture WHERE FactID=" + resInvoice.getId() + " AND FactStyle = 1)";
            String deleteTmpDtlStr = " DELETE FROM RMTempFactureDetail WHERE RMTempFactureID=" + whereStr;
            String deleteTmpStr = " DELETE FROM RMTempFacture WHERE FactID=" + resInvoice.getId() + " AND FactStyle = 1";
            sqlStr = deleteTmpDtlStr + " \n " + deleteTmpStr;
            jdbcTemplate.execute(sqlStr);
            boolean shouldMakeTempFact = false;
            Iterator iterator = resInvoice.getDetailInfo().iterator();
            while (iterator.hasNext() && !(shouldMakeTempFact = (dtl = (AResInvoiceDtlDto)iterator.next()).isEdited() || dtl.isNewlyInserted() || someArticlesAreDeleted || resInvoice.hasNoPaymentData())) {
            }
            long tmpId = -1L;
            sqlStr = "INSERT INTO RMTempFacture(FactID, DeskTitle, FactStyle, FCActionMode, PrintConfigType, OldDeskTitle) VALUES (" + resInvoice.getId() + ", '" + resInvoice.getTableName() + "', 1, 3, " + resInvoice.getPrintConfigType() + ", '')";
            jdbcTemplate.execute(sqlStr);
            sqlStr = "SELECT [ID] FROM RMTempFacture WHERE FactId = " + resInvoice.getId() + " AND FactStyle = 1";
            rs = jdbcTemplate.queryForRowSet(sqlStr);
            if (rs.next()) {
                tmpId = rs.getLong("ID");
            }
            int flIndex = 1;
            for (AResInvoiceDtlDto dtl3 : resInvoice.getDetailInfo()) {
                this.checkForErrorsInResDtl(dtl3, jdbcTemplate, myProduct, settingLoader);
                this.handleDtlCommonParts(dtl3, (JdbcTemplate)jdbcTemplate, settingLoader);
                sqlStr = "INSERT INTO RES_FAC_LIST(F_CODE, FL_INDEX, A_CODE, FL_FEW, FL_PRICE, FL_COMMENT, LEVY, SCOT, DARSAD_TAKHFIF, TakhfifSatriR, DARSAD_TYPE, ART_OUTERORD, SUMTAKHFIFSATRI_P, MinA_Name, Buy_Price, SelPriceID) VALUES(" + resInvoice.getId() + ", " + flIndex++ + ", '" + dtl3.getProductId() + "'," + dtl3.getAmount() + "," + dtl3.getPrice() + ",'" + dtl3.getDescription() + "'," + dtl3.getLevy() + "," + dtl3.getScot() + "," + ConvertStr.nullSafeDouble((Double)dtl3.getDiscountPercent()) + "," + ConvertStr.nullSafeDouble((Double)dtl3.getDiscountPrice()) + ", " + ConvertStr.getBoolToInt((Boolean)(!settingLoader.useRialDiscountPercent() ? 1 : 0)) + ", " + ConvertStr.getBoolToInt((Boolean)dtl3.getTakeOut()) + ", 0, '" + dtl3.getProductName() + "', " + dtl3.getBuyPrice() + ", 0)";
                jdbcTemplate.execute(sqlStr);
                rs = jdbcTemplate.queryForRowSet(" Select SCOPE_IDENTITY() fl_inc ");
                if (!rs.next()) continue;
                dtl3.setNewId(Long.valueOf(rs.getLong("fl_inc")));
            }
            if (shouldMakeTempFact && tmpId != -1L) {
                StringBuilder sb = new StringBuilder("INSERT INTO RMTempFactureDetail (RMTempFactureId, OldAmount, FCDetailId, RowStatus, A_CODE, FL_PRICE, FactID, FactStyle) VALUES");
                List changedDtlList = this.findChangedDtlRows(resInvoice.getDetailInfo(), (Map)oldDtls);
                for (AResInvoiceDtlDto dtl4 : changedDtlList) {
                    sb.append("(").append(tmpId).append(",").append(dtl4.getOldAmount() == 0.0 ? dtl4.getAmount().doubleValue() : dtl4.getOldAmount()).append(",").append(dtl4.getNewId()).append(",'").append(this.calculateRowStatus(dtl4)).append("','").append(dtl4.getProductId()).append("',").append(dtl4.getPrice()).append(",").append(resInvoice.getId()).append(", 1),");
                }
                if (!changedDtlList.isEmpty()) {
                    jdbcTemplate.execute(ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)sb, (String)",").toString());
                }
                jdbcTemplate.update("UPDATE RMTempFacture SET FCActionMode =\n(CASE WHEN (SELECT COUNT(RowStatus)\nFROM RMTempFactureDetail\nWHERE RMTempFactureId = ? AND (RowStatus = 1 OR RowStatus = 0)) = 0\nTHEN '2' ELSE '3' END) WHERE FactId = ?", new Object[]{tmpId, resInvoice.getId()});
            }
            int kindVat = this.handleCommonFactureParts(resInvoice, settingLoader);
            if (settingLoader.isDiscountEnabled()) {
                rs = jdbcTemplate.queryForRowSet(" SELECT SUM(ISNULL(TakhfifSatriR , 0)) PerRowDiscountR, SUM((FL_FEW * FL_PRICE * ISNULL(DARSAD_TAKHFIF , 0)) / 100) DiscountPercent FROM RES_FAC_LIST WHERE F_CODE='" + resInvoice.getId() + "'");
                double discountSatriR = 0.0;
                while (rs.next()) {
                    if (rs.getDouble("PerRowDiscountR") > 0.0) {
                        discountSatriR = rs.getDouble("PerRowDiscountR");
                        continue;
                    }
                    discountSatriR = rs.getDouble("DiscountPercent");
                }
                resInvoice.setDiscount(discountSatriR);
            }
            if (resInvoice.getDescription() == null) {
                resInvoice.setDescription("");
            }
            if (resInvoice.getPosHeading() == null) {
                resInvoice.setPosHeading("");
            }
            sqlStr = " UPDATE RES_FACTURE SET  SUM_LEVY = " + resInvoice.getLevy() + ", SUM_SCOT = " + resInvoice.getScot() + ", F_NAGHD = " + resInvoice.getCashAmount() + ", F_NESIEH = " + resInvoice.getCreditAmount() + ", F_TAKHFIF = " + resInvoice.getServerDiscountPrice() + ", F_POS = " + resInvoice.getPosAmount() + ", POS_CODE = " + ConvertStr.getNullableStrSqlField((String)resInvoice.getPosHeading()) + ", F_SERVICE = " + resInvoice.getServiceCost() + ", F_SUMPRICE = " + resInvoice.getSumPrice() + ", F_COMMENT = '" + resInvoice.getDescription() + "', KIND_VAT = '" + kindVat + "', DARSADSERVICE = " + resInvoice.getServiceCommission() + ", ISLEVYANDSCOT = " + (resInvoice.getLevy() + resInvoice.getScot() > 0.0 ? 1 : 0) + ", ALIAS_NAME = " + ConvertStr.getNullableStrSqlField((String)resInvoice.getAliasName()) + ", ALIAS_MOBILE = " + ConvertStr.getNullableStrSqlField((String)resInvoice.getAliasMobile()) + ", TasviehDate = " + resInvoice.getSettleDate() + ", UserCode = " + myLogin.getUserCodeInc() + " WHERE F_CODE = ? AND FType_KF = 'F' AND Fac_Type = ? ";
            jdbcTemplate.update(sqlStr, new Object[]{resInvoice.getId(), resInvoice.getFacType()});
            response.data((Object)this.makeSuccessMap(resInvoice));
        }
        catch (Throwable t) {
            assert (savePoint != null);
            status.rollbackToSavepoint(savePoint);
            response.withError(this.buildError(resInvoice, t));
        }
        return response.build();
    }

    @NotNull
    private ConcurrentHashMap<Long, AResInvoiceDtlDto> fetchOldDtls(@NotNull AResInvoiceDto resInvoice, @NotNull TncJdbc jdbcTemplate) {
        ConcurrentHashMap<Long, AResInvoiceDtlDto> oldDtls = new ConcurrentHashMap<Long, AResInvoiceDtlDto>();
        String sqlStr = "SELECT A_CODE, FL_INC_INDEX, FL_FEW, FL_PRICE, FL_COMMENT, LEVY, SCOT, DARSAD_TAKHFIF, TakhfifSatriR, ART_OuterOrd FROM RES_FAC_LIST WHERE F_CODE=" + resInvoice.getId();
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            double oldFew = rs.getDouble("FL_FEW");
            String oldArtCode = rs.getString("A_CODE");
            oldDtls.put(rs.getLong("FL_INC_INDEX"), AResInvoiceDtlDto.builder().productId(oldArtCode).id(Long.valueOf(rs.getLong("FL_INC_INDEX"))).amount(Double.valueOf(rs.getDouble("FL_FEW"))).price(Double.valueOf(rs.getDouble("FL_PRICE"))).description(rs.getString("FL_COMMENT")).levy(Double.valueOf(rs.getDouble("LEVY"))).scot(Double.valueOf(rs.getDouble("SCOT"))).discountPercent(Double.valueOf(rs.getDouble("DARSAD_TAKHFIF"))).discountPrice(Double.valueOf(rs.getDouble("TakhfifSatriR"))).takeOut(Boolean.valueOf(rs.getBoolean("ART_OuterOrd"))).build());
            sqlStr = "Update Article Set Exist = Exist + " + oldFew + ", Exist_Mandeh = Exist_Mandeh + " + oldFew + " Where A_Code = '" + oldArtCode + "'";
            jdbcTemplate.execute(sqlStr);
        }
        return oldDtls;
    }

    private double getOldAmount(@Nullable AResInvoiceDtlDto oldDtl) {
        if (oldDtl == null) {
            return 0.0;
        }
        return oldDtl.getAmount();
    }

    private boolean isDtlEdited(@NotNull AResInvoiceDtlDto dtl, Map<Long, AResInvoiceDtlDto> oldDtlList) {
        if (dtl.getId() == null) {
            return false;
        }
        return dtl.notEquals(oldDtlList.get(dtl.getId()));
    }

    @NotNull
    private List<AResInvoiceDtlDto> findChangedDtlRows(@NotNull List<AResInvoiceDtlDto> newDtlList, Map<Long, AResInvoiceDtlDto> oldDtlMap) {
        ArrayList<AResInvoiceDtlDto> updatedDetails = new ArrayList<AResInvoiceDtlDto>();
        ConcurrentHashMap<Long, AResInvoiceDtlDto> tmpOldMap = new ConcurrentHashMap<Long, AResInvoiceDtlDto>(oldDtlMap);
        for (AResInvoiceDtlDto dtl : newDtlList) {
            if (dtl.getId() == null) {
                updatedDetails.add(dtl);
                continue;
            }
            AResInvoiceDtlDto oldDtl = (AResInvoiceDtlDto)tmpOldMap.remove(dtl.getId());
            if (oldDtl == null) {
                dtl.setNewlyInserted(true);
                updatedDetails.add(dtl);
                continue;
            }
            if (!dtl.notEquals(oldDtl)) continue;
            dtl.setEdited(true);
            updatedDetails.add(dtl);
        }
        updatedDetails.addAll(tmpOldMap.values());
        return updatedDetails;
    }

    private void checkInvoiceEditErrors(TncJdbc jdbcTemplate, @NotNull AResInvoiceDto dto) throws TncException {
        if (dto.getId() == null) {
            throw new TncException(TncExceptionMessages.INVALID_INVOICE_NUMBER);
        }
        String sqlStr = " SELECT F_TYPE FROM RES_FACTURE WHERE FType_KF = 'F' AND Fac_Type = ? AND F_CODE = ?";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{dto.getFacType(), dto.getId()});
        if (!rs.next()) {
            throw new TncException(TncExceptionMessages.INVALID_INVOICE_NUMBER);
        }
        if (rs.getShort("F_TYPE") != 1) {
            throw new TncException(TncExceptionMessages.INVOICE_NUMBER_ALREADY_SETTLED);
        }
        if (dto.getActionMode() < 0 || dto.getActionMode() > 8) {
            throw new TncException(TncExceptionMessages.INCORRECT_ACTION_MODE);
        }
        this.checkPayments(dto, jdbcTemplate.getLogin());
    }

    private int calculateRowStatus(@NotNull AResInvoiceDtlDto dtl) {
        if (!dtl.isNewlyInserted()) {
            if (dtl.isEdited()) {
                return 1;
            }
            return 0;
        }
        return 2;
    }

    public BaseResponse<Map<String, Object>> sendRequest(AResInvoiceDto resInvoice, LoginDto login) {
        return (BaseResponse)this.dbConnection.getTransactionTemplate(login).execute(status -> this.internalSendRequest(resInvoice, login, status));
    }

    private BaseResponse<Map<String, Object>> internalSendRequest(AResInvoiceDto resInvoice, LoginDto login, TransactionStatus status) {
        BaseResponse.Builder response = new BaseResponse.Builder();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        TncLog log = new TncLog();
        try {
            int printConfigType;
            if (resInvoice.getId() == null || resInvoice.getId() <= 0L) {
                throw new TncException(TncExceptionMessages.INVALID_INVOICE_NUMBER);
            }
            String sqlStr = "SELECT COUNT(F_CODE) CNT FROM RES_FACTURE \n WHERE FType_KF = 'F' and Fac_Type = ? AND F_CODE= ? AND F_TYPE = 1";
            SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getFacType(), resInvoice.getId()});
            int count = -1;
            if (rs.next()) {
                count = rs.getInt("CNT");
            }
            if (count <= 0) {
                throw new TncException(TncExceptionMessages.INVOICE_NUMBER_ALREADY_SETTLED);
            }
            ResTableDao.ActionMode actionMode = ResTableDao.ActionMode.find((int)resInvoice.getActionMode());
            if (actionMode.equals((Object)ResTableDao.ActionMode.NONE)) {
                log.info(actionMode + " actionMode number = " + resInvoice.getActionMode());
                throw new TncException(TncExceptionMessages.INCORRECT_ACTION_MODE);
            }
            if (actionMode.equals((Object)ResTableDao.ActionMode.CHANGE_TABLE) && resInvoice.getTableId() <= 0) {
                throw new TncException(TncExceptionMessages.INVALID_TABLE_NUMBER);
            }
            sqlStr = "SELECT DESK_NAME, F_CODE_C FROM RES_FACTURE WHERE FType_KF = 'F' and Fac_Type = ? AND F_CODE= ?";
            rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getFacType(), resInvoice.getId()});
            String oldTableName = "";
            if (rs.next()) {
                oldTableName = rs.getString("DESK_NAME");
                resInvoice.setCode(rs.getLong("F_CODE_C"));
            }
            String newTableName = "";
            if (actionMode.equals((Object)ResTableDao.ActionMode.CHANGE_TABLE)) {
                sqlStr = "SELECT DESK_NAME FROM RES_DESK WHERE [ID] = ?";
                rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getTableId()});
                if (rs.next()) {
                    newTableName = rs.getString("DESK_NAME");
                }
                sqlStr = "UPDATE RES_FACTURE SET DESK_NAME = ? WHERE FType_KF = 'F' and Fac_Type = ? and F_CODE = ? AND F_TYPE = 1";
                jdbcTemplate.update(sqlStr, new Object[]{newTableName, resInvoice.getFacType(), resInvoice.getId()});
                sqlStr = "UPDATE RES_DESK SET DESK_OPEN = 0 WHERE DESK_NAME = ?";
                jdbcTemplate.update(sqlStr, new Object[]{oldTableName});
                sqlStr = " UPDATE RES_DESK SET DESK_OPEN = 1 WHERE DESK_NAME = ?";
                jdbcTemplate.update(sqlStr, new Object[]{newTableName});
            } else if (actionMode.equals((Object)ResTableDao.ActionMode.EMPTY_TABLE)) {
                this.emptyTheTable(resInvoice, jdbcTemplate);
                response.data((Object)this.makeSuccessMap(resInvoice, actionMode));
                return response.build();
            }
            sqlStr = "SELECT COUNT(FACTID) CNT FROM RMTEMPFACTURE WITH(NOLOCK) WHERE FACTID = ? AND FACTSTYLE = 1";
            rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getId()});
            boolean insert = true;
            while (rs.next()) {
                insert = rs.getInt("CNT") <= 0;
            }
            assert (newTableName != null);
            String oldTableTitleForDB = newTableName.isEmpty() ? "" : oldTableName;
            int n = printConfigType = resInvoice.getPrintConfigType() == -1 ? new SettingLoader(this.dbConnection, login).getPrintConfigType() : resInvoice.getPrintConfigType();
            if (insert) {
                sqlStr = "INSERT INTO RMTEMPFACTURE (FACTID, DeskTitle, FactStyle, FCActionMode,  PrintConfigType, OldDeskTitle) VALUES(?, ?, 1, ?, ?, ?)";
                jdbcTemplate.update(sqlStr, new Object[]{resInvoice.getId(), oldTableName, actionMode.getCode(), printConfigType, oldTableTitleForDB});
            } else {
                sqlStr = "UPDATE RMTEMPFACTURE SET DeskTitle = ?, FactStyle = 1, FCActionMode = ?, PrintConfigType = ? , OldDeskTitle = ? WHERE FactID = ?";
                jdbcTemplate.update(sqlStr, new Object[]{oldTableName, actionMode.getCode(), printConfigType, oldTableTitleForDB, resInvoice.getId()});
            }
            response.data((Object)this.makeSuccessMap(resInvoice, actionMode));
        }
        catch (Throwable t) {
            status.setRollbackOnly();
            response.withError(this.buildError(resInvoice, t));
        }
        return response.build();
    }

    private void emptyTheTable(AResInvoiceDto resInvoice, TncJdbc jdbcTemplate) {
        this.deleteRmTempForInvoice(resInvoice, jdbcTemplate);
        if (this.duplicateCodeExists(jdbcTemplate, resInvoice)) {
            resInvoice.setCode(this.nextFCodeC(jdbcTemplate, resInvoice.getFacType()));
        }
        jdbcTemplate.update("UPDATE RES_FACTURE SET F_TYPE = 2, F_CODE_C = ? \n WHERE FType_KF = 'F' AND Fac_Type = ? AND F_CODE = ?", new Object[]{resInvoice.getCode(), resInvoice.getFacType(), resInvoice.getId()});
    }

    private boolean duplicateCodeExists(TncJdbc jdbc, AResInvoiceDto resInvoice) {
        SqlRowSet rs = jdbc.queryForRowSet("SELECT COUNT(F_CODE_C) cnt FROM RES_FACTURE \n WHERE F_CODE_C = ? AND F_TYPE = 2 AND FAC_TYPE = ? And F_Code <> ?", new Object[]{resInvoice.getCode(), resInvoice.getFacType(), resInvoice.getId()});
        return rs.next() && rs.getInt("cnt") > 0;
    }

    private long nextFCodeC(TncJdbc jdbc, String facType) {
        String sqlStr = " exec sp_Res_FactureMaxF_Code_C;1 '" + facType + "','F' ";
        SqlRowSet rs = jdbc.queryForRowSet(sqlStr);
        if (rs.next()) {
            return rs.getLong("MaxF_Code_C") + 1L;
        }
        return 1L;
    }
}

