/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.utils.params;

import com.android.core.utils.params.Param;
import com.utility.SearchQuery;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class QueryParams {
    protected SearchQuery searchQuery = new SearchQuery();

    @Nullable
    public String makeWhere(String userGivenParam, String userGivenValue) {
        Param validParam = this.findValidParam(userGivenParam);
        if (validParam == null) {
            return null;
        }
        return this.generateWhereStr(validParam, userGivenValue);
    }

    @Nullable
    private Param findValidParam(String paramName) {
        for (Param validParam : this.validParamsIgnoreCase()) {
            if (!paramName.equalsIgnoreCase(validParam.getUserSideParamName())) continue;
            return validParam;
        }
        return null;
    }

    @Nullable
    protected String generateWhereStr(Param validParam, String userGivenValue) {
        userGivenValue = validParam.getSqlStandardValue(userGivenValue);
        if (validParam.getCustomQuery() != null) {
            return (String)validParam.getCustomQuery().apply(userGivenValue);
        }
        if (this.searchQuery.isTextSearch(userGivenValue)) {
            return this.searchQuery.makeSqlQuery(userGivenValue, validParam.getSqlFieldName(), validParam.getFieldAlias(), validParam.getFieldTableName());
        }
        return this.searchQuery.makeSqlQueryNoTextSearch(userGivenValue, validParam.getSqlFieldName(), validParam.getFieldAlias());
    }

    @NonNull
    protected abstract Param[] validParamsIgnoreCase();
}

