/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.domain.model;

import com.utility.ConvertStr;
import java.util.Map;

public class BaseError {
    private String entityId = "";
    private String message = "";
    private String errorCode;
    private Map<String, Object> additionalInfo;

    public BaseError setEntityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    public BaseError setMessage(String message) {
        this.message = message;
        return this;
    }

    public BaseError setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public void setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public BaseError addToEntityId(String entityId) {
        if (ConvertStr.isNullOrEmpty((String)entityId)) {
            return this;
        }
        if (!this.entityId.isEmpty()) {
            this.entityId = this.entityId + ",";
        }
        this.entityId = this.entityId + entityId;
        return this;
    }

    public void addToMessage(BaseError additionalError) {
        if (ConvertStr.isNullOrEmpty((String)additionalError.getEntityId())) {
            return;
        }
        if (!this.message.isEmpty()) {
            this.message = this.message + "\n";
        }
        this.message = this.message + "\u0634\u0645\u0627\u0631\u0647 " + additionalError.getEntityId() + ", \u06a9\u062f \u062e\u0637\u0627(" + additionalError.getErrorCode() + ") \n" + additionalError.getMessage();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }
}

