/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.domain;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.FetchOptions;
import com.android.core.domain.model.BaseResponse;
import com.dto.LoginDto;
import com.utility.Paging;
import com.utility.TextNormalizer;
import com.utility.TncLog;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.ResponseEntity;

public abstract class AndroidService<Item> {
    private final AndroidRepository<Item> androidRepository;
    protected final TncLog log = new TncLog();
    private final FetchOptions fetcher = this.configFetch();

    protected AndroidService(AndroidRepository<Item> androidRepository) {
        this.androidRepository = androidRepository;
    }

    @Nullable
    public final ResponseEntity<Map<String, Object>> getItems(HttpServletRequest request, int page, int itemsPerPage) {
        if (this.fetcher == null) {
            return null;
        }
        LoginDto loginDto = this.getLogin();
        this.androidRepository.log(loginDto);
        Paging paging = new Paging(itemsPerPage, page, this.fetcher.getTableNameForPaging());
        return this.getMapResponseEntity(request, loginDto, paging);
    }

    @NotNull
    private ResponseEntity<Map<String, Object>> getMapResponseEntity(HttpServletRequest request, LoginDto loginDto, Paging paging) {
        try {
            BaseResponse response = this.androidRepository.customQuery(request, paging, loginDto);
            if (response != null) {
                return this.makeAndroidResponse(response);
            }
            if (this.getItemClass() == null) {
                throw new RuntimeException("*");
            }
            return this.makeAndroidResponse(this.androidRepository.getAsObject(request, paging, loginDto), this.getItemClass());
        }
        catch (RuntimeException e) {
            if (!e.getMessage().startsWith("*")) {
                this.log.error(e.toString());
            }
            return this.makeAndroidResponse(this.androidRepository.getAsMap(request, paging, loginDto));
        }
    }

    @NotNull
    public final ResponseEntity<Map<String, Object>> post(List<Item> body) {
        LoginDto login = this.getLogin();
        this.androidRepository.log(login);
        return this.makeAndroidResponse(this.androidRepository.insertAll(body, login));
    }

    @Nullable
    protected Class<Item> getItemClass() {
        return null;
    }

    @Nullable
    protected FetchOptions configFetch() {
        return FetchOptions.builder().build();
    }

    protected boolean needsLogin() {
        return true;
    }

    public final AndroidRepository<Item> getAndroidRepository() {
        return this.androidRepository;
    }

    protected final LoginDto getLogin() {
        return this.needsLogin() ? LoginDto.makeFromCurrentToken() : LoginDto.builder().build();
    }

    @NotNull
    protected final <T> ResponseEntity<Map<String, Object>> makeAndroidResponse(@NotNull BaseResponse<T> responseModel, Class<T> tClass) {
        LinkedHashMap finalMap = new LinkedHashMap();
        if (responseModel.isFarsi()) {
            responseModel.setData(TextNormalizer.getNormalizedText((List)responseModel.getData(), tClass));
        }
        return this.generateResponse(responseModel, finalMap);
    }

    @NotNull
    private <T> ResponseEntity<Map<String, Object>> generateResponse(@NotNull BaseResponse<T> responseModel, @NotNull Map<String, Object> finalMap) {
        finalMap.put("data", responseModel.getData());
        finalMap.put("totalCount", responseModel.getTotalCount());
        finalMap.put("totalPages", responseModel.getTotalPages());
        if (responseModel.getError() != null) {
            finalMap.put("error", responseModel.getError());
        }
        return ResponseEntity.ok(finalMap);
    }

    @NotNull
    protected final ResponseEntity<Map<String, Object>> makeAndroidResponse(@NotNull BaseResponse<Map<String, Object>> responseModel) {
        LinkedHashMap finalMap = new LinkedHashMap();
        if (responseModel.isFarsi()) {
            responseModel.setData(TextNormalizer.getNormalizedText((List)responseModel.getData()));
        }
        return this.generateResponse(responseModel, finalMap);
    }

    public ResponseEntity<Map<String, Object>> edit(List<Item> body) {
        LoginDto login = this.getLogin();
        this.androidRepository.log(login);
        return this.makeAndroidResponse(this.androidRepository.edit(body, login));
    }
}

