/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.util;

import com.utility.ConvertStr;
import com.utility.TncJdbc;
import com.webhook.dto.TableHooksDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public enum CDCTables {
    CUSTOMER/* Unavailable Anonymous Inner Class!! */,
    CUST_TEL/* Unavailable Anonymous Inner Class!! */,
    DOCUMENT/* Unavailable Anonymous Inner Class!! */,
    PRODUCT/* Unavailable Anonymous Inner Class!! */,
    RES_DETAIL/* Unavailable Anonymous Inner Class!! */,
    RES_INVOICE/* Unavailable Anonymous Inner Class!! */,
    RES_TABLE/* Unavailable Anonymous Inner Class!! */,
    MAIN_GROUP/* Unavailable Anonymous Inner Class!! */,
    SIDE_GROUP/* Unavailable Anonymous Inner Class!! */,
    ORDER/* Unavailable Anonymous Inner Class!! */,
    PAGER/* Unavailable Anonymous Inner Class!! */,
    DEFAULT/* Unavailable Anonymous Inner Class!! */;

    private final String value;
    private final int idNumber;
    private List<CDCTables> relatedTables;

    private CDCTables(String value, int idNumber) {
        this.value = value;
        this.idNumber = idNumber;
    }

    public static CDCTables getTable(String value) {
        if (ConvertStr.isNullOrEmpty((String)(value = value.trim()))) {
            return DEFAULT;
        }
        for (CDCTables table : CDCTables.values()) {
            if (!CDCTables.isCDCTable((String)value, (CDCTables)table)) continue;
            return table;
        }
        return DEFAULT;
    }

    public static CDCTables getTableFromUser(String value) {
        if (ConvertStr.isNullOrEmpty((String)(value = value.trim()))) {
            return DEFAULT;
        }
        for (CDCTables table : CDCTables.values()) {
            if (!CDCTables.isCDCTableFromUser((String)value, (CDCTables)table)) continue;
            return table;
        }
        return DEFAULT;
    }

    private static boolean isCDCTable(String value, CDCTables table) {
        value = value.toLowerCase();
        return table.getValue().toLowerCase().contains(value);
    }

    private static boolean isCDCTableFromUser(String value, CDCTables table) {
        return value.equalsIgnoreCase(table.getTableToShow());
    }

    public List<CDCTables> getRelatedTables() {
        if (this.relatedTables != null) {
            return this.relatedTables;
        }
        ArrayList<CDCTables> tablesList = new ArrayList<CDCTables>();
        for (CDCTables table : CDCTables.values()) {
            if (table.getIdNumber() != this.getIdNumber()) continue;
            tablesList.add(table);
        }
        this.relatedTables = tablesList;
        return this.relatedTables;
    }

    public Map<String, String> getColPairs() {
        String[] realColNames = this.getCols();
        String[] fakeColNames = this.getColNamesToShow();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < realColNames.length; ++i) {
            map.put(realColNames[i].toLowerCase(), fakeColNames[i]);
        }
        return map;
    }

    public String getValueWithoutDbo() {
        return this.value.substring(4);
    }

    public String getValue() {
        return this.value.trim();
    }

    public int getIdNumber() {
        return this.idNumber;
    }

    public String getTableCodeFieldToShow() {
        return "ErpCode";
    }

    public abstract String getTableToShow();

    public abstract String[] getCols();

    public abstract String[] getColNamesToShow();

    public abstract String[] getTableCodeField();

    public final void subscribe(TableHooksDto dto, TncJdbc jdbcTemplate) {
        for (CDCTables table : this.getRelatedTables()) {
            jdbcTemplate.update(this.getSubscriptionInsertStatement(), new Object[]{dto.getUrl().trim(), table.getValue(), dto.getApikey() == null ? "" : dto.getApikey().trim()});
        }
    }

    public final void unsubscribe(JdbcTemplate jdbcTemplate) {
        for (CDCTables table : this.getRelatedTables()) {
            jdbcTemplate.update(this.getDeleteStatement(table.getValueWithoutDbo()));
        }
    }

    public boolean tableExists(JdbcTemplate jdbcTemplate) {
        Map map = jdbcTemplate.queryForMap(this.getExistingTableCountSqlStatement());
        int count = (Integer)map.get("cnt");
        return count != 0;
    }

    public String getFinalChangeTableName() {
        return this.getValue();
    }

    protected final String getExistingTableCountSqlStatement() {
        String select = " SELECT Count(*) cnt FROM WebHook_SUBSCRIPTIONS WHERE ";
        StringBuilder result = new StringBuilder();
        for (CDCTables table : this.getRelatedTables()) {
            if (result.length() != 0) {
                result.append(" OR ");
            }
            result.append("WH_TABLE_NAME LIKE '%").append(table.getValue()).append("%'");
        }
        return result.insert(0, select).toString();
    }

    protected final String getDeleteStatement(String tableName) {
        return " DELETE FROM WebHook_Subscriptions WHERE WH_TABLE_NAME LIKE '%" + tableName + "%'";
    }

    protected final String getSubscriptionInsertStatement() {
        return " INSERT INTO WebHook_Subscriptions([API_URL], [WH_TABLE_NAME], [API_KEY]) VALUES(?, ?, ?)";
    }

    public final boolean isMainTable() {
        return this.getFinalChangeTableName().equals(this.getValue());
    }
}

