/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.events;

import com.utility.CallApi;
import com.webhook.events.ChangeEventParser;
import com.webhook.notifs.CDCBaseNotification;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.RecordChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceRecord;

public class ChangeEventManager {
    private final ChangeEventParser eventParser = new ChangeEventParser();
    private Map<Integer, List<CDCBaseNotification>> notificationsToSend;

    public void handleNotification(List<RecordChangeEvent<SourceRecord>> recordChangeEvents, DebeziumEngine.RecordCommitter<RecordChangeEvent<SourceRecord>> committer) {
        this.notificationsToSend = new HashMap();
        for (RecordChangeEvent<SourceRecord> changeRecord : recordChangeEvents) {
            try {
                CDCBaseNotification notification = this.eventParser.parse(changeRecord, committer);
                if (notification == null) continue;
                notification.generateChangedFields();
                this.mergeChangeFields(notification);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.sendToApi();
    }

    private void mergeChangeFields(CDCBaseNotification nextNotification) {
        int tableId = nextNotification.getParser().getChangedTable().getIdNumber();
        List existingListForTable = (List)this.notificationsToSend.get(tableId);
        if (this.notificationsToSend.isEmpty() || existingListForTable == null) {
            ArrayList<CDCBaseNotification> nextNotificationList = new ArrayList<CDCBaseNotification>();
            nextNotificationList.add(nextNotification);
            this.notificationsToSend.put(tableId, nextNotificationList);
            return;
        }
        ArrayList<CDCBaseNotification> sameTableNotifications = new ArrayList<CDCBaseNotification>();
        boolean alreadyHadOperation = false;
        for (CDCBaseNotification notification : existingListForTable) {
            if (notification.getOperation().equals((Object)nextNotification.getOperation())) {
                notification.addAllChangedRows(nextNotification.getChangedFields());
                alreadyHadOperation = true;
                break;
            }
            if (sameTableNotifications.contains(nextNotification)) continue;
            sameTableNotifications.add(nextNotification);
        }
        if (!sameTableNotifications.isEmpty() && !alreadyHadOperation) {
            existingListForTable.addAll(sameTableNotifications);
        }
    }

    private void sendToApi() {
        for (List baseNotifications : this.notificationsToSend.values()) {
            CallApi.sendChangeNotification(baseNotifications.stream().map(CDCBaseNotification::makeNotification).collect(Collectors.toList()));
        }
    }
}

