/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.webhook.util.Command;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public final class TransactionCheck {
    private static final Map<String, TransactionCheck> instances = new HashMap();
    private final DbConnection dbConnection;
    private final String dbname;

    private TransactionCheck(DbConnection dbConnection, String dbname) {
        this.dbConnection = dbConnection;
        this.dbname = dbname;
    }

    public static TransactionCheck getInstance(DbConnection dbConnection, String dbname) {
        if (instances.containsKey(dbname)) {
            return (TransactionCheck)instances.get(dbname);
        }
        TransactionCheck transactionCheck = new TransactionCheck(dbConnection, dbname);
        instances.put(dbname, transactionCheck);
        return transactionCheck;
    }

    public void waitTranEndForTables(String ... tables) throws TimeoutException {
        int count;
        int maxRetry = 0;
        String tranTables = ConvertStr.commaBindStringsWithQuotes(Arrays.asList(tables));
        do {
            if (++maxRetry > 60) {
                this.clearSession();
                throw new TimeoutException("Timeout occurred due to already running transactions on the tables required for the requested operation. Rerun the request.");
            }
            count = (Integer)this.dbConnection.getJdbcTemplate(null).queryForObject(this.getSqlString(tranTables), Integer.class);
            if (count <= 0) continue;
            this.waitASec();
        } while (count > 0);
        this.clearSession();
    }

    private void clearSession() {
        instances.remove(this.dbname);
    }

    private boolean ongoingTransactionsEnded(String ... tables) {
        try {
            this.waitTranEndForTables(tables);
        }
        catch (TimeoutException ignored) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionDeadLockWrapper(Command command, String ... tables) {
        block7: {
            try {
                command.execute();
            }
            catch (Exception e) {
                if (ConvertStr.exceptionContains((Exception)e, (String)"deadlock")) {
                    if (this.ongoingTransactionsEnded(tables)) {
                        command.execute();
                        break block7;
                    }
                    throw e;
                }
                throw e;
            }
            finally {
                instances.remove(this.dbname);
            }
        }
    }

    private String getSqlString(String tranTables) {
        return this.dbConnection.getDbNameSql(this.dbname) + " SELECT COUNT(*) FROM MASTER..SysLockInfo L INNER JOIN  MASTER..SysProcesses P ON P.SpID=L.REQ_SpID AND L.RSC_DbID=P.DbID  WHERE (LOGIName='sa' OR NT_USERNAME<>'') AND RSC_ObjID IN (SELECT [ID]  FROM [SysObjects] WHERE [NAME] IN (" + tranTables + "))AND REQ_SpID<>@@SpID  AND DbID=(SELECT DbID FROM MASTER..SysDatabases WHERE NAME='" + this.dbname + "')  AND CMD NOT IN ('SELECT' , 'CONDITIONAL')";
    }

    private void waitASec() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

