/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.dto.LoginDto;
import com.utility.ConvertStr;
import javax.sql.DataSource;
import org.jetbrains.annotations.Nullable;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;

public class TncJdbc
extends JdbcTemplate {
    public static final String FLAG_NO_USE_DB = "!!!";
    private final LoginDto login;
    private String dbNameSql;

    public TncJdbc(LoginDto login, DataSource dataSource) {
        super(dataSource);
        if (login == null) {
            login = LoginDto.builder().build();
        }
        this.dbNameSql = login.makeUseDbSql();
        this.login = login;
    }

    public <T> T query(String sql, ResultSetExtractor<T> rse) throws DataAccessException {
        return (T)super.query(this.makeSql(sql), rse);
    }

    public <T> T query(String sql, PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws DataAccessException {
        return (T)super.query(this.makeSql(sql), pss, rse);
    }

    public <T> T execute(String sql, PreparedStatementCallback<T> action) throws DataAccessException {
        return (T)super.execute(this.makeSql(sql), action);
    }

    public void execute(String sql) throws DataAccessException {
        super.execute(this.makeSql(sql));
    }

    public int update(String sql) throws DataAccessException {
        return super.update(this.makeSql(sql));
    }

    public int update(String sql, Object ... args) throws DataAccessException {
        return super.update(this.makeSql(sql), args);
    }

    public int update(String sql, PreparedStatementSetter pss) throws DataAccessException {
        return super.update(this.makeSql(sql), pss);
    }

    public int update(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return super.update(this.makeSql(sql), args, argTypes);
    }

    public void executeOnDefaultDb(String sql) {
        this.execute(FLAG_NO_USE_DB + sql);
    }

    public int getCount(String tableName, @Nullable String whereStr) {
        Integer count = (Integer)this.queryForObject("SELECT COUNT(*) FROM " + tableName + " " + (ConvertStr.isNullOrEmpty((String)whereStr) ? "" : "WHERE " + whereStr), Integer.class);
        return count != null ? count : 0;
    }

    public int getCount(String tableName) {
        return this.getCount(tableName, null);
    }

    public long getMaxOf(String tableName, String colName) {
        Long result = (Long)this.queryForObject("SELECT IsNull(MAX(" + colName + "), 0) mx FROM " + tableName, Long.class);
        return result != null ? result : 0L;
    }

    public void truncateTable(String tableName) {
        this.execute("TRUNCATE TABLE " + tableName);
    }

    public LoginDto getLogin() {
        return this.login;
    }

    private String makeSql(String sql) {
        String s = sql.trim();
        if (s.startsWith("Use") || s.startsWith("USE") || s.startsWith("use")) {
            return s;
        }
        if (!s.contains(FLAG_NO_USE_DB)) {
            return this.dbNameSql + s;
        }
        return s.replace(FLAG_NO_USE_DB, "");
    }
}

