/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.android.core.domain.model.BaseError;
import com.utility.TncExceptionMessages;
import com.utility.TncLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TncException
extends RuntimeException {
    private final Map<String, Object> model = new LinkedHashMap();
    private final List<TncException> exceptions = new ArrayList();
    private final List<Map<String, Object>> success = new ArrayList();
    private final TncLog log = new TncLog();
    private String message;
    private int errorCode;
    private TncExceptionMessages exception;
    private Runnable doOnError;

    public TncException(TncExceptionMessages exceptionMessage) {
        this.message = exceptionMessage.getMessage();
        this.errorCode = exceptionMessage.getCode();
        this.exception = exceptionMessage;
        if (!exceptionMessage.getArgs().isEmpty()) {
            this.addArgsToMessage(exceptionMessage.getArgs());
        }
    }

    public TncException(List<TncException> list) {
        this.exceptions.addAll(list);
    }

    public static TncException fromException(Throwable t) {
        TncException e = new TncException(TncExceptionMessages.DEFAULT_ERROR);
        e.putMoreInfo("errorMessage", (Object)t.getMessage());
        return e;
    }

    public TncException addSuccessList(List<Map<String, Object>> successList) {
        this.success.addAll(successList);
        return this;
    }

    public List<Map<String, Object>> getSuccessList() {
        return this.success;
    }

    public List<Map<String, Object>> makeFailureList() {
        if (this.exceptions.isEmpty()) {
            return Collections.singletonList(this.getErrorMap());
        }
        return this.exceptions.stream().map(e -> {
            if (e.getDoOnError() != null) {
                e.getDoOnError().run();
            }
            return e.getErrorMap();
        }).collect(Collectors.toList());
    }

    @Override
    public synchronized Throwable getCause() {
        return new Throwable(this.message);
    }

    private void addArgsToMessage(List<Object> args) {
        this.message = String.format(this.message, args.toArray());
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public TncExceptionMessages getException() {
        return this.exception;
    }

    public void putMoreInfo(String key, Object value) {
        this.model.put(key, value);
    }

    public Map<String, Object> getErrorMap() {
        this.model.put("Error", this.message);
        this.model.put("ErrorCode", this.errorCode);
        return this.model;
    }

    public BaseError makeAndroidError() {
        BaseError error = new BaseError().setMessage(this.message).setErrorCode(String.valueOf(this.errorCode));
        this.log.info("responseError = " + this.message + "\n" + this.model);
        if (this.model.containsKey("id")) {
            error.setEntityId(String.valueOf(this.model.remove("id")));
        }
        if (!this.model.isEmpty()) {
            error.setAdditionalInfo(this.model);
        }
        return error;
    }

    public Map<String, Object> makeErrorWithCause(Throwable e) {
        Map model = this.getErrorMap();
        model.put("Error", this.getMessage() + " \n " + e.getCause());
        return model;
    }

    public Runnable getDoOnError() {
        return this.doOnError;
    }

    public void setDoOnError(Runnable doOnError) {
        this.doOnError = doOnError;
    }
}

