/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.utility.Paging;

/*
 * Exception performing whole class analysis ignored.
 */
public class Paging {
    private final boolean isPagination;
    private final String tableName;
    private final int itemsPerPage;
    private final int page;

    public Paging(int itemsPerPage, int page, String tableName) {
        this.itemsPerPage = itemsPerPage;
        this.page = page;
        this.tableName = tableName;
        this.isPagination = page > 0 && itemsPerPage > 0;
    }

    public String makeSql(PageSqlData sqlData) {
        String pageWhere = !this.isPagination ? "" : (sqlData.getWhereStr().isEmpty() ? " WHERE " : " AND ") + sqlData.getKeyField() + " in (Select TableKey from @orderedKeys where TableKey = " + sqlData.getKeyField() + " AND RowNum >= @firstRecord) ";
        return this.getPagePrepareSql(sqlData) + sqlData.getSelectSqlStr() + "\n" + sqlData.getJoinsStr() + "\n" + sqlData.getWhereStr() + "\n" + pageWhere + (sqlData.getSelectSqlStr().contains(sqlData.getKeyField()) ? " order by " + sqlData.getKeyField() : "");
    }

    private String getPagePrepareSql(PageSqlData sqlData) {
        if (!this.isPagination) {
            return "";
        }
        return "DECLARE @pageNo int\nDECLARE @pageSize int\nSET @pageNo = " + this.page + "\nSET @pageSize = " + this.itemsPerPage + "\n\nDECLARE @firstRecord int\nDECLARE @lastRecord int\nSET @firstRecord = (@pageNo - 1) * @pageSize + 1 \nSET @lastRecord = @firstRecord + @pageSize - 1 \nDECLARE @orderedKeys TABLE (\n  RowNum int IDENTITY NOT NULL PRIMARY KEY CLUSTERED, \n  TableKey " + PageSqlData.access$000((PageSqlData)sqlData) + " NOT NULL \n) \nSET ROWCOUNT @lastRecord \nINSERT INTO @orderedKeys (TableKey) SELECT " + sqlData.getDistinct() + sqlData.getKeyField() + " FROM " + (sqlData.getTableName().isEmpty() ? this.tableName : sqlData.getTableName()) + " " + sqlData.getAlias() + "\n" + sqlData.getJoinsStr() + "\n" + sqlData.getWhereStr() + " ORDER BY " + sqlData.getKeyField() + " \nSET ROWCOUNT 0 \n";
    }

    public boolean isPagination() {
        return this.isPagination;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int getPage() {
        return this.page;
    }
}

