/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice;

import com.dto.InvoiceDetailDto;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbLogin;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class ProxyInvoiceService {
    private final TncJdbc jdbcTemplate;
    private double commission = 0.0;

    public ProxyInvoiceService(DbLogin dbLogin) {
        LoginDto loginDto = dbLogin.getLogin();
        this.jdbcTemplate = dbLogin.getDbConnection().getJdbcTemplate(loginDto);
    }

    public double getCommission(InvoiceDetailDto dtl) throws TncException {
        this.checkErrors(dtl);
        return this.commission == -1.0 ? 0.0 : this.commission;
    }

    private void checkErrors(InvoiceDetailDto dtl) throws TncException {
        if (ConvertStr.isNullOrEmpty((String)dtl.getSellererpcode())) {
            throw new TncException(TncExceptionMessages.MUST_HAVE_SELLER_CODE);
        }
        this.checkCustomerIsSeller(dtl);
        this.checkProductHasGivenCustomer(dtl);
    }

    private void checkCustomerIsSeller(InvoiceDetailDto dtl) throws TncException {
        String sellerCode = ConvertStr.decrypt((String)dtl.getSellererpcode());
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(" SELECT ISNULL(ISSELLER, 0) isSeller FROM CUSTOMER WHERE C_CODE = ?", new Object[]{sellerCode});
        boolean isNotSeller = true;
        if (rs.next()) {
            boolean bl = isNotSeller = !rs.getBoolean("isSeller");
        }
        if (isNotSeller) {
            throw new TncException(TncExceptionMessages.CUSTOMER_NOT_PROXY_SELLER);
        }
    }

    private void checkProductHasGivenCustomer(InvoiceDetailDto dtl) throws TncException {
        String sellerCode = ConvertStr.decrypt((String)dtl.getSellererpcode());
        List sellersForCurrentProduct = this.jdbcTemplate.queryForList(" SELECT C_CODE, ISNULL(COMMISSION, 0) COMMISSION FROM SellerDetail WHERE A_CODE = ?", new Object[]{dtl.getProductid()});
        double tmpCommission = -1.0;
        boolean productHasSellerCustomers = !sellersForCurrentProduct.isEmpty();
        for (Map proxy : sellersForCurrentProduct) {
            if (!sellerCode.equals(proxy.get("C_CODE"))) continue;
            tmpCommission = (Double)proxy.get("COMMISSION");
        }
        if (tmpCommission == -1.0 && productHasSellerCustomers) {
            throw new TncException(TncExceptionMessages.CUSTOMER_NOT_EQUALS_PRODUCT_SELLER);
        }
        this.commission = tmpCommission;
    }

    public String getSellerSarfasl(String customerCode) {
        String sqlStr = " SELECT SARFASL_CODE FROM SARFASL WHERE COMMON ='" + customerCode + "' AND [TYPE] IN (5,15) AND SPARENT = 0 ";
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(sqlStr);
        if (rs.next()) {
            return rs.getString("SARFASL_CODE");
        }
        return null;
    }

    public String getSellerSarfaslName(String headingCode) {
        String sqlStr = " SELECT SARFASL_NAME FROM SARFASL WHERE SARFASL_CODE ='" + headingCode + "' AND [TYPE] IN (5,15) AND SPARENT = 0 ";
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(sqlStr);
        if (rs.next()) {
            return rs.getString("SARFASL_NAME");
        }
        return null;
    }
}

