/*
 * Decompiled with CFR 0.152.
 */
package com.service.customer;

import com.dao.SellerDetailDao;
import com.dto.LoginDto;
import com.dto.SellerDetailDto;
import com.utility.ConvertStr;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class SellerDetailService {
    private final SellerDetailDao dao;

    public SellerDetailService(SellerDetailDao dao) {
        this.dao = dao;
    }

    public ResponseEntity<?> postSellerDetail(List<SellerDetailDto> body) {
        LoginDto login = this.dao.login();
        ArrayList duplicates = new ArrayList();
        HashMap<String, String> duplicateCodeMap = new HashMap<String, String>();
        try {
            for (SellerDetailDto dto : body) {
                dto.setCustomerCode(this.decrypt(dto.getCustomerErpCode()));
                dto.setProductCode(this.decrypt(dto.getProductErpCode()));
                this.checkSellerErrors(dto, login);
                if (this.dao.getSellerDtl(dto.getCustomerCode(), dto.getProductCode(), login) != null) {
                    duplicateCodeMap.put("customerErpCode", dto.getCustomerErpCode());
                    duplicateCodeMap.put("productErpCode", dto.getProductErpCode());
                    duplicates.add(duplicateCodeMap);
                    continue;
                }
                this.dao.insert(dto, login);
            }
        }
        catch (TncException e) {
            return ConvertStr.getMapResponseEntity((String)"Seller", Collections.singletonList(e.getErrorMap()), Collections.emptyList());
        }
        catch (Exception e) {
            TncException ex = new TncException(TncExceptionMessages.DEFAULT_ERROR);
            return ConvertStr.getMapResponseEntity((String)"Seller", Collections.singletonList(ex.makeErrorWithCause((Throwable)e)), Collections.emptyList());
        }
        return ConvertStr.getMapResponseEntity((String)"Seller", Collections.singletonList(Collections.singletonMap("duplicates", duplicates)), Collections.singletonList(Collections.singletonMap("Success", duplicates.size() != body.size())));
    }

    @NotNull
    private String decrypt(String erpCode) {
        return ConvertStr.decrypt((String)erpCode);
    }

    private void checkSellerErrors(@NotNull SellerDetailDto dto, LoginDto login) throws TncException {
        if (ConvertStr.isNullOrEmpty((String)dto.getCustomerCode())) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
        }
        Map sellerState = this.dao.getCustomerSellerState(dto.getCustomerCode(), login);
        if (this.customerNotExist(sellerState)) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
        }
        if (!((Object)sellerState.getOrDefault("IsSeller", false)).equals(true)) {
            throw new TncException(TncExceptionMessages.CUSTOMER_NOT_PROXY_SELLER);
        }
        if (ConvertStr.isNullOrEmpty((String)dto.getProductCode())) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        if (this.dao.productNotExist(dto.getProductCode(), login)) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        if (dto.getCommission() < 0.0 || dto.getCommission() > 100.0) {
            throw new TncException(TncExceptionMessages.COMMISSION_MUST_BE_PERCENTAGE);
        }
    }

    private boolean customerNotExist(Map<String, Object> customer) {
        return customer == null || customer.isEmpty();
    }
}

