/*
 * Decompiled with CFR 0.152.
 */
package com.resource;

import com.Application;
import com.dao.PaymentDao;
import com.dto.PosTransactionDto;
import com.dto.ProxyVoucherDto;
import com.utility.ConvertStr;
import com.utility.JsonParser;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/Payment"})
public class Payment {
    private final PaymentDao paymentDao;
    private final Application config;

    public Payment(PaymentDao paymentDao, Application Config) {
        this.paymentDao = paymentDao;
        this.config = Config;
    }

    @GetMapping(value={"/Bank"})
    public List<Map<String, Object>> getBanks() {
        if (!this.config.usePack3) {
            return null;
        }
        return this.paymentDao.getBanksList();
    }

    @GetMapping(value={"/City"})
    public List<Map<String, Object>> getCities() {
        if (!this.config.usePack3) {
            return null;
        }
        return this.paymentDao.getCityList();
    }

    @GetMapping(value={"/Account"})
    public List<Map<String, Object>> getAccounts(HttpServletRequest request) {
        if (!this.config.usePack3) {
            return null;
        }
        return this.paymentDao.getAccountsList(request);
    }

    @PostMapping(value={"/Havaleh"}, consumes={"application/json"})
    public ResponseEntity<?> postHavaleh(@RequestBody String body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.postPaymentList(body, 3, true);
    }

    @PostMapping(value={"/ReciveFromCustomer"}, consumes={"application/json"})
    public ResponseEntity<?> postReceiveFromCustomer(@RequestBody String body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.postPaymentList(body, 4, true);
    }

    @PostMapping(value={"/PayCustomer"}, consumes={"application/json"})
    public ResponseEntity<?> payCustomer(@RequestBody String body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.postPaymentList(body, 5, true);
    }

    @PostMapping(value={"/Sanad"}, consumes={"application/json"})
    public ResponseEntity<?> postSanad(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.postPaymentList(ConvertStr.deCompressionGZip((byte[])body), 0, false);
    }

    @PostMapping(value={"/Sarfasl"}, consumes={"application/json"})
    public ResponseEntity<?> postSarfasl(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.postSarfaslList(ConvertStr.deCompressionGZip((byte[])body));
    }

    @PostMapping(value={"/Check"}, consumes={"application/json"})
    public ResponseEntity<?> postCheck(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.postCheckList(ConvertStr.deCompressionGZip((byte[])body));
    }

    @PostMapping(value={"/CheckEvent"}, consumes={"application/json"})
    public ResponseEntity<?> postCheckEvent(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.postCheckEventList(ConvertStr.deCompressionGZip((byte[])body));
    }

    @PostMapping(value={"/Bank"}, consumes={"application/json"})
    public ResponseEntity<?> postBank(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.postBankList(ConvertStr.deCompressionGZip((byte[])body));
    }

    @PostMapping(value={"/User"}, consumes={"application/json"})
    public ResponseEntity<?> postUser(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.postUserDbList(ConvertStr.deCompressionGZip((byte[])body));
    }

    @PostMapping(value={"/Setting"}, consumes={"application/json"})
    public ResponseEntity<?> postSetting(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.postSettingList(ConvertStr.deCompressionGZip((byte[])body));
    }

    @PostMapping(value={"/ResInvoice"}, consumes={"application/json"})
    public ResponseEntity<?> postResInvoice(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.postResInvoice(ConvertStr.deCompressionGZip((byte[])body));
    }

    @PostMapping(value={"/DeleteTable"}, consumes={"application/json"})
    public ResponseEntity<?> deleteTable(@RequestBody byte[] body) {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.deleteTableList(ConvertStr.deCompressionGZip((byte[])body));
    }

    @PostMapping(value={"/DropDataBase"}, consumes={"application/json"})
    public ResponseEntity<?> dropDataBase() {
        if (!this.config.usePack2) {
            return null;
        }
        return this.paymentDao.dropDataBase();
    }

    @ApiIgnore
    @PostMapping(value={"/PosLog"}, consumes={"application/json"})
    public ResponseEntity<?> logPosTransaction(@RequestBody byte[] body) {
        return this.paymentDao.insertPosLog((PosTransactionDto[])new JsonParser(PosTransactionDto[].class).parseJson(ConvertStr.deCompressionGZip((byte[])body)));
    }

    @ApiIgnore
    @PostMapping(value={"/ProxyVoucher"})
    public ResponseEntity<?> postProxyVoucher(@RequestBody List<ProxyVoucherDto> body) {
        return this.paymentDao.postProxyVoucher(body);
    }

    @ApiIgnore
    @DeleteMapping(value={"/ProxyVoucher"})
    public ResponseEntity<?> deleteProxyVoucher(@RequestParam(value="sanadCode") String voucherCode) {
        return this.paymentDao.deleteProxyVoucher(voucherCode);
    }
}

