/*
 * Decompiled with CFR 0.152.
 */
package com.dao.process;

import com.dao.process.ProcessDao;
import com.dto.LoginDto;
import com.utility.DbConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.lang.Nullable;

public abstract class ProcessDao<T> {
    private final LoginDto login;
    private final String blob;
    private final JdbcTemplate jdbcTemplate;
    private int multipleProcessesId = -1;

    public ProcessDao(DbConnection dbConnection, LoginDto login, @Nullable String blob) {
        this.login = login;
        this.blob = blob;
        this.jdbcTemplate = dbConnection.getJdbcTemplate(login);
    }

    public void insert(T data, ProcessKind kindProc) {
        this.jdbcTemplate.update(" INSERT INTO [PROCESS] (C_CODE, Comment, DateProc, KINDPROC, NAMEPROC, [NUMBER], [ProcId], TimeProc, User_Code, WEBBLOB) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{this.getCCode(data), "(\u0648\u0628 \u0633\u0631\u0648\u06cc\u0633) " + this.generateComment(data), new SimpleDateFormat("yyyy/MM/dd").format(new Date()), kindProc.getKindProc(), this.getNameProc(data), this.getNumber(data), this.getProcId(), new SimpleDateFormat("HH:mm").format(new Date()), this.login.getUserCodeInc(), this.getBytesFromBody()});
    }

    protected abstract String generateComment(T var1);

    protected abstract String getNumber(T var1);

    protected abstract String getNameProc(T var1);

    protected abstract String getCCode(T var1);

    protected JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected void multipleProcessesId(int id) {
        this.multipleProcessesId = id;
    }

    protected LoginDto getLogin() {
        return this.login;
    }

    protected final byte[] getBytesFromBody() {
        if (this.blob == null) {
            return null;
        }
        return this.blob.getBytes();
    }

    protected final int getProcId() {
        if (this.multipleProcessesId != -1) {
            return this.multipleProcessesId;
        }
        Map maxId = this.jdbcTemplate.queryForMap(" SELECT ISNULL(MAX([ProcId]), 0) + 1 pid from [PROCESS]");
        return (Integer)maxId.get("pid");
    }
}

