/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dto.LoginDto;
import com.dto.SideGroupDto;
import com.google.gson.Gson;
import com.service.product.IndustrialProductService;
import com.utility.CallApi;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.DbLogin;
import com.utility.MyHolooMessageMaker;
import com.utility.TextNormalizer;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.utility.TransactionCheck;
import com.utility.UnavailableACode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class SideGroupDao {
    private final DbConnection dbConnection;

    public SideGroupDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    static int resetAndGetCounter(TncJdbc tncJdbc, StringBuilder sb, String insert, int counter) {
        if (counter >= 50) {
            sb.deleteCharAt(sb.lastIndexOf(","));
            tncJdbc.execute(sb.toString());
            sb.delete(0, sb.length());
            sb.append(insert);
            counter = 0;
        }
        return counter;
    }

    public ResponseEntity<?> getSideGroupList(HttpServletRequest request) {
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        String sqlStr = " select M.M_groupcode+S_groupcode ErpCode, S_GROUPCODE SideGroupCode,  M.M_GROUPCODE MainGroupCode, S_groupname Name, \n M.M_groupName MainGroupName,M.M_groupcode MainGroupErpcode,M.M_groupcode MainErpCode, \n   Isnull(S.DarsadTakhfif,0) DiscountPercent , Isnull(S.PriceTakhfif,0) DiscountPrice  \n From S_group S inner join M_GROUP M on S.M_groupcode=M.M_groupcode ";
        String sqlWhere = this.getFilter(request);
        sqlStr = sqlStr + sqlWhere + " Order by  M.M_groupName,S.S_groupname ";
        List rowSet = jdbcTemplate.queryForList(sqlStr);
        for (int i = 0; i < rowSet.size(); ++i) {
            Map map = (Map)rowSet.get(i);
            if (!myLogin.getIsMyHoloo().booleanValue()) {
                map.remove("MainGroupCode");
                map.remove("SideGroupCode");
            }
            String erpCode = map.get("ErpCode").toString();
            map.put("ErpCode", ConvertStr.encrypt((String)ConvertStr.getNullIfEmpty((String)erpCode)));
            map.put("MainGroupErpcode", ConvertStr.encrypt((String)ConvertStr.getNullIfEmpty((String)map.get("MainGroupErpcode").toString())));
            map.put("MainErpCode", ConvertStr.encrypt((String)ConvertStr.getNullIfEmpty((String)map.get("MainErpCode").toString())));
            rowSet.set(i, map);
        }
        return ConvertStr.getMapResponseEntity((String)"sideGroup", (List)rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    private StringBuilder getInsertStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("Insert Into S_Group(").append("M_GroupCode,S_GroupCode,S_GroupName,Creation_Date,FromModatDate,ToModatDate)");
        return sb;
    }

    private void appendSelectStatement(StringBuilder sb, SideGroupDto dto) {
        sb.append(" ( ").append("'").append(dto.getMaingrouperpcode()).append("',").append("'").append(dto.getCode()).append("',").append("'").append(dto.getName()).append("',").append("GetDate(),GetDate(),GetDate()").append(" ) ");
    }

    private void appendUpdateStatement(StringBuilder sb, SideGroupDto dto) {
        sb.append("Update s_Group Set  S_GroupName = '").append(dto.getName()).append("'");
        sb.append(" Where M_GroupCode+S_GroupCode='").append(dto.getMaingrouperpcode()).append(dto.getCode()).append("'");
    }

    public synchronized ResponseEntity<Map<String, Object>> postSideGroupList(String body, int insertType, boolean rebuildJson) {
        SideGroupDto[] sideGroupDtoArray;
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        try {
            if (rebuildJson) {
                JSONObject obj = new JSONObject(body);
                obj = ConvertStr.rebuildJsonObject((JSONObject)obj);
                JSONArray jsonArray = obj.getJSONArray("sidegroupinfo");
                body = jsonArray.toString();
            } else {
                body = body.substring(17, body.length() - 1);
            }
            Gson gson = new Gson();
            sideGroupDtoArray = (SideGroupDto[])gson.fromJson(body, SideGroupDto[].class);
        }
        catch (Exception ex) {
            TncException e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            failure.add(e.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"MainGroup", failure, success);
        }
        if ((myLogin.getIsMyHoloo().booleanValue() || myLogin.getIsTorfehNegar().booleanValue()) && sideGroupDtoArray.length > 0 && !ConvertStr.isNullOrEmpty((String)sideGroupDtoArray[0].getS_groupcode())) {
            return this.postSGroupListOnly(myLogin, sideGroupDtoArray, insertType);
        }
        return (ResponseEntity)this.dbConnection.getTransactionTemplate(myLogin).execute(status -> {
            StringBuilder sb = new StringBuilder();
            for (SideGroupDto dto : sideGroupDtoArray) {
                try {
                    dto.setInputid(dto.getId());
                    if (ConvertStr.isNullOrEmpty((String)dto.getName())) {
                        throw new TncException(TncExceptionMessages.EMPTY_SIDE_GROUP_NAME);
                    }
                    if (this.isUpdate(insertType)) {
                        dto.setCode(ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)dto.getErpcode())));
                        dto.setMaingrouperpcode(dto.getCode().substring(0, 2));
                        dto.setCode(dto.getCode().substring(2, 4));
                    } else {
                        dto.setMaingrouperpcode(ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)dto.getMaingrouperpcode())));
                    }
                    String sqlStr = "Select Count(*) cnt from M_Group Where m_Groupcode='" + dto.getMaingrouperpcode() + "'";
                    SqlRowSet rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rowSet.next()) {
                        if (rowSet.getInt("cnt") != 0) continue;
                        throw new TncException(TncExceptionMessages.INVALID_MAIN_GROUP_ERP_CODE);
                    }
                    sqlStr = "Select Count(*) cnt from S_Group where  S_groupname = '" + dto.getName() + "' and m_Groupcode='" + dto.getMaingrouperpcode() + "' and s_Groupcode<>'" + dto.getCode() + "'";
                    rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rowSet.next()) {
                        if (rowSet.getInt("cnt") <= 0) continue;
                        throw new TncException(TncExceptionMessages.DUPLICATE_SIDE_GROUP_NAME);
                    }
                    if (this.isUpdate(insertType)) {
                        sqlStr = "Select Count(*) cnt from S_Group Where m_Groupcode+s_groupcode='" + dto.getMaingrouperpcode() + dto.getCode() + "'";
                        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                        while (rowSet.next()) {
                            if (rowSet.getInt("cnt") != 0) continue;
                            throw new TncException(TncExceptionMessages.INVALID_SIDE_GROUP_ERP_CODE);
                        }
                    } else {
                        sqlStr = "declare @code int  exec RETURN_MAX_SGROUP @code output, '" + dto.getMaingrouperpcode() + "'\n select @code code";
                        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                        while (rowSet.next()) {
                            dto.setCode(rowSet.getString("code"));
                        }
                        if (ConvertStr.maxCodeReached((String)dto.getCode())) {
                            throw new TncException(TncExceptionMessages.MAIN_GROUP_CAPACITY_FILLED);
                        }
                        if (dto.getCode().length() < 2) {
                            dto.setCode(ConvertStr.produceCode((int)Integer.parseInt(dto.getCode()), (int)2));
                        }
                    }
                    sb.delete(0, sb.length());
                    if (this.isUpdate(insertType)) {
                        this.appendUpdateStatement(sb, dto);
                    } else {
                        sb = this.getInsertStatement();
                        sb.append("values ");
                        this.appendSelectStatement(sb, dto);
                    }
                    jdbcTemplate.execute(sb.toString());
                    IndustrialProductService industrialService = new IndustrialProductService(DbLogin.getInstance((DbConnection)this.dbConnection, (LoginDto)myLogin));
                    if (!this.isUpdate(insertType)) {
                        industrialService.insertSideGroupSarfasl(dto);
                    } else {
                        industrialService.updateSGroupSarfasl(dto);
                    }
                    LinkedHashMap<String, String> model = new LinkedHashMap<String, String>();
                    if (!ConvertStr.isNullOrEmpty((String)dto.getInputid())) {
                        model.put("Id", dto.getInputid());
                    }
                    model.put("ErpCode", ConvertStr.encrypt((String)(dto.getMaingrouperpcode() + dto.getCode())));
                    success.add(model);
                }
                catch (TncException e) {
                    if (!ConvertStr.isNullOrEmpty((String)dto.getInputid())) {
                        e.putMoreInfo("Id", (Object)dto.getInputid());
                    }
                    failure.add(e.getErrorMap());
                }
                catch (Exception e) {
                    TncException ex = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                    failure.add(ex.makeErrorWithCause((Throwable)e));
                }
            }
            return ConvertStr.getMapResponseEntity((String)"SideGroup", (List)failure, (List)success);
        });
    }

    private boolean isUpdate(int InsType) {
        return InsType == 1;
    }

    private ResponseEntity<Map<String, Object>> postSGroupListOnly(LoginDto myLogin, SideGroupDto[] sGroupDtoArray, int InsType) {
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        UnavailableACode unavailableCode = new UnavailableACode(myLogin);
        try {
            this.insertOrDeleteSGroup(myLogin, sGroupDtoArray, InsType, unavailableCode);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.makeErrorWithCause((Throwable)ex));
            return ConvertStr.getMapResponseEntity((String)"SideGroup", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        model.putAll(unavailableCode.getResultMap());
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"SideGroup", failure, success);
    }

    void insertOrDeleteSGroup(LoginDto myLogin, SideGroupDto[] sGroupDtoArray, int insType, UnavailableACode unavailableCode) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDataBaseName()).transactionDeadLockWrapper(() -> this.insertSGroup(myLogin, sGroupDtoArray, insType, unavailableCode), new String[]{"S_GROUP"});
        }
        catch (Exception ex) {
            this.deleteRepeatSGroup(myLogin, sGroupDtoArray);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteSGroup(myLogin, sGroupDtoArray, insType, unavailableCode);
            }
            throw ex;
        }
    }

    private void insertSGroup(LoginDto myLogin, SideGroupDto[] sGroupDtoArray, int insertType, UnavailableACode unavailableCode) {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        StringBuilder sb = new StringBuilder();
        MyHolooMessageMaker messageMaker = new MyHolooMessageMaker();
        String insert = this.getInsertStatement().append(" values ").toString();
        if (!this.isUpdate(insertType)) {
            sb.append(insert);
        }
        int counter = 0;
        for (SideGroupDto sGroup : sGroupDtoArray) {
            if (this.isUpdate(insertType)) {
                if (counter >= 50) {
                    jdbcTemplate.execute(sb.toString());
                    sb.delete(0, sb.length());
                    counter = 0;
                }
                sGroup.setMaingrouperpcode(sGroup.getS_groupcode().substring(0, 2));
                sGroup.setCode(sGroup.getS_groupcode().substring(2, 4));
                this.appendUpdateStatement(sb, sGroup);
            } else {
                counter = SideGroupDao.resetAndGetCounter((TncJdbc)jdbcTemplate, (StringBuilder)sb, (String)insert, (int)counter);
                sGroup.setMaingrouperpcode(sGroup.getS_groupcode().substring(0, 2));
                sGroup.setCode(sGroup.getS_groupcode().substring(2, 4));
                this.appendSelectStatement(sb, sGroup);
                sb.append(" , ");
                messageMaker.addIfAbsent(sGroup.getS_groupcode(), sGroup.getIsupdate());
            }
            ++counter;
        }
        if (!this.isUpdate(insertType)) {
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        jdbcTemplate.execute(sb.toString());
        unavailableCode.set(CallApi.callApiGetNotify((LoginDto)myLogin, (String)"S_Group", (int)(this.isUpdate(insertType) ? 1 : 0), (String)messageMaker.makeCodes(), (String)messageMaker.makeMessage("\u06af\u0631\u0648\u0647 \u0641\u0631\u0639\u06cc", this.isUpdate(insertType)), (String)"insertSGroup", (DbConnection)this.dbConnection));
    }

    private void deleteRepeatSGroup(LoginDto myLogin, SideGroupDto[] mGroupDtoArray) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDataBaseName()).transactionDeadLockWrapper(() -> {
            StringBuilder sGroupCode = new StringBuilder();
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
            int i = 0;
            while (i < mGroupDtoArray.length) {
                sGroupCode.delete(0, sGroupCode.length());
                sGroupCode.append("'").append(mGroupDtoArray[i].getS_groupcode()).append("'");
                ++i;
                for (int j = 0; j < 50 && i < mGroupDtoArray.length; ++j, ++i) {
                    sGroupCode.append(",'").append(mGroupDtoArray[i].getS_groupcode()).append("'");
                }
                jdbcTemplate.execute(" Delete S_Group Where M_GroupCode+S_GroupCode in (" + sGroupCode + ")");
            }
        }, new String[]{"S_GROUP"});
    }

    private String getFilter(HttpServletRequest request) {
        String sqlWhere = "";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        if (info.containsKey("erpcode")) {
            sqlWhere = sqlWhere + " Isnull(M.M_groupcode,0)+Isnull(S.S_groupcode,0) = '" + ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)((String)info.get("erpcode")))) + "'";
        }
        if (info.containsKey("maingrouperpcode")) {
            if (!"".equals(sqlWhere)) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(M.M_groupcode,0) = '" + ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)((String)info.get("maingrouperpcode")))) + "'";
        } else if (info.containsKey("mainerpcode")) {
            if (!"".equals(sqlWhere)) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(M.M_groupcode,0) = '" + ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)((String)info.get("mainerpcode")))) + "'";
        }
        if (info.containsKey("maingroupcode")) {
            if (!"".equals(sqlWhere)) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(M.M_groupcode,0) = '" + (String)info.get("maingroupcode") + "'";
        }
        if (info.containsKey("sidegroupcode")) {
            if (!"".equals(sqlWhere)) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(S.S_GROUPCODE, 0) = '" + (String)info.get("sidegroupcode") + "'";
        }
        if (!"".equals(sqlWhere)) {
            sqlWhere = " Where " + sqlWhere;
        }
        return sqlWhere;
    }
}

