/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dao.HolooSettingsDao;
import com.dto.LoginDto;
import com.dto.ProductDto;
import com.google.gson.Gson;
import com.service.product.IndustrialProductService;
import com.service.product.PoshakService;
import com.utility.CallApi;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.DbLogin;
import com.utility.MyHolooMessageMaker;
import com.utility.Paging;
import com.utility.SearchQuery;
import com.utility.TextNormalizer;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.utility.TncLog;
import com.utility.TransactionCheck;
import com.utility.UnavailableACode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class ProductDao {
    private final SearchQuery searchQuery = new SearchQuery();
    private final DbConnection dbConnection;
    private final HolooSettingsDao settingDao;
    private final TncLog log;
    private final PoshakService poshakService;
    private boolean getImage;

    public ProductDao(DbConnection dbConnection, HolooSettingsDao settingDao, TncLog log, PoshakService poshakService) {
        this.dbConnection = dbConnection;
        this.settingDao = settingDao;
        this.log = log;
        this.poshakService = poshakService;
    }

    public ResponseEntity<?> getProductList(HttpServletRequest request, int itemsPerPage, int page) {
        ResponseEntity response;
        String sqlWhere;
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        Paging paging = new Paging(itemsPerPage, page, "ARTICLE");
        String sessionId = myLogin.getDataBaseName() + " " + request.getSession().getId();
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        String paramACodes = info.getOrDefault("a_code", "");
        int paramSize = paramACodes.split(",").length;
        this.log.info("session: " + sessionId + " *** parameters: " + info);
        String sqlFields = myLogin.getIsMyHoloo() == false ? " Round(W.EXIST2, 3) FewKarton, Round(V.Exist, 3) FewSpd, Round(W.Exist, 3) FewTak, " : " Round(A.FewKarton, 3) FewKarton, Round(A.FewSpd, 3) FewSpd, Round(A.FewTak, 3) FewTak, ";
        String sqlStr = " SELECT A.A_Code_C Code, A.A_Name Name, Round(A.Exist, 3) Few, " + sqlFields + " Round(A.Buy_Price, 5) BuyPrice, \n Round(A.EndBuy_Price, 5) LastBuyPrice, Isnull(A.Sel_Price, 0) SellPrice, \n Isnull(A.Sel_Price2, 0) SellPrice2, Isnull(A.Sel_Price3, 0) SellPrice3, \n Isnull(A.Sel_Price4, 0) SellPrice4, Isnull(A.Sel_Price5, 0) SellPrice5, \n Isnull(A.Sel_Price6, 0) SellPrice6, Isnull(A.Sel_Price7, 0) SellPrice7, \n Isnull(A.Sel_Price8, 0) SellPrice8, Isnull(A.Sel_Price9, 0) SellPrice9, \n Isnull(A.Sel_Price10, 0) SellPrice10, A.KARTONSELPRICE SelPriceKarton, \n Isnull(A.karton, 0) CountInKarton, Isnull(A.Basteh, 0) CountInBasteh, \n M.M_groupname MainGroupName, M.M_GroupCode MainGroupErpCode, S.S_groupname SideGroupName, \n S.M_groupcode+S.S_groupcode SideGroupErpCode, S.S_GROUPCODE SideGroupCode, \n Isnull(A.vahedcode, 0) UnitErpCode, A.A_COUNTRY Producer,  dbo.MiladiToShamsi(A.FROMMODATDATE) EtebarTakhfifAz, dbo.MiladiToShamsi(A.TOMODATDATE) EtebarTakhfifTa,  A.Other1,A.Other2,A.Other3,A.Other4,A.Other5,A.Other6,A.Other7,A.Other8,A.Other9,A.Other10 , \n Isnull(A.DarsadTakhfif,0) DiscountPercent , Isnull(A.PriceTakhfif,0) DiscountPrice , \n A.A_Code ErpCode, A.A_Code, A.Attribute comment, A.IsActive, \n CONVERT(nvarchar(20), A.ModifyDate, 120) modifyDate \n FROM  ARTICLE A \n INNER JOIN M_GROUP M ON M.M_GROUPCODE = SUBSTRING(A.A_CODE, 1, 2) \n INNER JOIN S_GROUP S ON S.M_GROUPCODE = M.M_GROUPCODE AND \n       S.M_GROUPCODE + S.S_GROUPCODE = SUBSTRING(A.A_CODE, 1, 4) ";
        if (!myLogin.getIsMyHoloo().booleanValue()) {
            sqlStr = sqlStr + " LEFT JOIN W_GETEXISTARTICLE V ON V.A_CODE = A.A_CODE \n LEFT JOIN W_SHOWARTICLEFORSEARCH_BIG W ON W.A_CODE = A.A_CODE \n";
        }
        try {
            sqlWhere = this.getFilter(request);
        }
        catch (TncException e) {
            return ConvertStr.getMapResponseEntity((String)"product", new ArrayList(), (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
        }
        sqlStr = paging.makeSql(Paging.PageSqlData.builder().selectSqlStr(sqlStr).whereStr(sqlWhere).keyField("A_CODE").keyFieldType("nvarchar(8)").alias("A").build());
        List rowSet = this.getRowSet(jdbcTemplate, sqlStr);
        List rowSetImg = null;
        if (this.getImage) {
            sqlStr = " Select A.A_Code, P.PicturePath, P.Picture \n   From  HLOPictures P inner join Article A on p.code=a.a_code    inner join M_GROUP M on M.M_groupcode=Substring(A.A_Code,1,2)\n   inner join S_group S on S.M_groupcode=M.M_groupcode and \n            S.M_groupcode+S.S_groupcode=Substring(A.A_Code,1,4) " + sqlWhere;
            rowSetImg = jdbcTemplate.query(sqlStr, (rs, i) -> {
                LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
                String A_Code = rs.getString("A_Code");
                results.put("A_Code", A_Code);
                String PicturePath = rs.getString("PicturePath");
                results.put("PicturePath", ConvertStr.base64encodeNoLineBreak((byte[])ConvertStr.imageToBytes((String)PicturePath)));
                byte[] Picture = rs.getBytes("Picture");
                results.put("Picture", ConvertStr.base64encodeNoLineBreak((byte[])Picture));
                return results;
            });
        }
        sqlStr = " Select A.A_Code, P.PicturePath \n  From  HLOPictures P inner join Article A on p.code=a.a_code   inner join M_GROUP M on M.M_groupcode=Substring(A.A_Code,1,2)\n  inner join S_group S on S.M_groupcode=M.M_groupcode and \n        S.M_groupcode+S.S_groupcode=Substring(A.A_Code,1,4) " + sqlWhere;
        List imagePathMaps = jdbcTemplate.queryForList(sqlStr);
        sqlStr = "SELECT A.A_CODE, C.A_CODE_C\nFROM ARTICLECODES C\nINNER JOIN ARTICLE A ON A.A_CODE = C.A_CODE\nINNER JOIN M_GROUP M ON M.M_GROUPCODE=SUBSTRING(A.A_CODE,1,2)\nINNER JOIN S_GROUP S ON S.M_GROUPCODE=M.M_GROUPCODE AND\nS.M_GROUPCODE+S.S_GROUPCODE=SUBSTRING(A.A_CODE,1,4)" + sqlWhere;
        List rowSetMoreCodes = this.getRowSet(jdbcTemplate, sqlStr);
        Map poshakForAllACodes = this.poshakService.getPoshakListForProduct(sqlWhere, paging.isPagination() ? ConvertStr.commaBindStringsWithQuotes((Collection)rowSet.stream().map(map -> (String)map.get("A_Code")).collect(Collectors.toList())) : null);
        for (int i2 = 0; i2 < rowSet.size(); ++i2) {
            Object path2;
            Map map2 = (Map)rowSet.get(i2);
            Object aCode = map2.get("A_Code");
            map2.put("ErpCode", ConvertStr.encrypt((String)ConvertStr.getNullIfEmpty((String)aCode.toString())));
            String mainGroupCode = map2.get("MainGroupErpCode").toString();
            String sideGroupCode = map2.get("SideGroupErpCode").toString();
            if (myLogin.getIsMyHoloo().booleanValue()) {
                map2.put("MainGroupCode", mainGroupCode);
            } else if (!myLogin.getIsTorfehNegar().booleanValue()) {
                map2.remove("SideGroupCode");
            }
            if (myLogin.getIsTorfehNegar().booleanValue()) {
                map2.put("SideGroupCode", ConvertStr.encrypt((String)ConvertStr.getNullIfEmpty((String)map2.get("SideGroupCode").toString())));
            }
            map2.put("MainGroupErpCode", ConvertStr.encrypt((String)ConvertStr.getNullIfEmpty((String)mainGroupCode)));
            map2.put("SideGroupErpCode", ConvertStr.encrypt((String)ConvertStr.getNullIfEmpty((String)sideGroupCode)));
            if ((Integer)map2.get("UnitErpCode") > 0) {
                map2.put("UnitErpCode", ConvertStr.encrypt((String)ConvertStr.getNullIfEmpty((String)map2.get("UnitErpCode").toString())));
            }
            if (this.getImage) {
                ArrayList Imglist = new ArrayList();
                assert (rowSetImg != null);
                for (Map img : rowSetImg) {
                    if (!((String)img.get("A_Code")).equals(aCode.toString())) continue;
                    if (img.get("PicturePath") != null) {
                        Imglist.add(img.get("PicturePath"));
                        continue;
                    }
                    if (img.get("Picture") == null) continue;
                    Imglist.add(img.get("Picture"));
                }
                if (!Imglist.isEmpty()) {
                    map2.put("Image", Imglist);
                }
            }
            ArrayList<String> pathList = new ArrayList<String>();
            for (Object path2 : imagePathMaps) {
                if (!path2.get("A_Code").equals(aCode.toString()) || path2.get("PicturePath") == null) continue;
                pathList.add((String)path2.get("PicturePath"));
            }
            if (!pathList.isEmpty()) {
                map2.put("ImagePath", pathList);
            }
            ArrayList<String> codesList = new ArrayList<String>();
            path2 = rowSetMoreCodes.iterator();
            while (path2.hasNext()) {
                Map code = (Map)path2.next();
                if (!aCode.equals(code.get("A_CODE")) || code.get("A_CODE_C") == null) continue;
                codesList.add((String)code.get("A_CODE_C"));
            }
            if (!codesList.isEmpty()) {
                map2.put("MoreCodes", codesList);
            }
            map2.put("Poshak", poshakForAllACodes.get(String.valueOf(aCode)));
            List serials = jdbcTemplate.queryForList(" SELECT A_SERIAL FROM ANB_SER WHERE A_CODE = ?", String.class, new Object[]{aCode});
            if (!ConvertStr.isNullOrEmpty((Collection)serials)) {
                map2.put("serials", serials);
            }
            if (!myLogin.getIsMyHoloo().booleanValue()) {
                map2.remove("A_Code");
            }
            rowSet.set(i2, map2);
            if (!myLogin.getIsMyHoloo().booleanValue() || paramSize <= 0 || rowSet.size() >= paramSize) continue;
            String currentACode = String.valueOf(map2.get("A_Code"));
            paramACodes = paramACodes.replace(currentACode, "");
        }
        this.log.info("session: " + sessionId + " *** params size: " + paramSize);
        this.log.info("session: " + sessionId + " *** response size: " + rowSet.size());
        if (rowSet.size() < paramSize) {
            this.log.info("session: " + sessionId + " *** not available aCodes: " + paramACodes);
        }
        if (((List)((Map)Objects.requireNonNull((response = ConvertStr.getMapResponseEntity((String)"product", (List)rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request))).getBody())).get("product")).isEmpty()) {
            this.log.info("session: " + sessionId + " *** response: " + response);
        }
        return response;
    }

    List<Map<String, Object>> getRowSet(TncJdbc jdbcTemplate, String sqlStr) {
        return jdbcTemplate.queryForList(sqlStr);
    }

    public ResponseEntity<?> getProductCount(HttpServletRequest request) {
        LoginDto mylogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(mylogin);
        String sql = " SELECT COUNT(A_CODE) FROM ARTICLE A    INNER JOIN M_GROUP M ON M.M_GROUPCODE = SUBSTRING(A.A_CODE,1,2) \n   INNER JOIN S_GROUP S ON S.M_GROUPCODE = M.M_GROUPCODE AND \n           S.M_GROUPCODE + S.S_GROUPCODE = SUBSTRING(A.A_CODE,1,4) ";
        sql = sql + this.getFilter(request);
        Integer count = (Integer)jdbcTemplate.queryForObject(sql, Integer.class);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("totalCount", count == null ? 0 : count);
        return ResponseEntity.ok(map);
    }

    private StringBuilder getInsertStatement(boolean isMyHoloo) {
        StringBuilder sb = new StringBuilder();
        sb.append("Insert Into Article(").append("A_Code,A_Code_C,A_Name,Attribute,Model,Exist,Exist2,Buy_Price,First_Exist,First_Exist2,FirstBuy_Price,").append("EndBuy_Price, DarsadTakhfif, PriceTakhfif, Sel_Price,Sel_Price2,Sel_Price3,Sel_Price4,Sel_Price5,Sel_Price6,").append("Sel_Price7,Sel_Price8,Sel_Price9,Sel_Price10,KartonSelPrice,Include_Tax,levy,scot,karton,basteh,VahedCode,DarsadForush2,DarsadForush3,DarsadForush4,").append("DarsadForush5,DarsadForush6,DarsadForush7,DarsadForush8,DarsadForush9,DarsadForush10,Finish_Date,Creation_date,A_Min,A_Max,").append("Other1,Other2,Other3,Other4,Other5,Other6,Other7,Other8,Other9,Other10,WebId, Type_Anbar_C");
        if (isMyHoloo) {
            sb.append(", FewKarton, FewTak, FewSpd)");
        } else {
            sb.append(")");
        }
        return sb;
    }

    private void appendSelectStatement(StringBuilder sb, ProductDto p, boolean isMyHoloo) {
        String WebId = "0";
        if (!ConvertStr.isNullOrEmpty((String)p.getInputid())) {
            WebId = p.getInputid();
        }
        sb.append(" ( ").append("'").append(p.getId()).append("',").append(ConvertStr.getNullableStrSqlField((String)p.getCode())).append(",").append("'").append(p.getName()).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getComment())).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getModel())).append("',").append(p.getFew()).append(",").append(p.getFewkarton() != null ? p.getFewkarton() : 0.0).append(",").append(p.getBuyprice()).append(",").append(p.getFirstfew()).append(",").append(p.getFirstfewkarton()).append(",").append(p.getFirstbuyprice()).append(",").append(p.getLastbuyprice() != null ? p.getLastbuyprice() : 0.0).append(",").append(p.getDiscountpercent() != null ? p.getDiscountpercent() : 0.0).append(",").append(p.getDiscountprice() != null ? p.getDiscountprice() : 0.0).append(",").append(p.getSellprice()).append(",").append(p.getSellprice2()).append(",").append(p.getSellprice3()).append(",").append(p.getSellprice4()).append(",").append(p.getSellprice5()).append(",").append(p.getSellprice6()).append(",").append(p.getSellprice7()).append(",").append(p.getSellprice8()).append(",").append(p.getSellprice9()).append(",").append(p.getSellprice10()).append(",").append(p.getSelpricekarton() != null ? p.getSelpricekarton() : 0.0).append(",").append(ConvertStr.getBoolToInt((Boolean)p.getIncludetax())).append(",").append(p.getLevy()).append(",").append(p.getScot()).append(",").append(p.getCountinkarton()).append(",").append(p.getCountinbasteh()).append(",").append(p.getUnitid()).append(",").append("Null,Null,Null,Null,Null,Null,Null,Null,Null,").append("GetDate(),").append("GetDate(),").append(p.getMinfew()).append(",").append(p.getMaxfew()).append(",").append("'").append(ConvertStr.nullSafeString((String)p.getOther1())).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getOther2())).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getOther3())).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getOther4())).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getOther5())).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getOther6())).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getOther7())).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getOther8())).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getOther9())).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getOther10())).append("',").append(WebId).append(",").append(p.getWarehousetype());
        if (isMyHoloo) {
            sb.append(", ").append(p.getFewkarton()).append(",").append(p.getFewtak()).append(",").append(p.getFewspd());
        }
        sb.append(" ) ");
    }

    private void appendUpdateStatement(StringBuilder sb, ProductDto p) {
        String webId = p.getInputid() == null ? "0" : p.getInputid();
        sb.append("Update Article Set WebId='").append(webId).append("'");
        if (p.getCode() != null) {
            sb.append(" ,A_Code_C = '").append(p.getCode()).append("'");
        }
        if (p.getName() != null) {
            sb.append(" ,A_Name = '").append(p.getName()).append("'");
        }
        if (p.getProducer() != null) {
            sb.append(" ,A_Country = '").append(p.getProducer()).append("'");
        }
        if (p.getSellprice() != null) {
            sb.append(",Sel_Price=").append(p.getSellprice());
        }
        if (p.getSellprice2() != null) {
            sb.append(",Sel_Price2=").append(p.getSellprice2());
        }
        if (p.getSellprice3() != null) {
            sb.append(",Sel_Price3=").append(p.getSellprice3());
        }
        if (p.getSellprice4() != null) {
            sb.append(",Sel_Price4=").append(p.getSellprice4());
        }
        if (p.getSellprice5() != null) {
            sb.append(",Sel_Price5=").append(p.getSellprice5());
        }
        if (p.getSellprice6() != null) {
            sb.append(",Sel_Price6=").append(p.getSellprice6());
        }
        if (p.getSellprice7() != null) {
            sb.append(",Sel_Price7=").append(p.getSellprice7());
        }
        if (p.getSellprice8() != null) {
            sb.append(",Sel_Price8=").append(p.getSellprice8());
        }
        if (p.getSellprice9() != null) {
            sb.append(",Sel_Price9=").append(p.getSellprice9());
        }
        if (p.getSellprice10() != null) {
            sb.append(",Sel_Price10=").append(p.getSellprice10());
        }
        if (p.getSelpricekarton() != null) {
            sb.append(",KartonSelPrice=").append(p.getSelpricekarton());
        }
        if (p.getFirstfew() != null) {
            sb.append(",First_Exist=").append(p.getFirstfew());
        }
        if (p.getFirstfewkarton() != null) {
            sb.append(",First_Exist2=").append(p.getFirstfewkarton());
        }
        if (p.getFew() != null) {
            sb.append(",EXIST=").append(p.getFew());
        }
        if (p.getFewkarton() != null) {
            sb.append(",EXIST2=").append(p.getFewkarton());
        }
        if (p.getDiscountpercent() != null) {
            sb.append(",DarsadTakhfif=").append(p.getDiscountpercent());
        }
        if (p.getDiscountprice() != null) {
            sb.append(",PriceTakhfif=").append(p.getDiscountprice());
        }
        if (p.getLastbuyprice() != null) {
            sb.append(",EndBuy_Price=").append(p.getLastbuyprice());
        }
        if (p.getDiscountmodatfrom() != null) {
            sb.append(",FromModatDate='").append(p.getDiscountmodatfrom()).append("'");
        }
        if (p.getDiscountmodatto() != null) {
            sb.append(",ToModatDate='").append(p.getDiscountmodatto()).append("'");
        }
        if (p.getCountinkarton() != null) {
            sb.append(",Karton =").append(p.getCountinkarton());
        }
        if (p.getCountinbasteh() != null) {
            sb.append(",Basteh =").append(p.getCountinbasteh());
        }
        if (p.getUniterpcode() != null) {
            sb.append(",VahedCode =").append(p.getUnitid());
        }
        if (p.getWarehousetype() != null) {
            sb.append(",Type_Anbar_C =").append(p.getWarehousetype());
        }
        sb.append(" Where A_Code='").append(p.getId()).append("'");
    }

    public synchronized ResponseEntity<Map<String, Object>> postProductList(String body, int insertType, boolean rebuildJson) {
        ProductDto[] productDtoArray;
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        double levy = this.settingDao.getMSetup2Float(myLogin, "FEditDarsad_Malyat");
        double scot = this.settingDao.getMSetup2Float(myLogin, "FEditDarsad_Avarez");
        boolean hasFirstExist = false;
        try {
            if (rebuildJson) {
                JSONObject obj = new JSONObject(body);
                obj = ConvertStr.rebuildJsonObject((JSONObject)obj);
                JSONArray jsonArray = obj.getJSONArray("productinfo");
                body = jsonArray.toString();
            } else {
                body = body.substring(15, body.length() - 1);
            }
            Gson gson = new Gson();
            productDtoArray = (ProductDto[])gson.fromJson(body, ProductDto[].class);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            failure.add(exception.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Product", failure, success);
        }
        if (myLogin.getIsMyHoloo().booleanValue() && productDtoArray.length > 0 && !ConvertStr.isNullOrEmpty((String)productDtoArray[0].getA_code())) {
            return this.postProductListOnly(myLogin, productDtoArray, insertType);
        }
        StringBuilder sb = new StringBuilder();
        for (ProductDto dto : productDtoArray) {
            try {
                SqlRowSet rowSet;
                String sqlStr;
                dto.setInputid(dto.getId());
                if (dto.getLevy() == null) {
                    dto.setLevy(Double.valueOf(levy));
                }
                if (dto.getScot() == null) {
                    dto.setScot(Double.valueOf(scot));
                }
                if (dto.getIncludetax() == null) {
                    dto.setIncludetax(Boolean.valueOf(true));
                }
                if (dto.getFirstbuyprice() == null && dto.getBuyprice() != null) {
                    dto.setFirstbuyprice(dto.getBuyprice());
                }
                if (dto.getLastbuyprice() == null && dto.getBuyprice() != null) {
                    dto.setLastbuyprice(dto.getBuyprice());
                }
                if (dto.getDiscountpercent() == null && !this.isUpdate(insertType)) {
                    dto.setDiscountpercent(Double.valueOf(0.0));
                }
                if (dto.getDiscountprice() == null && !this.isUpdate(insertType)) {
                    dto.setDiscountprice(Double.valueOf(0.0));
                }
                if (dto.getFirstfew() == null && dto.getFew() != null) {
                    dto.setFirstfew(dto.getFew());
                }
                if (dto.getFirstfewkarton() == null && dto.getFewkarton() != null) {
                    dto.setFirstfewkarton(dto.getFewkarton());
                }
                IndustrialProductService industrialService = new IndustrialProductService(DbLogin.getInstance((DbConnection)this.dbConnection, (LoginDto)myLogin));
                if (this.isUpdate(insertType)) {
                    dto.setId(ConvertStr.decrypt((String)dto.getErpcode()));
                    sqlStr = "Select Count(*) cnt from Article Where A_Code = '" + dto.getId() + "'";
                    rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                    if (rowSet.next() && rowSet.getInt("cnt") == 0) {
                        throw new TncException(TncExceptionMessages.INVALID_PRODUCT_ERP_CODE);
                    }
                    dto.setFew(null);
                    dto.setFewkarton(null);
                    if (dto.getFirstfew() != null || dto.getFirstfewkarton() != null) {
                        sqlStr = " SELECT ISNULL(FIRST_EXIST, 0) FEXIST, ISNULL(FIRST_EXIST2, 0) FEXIST2, ISNULL(EXIST, 0) FEW, ISNULL(EXIST2, 0) FEWKARTON FROM ARTICLE WHERE A_CODE='" + dto.getId() + "'";
                        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                        while (rowSet.next()) {
                            double firstExist = rowSet.getDouble("FEXIST");
                            double firstExist2 = rowSet.getDouble("FEXIST2");
                            dto.setFirstfew(Double.valueOf(dto.getFirstfew() == null ? firstExist : dto.getFirstfew()));
                            dto.setFirstfewkarton(Double.valueOf(dto.getFirstfewkarton() == null ? firstExist2 : dto.getFirstfewkarton()));
                            double exist = dto.getFirstfew() - firstExist;
                            dto.setFew(Double.valueOf(rowSet.getDouble("FEW") + exist));
                            double existBox = dto.getFirstfewkarton() - firstExist2;
                            dto.setFewkarton(Double.valueOf(rowSet.getDouble("FEWKARTON") + existBox));
                        }
                    }
                    if (dto.getWarehousetype() != null) {
                        industrialService.checkWarehouseTypeValidity(dto.getWarehousetype());
                    }
                } else {
                    String sideGroupId = myLogin.getIsMyHoloo() == false ? ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)dto.getSidegrouperpcode())) : dto.getSidegroupid();
                    dto.setSidegroupid(sideGroupId);
                    sqlStr = "Select Count(*) cnt From S_Group  Where M_GroupCode + S_groupCode = '" + dto.getSidegroupid() + "'";
                    rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rowSet.next()) {
                        if (rowSet.getInt("cnt") != 0) continue;
                        throw new TncException(TncExceptionMessages.INVALID_SIDE_GROUP_ERP_CODE);
                    }
                    dto.setMaingroupid(dto.getSidegroupid().substring(0, 2));
                    dto.setSidegroupid(dto.getSidegroupid().substring(2, 4));
                    String maxACode = "0";
                    sqlStr = "exec Sp_Createpropera_code '" + dto.getMaingroupid() + "','" + dto.getSidegroupid() + "'";
                    rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rowSet.next()) {
                        maxACode = rowSet.getString("C");
                    }
                    assert (maxACode != null);
                    if (ConvertStr.maxCodeReached((String)maxACode)) {
                        throw new TncException(TncExceptionMessages.REACHED_MAX_PRODUCT_FOR_THIS_GROUP);
                    }
                    if (maxACode.length() < 3) {
                        dto.setId(dto.getMaingroupid() + dto.getSidegroupid() + ConvertStr.produceCode((int)ConvertStr.parseNullSafeInt((String)maxACode), (int)3));
                    } else {
                        dto.setId(dto.getMaingroupid() + dto.getSidegroupid() + maxACode);
                    }
                    dto.setWarehousetype(industrialService.getWarehouseType(dto.getMaingroupid()));
                }
                if (!this.isUpdate(insertType) && ConvertStr.isNullOrEmpty((String)dto.getName())) {
                    throw new TncException(TncExceptionMessages.EMPTY_PRODUCT_NAME);
                }
                if (!myLogin.getIsMyHoloo().booleanValue() && !ConvertStr.isNullOrEmpty((String)dto.getUniterpcode())) {
                    dto.setUnitid(ConvertStr.decrypt((String)dto.getUniterpcode()));
                }
                if (!ConvertStr.isNullOrEmpty((String)dto.getUnitid())) {
                    sqlStr = "Select Count(*)cnt From Unit  Where cast(Unit_Code as nvarchar(5))='" + dto.getUnitid() + "'";
                    rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rowSet.next()) {
                        if (rowSet.getInt("cnt") != 0) continue;
                        throw new TncException(TncExceptionMessages.INVALID_UNIT_ERP_CODE);
                    }
                }
                if (dto.getDiscountmodatfrom() != null && dto.getDiscountmodatfrom().length() != 10 || dto.getDiscountmodatto() != null && dto.getDiscountmodatto().length() != 10) {
                    throw new TncException(TncExceptionMessages.INVALID_DATE);
                }
                sb.delete(0, sb.length());
                if (this.isUpdate(insertType)) {
                    this.appendUpdateStatement(sb, dto);
                    sb.append(dto.getDeleteMoreCodesSql());
                } else {
                    sb = this.getInsertStatement(myLogin.getIsMyHoloo().booleanValue());
                    sb.append(" values ");
                    this.appendSelectStatement(sb, dto, myLogin.getIsMyHoloo().booleanValue());
                }
                sb.append(dto.getInsertMoreCodesSql());
                try {
                    StringBuilder finalSb = sb;
                    this.dbConnection.getTransactionTemplate(myLogin).executeWithoutResult(transactionStatus -> {
                        jdbcTemplate.execute(finalSb.toString());
                        if (!this.isUpdate(insertType)) {
                            this.insertPicturePaths((JdbcTemplate)jdbcTemplate, dto);
                            industrialService.insertProductSarfasl(dto);
                        } else {
                            industrialService.updateProductSarfasl(dto);
                        }
                    });
                }
                catch (Exception ex) {
                    TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                    Map model = exception.getErrorMap();
                    model.put("Error", exception.getMessage() + "\n" + ex.getCause());
                    failure.add(model);
                }
                if (insertType == 0 && dto.getFew() != null || dto.getBuyprice() != null) {
                    hasFirstExist = true;
                }
                LinkedHashMap<String, String> model = new LinkedHashMap<String, String>();
                if (!ConvertStr.isNullOrEmpty((String)dto.getInputid())) {
                    model.put("Id", dto.getInputid());
                }
                model.put("ErpCode", ConvertStr.encrypt((String)String.valueOf(dto.getId())));
                success.add(model);
            }
            catch (TncException e) {
                if (!ConvertStr.isNullOrEmpty((String)dto.getInputid())) {
                    e.putMoreInfo("Id", (Object)dto.getInputid());
                }
                failure.add(e.getErrorMap());
            }
        }
        if (hasFirstExist) {
            this.updateFirstExistProduct((JdbcTemplate)jdbcTemplate);
        }
        return ConvertStr.getMapResponseEntity((String)"Product", failure, success);
    }

    private void insertPicturePaths(JdbcTemplate jdbcTemplate, ProductDto dto) {
        if (ConvertStr.isNullOrEmpty((Collection)dto.getImagepath())) {
            return;
        }
        String sql = " INSERT INTO HLOPICTURES ([CODE], [PICTURE], [TYPE], [PICTUREPATH]) VALUES";
        StringBuilder sb = new StringBuilder();
        for (Map path : dto.getImagepath()) {
            sb.append("('").append(dto.getId()).append("', '0', 1, '").append(((String)path.get("path")).replace("\\", "/")).append("'),");
        }
        jdbcTemplate.update(sql + ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)sb, (String)","));
    }

    private synchronized ResponseEntity<Map<String, Object>> postProductListOnly(LoginDto myLogin, ProductDto[] productDtoArray, int insertType) {
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        UnavailableACode unavailableACode = new UnavailableACode(myLogin);
        try {
            this.insertOrDeleteArticle(myLogin, productDtoArray, insertType, unavailableACode);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.makeErrorWithCause((Throwable)ex));
            return ConvertStr.getMapResponseEntity((String)"Product", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        model.putAll(unavailableACode.getResultMap());
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"Product", failure, success);
    }

    synchronized void insertOrDeleteArticle(LoginDto myLogin, ProductDto[] productDtoArray, int insertType, UnavailableACode unavailableACode) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDataBaseName()).transactionDeadLockWrapper(() -> this.insertProduct(myLogin, productDtoArray, insertType, unavailableACode), new String[]{"ARTICLE"});
        }
        catch (Exception ex) {
            this.log.info("dbName: " + myLogin.getDataBaseName() + "insert article error: " + ex);
            this.deleteRepeatArticle(myLogin, productDtoArray);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteArticle(myLogin, productDtoArray, insertType, unavailableACode);
            }
            throw ex;
        }
    }

    private synchronized void insertProduct(LoginDto myLogin, ProductDto[] productDtoArray, int insertType, UnavailableACode unavailableACode) {
        boolean hasFirstExist = false;
        MyHolooMessageMaker messageMaker = new MyHolooMessageMaker();
        String insert = this.getInsertStatement(myLogin.getIsMyHoloo().booleanValue()).append(" values ").toString();
        TncJdbc tncJdbc = this.dbConnection.getJdbcTemplate(myLogin);
        StringBuilder sb = new StringBuilder();
        if (!this.isUpdate(insertType)) {
            sb.append(insert);
        }
        int counter = 0;
        for (ProductDto product : productDtoArray) {
            if (this.isUpdate(insertType)) {
                if (counter >= 50) {
                    tncJdbc.execute(sb.toString());
                    sb.delete(0, sb.length());
                    counter = 0;
                }
                product.setId(product.getA_code());
                this.appendUpdateStatement(sb, product);
            } else {
                if (counter >= 50) {
                    sb.deleteCharAt(sb.lastIndexOf(","));
                    tncJdbc.execute(sb.toString());
                    this.log.info("dbName: " + myLogin.getDataBaseName() + " - insert article: " + sb);
                    sb.delete(0, sb.length());
                    sb.append(insert);
                    counter = 0;
                }
                product.setId(product.getA_code());
                if (product.getFew() != null || product.getBuyprice() != null) {
                    hasFirstExist = true;
                }
                this.appendSelectStatement(sb, product, myLogin.getIsMyHoloo().booleanValue());
                sb.append(" , ");
                messageMaker.addIfAbsent(product.getA_code(), product.getIsupdate());
            }
            ++counter;
        }
        if (!this.isUpdate(insertType)) {
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        tncJdbc.execute(sb.toString());
        this.log.info("dbName: " + myLogin.getDataBaseName() + " - insert article: " + sb);
        if (hasFirstExist) {
            this.updateFirstExistProduct((JdbcTemplate)tncJdbc);
        }
        String codes = messageMaker.makeCodes();
        unavailableACode.set(CallApi.callApiGetNotify((LoginDto)myLogin, (String)"Article", (int)(this.isUpdate(insertType) ? 1 : 0), (String)codes, (String)messageMaker.makeMessage("\u06a9\u0627\u0644\u0627", this.isUpdate(insertType)), (String)"insertProduct", (DbConnection)this.dbConnection));
    }

    private boolean isUpdate(int insertType) {
        return insertType == 1;
    }

    private void updateFirstExistProduct(JdbcTemplate jdbcTemplate) {
        String sqlStr = "if Not Exists(Select Col_Code From SND_LIST Where Col_Code=106 and OldSCode = 1) And (Select  Isnull(sum(First_exist*FirstBuy_Price),0) From Article where First_exist<>0 and  FirstBuy_Price<>0 and Model<> '#*Not_Article*#' )>=0 INSERT INTO SND_LIST(Sanad_Code ,Col_Code,Moien_Code,Tafzili_Code ,Bed ,Bes ,Show_Daftar,Joze, Type_line, Actions, Comment_Line, Number_Line, OldSCode) Select 1 , '106' , '' , '' ,(Select  Isnull(sum(First_exist*FirstBuy_Price),0) From Article where First_exist<>0 and FirstBuy_Price<>0 and Model<> '#*Not_Article*#' ),0.0 ,1, 0,'',0,'\u0633\u0646\u062f \u0627\u0641\u062a\u062a\u0627\u062d\u064a\u0647', Null,1 if Not Exists(Select Col_Code From SND_LIST Where Col_Code=106 and OldSCode =2 ) And (Select Isnull(sum(First_exist*FirstBuy_Price),0) From Article where First_exist<>0 and  FirstBuy_Price<>0 and Model<> '#*Not_Article*#' )<0   Begin  if (Select COUNT(*) From Sanad Where Sanad_state=1)= 1     Insert Into SND_LIST(Sanad_Code ,Col_Code,Moien_Code,Tafzili_Code ,Bed ,Bes,   Show_Daftar, Joze, Type_line, Actions, Comment_Line, Number_Line, OldSCode)   Select 1 , '106' , '' , '',0 ,(Select  ABS(Isnull(sum(First_exist*FirstBuy_Price),0)) From Article where First_exist<>0 and  FirstBuy_Price<>0 and Model<> '#*Not_Article*#' ), 1, 0, '',0, '\u0633\u0646\u062f \u0627\u0641\u062a\u062a\u0627\u062d\u064a\u0647', Null, 2   if (Select COUNT(*) From Sanad Where Sanad_state=1)= 2    Insert Into SND_LIST(Sanad_Code ,Col_Code, Moien_Code, Tafzili_Code ,Bed ,Bes,   Show_Daftar, Joze, Type_line, Actions, Comment_Line, Number_Line, OldSCode)   Select 2 , '106' , '' , '',0 ,(Select  ABS(Isnull(sum(First_exist*FirstBuy_Price),0)) From Article where First_exist<>0 and  FirstBuy_Price<>0 and Model<> '#*Not_Article*#' ),1, 0,'',0,'\u0633\u0646\u062f \u0627\u0641\u062a\u062a\u0627\u062d\u064a\u0647', Null,2  END ";
        jdbcTemplate.execute("Delete Snd_List Where Col_Code = '106'  And Sanad_Code in (Select Sanad_code from sanad  Where Sanad_State = 1)");
        jdbcTemplate.execute(sqlStr);
        jdbcTemplate.execute("Update Msetup2 Set Boolean = 0 Where Name='BalancEftetahieh' ");
    }

    private void deleteRepeatArticle(LoginDto loginDto, ProductDto[] productDtos) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)loginDto.getDataBaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(loginDto);
            int i = 0;
            while (i < productDtos.length) {
                StringBuilder aCode = new StringBuilder("'" + productDtos[i].getA_code() + "'");
                ++i;
                for (int j = 0; j < 50 && i < productDtos.length; ++j, ++i) {
                    aCode.append(",'").append(productDtos[i].getA_code()).append("'");
                }
                jdbcTemplate.execute(" Delete Article Where A_Code in (" + aCode + ")");
            }
        }, new String[]{"ARTICLE"});
    }

    private String getFilter(HttpServletRequest request) {
        String poshakIdConcat;
        String pSql;
        String sqlWhere = "";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        if (info.containsKey("code")) {
            String code = (String)info.get("code");
            if (!code.contains(",")) {
                sqlWhere = sqlWhere + " Isnull(A.A_code_C,'') = '" + code + "'";
            } else {
                code = code.replaceAll(",", "','");
                sqlWhere = sqlWhere + " Isnull(A.A_code_C,'') in ('" + code + "')";
            }
        }
        if (info.containsKey("code.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(A.A_code_C,'') >= '" + (String)info.get("code.from") + "'";
        }
        if (info.containsKey("code.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(A.A_code_C,'') <= '" + (String)info.get("code.to") + "'";
        }
        if (info.containsKey("name")) {
            String name = (String)info.get("name");
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + this.searchQuery.makeSqlQuery(name, "A_NAME", "A", "ARTICLE");
        }
        if (info.containsKey("date.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " A.ModifyDate >= '" + (String)info.get("date.from") + "'";
        }
        if (info.containsKey("date.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " A.ModifyDate <= '" + (String)info.get("date.to") + "'";
        }
        if (info.containsKey("time.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " CONVERT(time,A.ModifyDate,108)>=CONVERT(time,'" + (String)info.get("time.from") + "',108)";
        }
        if (info.containsKey("time.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " CONVERT(time,A.ModifyDate,108)<=CONVERT(time,'" + (String)info.get("time.to") + "',108)";
        }
        if (info.containsKey("productmainerpcode")) {
            pSql = (String)info.get("productmainerpcode");
            pSql = ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)pSql));
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(M.M_groupcode,0) = '" + pSql + "'";
        } else if (info.containsKey("maingrouperpcode")) {
            pSql = (String)info.get("maingrouperpcode");
            pSql = ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)pSql));
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(M.M_groupcode,0) = '" + pSql + "'";
        }
        if (info.containsKey("productsideerpcode")) {
            pSql = (String)info.get("productsideerpcode");
            pSql = ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)pSql));
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(S.M_groupcode+S.S_groupcode,0) = '" + pSql + "'";
        } else if (info.containsKey("sidegrouperpcode")) {
            pSql = (String)info.get("sidegrouperpcode");
            pSql = ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)pSql));
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(S.M_groupcode+S.S_groupcode,0) = '" + pSql + "'";
        }
        if (info.containsKey("condition")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = "( " + sqlWhere + ") And ";
            }
            sqlWhere = sqlWhere + " ( " + (String)info.get("condition") + ")";
        }
        if (info.containsKey("erpcode")) {
            String erpCode;
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            if (!(erpCode = (String)info.get("erpcode")).contains(",")) {
                sqlWhere = sqlWhere + " A.A_Code = '" + ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)erpCode)) + "'";
            } else {
                String[] erpCodes = erpCode.split(",");
                StringBuilder codeBuilder = new StringBuilder();
                for (String code : erpCodes) {
                    codeBuilder.append("'").append(ConvertStr.decrypt((String)code)).append("',");
                }
                codeBuilder.deleteCharAt(codeBuilder.lastIndexOf(","));
                sqlWhere = sqlWhere + " A.A_Code in (" + codeBuilder + ")";
            }
        }
        if (info.containsKey("a_code")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            String aCode = (String)info.get("a_code");
            sqlWhere = sqlWhere + this.searchQuery.makeSqlQueryNoTextSearch(aCode, "A_CODE", "A");
        }
        if (info.containsKey("a_code.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " A.A_code >= '" + (String)info.get("a_code.from") + "'";
        }
        if (info.containsKey("a_code.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " A.A_code <= '" + (String)info.get("a_code.to") + "'";
        }
        if (info.containsKey("maingroupcode")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            String mainGroupCode = (String)info.get("maingroupcode");
            sqlWhere = sqlWhere + this.searchQuery.makeSqlQueryNoTextSearch(mainGroupCode, "M_GroupCode", "M");
        }
        if (info.containsKey("sidegroupcode")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            String sideGroupCode = (String)info.get("sidegroupcode");
            sqlWhere = sqlWhere + this.searchQuery.makeSqlQueryNoTextSearch(sideGroupCode, "S_GROUPCODE", "S");
        }
        if (info.containsKey("levelid")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            poshakIdConcat = ConvertStr.commaBindStringsWithQuotes(Arrays.asList(((String)info.get("levelid")).split(",")));
            sqlWhere = sqlWhere + " A.A_CODE IN (SELECT A_CODE FROM ItemArticle WHERE PoshakID IN (" + poshakIdConcat + "))";
        }
        if (info.containsKey("poshakid")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            poshakIdConcat = ConvertStr.commaBindStringsWithQuotes(Arrays.asList(((String)info.get("poshakid")).split(",")));
            sqlWhere = sqlWhere + " A.A_CODE IN (SELECT A_CODE FROM ItemArticle WHERE PoshakID IN (" + poshakIdConcat + "))";
        }
        this.getImage = false;
        if (info.containsKey("getimage")) {
            this.getImage = Boolean.parseBoolean((String)info.get("getimage"));
        }
        if (!sqlWhere.isEmpty()) {
            sqlWhere = " Where " + sqlWhere;
        }
        return sqlWhere;
    }
}

