/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dao.HolooSettingsDao;
import com.dto.CheckDto;
import com.dto.LoginDto;
import com.dto.PaymentDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class CheckDao {
    private final TncJdbc jdbc;
    private final LoginDto login;
    private final HolooSettingsDao settingsDao;
    private final boolean duplicateChecksNotAllowed;

    public CheckDao(DbConnection dbConnection, LoginDto login) {
        this.jdbc = dbConnection.getJdbcTemplate(login);
        this.login = login;
        this.settingsDao = new HolooSettingsDao(dbConnection);
        this.duplicateChecksNotAllowed = this.settingsDao.getMSetup2Boolean(login, "ChkNo_Tekrari");
    }

    public void findCheckErrors(PaymentDto payment) throws TncException {
        if (ConvertStr.isNullOrEmpty((Collection)payment.getChecks()) || payment.checksNotAllowed()) {
            return;
        }
        CheckDto duplicateCheck = payment.thereIsDuplicateCheckNumber();
        if (duplicateCheck != null && this.duplicateChecksNotAllowed) {
            throw new TncException(TncExceptionMessages.DUPLICATE_CHECKS_ENTERED.setArgs(new Object[]{duplicateCheck.getAccountnumber(), duplicateCheck.getChecknumber()}));
        }
        for (CheckDto check : payment.getChecks()) {
            this.checkForErrors(check, payment);
        }
    }

    public void insertChecks(PaymentDto payment) {
        if (ConvertStr.isNullOrEmpty((Collection)payment.getChecks()) || payment.checksNotAllowed()) {
            return;
        }
        if (!this.settingsDao.getMSetup2Boolean(this.login, "UseNewCheck")) {
            return;
        }
        ArrayList<String> checkCodes = new ArrayList<String>();
        for (CheckDto check : payment.getChecks()) {
            this.setCheckData(check, payment);
            checkCodes.add(this.insertCheck(check));
        }
        String comment = this.makeComment(checkCodes, payment.isReceive());
        if (comment != null) {
            this.jdbc.update(" UPDATE SANAD SET COMMENT = " + ConvertStr.getNullableStrSqlField((String)comment) + " WHERE SANAD_CODE = ?", new Object[]{payment.getFixsanadcode()});
        }
    }

    private void checkForErrors(CheckDto check, PaymentDto payment) throws TncException {
        if (ConvertStr.isNullOrEmpty((String)check.getAccountnumber())) {
            throw new TncException(TncExceptionMessages.INVALID_ACCOUNT_NUMBER);
        }
        if (ConvertStr.isNullOrEmpty((String)check.getChecknumber())) {
            throw new TncException(TncExceptionMessages.INVALID_CHECK_NUMBER);
        }
        if (ConvertStr.isNullOrEmpty((String)check.getBankcode())) {
            throw new TncException(TncExceptionMessages.INVALID_BANK_CODE);
        }
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT COUNT(*) FROM [NewBank] WHERE BANK_CODE = ?", new Object[]{check.getBankcode()});
        if (!rs.next()) {
            throw new TncException(TncExceptionMessages.INVALID_BANK_CODE);
        }
        if (this.duplicateChecksNotAllowed && (rs = this.jdbc.queryForRowSet("SELECT COUNT(*) cnt FROM [CHECK] WHERE ACCOUNT_NUMBER = ? AND\n CHECK_NUMBER = ? AND BANK_CODE = ? ", new Object[]{check.getAccountnumber(), check.getChecknumber(), check.getBankcode()})).next() && rs.getInt("cnt") > 0) {
            throw new TncException(TncExceptionMessages.DUPLICATE_CHECK_NUMBERS_FOR_ACCOUNT.setArgs(new Object[]{check.getAccountnumber(), check.getChecknumber(), "(\u0686\u06a9)"}));
        }
        if (payment.isReceive()) {
            this.checkReceiveErrors(check, payment);
        } else {
            this.checkPaymentErrors(check);
        }
        if (ConvertStr.isNullOrEmpty((String)check.getExportdate()) || check.getExportdate().length() != 10) {
            throw new TncException(TncExceptionMessages.INVALID_DATE);
        }
        if (ConvertStr.isNullOrEmpty((String)check.getReceivedate()) || check.getReceivedate().length() != 10) {
            throw new TncException(TncExceptionMessages.INVALID_DATE);
        }
        if (check.getCust() <= 0.0) {
            throw new TncException(TncExceptionMessages.UNSPECIFIED_PRICE);
        }
    }

    private void checkReceiveErrors(CheckDto check, PaymentDto payment) throws TncException {
        if (ConvertStr.isNullOrEmpty((String)payment.getVaultcashsarfasl())) {
            throw new TncException(TncExceptionMessages.INVALID_CASH_HEADING);
        }
        if (ConvertStr.isNullOrEmpty((String)check.getCitycode())) {
            throw new TncException(TncExceptionMessages.INVALID_CITY_CODE);
        }
        if (check.getBacknumber() <= 0) {
            throw new TncException(TncExceptionMessages.INVALID_CHECK_BACK_NUMBER);
        }
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT SARFASL_CODE2 FROM [CASH] WHERE SARFASL_CODE = ?", new Object[]{payment.getVaultcashsarfasl()});
        if (!rs.next() || ConvertStr.isNullOrEmpty((String)rs.getString("SARFASL_CODE2"))) {
            throw new TncException(TncExceptionMessages.INVALID_CASH_HEADING);
        }
    }

    private void checkPaymentErrors(CheckDto check) throws TncException {
        SqlRowSet rs;
        if (this.settingsDao.getMSetup2Boolean(this.login, "CheckDastehCheck")) {
            rs = this.jdbc.queryForRowSet(" SELECT UsedNumbers FROM DASTEHCH WHERE BANK_CODE = ? AND\n ACCOUNT_N = ? AND '" + check.getChecknumber() + "' BETWEEN D_START AND D_END ", new Object[]{check.getBankcode(), check.getAccountnumber()});
            if (!rs.next()) {
                throw new TncException(TncExceptionMessages.CHECK_NUM_NOT_IN_CHECKBOOK);
            }
            String usedNumbers = ConvertStr.nullSafeString((String)rs.getString("UsedNumbers"));
            if (usedNumbers.contains(check.getChecknumber()) && this.duplicateChecksNotAllowed) {
                throw new TncException(TncExceptionMessages.DUPLICATE_CHECK_NUMBERS_FOR_ACCOUNT.setArgs(new Object[]{check.getAccountnumber(), check.getChecknumber(), "(\u062f\u0633\u062a\u0647 \u0686\u06a9)"}));
            }
            if (usedNumbers.endsWith(",")) {
                usedNumbers = usedNumbers.substring(0, usedNumbers.length() - 1);
            }
            check.setUsedCheckNumbers(usedNumbers);
        }
        if (!(rs = this.jdbc.queryForRowSet("SELECT JARY_HASANEH \n FROM [ACOUND_N] WHERE ACCOUNT_N = ? AND BANK_CODE = ?", new Object[]{check.getAccountnumber(), check.getBankcode()})).next()) {
            throw new TncException(TncExceptionMessages.ACCOUNT_FOR_BANK_NOT_FOUND);
        }
        if (!rs.getBoolean("JARY_HASANEH")) {
            throw new TncException(TncExceptionMessages.GIVEN_CHECK_ACCOUNT_IS_NOT_CURRENT);
        }
    }

    private void setCheckData(CheckDto check, PaymentDto payment) {
        if (payment.isReceive()) {
            this.setCheckDataReceive(check, payment);
        } else {
            this.setCheckDataPayment(check);
        }
        check.setCcodesource(payment.getCustomerCode());
        check.setDaryaftpardakht(Boolean.valueOf(payment.isReceive()));
        check.setSanadcode(payment.getFixsanadcode());
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT BANK_NAME\n FROM [NewBank] WHERE BANK_CODE = ?", new Object[]{check.getBankcode()});
        rs.next();
        check.setBankName(rs.getString("BANK_NAME"));
        check.setSanadDate(payment.getDate());
    }

    private void setCheckDataReceive(CheckDto check, PaymentDto payment) {
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT ID, SARFASL_CODE2 FROM [CASH] WHERE SARFASL_CODE = ?", new Object[]{payment.getVaultcashsarfasl()});
        rs.next();
        check.setCashid(rs.getInt("ID"));
        check.setCheckSarfasl(rs.getString("SARFASL_CODE2"));
    }

    private void setCheckDataPayment(CheckDto check) {
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT COL_CODE, MOIEN_CODE, TAFZILI_CODE, KART_NUM, JARY_HASANEH,\n PAR_COL_CODE + PAR_MOIEN_CODE + PAR_TAFZILI_CODE CHECK_SARFASL\n FROM [ACOUND_N] WHERE ACCOUNT_N = ? AND BANK_CODE = ?", new Object[]{check.getAccountnumber(), check.getBankcode()});
        rs.next();
        check.setColcode(rs.getString("COL_CODE"));
        check.setMoiencode(rs.getString("MOIEN_CODE"));
        check.setTafzilicode(rs.getString("TAFZILI_CODE"));
        check.setCheckSarfasl(rs.getString("CHECK_SARFASL"));
        check.setCardNumber(rs.getString("KART_NUM"));
        check.setBacknumber(0);
        check.setCitycode(null);
        check.setBranchcode(null);
        check.setCheckseries(null);
    }

    private String insertCheck(CheckDto check) {
        String sql = "INSERT INTO [CHECK] (BACK_NUMBER, EXPORT_DATE, RECEIVE_DATE, CHECK_NUMBER,\n C_CODE_SOURCE, DARYAFT_PARDAKHT, CUST, BANK_CODE, ACCOUNT_NUMBER, COL_CODE, MOIEN_CODE,\n TAFZILI_CODE, SANAD_CODE, FlagHelp, SEL_CHECK, VOSOOL, DarJaryan, BankToBank,\n CITY_CODE, BRANCH, COMM, CASH_ID, BranchCode, CheckSerial_Code, Check_SeriesNo, Sayad_Number,\n UserCodeReciveCheck, IsSayad, KART_NUM) VALUES (" + check.getBacknumber() + ",'" + check.getExportdate() + "','" + check.getReceivedate() + "'," + check.getChecknumber() + ",'" + check.getCcodesource() + "'," + ConvertStr.getBoolToInt((Boolean)check.getDaryaftpardakht()) + "," + check.getCust() + ",'" + check.getBankcode() + "','" + check.getAccountnumber() + "'," + ConvertStr.getNullableStrSqlField((String)check.getColcode()) + "," + ConvertStr.getNullableStrSqlField((String)check.getMoiencode()) + "," + ConvertStr.getNullableStrSqlField((String)check.getTafzilicode()) + ",'" + check.getSanadcode() + "', 0, 0, 0, 0, 0,\n" + check.getCitycode() + "," + ConvertStr.getNullableStrSqlField((String)check.getBranch()) + "," + ConvertStr.getNullableStrSqlField((String)check.getComm()) + "," + check.getCashid() + "," + ConvertStr.getNullableStrSqlField((String)check.getBranchcode()) + "," + ConvertStr.getNullableStrSqlField((String)check.getCheckserial()) + "," + ConvertStr.getNullableStrSqlField((String)check.getCheckseries()) + "," + ConvertStr.getNullableStrSqlField((String)check.getSayadid()) + "," + this.login.getUserCodeInc() + "," + ConvertStr.getBoolToInt((Boolean)check.isRecordedinsayad()) + "," + ConvertStr.getNullableStrSqlField((String)check.getCardNumber()) + ")";
        this.jdbc.execute(sql);
        SqlRowSet rs = this.jdbc.queryForRowSet(" Select SCOPE_IDENTITY() id ");
        if (rs.next()) {
            check.setCheckcode(rs.getInt("id"));
        }
        this.jdbc.execute("INSERT INTO [CHECK_EVENT] (CHECK_CODE, SANAD_CODE, DATE_TIME, CASH_ID, SARFASL_CODE, STATE) VALUES ('" + check.getCheckcode() + "'," + check.getSanadcode() + ", '" + check.getSanadDate() + "'," + check.getCashid() + ",'" + check.getCcodesource() + "','" + check.getState() + "')");
        this.jdbc.execute("INSERT INTO [CHECK_BKUP] (SANAD_CODE, CHECK_NUMBER, CUST, ACCOUNT_NUMBER, BANK_NAME, BACK_NUMBER,\n RECEIVE_DATE, BranchCode) VALUES (" + check.getSanadcode() + ",'" + check.getChecknumber() + "'," + check.getCust() + ",'" + check.getAccountnumber() + "',N'" + check.getBankName() + "'," + check.getBacknumber() + ",'" + check.getReceivedate() + "'," + ConvertStr.getNullableStrSqlField((String)check.getBranchcode()) + ")");
        sql = "INSERT INTO [SND_INDX] (SANAD_CODE, FAC_CODE, FAC_TYPE, CHECK_CODE) VALUES (";
        this.jdbc.update(sql + ConvertStr.getValuesQuestionMarksBasedOnInsertColNum((String)sql) + ")", new Object[]{check.getSanadcode(), "", "M", check.getCheckcode()});
        if (check.getUsedCheckNumbers() != null) {
            this.jdbc.update(" UPDATE DASTEHCH SET UsedNumbers = ? WHERE BANK_CODE = ? AND ACCOUNT_N = ?", new Object[]{check.makeUsedCheckNumbers(), check.getBankcode(), check.getAccountnumber()});
        }
        return check.getChecknumber();
    }

    private String makeComment(List<String> checkCodes, boolean receive) {
        String receiveOrPayStr;
        if (checkCodes.isEmpty()) {
            return null;
        }
        String string = receiveOrPayStr = receive ? "\u062f\u0631\u06cc\u0627\u0641\u062a\u06cc " : "\u067e\u0631\u062f\u0627\u062e\u062a\u06cc ";
        if (checkCodes.size() == 1) {
            String comment = "\u0634\u0645\u0627\u0631\u0647 \u0686\u06a9 " + receiveOrPayStr + checkCodes.get(0) + " \u0645\u06cc \u0628\u0627\u0634\u062f";
            return comment;
        }
        StringBuilder sb = new StringBuilder("\u0634\u0645\u0627\u0631\u0647 \u0686\u06a9 \u0647\u0627\u06cc " + receiveOrPayStr);
        for (String checkCode : checkCodes) {
            sb.append(checkCode).append(" \u0648 ");
        }
        String comment = ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)sb, (String)" \u0648 ") + " \u0645\u06cc \u0628\u0627\u0634\u062f";
        return comment;
    }
}

