/*
 * Decompiled with CFR 0.152.
 */
package com.android.res_table.data;

import com.android.core.data.AndroidRepository;
import com.android.core.utils.params.QueryParamTypes;
import com.service.SettingLoader;
import com.utility.DbConnection;
import com.utility.Paging;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResTableRepository
extends AndroidRepository<Map<String, Object>> {
    @Autowired
    public ResTableRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    @NotNull
    protected QueryParamTypes queryParamType() {
        return QueryParamTypes.RES_TABLE;
    }

    protected Paging.PageSqlData queryWithDefaultPaging(SettingLoader settingsLoader) {
        if (settingsLoader.sendResTablesDisabled()) {
            return null;
        }
        String whereShowOnlyThisUserInvoices = settingsLoader.showThisUserResInvoicesOnly() ? "WHERE OpenCount.UserCode = " + settingsLoader.getLogin().getUserCodeInc() + " OR OpenCount.UserCode IS NULL" : "";
        return Paging.PageSqlData.builder().selectSqlStr("SELECT Desk.id as code, RTrim(LTrim(Desk.Desk_Name)) AS title, \nIsnull(FcPay.F_Code,0) AS lastpaycode, \nCONVERT(nvarchar(50), Isnull(Isnull(FcPay.F_Date, 0) \n+ Cast(FcPay.F_Time as DateTime), 0), 120) AS lastpaydatetime, \nIsnull(FcPay.F_SumPrice, 0) AS lastpayprice, \nIsnull(FcOpen.F_Code, 0) AS lastopencode, \nCONVERT(nvarchar(50), Isnull(Isnull(FcOpen.F_Date, 0) \n+ Cast(FcOpen.F_Time as DateTime), 0), 120) AS lastopendatetime, \nIsnull(FcOpen.F_SumPrice,0) AS lastopenprice, \nIsnull(OpenCount.OpenCount,0) AS opentablecount, Chair_Count, \n (CASE WHEN FcOpen.cashAmount + FcOpen.creditAmount + FcOpen.posAmount > 0 \n THEN 'true' ELSE 'false' END) isSettled \nFROM Res_Desk Desk").joinsStr("LEFT JOIN\n(SELECT rf.F_Code, RTrim(LTrim(rf.Desk_Name)) AS Desk_Name, rf.F_Time, rf.F_Date, \n rf.F_SumPrice \n FROM Res_Facture rf \n INNER JOIN(\n  SELECT MAX(rf.F_Date + CAST(rf.F_Time AS DateTime)) AS fDate,   RTrim(LTrim(rf.Desk_Name)) AS Desk_Name  FROM Res_Facture rf\n  where ISNULL(ExporterSId,0) > -1\n  And F_Type = 2 and Fac_Type = 'R'\n  GROUP BY RTrim(LTrim(rf.Desk_Name))\n  ) AS MaxInfo ON MaxInfo.fDate = (rf.F_Date + CAST(rf.F_Time AS DateTime))\n   and RTrim(LTrim(MaxInfo.Desk_Name)) = RTrim(LTrim(rf.Desk_Name)) And rf.F_Type = 2\n) AS FcPay ON  RTrim(LTrim(Desk.Desk_Name)) = RTrim(LTrim(FcPay.Desk_Name))\nLEFT JOIN\n(SELECT rf.F_Code, RTrim(LTrim(rf.Desk_Name)) AS Desk_Name, rf.F_Time, rf.F_Date, \n rf.F_SumPrice, IsNull(rf.F_Naghd, 0) cashAmount, IsNull(rf.F_Nesieh, 0) creditAmount, \n IsNull(rf.F_Pos, 0) posAmount \n FROM Res_Facture rf \n INNER JOIN( \n  SELECT MAX(rf.F_Date + CAST(rf.F_Time AS DateTime)) AS fDate, \n  RTrim(LTrim(rf.Desk_Name)) AS Desk_Name \n  FROM Res_Facture rf \n  where ISNULL(ExporterSId, 0) > -1 \n  And F_Type = 1 \n  and Fac_Type = 'R' \n  GROUP BY RTrim(LTrim(rf.Desk_Name)) \n ) AS MaxInfo ON MaxInfo.fDate = (rf.F_Date + CAST(rf.F_Time AS DateTime)) \n   and RTrim(LTrim(MaxInfo.Desk_Name)) = RTrim(LTrim(rf.Desk_Name)) \n   And rf.F_Type = 1 \n) AS FcOpen ON  RTrim(LTrim(Desk.Desk_Name)) = RTrim(LTrim(FcOpen.Desk_Name)) \nLEFT JOIN( \n SELECT COUNT(rf.F_Code) AS OpenCount,RTrim(LTrim(rf.Desk_Name)) AS Desk_Name, UserCode \n FROM Res_Facture rf \n where ISNULL(ExporterSId,0) > -1 \n And F_Type = 1 \n and Fac_Type = 'R' \n Group BY RTrim(LTrim(rf.Desk_Name)), UserCode \n) AS OpenCount ON  RTrim(LTrim(OpenCount.Desk_Name)) = RTrim(LTrim(Desk.Desk_Name)) \n").whereStr(whereShowOnlyThisUserInvoices).alias("Desk").keyField("Id").build();
    }
}

