/*
 * Decompiled with CFR 0.152.
 */
package com.android.files.data;

import com.android.files.domain.model.FileData;
import com.android.files.domain.util.BinaryDataService;
import com.android.files.domain.util.FileIdData;
import com.utility.ConvertStr;
import com.utility.TncJdbc;
import java.io.File;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.web.multipart.MultipartFile;

public class FileSystemBinaryDataService
implements BinaryDataService {
    private final TncJdbc jdbc;

    public FileSystemBinaryDataService(TncJdbc jdbc) {
        this.jdbc = jdbc;
    }

    public void store(MultipartFile file) {
    }

    public Path load(String fileId) {
        FileIdData idData = this.getSrcIdCode(fileId);
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT PicturePath FROM HLOPictures \n WHERE image_src = ? AND [ID] = ? AND [CODE] = ?", new Object[]{idData.getFileSrc(), idData.getId(), idData.getEntityCode()});
        if (!rs.next()) {
            return null;
        }
        String path = rs.getString("PicturePath");
        if (ConvertStr.isNullOrEmpty((String)path)) {
            return null;
        }
        return Paths.get(path, new String[0]);
    }

    public Resource loadAsResource(String fileId) {
        try {
            Path file = this.load(fileId);
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                return resource;
            }
            throw new RuntimeException("could not read file: " + fileId);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("couldn't read file: " + fileId, e);
        }
    }

    public void deleteAll() {
    }

    public long getSize(FileData fileData) {
        return new File(fileData.getFilePath()).length();
    }
}

