/*
 * Decompiled with CFR 0.152.
 */
package com.android.customer.data.repository;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseResponse;
import com.android.core.utils.params.QueryParamTypes;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.LockCode;
import com.utility.LockReader;
import com.utility.Paging;
import com.utility.TncJdbc;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class MoienReportRepository
extends AndroidRepository<Map<String, Object>> {
    public MoienReportRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    public BaseResponse<Map<String, Object>> customQuery(HttpServletRequest request, Paging paging, LoginDto login) {
        String sql;
        Map filter = this.getFilterParams(request).makeUserParamMap(true);
        TncJdbc jdbc = this.getJdbc(login);
        LockReader lockReader = new LockReader(jdbc);
        SettingLoader loader = this.getSettingLoader(login);
        String whereStrUser = lockReader.isLockEnabled(LockCode.AGGREGATE_REPORTS) ? " UserCodeInc = " + login.getUserCodeInc() : "";
        boolean showWithDetails = ConvertStr.boolStrToBool((String)filter.getOrDefault("with-details", "false").toString());
        if (showWithDetails) {
            String whereStrDetail = this.getDetailWhereStr(jdbc, filter);
            sql = " EXEC sp_MoienAshkhas @DBName = '" + login.getDataBaseName() + "', \n @HazinehHaml = '" + ConvertStr.getBoolToInt((Boolean)loader.isUseHazHamlInFactEnabled()) + "', \n @HlpMoienQuery ='', \n @HlpTbl ='', \n @WhereCustomer= '" + whereStrDetail + "\n" + whereStrUser + "', \n @AutoService = 3";
        } else {
            sql = " EXEC spMoienAshkhas @C_Code = '" + this.decryptCustomerCode(filter.getOrDefault("customer-code", "0").toString(), login) + "', @FromSanadDate = '" + filter.getOrDefault("from-date", "") + "', @ToSanadDate = '" + filter.getOrDefault("to-date", "") + "', @WhereSql = '" + whereStrUser + "'";
        }
        List result = jdbc.queryForList(sql);
        result = result.stream().peek(map -> {
            Timestamp date = (Timestamp)map.get("Sanad_Date");
            Timestamp time = (Timestamp)map.get("Sanad_Time");
            if (map.get("Sanad_Date") != null) {
                map.put("Sanad_Date", ConvertStr.timestampToCommonDateTimeStr((Timestamp)date));
            }
            if (map.get("Sanad_Time") != null) {
                map.put("Sanad_Time", ConvertStr.timestampToCommonDateTimeStr((Timestamp)time));
            }
        }).collect(Collectors.toList());
        return new BaseResponse.Builder().data(result).build();
    }

    private String getDetailWhereStr(TncJdbc jdbc, Map<String, Object> filter) {
        SqlRowSet rs = jdbc.queryForRowSet(" SELECT Col_Code_Bed, Moien_Code_Bed, Tafzili_Code_Bed, \n Col_Code_Bes, Moien_Code_Bes, Tafzili_Code_Bes, \n (Col_Code_Bed + Moien_Code_Bed + Tafzili_Code_Bed) as CMTCode, \n (Col_Code_Bes + Moien_Code_Bes + Tafzili_Code_Bes) as CMTCodeBes \n  FROM CUSTOMER C  WHERE C_CODE = '" + this.decryptCustomerCode(filter.getOrDefault("customer-code", "").toString(), jdbc.getLogin()) + "'");
        if (!rs.next()) {
            return "";
        }
        String colBed = ConvertStr.nullSafeString((String)rs.getString("Col_Code_Bed"));
        String moienBed = ConvertStr.nullSafeString((String)rs.getString("Moien_Code_Bed"));
        String tafsiliBed = ConvertStr.nullSafeString((String)rs.getString("Tafzili_Code_Bed"));
        String colBes = ConvertStr.nullSafeString((String)rs.getString("Col_Code_Bes"));
        String moienBes = ConvertStr.nullSafeString((String)rs.getString("Moien_Code_Bes"));
        String tafsiliBes = ConvertStr.nullSafeString((String)rs.getString("Tafzili_Code_Bes"));
        String f1 = "";
        String f2 = "";
        if (!colBed.isEmpty()) {
            f1 = tafsiliBed.isEmpty() ? " (Snd_List.Col_Code = ''" + colBed + "'' AND Snd_List.Moien_Code = ''" + moienBed + "'' AND (Snd_List.Tafzili_Code = '''' OR Snd_List.Tafzili_Code is null) )" : " (Snd_List.Col_Code = ''" + colBed + "'' AND Snd_List.Moien_Code = ''" + moienBed + "'' AND Snd_List.Tafzili_Code = ''" + tafsiliBed + "'' )";
        }
        if (!colBes.isEmpty()) {
            f2 = tafsiliBes.isEmpty() ? " (Snd_List.Col_Code = '" + colBes + "' AND Snd_List.Moien_Code = ''" + moienBes + "'' AND (Snd_List.Tafzili_Code = '''' OR Snd_List.Tafzili_Code IS NULL))" : " (Snd_List.Col_Code = ''" + colBes + "'' And Snd_List.Moien_Code = ''" + moienBes + "'' And Snd_List.Tafzili_Code = ''" + tafsiliBes + "'' )";
        }
        String result = "";
        if (!f1.isEmpty() && !f2.isEmpty()) {
            result = "(" + f1 + " Or " + f2 + ")";
        }
        if (f1.isEmpty() || f2.isEmpty()) {
            result = "(" + f1 + f2 + ")";
        }
        if (f1.isEmpty() && f2.isEmpty()) {
            result = "(Snd_List.Col_Code = '''' AND Snd_List.Moien_Code = '''' AND (Snd_List.Tafzili_Code = '''' OR Snd_List.Tafzili_Code is null) )";
        }
        String fromDate = (String)filter.getOrDefault("from-date", "");
        String toDate = (String)filter.getOrDefault("to-date", "");
        if (!fromDate.isEmpty()) {
            result = result + " AND (Sanad.Sanad_Date >= ''" + fromDate + "'')";
        }
        if (!toDate.isEmpty()) {
            result = result + " AND (Sanad.Sanad_Date <= ''" + toDate + "'')";
        }
        return result;
    }

    private String decryptCustomerCode(String code, LoginDto login) {
        if (!login.isAndroid()) {
            return ConvertStr.decrypt((String)code);
        }
        return code;
    }

    @NotNull
    protected QueryParamTypes queryParamType() {
        return QueryParamTypes.MOIEN_REPORT;
    }
}

