/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.utils.params;

import com.android.core.utils.params.QueryParamTypes;
import com.utility.ConvertStr;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;

public class AndroidFilter {
    private final HttpServletRequest request;
    private final QueryParamTypes type;
    private final Map<String, Object> userGivenParamMap = new ConcurrentHashMap();

    @NonNull
    public String getFilter() {
        if (this.type.equals((Object)QueryParamTypes.NO_QUERY)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String nextParam : this.request.getParameterMap().keySet()) {
            if (this.isPagingParam(nextParam)) continue;
            String paramValue = this.request.getParameter(nextParam);
            String whereStrForField = this.type.getInstance().makeWhere(nextParam, paramValue);
            if (whereStrForField == null) continue;
            sb.append(whereStrForField).append(" AND ");
        }
        return ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)sb, (String)" AND").toString();
    }

    public Map<String, Object> makeUserParamMap(boolean lowerCaseParamNames) {
        if (this.type.equals((Object)QueryParamTypes.NO_QUERY)) {
            return new ConcurrentHashMap<String, Object>();
        }
        for (String nextParam : this.request.getParameterMap().keySet()) {
            if (this.isPagingParam(nextParam)) continue;
            String paramValue = this.request.getParameter(nextParam);
            this.userGivenParamMap.put(lowerCaseParamNames ? nextParam.toLowerCase() : nextParam, paramValue);
        }
        return this.userGivenParamMap;
    }

    private boolean isPagingParam(String nextParam) {
        return nextParam.equalsIgnoreCase("page") || nextParam.equalsIgnoreCase("itemsPerPage");
    }

    @NonNull
    public String getFilterWithPrecedingWhere() {
        String sqlWhere = this.getFilter();
        return sqlWhere.isEmpty() ? "" : " WHERE " + sqlWhere;
    }

    public AndroidFilter(HttpServletRequest request, QueryParamTypes type) {
        this.request = request;
        this.type = type;
    }
}

