/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.data.api;

import com.Application;
import com.android.core.domain.AndroidService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.documentation.annotations.ApiIgnore;

public abstract class AndroidController<T> {
    protected final Application app;
    protected final AndroidService<T> service;

    protected AndroidController(Application app, AndroidService<T> service) {
        this.app = app;
        this.service = service;
    }

    @ApiIgnore
    @GetMapping
    @Nullable
    public final ResponseEntity<Map<String, Object>> getItems(HttpServletRequest request, @RequestParam(required=false, name="page", defaultValue="-1") int page, @RequestParam(required=false, name="itemsPerPage", defaultValue="-1") int itemsPerPage) {
        if (!this.app.isAndroidPack()) {
            return null;
        }
        return this.service.getItems(request, page, itemsPerPage);
    }

    @ApiIgnore
    @PostMapping
    @Nullable
    public final ResponseEntity<Map<String, Object>> postItems(@RequestBody List<T> body) {
        if (!this.app.isAndroidPack()) {
            return null;
        }
        return this.service.post(body);
    }

    public AndroidService<T> getService() {
        return this.service;
    }

    public Application getApp() {
        return this.app;
    }
}

