/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.data;

import com.android.core.data.AndroidLogger;
import com.android.core.domain.model.BaseResponse;
import com.android.core.utils.Totals;
import com.android.core.utils.params.AndroidFilter;
import com.android.core.utils.params.QueryParamTypes;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.NonNull;
import org.springframework.transaction.TransactionStatus;

public abstract class AndroidRepository<T> {
    protected final DbConnection dbConnection;
    private Integer totalCount = null;
    private Integer totalPages = null;

    public AndroidRepository(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseResponse<Map<String, Object>> getAsMap(HttpServletRequest request, Paging paging, LoginDto login) {
        try {
            String sql = this.makeSql(request, paging, login);
            if (sql == null) {
                BaseResponse baseResponse = new BaseResponse.Builder().build();
                return baseResponse;
            }
            BaseResponse baseResponse = new BaseResponse.Builder().data(this.dbConnection.getJdbcTemplate(login).queryForList(sql)).totalCount(this.totalCount).totalPages(this.totalPages).build();
            return baseResponse;
        }
        catch (Exception e) {
            BaseResponse baseResponse = new BaseResponse.Builder().withError(TncException.fromException((Throwable)e).makeAndroidError()).build();
            return baseResponse;
        }
        finally {
            this.deleteTempTableIfAny(login, paging);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseResponse<T> getAsObject(HttpServletRequest request, Paging paging, LoginDto login) throws RuntimeException {
        RowMapper rowMapper = this.getRowMapper();
        if (rowMapper == null) {
            throw new RuntimeException("*No RowMapper implemented for " + this.getClass().getSimpleName());
        }
        try {
            String sql = this.makeSql(request, paging, login);
            if (sql == null) {
                BaseResponse baseResponse = new BaseResponse.Builder().build();
                return baseResponse;
            }
            BaseResponse baseResponse = new BaseResponse.Builder().data(this.dbConnection.getJdbcTemplate(login).query(sql, rowMapper)).totalCount(this.totalCount).totalPages(this.totalPages).build();
            return baseResponse;
        }
        catch (Exception e) {
            BaseResponse baseResponse = new BaseResponse.Builder().withError(TncException.fromException((Throwable)e).makeAndroidError()).build();
            return baseResponse;
        }
        finally {
            this.deleteTempTableIfAny(login, paging);
        }
    }

    @Nullable
    protected String makeSql(HttpServletRequest request, Paging paging, LoginDto login) {
        Paging.PageSqlData data = this.queryWithDefaultPaging(this.getSettingLoader(login));
        if (data == null) {
            return null;
        }
        data.setWhereStr(this.makeWhere(request, data));
        if (paging.getTableName().isEmpty()) {
            return login.makeUseDbSql() + data.getSelectSqlStr();
        }
        Totals totals = new Totals(paging, this.dbConnection, login);
        totals.calculateTotals(data);
        this.totalCount = totals.getTotalCount();
        this.totalPages = totals.getTotalPages();
        return paging.makeSql(data);
    }

    private void deleteTempTableIfAny(LoginDto login, @NotNull Paging paging) {
        if (!paging.getTableName().contains("#")) {
            return;
        }
        this.dbConnection.getJdbcTemplate(login).update(" IF (OBJECT_ID('tempdb.." + paging.getTableName() + "') IS NOT NULL) \n DROP TABLE " + paging.getTableName());
    }

    @NotNull
    private String makeWhere(HttpServletRequest request, @NotNull Paging.PageSqlData data) {
        String sqlWhere = this.getFilterParams(request).getFilterWithPrecedingWhere();
        if (data.getWhereStr().isEmpty()) {
            return sqlWhere;
        }
        String tWhere = data.getWhereStr().trim();
        if (tWhere.startsWith("WHERE") || tWhere.startsWith("where")) {
            tWhere = tWhere.replaceFirst("WHERE", "").replaceFirst("where", "");
        }
        sqlWhere = sqlWhere + (sqlWhere.isEmpty() ? " WHERE " + tWhere : " AND " + tWhere);
        return sqlWhere;
    }

    public BaseResponse<Map<String, Object>> customQuery(HttpServletRequest request, Paging paging, LoginDto login) {
        return null;
    }

    public final BaseResponse<Map<String, Object>> insertAll(@NotNull List<T> items, LoginDto login) {
        BaseResponse.Builder response = new BaseResponse.Builder();
        for (T item : items) {
            response.mergeResponse((BaseResponse)this.dbConnection.getTransactionTemplate(login).execute(status -> this.insert(item, login, status)));
        }
        return response.build();
    }

    public final BaseResponse<Map<String, Object>> edit(List<T> entityList, LoginDto myLogin) {
        return (BaseResponse)this.dbConnection.getTransactionTemplate(myLogin).execute(status -> this.internalEdit(entityList, myLogin, status));
    }

    protected BaseResponse<Map<String, Object>> internalEdit(List<T> entityList, LoginDto myLogin, TransactionStatus status) {
        return null;
    }

    public final void log(LoginDto login) {
        if (ConvertStr.isNullOrEmpty((String)login.getDataBaseName())) {
            return;
        }
        AndroidLogger logger = new AndroidLogger(this.getJdbc(login));
        logger.log();
    }

    protected BaseResponse<Map<String, Object>> insert(T item, LoginDto login, TransactionStatus status) throws TncException {
        throw new TncException(TncExceptionMessages.DEFAULT_ERROR);
    }

    @Nullable
    protected Paging.PageSqlData queryWithDefaultPaging(SettingLoader settingsLoader) {
        return null;
    }

    @NonNull
    protected QueryParamTypes queryParamType() {
        return QueryParamTypes.NO_QUERY;
    }

    protected AndroidFilter getFilterParams(HttpServletRequest request) {
        return new AndroidFilter(request, this.queryParamType());
    }

    protected SettingLoader getSettingLoader(LoginDto loginDto) {
        return new SettingLoader(this.dbConnection, loginDto);
    }

    @Nullable
    protected RowMapper<T> getRowMapper() {
        return null;
    }

    protected TncJdbc getJdbc(LoginDto loginDto) {
        return this.dbConnection.getJdbcTemplate(loginDto);
    }

    protected final Integer getTotalCount() {
        return this.totalCount;
    }

    protected final Integer getTotalPages() {
        return this.totalPages;
    }
}

