/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.data;

import com.utility.TncJdbc;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class AndroidLogger {
    public static final String TABLE_NAME = "ANDROID_USER_ACTIONS";
    public static final int AMOUNT_TO_KEEP = 90;
    private final TncJdbc jdbc;

    public void log() {
        if (this.loggingNotActive()) {
            return;
        }
        this.truncateIfIdIsBig();
        this.onlyKeepLatestRows();
        this.insertLog();
    }

    private boolean loggingNotActive() {
        SqlRowSet rs = this.jdbc.queryForRowSet("select [BOOLEAN] from MSETUP2 where [NAME] = 'SWUserAction'");
        if (!rs.next()) {
            return true;
        }
        return rs.getBoolean("BOOLEAN");
    }

    private void insertLog() {
        this.jdbc.update(" INSERT INTO ANDROID_USER_ACTIONS(ACTION_LOG, ACTION_TYPE) VALUES \n ('Connected _ ' + Convert(nvarchar(20), GetDate(), 120), 1)");
    }

    private void onlyKeepLatestRows() {
        if (this.jdbc.getCount(TABLE_NAME) <= 180) {
            return;
        }
        this.jdbc.execute("DELETE FROM ANDROID_USER_ACTIONS WHERE id IN ( \n SELECT TOP (SELECT COUNT(*) - 90 FROM ANDROID_USER_ACTIONS) id \n FROM ANDROID_USER_ACTIONS \n ORDER BY ID ASC \n)");
    }

    private void truncateIfIdIsBig() {
        if (this.jdbc.getMaxOf(TABLE_NAME, "id") > 100000L) {
            this.jdbc.truncateTable(TABLE_NAME);
        }
    }

    public AndroidLogger(TncJdbc jdbc) {
        this.jdbc = jdbc;
    }
}

